/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import react4j.processor.ComponentDescriptor;
import react4j.processor.Generator;
import react4j.processor.MethodChecks;
import react4j.processor.MethodDescriptor;
import react4j.processor.OnPropChangeDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.PropDescriptor;
import react4j.processor.ReactProcessorException;
import react4j.processor.vendor.google.auto.common.SuperficialValidation;
import react4j.processor.vendor.javapoet.JavaFile;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;

@SupportedAnnotationTypes(value={"react4j.annotations.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public final class ReactProcessor
extends AbstractProcessor {
    private ExecutableElement _componentRenderMethod;
    @Nonnull
    private HashSet<TypeElement> _deferred = new HashSet();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this._componentRenderMethod = null;
        TypeElement annotation = this.processingEnv.getElementUtils().getTypeElement("react4j.annotations.ReactComponent");
        Set<? extends Element> elements = env.getElementsAnnotatedWith(annotation);
        Collection<Element> elementsToProcess = this.getElementsToProcess(elements);
        this.processElements(elementsToProcess);
        if (env.getRootElements().isEmpty() && !this._deferred.isEmpty()) {
            this._deferred.forEach(this::processingErrorMessage);
            this._deferred.clear();
        }
        return true;
    }

    private void processingErrorMessage(@Nonnull TypeElement target) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "ReactProcessor unable to process " + target.getQualifiedName() + " because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.", target);
    }

    @Nonnull
    private Collection<Element> getElementsToProcess(@Nonnull Set<? extends Element> elements) {
        List deferred = this._deferred.stream().map(e -> this.processingEnv.getElementUtils().getTypeElement(e.getQualifiedName())).collect(Collectors.toList());
        this._deferred = new HashSet();
        ArrayList<Element> elementsToProcess = new ArrayList<Element>();
        this.collectElementsToProcess(elements, elementsToProcess);
        this.collectElementsToProcess(deferred, elementsToProcess);
        return elementsToProcess;
    }

    private void collectElementsToProcess(@Nonnull Collection<? extends Element> elements, @Nonnull ArrayList<Element> elementsToProcess) {
        for (Element element : elements) {
            if (SuperficialValidation.validateElement(element)) {
                elementsToProcess.add(element);
                continue;
            }
            this._deferred.add((TypeElement)element);
        }
    }

    private void processElements(@Nonnull Collection<? extends Element> elements) {
        for (Element element : elements) {
            try {
                this.process((TypeElement)element);
            }
            catch (IOException ioe) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ioe.getMessage(), element);
            }
            catch (ReactProcessorException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement());
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                sw.flush();
                String message = "Unexpected error will running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state. Please report the failure to the developers so that it can be fixed.\n Report the error at: https://github.com/react4j/react4j/issues\n\n\n" + sw.toString();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
            }
        }
    }

    private void process(@Nonnull TypeElement element) throws IOException, ReactProcessorException {
        ComponentDescriptor descriptor = this.parse(element);
        this.emitTypeSpec(descriptor.getPackageName(), Generator.buildEnhancedComponent(descriptor));
        this.emitTypeSpec(descriptor.getPackageName(), Generator.buildComponentBuilder(descriptor));
        if (descriptor.needsDaggerIntegration()) {
            if (descriptor.isArezComponent()) {
                this.emitTypeSpec(descriptor.getPackageName(), Generator.buildArezDaggerComponentExtension(descriptor));
            } else {
                this.emitTypeSpec(descriptor.getPackageName(), Generator.buildDaggerComponentExtension(descriptor));
            }
        }
    }

    private void emitTypeSpec(@Nonnull String packageName, @Nonnull TypeSpec typeSpec) throws IOException {
        JavaFile.builder(packageName, typeSpec).skipJavaLangImports(true).build().writeTo(this.processingEnv.getFiler());
    }

    @Nonnull
    private ComponentDescriptor parse(@Nonnull TypeElement typeElement) {
        String name = this.deriveComponentName(typeElement);
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(typeElement);
        ComponentDescriptor descriptor = new ComponentDescriptor(this.processingEnv.getElementUtils(), this.processingEnv.getSourceVersion(), name, packageElement, typeElement);
        this.determineComponentType(descriptor, typeElement);
        this.determineRenderMethod(typeElement, descriptor);
        this.determineProps(descriptor);
        this.determinePropValidatesMethods(descriptor);
        this.determineOnPropChangeMethods(descriptor);
        this.determineDefaultPropsMethods(descriptor);
        this.determineDefaultPropsFields(descriptor);
        this.determinePreUpdateMethod(typeElement, descriptor);
        this.determinePostRenderMethod(typeElement, descriptor);
        this.determinePostUpdateMethod(typeElement, descriptor);
        this.determinePostMountMethod(typeElement, descriptor);
        this.determinePreUnmountMethod(typeElement, descriptor);
        for (PropDescriptor prop : descriptor.getProps()) {
            if (this.isPropRequired(prop)) continue;
            prop.markAsOptional();
        }
        descriptor.sortProps();
        this.verifyNoUnexpectedAbstractMethod(descriptor);
        this.verifyPropsNotAnnotatedWithArezAnnotations(descriptor);
        this.verifyPropsNotCollectionOfArezComponents(descriptor);
        return descriptor;
    }

    private void verifyPropsNotCollectionOfArezComponents(@Nonnull ComponentDescriptor descriptor) {
        for (PropDescriptor prop : descriptor.getProps()) {
            ArrayType arrayType;
            ExecutableElement method = prop.getMethod();
            TypeMirror returnType = method.getReturnType();
            if (TypeKind.DECLARED == returnType.getKind()) {
                DeclaredType declaredType = (DeclaredType)returnType;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!(this.isCollection(declaredType) ? 1 == typeArguments.size() && this.isArezComponent(typeArguments.get(0)) : this.isMap(declaredType) && 2 == typeArguments.size() && (this.isArezComponent(typeArguments.get(0)) || this.isArezComponent(typeArguments.get(1))))) continue;
                throw new ReactProcessorException("@Prop target is a collection that contains Arez components. This is not a safe pattern when the arez components can be disposed.", method);
            }
            if (TypeKind.ARRAY != returnType.getKind() || !this.isArezComponent((arrayType = (ArrayType)returnType).getComponentType())) continue;
            throw new ReactProcessorException("@Prop target is an array that contains Arez components. This is not a safe pattern when the arez components can be disposed.", method);
        }
    }

    private boolean isCollection(@Nonnull DeclaredType declaredType) {
        TypeElement returnType = (TypeElement)this.processingEnv.getTypeUtils().asElement(declaredType);
        String classname = returnType.getQualifiedName().toString();
        return Collection.class.getName().equals(classname) || Set.class.getName().equals(classname) || List.class.getName().equals(classname) || HashSet.class.getName().equals(classname) || ArrayList.class.getName().equals(classname);
    }

    private boolean isMap(@Nonnull DeclaredType declaredType) {
        TypeElement returnType = (TypeElement)this.processingEnv.getTypeUtils().asElement(declaredType);
        String classname = returnType.getQualifiedName().toString();
        return Map.class.getName().equals(classname) || HashMap.class.getName().equals(classname);
    }

    private boolean isArezComponent(@Nonnull TypeMirror typeMirror) {
        return typeMirror instanceof DeclaredType && this.processingEnv.getTypeUtils().asElement(typeMirror).getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().equals("arez.annotations.ArezComponent"));
    }

    private void verifyPropsNotAnnotatedWithArezAnnotations(@Nonnull ComponentDescriptor descriptor) {
        for (PropDescriptor prop : descriptor.getProps()) {
            ExecutableElement method = prop.getMethod();
            for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                String classname = annotationMirror.getAnnotationType().toString();
                if (!this.isArezAnnotation(classname)) continue;
                throw new ReactProcessorException("@Prop target must not be annotated with any arez annotations but is annotated by '" + classname + "'.", method);
            }
        }
    }

    private void verifyNoUnexpectedAbstractMethod(@Nonnull ComponentDescriptor descriptor) {
        ExecutableElement abstractMethod;
        if (!descriptor.isArezComponent() && null != (abstractMethod = (ExecutableElement)this.getMethods(descriptor.getElement()).stream().filter(m -> m.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(m -> descriptor.getProps().stream().noneMatch(p -> p.getMethod() == m)).findAny().orElse(null))) {
            throw new ReactProcessorException("@ReactComponent target has an unexpected abstract method", abstractMethod);
        }
    }

    private void determineOnPropChangeMethods(@Nonnull ComponentDescriptor descriptor) {
        List methods = this.getMethods(descriptor.getElement()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.OnPropChange")).collect(Collectors.toList());
        ArrayList<OnPropChangeDescriptor> onPropChangeDescriptors = new ArrayList<OnPropChangeDescriptor>();
        for (ExecutableElement method : methods) {
            VariableElement phase = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.OnPropChange", "phase").getValue();
            boolean preUpdate = phase.getSimpleName().toString().equals("PRE");
            List<? extends VariableElement> parameters = method.getParameters();
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
            MethodChecks.mustBeSubclassCallable(descriptor.getElement(), "react4j.annotations.OnPropChange", method);
            MethodChecks.mustNotThrowAnyExceptions("react4j.annotations.OnPropChange", method);
            MethodChecks.mustNotReturnAValue("react4j.annotations.OnPropChange", method);
            MethodChecks.mustNotBePublic("react4j.annotations.OnPropChange", method);
            int parameterCount = parameters.size();
            if (0 == parameterCount) {
                throw new ReactProcessorException("@OnPropChange target must have at least 1 parameter.", method);
            }
            ArrayList<PropDescriptor> propDescriptors = new ArrayList<PropDescriptor>(parameterCount);
            for (int i = 0; i < parameterCount; ++i) {
                boolean mismatchedNullability;
                VariableElement parameter = parameters.get(i);
                String name = this.deriveOnPropChangeName(descriptor, parameter);
                PropDescriptor prop = descriptor.findPropNamed(name);
                if (null == prop) {
                    throw new ReactProcessorException("@OnPropChange target has a parameter named '" + parameter.getSimpleName() + "' and the parameter is associated with a @Prop named '" + name + "' but there is no corresponding @Prop annotated method.", parameter);
                }
                Types typeUtils = this.processingEnv.getTypeUtils();
                if (!typeUtils.isAssignable(parameterTypes.get(i), prop.getMethodType().getReturnType())) {
                    throw new ReactProcessorException("@OnPropChange target has a parameter named '" + parameter.getSimpleName() + "' and the parameter type is not assignable to the return type of the associated @Prop annotated method.", method);
                }
                boolean bl = mismatchedNullability = null != ProcessorUtil.findAnnotationByType(parameter, "javax.annotation.Nonnull") && null != ProcessorUtil.findAnnotationByType(prop.getMethod(), "javax.annotation.Nullable") || null != ProcessorUtil.findAnnotationByType(parameter, "javax.annotation.Nullable") && null != ProcessorUtil.findAnnotationByType(prop.getMethod(), "javax.annotation.Nonnull");
                if (mismatchedNullability) {
                    throw new ReactProcessorException("@OnPropChange target has a parameter named '" + parameter.getSimpleName() + "' that has a nullability annotation incompatible with the associated @Prop method named " + method.getSimpleName(), method);
                }
                propDescriptors.add(prop);
            }
            onPropChangeDescriptors.add(new OnPropChangeDescriptor(method, propDescriptors, preUpdate));
        }
        descriptor.setOnPropChangeDescriptors(onPropChangeDescriptors);
    }

    @Nonnull
    private String deriveOnPropChangeName(@Nonnull ComponentDescriptor descriptor, @Nonnull VariableElement parameter) {
        AnnotationValue value = ProcessorUtil.findAnnotationValue(descriptor.getElements(), parameter, "react4j.annotations.PropRef", "value");
        if (null != value) {
            return (String)value.getValue();
        }
        String parameterName = parameter.getSimpleName().toString();
        if (ProcessorUtil.LAST_PROP_PATTERN.matcher(parameterName).matches() || ProcessorUtil.PREV_PROP_PATTERN.matcher(parameterName).matches()) {
            return Character.toLowerCase(parameterName.charAt(4)) + parameterName.substring(5);
        }
        if (ProcessorUtil.PROP_PATTERN.matcher(parameterName).matches()) {
            return parameterName;
        }
        throw new ReactProcessorException("@OnPropChange target has a parameter named '" + parameterName + "' is not explicitly associated with a prop using @PropRef nor does it follow required naming conventions 'prev[MyProp]', 'last[MyProp]' or '[myProp]'.", parameter);
    }

    private void determinePropValidatesMethods(@Nonnull ComponentDescriptor descriptor) {
        List methods = this.getMethods(descriptor.getElement()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.PropValidate")).collect(Collectors.toList());
        for (ExecutableElement method : methods) {
            String name = this.derivePropValidateName(method);
            PropDescriptor prop = descriptor.findPropNamed(name);
            if (null == prop) {
                throw new ReactProcessorException("@PropValidate target for prop named '" + name + "' has no corresponding @Prop annotated method.", method);
            }
            if (1 != method.getParameters().size()) {
                throw new ReactProcessorException("@PropValidate target must have exactly 1 parameter", method);
            }
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            if (!this.processingEnv.getTypeUtils().isAssignable(methodType.getParameterTypes().get(0), prop.getMethodType().getReturnType())) {
                throw new ReactProcessorException("@PropValidate target has a parameter type that is not assignable to the return type of the associated @Prop annotated method.", method);
            }
            prop.setValidateMethod(method);
        }
    }

    @Nonnull
    private String derivePropValidateName(@Nonnull Element element) throws ReactProcessorException {
        String name = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), element, "react4j.annotations.PropValidate", "name").getValue();
        if (ProcessorUtil.isSentinelName(name)) {
            String deriveName = ProcessorUtil.deriveName(element, ProcessorUtil.VALIDATE_PROP_PATTERN, name);
            if (null == deriveName) {
                throw new ReactProcessorException("@PropValidate target has not specified name nor is it named according to the convention 'validate[Name]Prop'.", element);
            }
            return deriveName;
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@PropValidate target specified an invalid name '" + name + "'. The name must be a valid java identifier.", element);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@PropValidate target specified an invalid name '" + name + "'. The name must not be a java keyword.", element);
        }
        return name;
    }

    private void determineDefaultPropsMethods(@Nonnull ComponentDescriptor descriptor) {
        List defaultPropsMethods = this.getMethods(descriptor.getElement()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.PropDefault")).collect(Collectors.toList());
        for (ExecutableElement method : defaultPropsMethods) {
            String name = this.derivePropDefaultName(method);
            PropDescriptor prop = descriptor.findPropNamed(name);
            if (null == prop) {
                throw new ReactProcessorException("@PropDefault target for prop named '" + name + "' has no corresponding @Prop annotated method.", method);
            }
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            if (!this.processingEnv.getTypeUtils().isAssignable(methodType.getReturnType(), prop.getMethodType().getReturnType())) {
                throw new ReactProcessorException("@PropDefault target has a return type that is not assignable to the return type of the associated @Prop annotated method.", method);
            }
            MethodChecks.mustBeStaticallySubclassCallable(descriptor.getElement(), "react4j.annotations.PropDefault", method);
            prop.setDefaultMethod(method);
        }
    }

    private void determineDefaultPropsFields(@Nonnull ComponentDescriptor descriptor) {
        List defaultPropsFields = ProcessorUtil.getFieldElements(descriptor.getElement()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.PropDefault")).collect(Collectors.toList());
        for (VariableElement field : defaultPropsFields) {
            String name = this.derivePropDefaultName(field);
            PropDescriptor prop = descriptor.findPropNamed(name);
            if (null == prop) {
                throw new ReactProcessorException("@PropDefault target for prop named '" + name + "' has no corresponding @Prop annotated method.", field);
            }
            if (!this.processingEnv.getTypeUtils().isAssignable(field.asType(), prop.getMethodType().getReturnType())) {
                throw new ReactProcessorException("@PropDefault target has a type that is not assignable to the return type of the associated @Prop annotated method.", field);
            }
            MethodChecks.mustBeStaticallySubclassCallable(descriptor.getElement(), "react4j.annotations.PropDefault", field);
            prop.setDefaultField(field);
        }
    }

    @Nonnull
    private String derivePropDefaultName(@Nonnull Element element) throws ReactProcessorException {
        String name = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), element, "react4j.annotations.PropDefault", "name").getValue();
        if (ProcessorUtil.isSentinelName(name)) {
            if (element instanceof ExecutableElement) {
                String deriveName = ProcessorUtil.deriveName(element, ProcessorUtil.DEFAULT_GETTER_PATTERN, name);
                if (null == deriveName) {
                    throw new ReactProcessorException("@PropDefault target has not specified name nor is it named according to the convention 'get[Name]Default'.", element);
                }
                return deriveName;
            }
            String fieldName = element.getSimpleName().toString();
            boolean matched = true;
            int lengthPrefix = "DEFAULT_".length();
            int length = fieldName.length();
            if (fieldName.startsWith("DEFAULT_") && length > lengthPrefix) {
                for (int i = lengthPrefix; i < length; ++i) {
                    char ch = fieldName.charAt(i);
                    if (!Character.isLowerCase(ch) && (i == lengthPrefix && Character.isJavaIdentifierStart(ch) || i != lengthPrefix && Character.isJavaIdentifierPart(ch))) continue;
                    matched = false;
                    break;
                }
            } else {
                matched = false;
            }
            if (matched) {
                return this.uppercaseConstantToPascalCase(fieldName.substring(lengthPrefix));
            }
            throw new ReactProcessorException("@PropDefault target has not specified name nor is it named according to the convention 'DEFAULT_[NAME]'.", element);
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@PropDefault target specified an invalid name '" + name + "'. The name must be a valid java identifier.", element);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@PropDefault target specified an invalid name '" + name + "'. The name must not be a java keyword.", element);
        }
        return name;
    }

    @Nonnull
    private String uppercaseConstantToPascalCase(@Nonnull String candidate) {
        String s = candidate.toLowerCase();
        StringBuilder sb = new StringBuilder();
        boolean uppercase = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if ('_' == ch) {
                uppercase = true;
                continue;
            }
            if (uppercase) {
                sb.append(Character.toUpperCase(ch));
                uppercase = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private void determineProps(@Nonnull ComponentDescriptor descriptor) {
        List<PropDescriptor> props = this.getMethods(descriptor.getElement()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.Prop")).map(m -> this.createPropDescriptor(descriptor, (ExecutableElement)m)).collect(Collectors.toList());
        PropDescriptor childrenProp = props.stream().filter(p -> p.getName().equals("children")).findAny().orElse(null);
        PropDescriptor childProp = props.stream().filter(p -> p.getName().equals("child")).findAny().orElse(null);
        if (null != childrenProp && null != childProp) {
            throw new ReactProcessorException("Multiple candidate children @Prop annotated methods: " + childrenProp.getMethod().getSimpleName() + " and " + childProp.getMethod().getSimpleName(), childrenProp.getMethod());
        }
        descriptor.setProps(props);
    }

    private boolean isPropRequired(@Nonnull PropDescriptor prop) {
        VariableElement parameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), prop.getMethod(), "react4j.annotations.Prop", "require").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return !prop.hasDefaultMethod() && !prop.hasDefaultField() && null == ProcessorUtil.findAnnotationByType(prop.getMethod(), "javax.annotation.Nullable");
    }

    @Nonnull
    private PropDescriptor createPropDescriptor(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method) {
        boolean disposable;
        String name = this.derivePropName(method);
        ExecutableType methodType = this.resolveMethodType(descriptor, method);
        this.verifyNoDuplicateAnnotations(method);
        MethodChecks.mustBeAbstract("react4j.annotations.Prop", method);
        MethodChecks.mustNotBePublic("react4j.annotations.Prop", method);
        MethodChecks.mustNotHaveAnyParameters("react4j.annotations.Prop", method);
        MethodChecks.mustReturnAValue("react4j.annotations.Prop", method);
        MethodChecks.mustNotThrowAnyExceptions("react4j.annotations.Prop", method);
        MethodChecks.mustNotBePackageAccessInDifferentPackage(descriptor.getElement(), "react4j.annotations.Prop", method);
        TypeMirror returnType = method.getReturnType();
        if ("key".equals(name)) {
            throw new ReactProcessorException("@Prop named 'key' is invalid as the name references value used in the reconciliation process. This value can be accessed via Component.getKey()", method);
        }
        if ("build".equals(name)) {
            throw new ReactProcessorException("@Prop named 'build' is invalid as it conflicts with the method named build() that is used in the generated Builder classes", method);
        }
        if ("child".equals(name) && returnType.getKind() != TypeKind.DECLARED && !"react4j.ReactNode".equals(returnType.toString())) {
            throw new ReactProcessorException("@Prop named 'child' should be of type react4j.ReactNode", method);
        }
        if ("children".equals(name) && returnType.getKind() != TypeKind.DECLARED && !"react4j.ReactNode[]".equals(returnType.toString())) {
            throw new ReactProcessorException("@Prop named 'children' should be of type react4j.ReactNode[]", method);
        }
        if (returnType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)returnType;
            String typeVariableName = typeVariable.asElement().getSimpleName().toString();
            List<? extends TypeParameterElement> typeParameters = method.getTypeParameters();
            if (typeParameters.stream().anyMatch(p -> p.getSimpleName().toString().equals(typeVariableName))) {
                throw new ReactProcessorException("@Prop named '" + name + "' is has a type variable as a return type that is declared on the method.", method);
            }
        }
        Element propType = this.processingEnv.getTypeUtils().asElement(returnType);
        boolean shouldUpdateOnChange = this.shouldUpdateOnChange(method);
        boolean observable = this.isPropObservable(descriptor, method, shouldUpdateOnChange);
        boolean bl = disposable = null != propType && this.isPropDisposable(descriptor, method, propType);
        if (observable && !descriptor.isArezComponent()) {
            throw new ReactProcessorException("@Prop named '" + name + "' is marked as observable but the host component is not a subclass of react4j.arez.ReactArezComponent", method);
        }
        if (disposable && !descriptor.isArezComponent()) {
            throw new ReactProcessorException("@Prop named '" + name + "' is marked as disposable but the host component is not a subclass of react4j.arez.ReactArezComponent", method);
        }
        if (TypeName.get(returnType).isBoxedPrimitive() && null != ProcessorUtil.findAnnotationByType(method, "javax.annotation.Nonnull")) {
            throw new ReactProcessorException("@Prop named '" + name + "' is a boxed primitive annotated with a @Nonnull annotation. The return type should be the primitive type.", method);
        }
        return new PropDescriptor(descriptor, name, method, methodType, shouldUpdateOnChange, observable, disposable);
    }

    @Nonnull
    private String derivePropName(@Nonnull ExecutableElement method) throws ReactProcessorException {
        String specifiedName = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.Prop", "name").getValue();
        String name = ProcessorUtil.getPropertyAccessorName(method, specifiedName);
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@Prop target specified an invalid name '" + specifiedName + "'. The name must be a valid java identifier.", method);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@Prop target specified an invalid name '" + specifiedName + "'. The name must not be a java keyword.", method);
        }
        return name;
    }

    private void determinePreUpdateMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (null == ProcessorUtil.findAnnotationByType(method, "react4j.annotations.PreUpdate")) continue;
            descriptor.setPreUpdate(method);
        }
    }

    private void determinePreUnmountMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (null == ProcessorUtil.findAnnotationByType(method, "react4j.annotations.PreUnmount")) continue;
            descriptor.setPreUnmount(method);
        }
    }

    private void determinePostRenderMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (null == ProcessorUtil.findAnnotationByType(method, "react4j.annotations.PostRender")) continue;
            descriptor.setPostRender(method);
        }
    }

    private void determinePostUpdateMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (null == ProcessorUtil.findAnnotationByType(method, "react4j.annotations.PostUpdate")) continue;
            descriptor.setPostUpdate(method);
        }
    }

    private void determinePostMountMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (null == ProcessorUtil.findAnnotationByType(method, "react4j.annotations.PostMount")) continue;
            descriptor.setPostMount(method);
        }
    }

    private ExecutableType resolveMethodType(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method) {
        return (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
    }

    private void determineRenderMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        ExecutableElement renderMethod = this.getComponentRenderMethod();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement componentType = elementUtils.getTypeElement("react4j.Component");
        MethodDescriptor overriddenRenderMethod = this.getMethods(typeElement).stream().filter(m -> elementUtils.overrides((ExecutableElement)m, renderMethod, typeElement)).filter(m -> m.getEnclosingElement() != componentType).map(m -> new MethodDescriptor((ExecutableElement)m, (ExecutableType)typeUtils.asMemberOf(descriptor.getDeclaredType(), (Element)m))).findAny().orElse(null);
        if (null == overriddenRenderMethod) {
            throw new ReactProcessorException("The react component does not override the render method.", typeElement);
        }
    }

    @Nonnull
    private String deriveComponentName(@Nonnull TypeElement typeElement) {
        String name = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "name").getValue();
        if (ProcessorUtil.isSentinelName(name)) {
            return typeElement.getSimpleName().toString();
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ReactProcessorException("@ReactComponent target specified an invalid name '" + name + "'. The name must be a valid java identifier.", typeElement);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ReactProcessorException("@ReactComponent target specified an invalid name '" + name + "'. The name must not be a java keyword.", typeElement);
        }
        return name;
    }

    @Nonnull
    private ExecutableElement getComponentRenderMethod() {
        if (null == this._componentRenderMethod) {
            TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.Component");
            for (ExecutableElement method : this.getMethods(componentType)) {
                String methodName = method.getSimpleName().toString();
                if (!"render".equals(methodName)) continue;
                this._componentRenderMethod = method;
                break;
            }
        }
        return this._componentRenderMethod;
    }

    private void determineComponentType(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeElement typeElement) {
        boolean isDaggerPresent;
        AnnotationMirror arezAnnotation;
        boolean isArezComponent;
        TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.Component");
        TypeMirror rawComponentType = this.processingEnv.getTypeUtils().erasure(componentType.asType());
        TypeElement arezComponentType = this.processingEnv.getElementUtils().getTypeElement("react4j.arez.ReactArezComponent");
        TypeMirror rawArezComponentType = null == arezComponentType ? null : this.processingEnv.getTypeUtils().erasure(arezComponentType.asType());
        DeclaredType type = descriptor.getDeclaredType();
        boolean isComponent = this.processingEnv.getTypeUtils().isSubtype(type, rawComponentType);
        boolean bl = isArezComponent = null != rawArezComponentType && this.processingEnv.getTypeUtils().isSubtype(type, rawArezComponentType);
        if (!isComponent) {
            throw new ReactProcessorException("@ReactComponent target must be a subclass of react4j.Component", typeElement);
        }
        if (isArezComponent && null != (arezAnnotation = (AnnotationMirror)typeElement.getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().toString().equals("arez.annotations.ArezComponent")).findAny().orElse(null))) {
            throw new ReactProcessorException("@ReactComponent target extends react4j.arez.ReactArezComponent and should not be annotated with arez.annotations.ArezComponent as React4j will add annotation", typeElement);
        }
        boolean needsInjection = this.isInjectionRequired(typeElement);
        boolean bl2 = isDaggerPresent = needsInjection && this.isDaggerRequired(typeElement);
        if (isDaggerPresent && !descriptor.getDeclaredType().getTypeArguments().isEmpty()) {
            throw new ReactProcessorException("@ReactComponent target has enabled dagger injection and the class has type argument but type arguments on a component are not compatible with dagger injected components", typeElement);
        }
        descriptor.setNeedsInjection(needsInjection);
        descriptor.setNeedsDaggerIntegration(isDaggerPresent);
        descriptor.setArezComponent(isArezComponent);
        if (isArezComponent) {
            this.ensureMemoizeMatchesExpectations(typeElement);
            boolean runArezScheduler = this.hasAnyArezScheduledObserverMethods(typeElement) || this.hasAnyKeepAliveMemoizeMethods(typeElement) || this.hasAnyDependencyMethods(typeElement);
            descriptor.setRunArezScheduler(runArezScheduler);
            descriptor.setMemoizeMethods(this.getMemoizeMethods(typeElement));
        } else {
            String classname;
            for (ExecutableElement method : ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils())) {
                for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                    classname = annotationMirror.getAnnotationType().toString();
                    if (!this.isArezAnnotation(classname)) continue;
                    throw new ReactProcessorException("@ReactComponent target has a method '" + method.getSimpleName() + "' with an arez annotation '" + classname + "' but is not an arez component.", method);
                }
            }
            for (VariableElement element : ProcessorUtil.getFieldElements(typeElement)) {
                for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                    classname = annotationMirror.getAnnotationType().toString();
                    if (!this.isArezAnnotation(classname)) continue;
                    throw new ReactProcessorException("@ReactComponent target has a field '" + element.getSimpleName() + "' with an arez annotation '" + classname + "' but is not an arez component.", element);
                }
            }
        }
    }

    private void ensureMemoizeMatchesExpectations(@Nonnull TypeElement typeElement) {
        TypeElement computedElement = this.processingEnv.getElementUtils().getTypeElement("arez.annotations.Memoize");
        Set parameters = computedElement.getEnclosedElements().stream().map(e -> e.getSimpleName().toString()).collect(Collectors.toSet());
        if (!(parameters.contains("name") && parameters.contains("priority") && parameters.contains("keepAlive") && parameters.contains("reportResult") && parameters.contains("observeLowerPriorityDependencies") && parameters.contains("depType") && 6 == parameters.size())) {
            throw new ReactProcessorException("The @arez.annotations.Memoize annotation was expected to have the parameters name, priority, keepAlive, reportResult, depType and observeLowerPriorityDependencies but has " + parameters + ". The react4j annotation processor needs to be updated to handle the change in parameters.", typeElement);
        }
    }

    private boolean shouldUpdateOnChange(@Nonnull ExecutableElement method) {
        VariableElement parameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.Prop", "shouldUpdateOnChange").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return true;
    }

    private boolean isPropObservable(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method, boolean shouldUpdateOnChange) {
        VariableElement parameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.Prop", "observable").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return descriptor.isArezComponent() && shouldUpdateOnChange && this.hasAnyArezObserverMethods(descriptor.getElement());
    }

    private boolean hasAnyArezObserverMethods(@Nonnull TypeElement typeElement) {
        return this.getMethods(typeElement).stream().anyMatch(m -> null != ProcessorUtil.findAnnotationByType(m, "arez.annotations.Memoize") || null != ProcessorUtil.findAnnotationByType(m, "arez.annotations.Observe") && (!m.getParameters().isEmpty() || !m.getSimpleName().toString().equals("trackRender")));
    }

    private boolean isPropDisposable(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method, @Nonnull Element propType) {
        VariableElement parameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.Prop", "disposable").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return descriptor.isArezComponent() && ElementKind.CLASS == propType.getKind() && null != ProcessorUtil.findAnnotationByType(propType, "arez.annotations.ArezComponent");
    }

    private boolean isInjectionRequired(@Nonnull TypeElement typeElement) {
        VariableElement parameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "inject").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return ProcessorUtil.getFieldElements(typeElement).stream().anyMatch(this::hasInjectAnnotation) || this.getMethods(typeElement).stream().anyMatch(this::hasInjectAnnotation);
    }

    private boolean isDaggerRequired(@Nonnull TypeElement typeElement) {
        VariableElement parameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "dagger").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return null != this.processingEnv.getElementUtils().getTypeElement("dagger.Module");
    }

    private boolean hasAnyArezScheduledObserverMethods(@Nonnull TypeElement typeElement) {
        return this.getMethods(typeElement).stream().anyMatch(m -> {
            AnnotationValue annotationValue = ProcessorUtil.findAnnotationValue(this.processingEnv.getElementUtils(), m, "arez.annotations.Observe", "executor");
            return null != annotationValue && ((VariableElement)annotationValue.getValue()).getSimpleName().toString().equals("INTERNAL");
        });
    }

    private boolean hasAnyDependencyMethods(@Nonnull TypeElement typeElement) {
        return this.getMethods(typeElement).stream().anyMatch(m -> null != ProcessorUtil.findAnnotationByType(m, "arez.annotations.Dependency"));
    }

    private boolean hasAnyKeepAliveMemoizeMethods(@Nonnull TypeElement typeElement) {
        return this.getMethods(typeElement).stream().anyMatch(m -> {
            AnnotationValue annotationValue = ProcessorUtil.findAnnotationValue(this.processingEnv.getElementUtils(), m, "arez.annotations.Memoize", "keepAlive");
            return null != annotationValue && (Boolean)annotationValue.getValue() != false;
        });
    }

    private boolean hasInjectAnnotation(Element method) {
        return null != ProcessorUtil.findAnnotationByType(method, "javax.inject.Inject");
    }

    @Nonnull
    private List<MethodDescriptor> getMemoizeMethods(@Nonnull TypeElement typeElement) {
        DeclaredType type = (DeclaredType)typeElement.asType();
        return this.getMethods(typeElement).stream().filter(method -> !method.getModifiers().contains((Object)Modifier.PRIVATE)).filter(method -> {
            AnnotationMirror mirror = ProcessorUtil.findAnnotationByType(method, "arez.annotations.Memoize");
            return null != mirror && mirror.getElementValues().keySet().stream().noneMatch(v -> "priority".equals(v.getSimpleName().toString()));
        }).map(m -> new MethodDescriptor((ExecutableElement)m, (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(type, (Element)m))).collect(Collectors.toList());
    }

    private void verifyNoDuplicateAnnotations(@Nonnull ExecutableElement method) throws ReactProcessorException {
        String[] annotationTypes = new String[]{"react4j.annotations.PropDefault", "react4j.annotations.PropValidate", "react4j.annotations.OnPropChange", "react4j.annotations.Prop"};
        for (int i = 0; i < annotationTypes.length; ++i) {
            String type1 = annotationTypes[i];
            AnnotationMirror annotation1 = ProcessorUtil.findAnnotationByType(method, type1);
            if (null == annotation1) continue;
            for (int j = i + 1; j < annotationTypes.length; ++j) {
                String type2 = annotationTypes[j];
                AnnotationMirror annotation2 = ProcessorUtil.findAnnotationByType(method, type2);
                if (null == annotation2) continue;
                String message = "Method can not be annotated with both @" + ProcessorUtil.toSimpleName(type1) + " and @" + ProcessorUtil.toSimpleName(type2);
                throw new ReactProcessorException(message, method);
            }
        }
    }

    @Nonnull
    private List<ExecutableElement> getMethods(@Nonnull TypeElement typeElement) {
        return ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils());
    }

    private boolean isArezAnnotation(@Nonnull String classname) {
        return classname.startsWith("arez.annotations.");
    }
}

