/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ExecutableType;
import react4j.processor.PropDescriptor;
import react4j.processor.StepMethodType;
import react4j.processor.vendor.javapoet.TypeName;

final class StepMethod {
    @Nonnull
    private final String _name;
    @Nonnull
    private final String _key;
    @Nonnull
    private final TypeName _type;
    @Nullable
    private final PropDescriptor _prop;
    @Nonnull
    private final StepMethodType _stepMethodType;

    StepMethod(@Nonnull PropDescriptor prop, @Nonnull StepMethodType stepMethodType) {
        this(prop.getName(), prop.getName(), TypeName.get(prop.getMethodType().getReturnType()), prop, stepMethodType);
    }

    StepMethod(@Nonnull String name, @Nonnull String key, @Nonnull TypeName type, @Nullable PropDescriptor prop, @Nonnull StepMethodType stepMethodType) {
        this._name = Objects.requireNonNull(name);
        this._key = Objects.requireNonNull(key);
        this._type = Objects.requireNonNull(type);
        this._prop = prop;
        this._stepMethodType = Objects.requireNonNull(stepMethodType);
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    String getKey() {
        return this._key;
    }

    @Nonnull
    TypeName getType() {
        return this._type;
    }

    @Nullable
    PropDescriptor getProp() {
        return this._prop;
    }

    @Nullable
    ExecutableElement getPropMethod() {
        return null != this._prop ? this._prop.getMethod() : null;
    }

    @Nullable
    ExecutableType getPropMethodType() {
        return null != this._prop ? this._prop.getMethodType() : null;
    }

    @Nonnull
    StepMethodType getStepMethodType() {
        return this._stepMethodType;
    }

    boolean isBuildIntrinsic() {
        return this.getName().equals("build");
    }

    boolean isKeyIntrinsic() {
        return this.getName().equals("key");
    }

    boolean isChildIntrinsic() {
        return this.getName().equals("child") && this.getKey().equals("child");
    }

    boolean isChildrenIntrinsic() {
        return this.getName().equals("children") && this.getKey().equals("children");
    }

    boolean isChildrenStreamIntrinsic() {
        return this.getName().equals("children") && this.getKey().equals("*children_stream*");
    }
}

