/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import react4j.processor.ComponentDescriptor;
import react4j.processor.ImmutablePropKeyStrategy;
import react4j.processor.MethodChecks;
import react4j.processor.ProcessorUtil;
import react4j.processor.ReactProcessorException;

final class PropDescriptor {
    @Nonnull
    private final ComponentDescriptor _descriptor;
    @Nonnull
    private final String _name;
    @Nonnull
    private final ExecutableElement _method;
    @Nonnull
    private final ExecutableType _methodType;
    private final boolean _shouldUpdateOnChange;
    private final boolean _observable;
    private final boolean _disposable;
    @Nullable
    private final ImmutablePropKeyStrategy _immutablePropKeyStrategy;
    @Nullable
    private VariableElement _defaultField;
    @Nullable
    private ExecutableElement _defaultMethod;
    @Nullable
    private ExecutableElement _validateMethod;
    private boolean _optional;

    PropDescriptor(@Nonnull ComponentDescriptor descriptor, @Nonnull String name, @Nonnull ExecutableElement method, @Nonnull ExecutableType methodType, boolean shouldUpdateOnChange, boolean observable, boolean disposable, @Nullable ImmutablePropKeyStrategy immutablePropKeyStrategy) {
        this._descriptor = Objects.requireNonNull(descriptor);
        this._name = Objects.requireNonNull(name);
        this._method = Objects.requireNonNull(method);
        this._methodType = Objects.requireNonNull(methodType);
        this._shouldUpdateOnChange = shouldUpdateOnChange;
        this._observable = observable;
        this._disposable = disposable;
        this._immutablePropKeyStrategy = immutablePropKeyStrategy;
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    ExecutableElement getMethod() {
        return this._method;
    }

    @Nonnull
    ExecutableType getMethodType() {
        return this._methodType;
    }

    boolean shouldUpdateOnChange() {
        return this._shouldUpdateOnChange;
    }

    boolean isObservable() {
        return this._observable;
    }

    boolean isDisposable() {
        return this._disposable;
    }

    boolean isImmutable() {
        return null != this._immutablePropKeyStrategy;
    }

    @Nonnull
    ImmutablePropKeyStrategy getImmutablePropKeyStrategy() {
        assert (null != this._immutablePropKeyStrategy);
        return this._immutablePropKeyStrategy;
    }

    void setDefaultMethod(@Nonnull ExecutableElement method) {
        MethodChecks.mustNotHaveAnyParameters("react4j.annotations.PropDefault", method);
        MethodChecks.mustNotThrowAnyExceptions("react4j.annotations.PropDefault", method);
        MethodChecks.mustReturnAValue("react4j.annotations.PropDefault", method);
        if (null != this._defaultMethod) {
            throw new ReactProcessorException("@PropDefault target duplicates existing method named " + this._defaultMethod.getSimpleName(), method);
        }
        assert (null == this._defaultField);
        this._defaultMethod = Objects.requireNonNull(method);
    }

    boolean hasValidateMethod() {
        return null != this._validateMethod;
    }

    @Nonnull
    ExecutableElement getValidateMethod() {
        assert (null != this._validateMethod);
        return this._validateMethod;
    }

    void setValidateMethod(@Nonnull ExecutableElement method) {
        boolean mismatchedNullability;
        MethodChecks.mustBeSubclassCallable(this._descriptor.getElement(), "react4j.annotations.PropValidate", method);
        MethodChecks.mustNotThrowAnyExceptions("react4j.annotations.PropValidate", method);
        MethodChecks.mustNotReturnAValue("react4j.annotations.PropValidate", method);
        MethodChecks.mustNotBePublic("react4j.annotations.PropValidate", method);
        VariableElement param = method.getParameters().get(0);
        boolean bl = mismatchedNullability = ProcessorUtil.hasAnnotationOfType(param, "javax.annotation.Nonnull") && ProcessorUtil.hasAnnotationOfType(this._method, "javax.annotation.Nullable") || ProcessorUtil.hasAnnotationOfType(param, "javax.annotation.Nullable") && ProcessorUtil.hasAnnotationOfType(this._method, "javax.annotation.Nonnull");
        if (mismatchedNullability) {
            throw new ReactProcessorException("@PropValidate target has a parameter that has a nullability annotation incompatible with the associated @Prop method named " + this._method.getSimpleName(), method);
        }
        if (null != this._validateMethod) {
            throw new ReactProcessorException("@PropValidate target duplicates existing method named " + this._validateMethod.getSimpleName(), method);
        }
        this._validateMethod = Objects.requireNonNull(method);
    }

    void setDefaultField(@Nonnull VariableElement field) {
        MethodChecks.mustBeFinal("react4j.annotations.PropDefault", field);
        if (null != this._defaultMethod) {
            throw new ReactProcessorException("@PropDefault target duplicates existing method named " + this._defaultMethod.getSimpleName(), field);
        }
        if (null != this._defaultField) {
            throw new ReactProcessorException("@PropDefault target duplicates existing field named " + this._defaultField.getSimpleName(), field);
        }
        this._defaultField = Objects.requireNonNull(field);
    }

    boolean hasDefaultField() {
        return null != this._defaultField;
    }

    @Nonnull
    VariableElement getDefaultField() {
        assert (null != this._defaultField);
        return this._defaultField;
    }

    boolean hasDefaultMethod() {
        return null != this._defaultMethod;
    }

    @Nonnull
    ExecutableElement getDefaultMethod() {
        assert (null != this._defaultMethod);
        return this._defaultMethod;
    }

    boolean isOptional() {
        return this._optional;
    }

    void markAsOptional() {
        this._optional = true;
    }

    @Nonnull
    String getConstantName() {
        return this.getName();
    }

    boolean isSpecialChildrenProp() {
        return this.getName().equals("children") || this.getName().equals("child");
    }
}

