/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import react4j.processor.ComponentType;
import react4j.processor.MethodChecks;
import react4j.processor.OnPropChangeDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.PropComparator;
import react4j.processor.PropDescriptor;
import react4j.processor.ReactProcessorException;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;

final class ComponentDescriptor {
    @Nonnull
    private final Elements _elements;
    @Nonnull
    private final SourceVersion _sourceVersion;
    @Nonnull
    private final String _name;
    @Nonnull
    private final PackageElement _packageElement;
    @Nonnull
    private final TypeElement _element;
    @Nonnull
    private final ComponentType _type;
    private final boolean _nonConstructorInjections;
    @Nonnull
    private final ExecutableElement _constructor;
    @Nullable
    private ExecutableElement _preUpdate;
    @Nullable
    private ExecutableElement _postRender;
    @Nullable
    private ExecutableElement _postUpdate;
    @Nullable
    private ExecutableElement _postMount;
    @Nullable
    private ExecutableElement _onError;
    @Nullable
    private List<PropDescriptor> _props;
    @Nullable
    private List<OnPropChangeDescriptor> _onPropChangeDescriptors;
    @Nullable
    private List<String> _priorityOverrides;
    private Boolean _hasValidatedProps;
    private boolean _hasArezElements;

    ComponentDescriptor(@Nonnull Elements elements, @Nonnull SourceVersion sourceVersion, @Nonnull String name, @Nonnull PackageElement packageElement, @Nonnull TypeElement element, @Nonnull ComponentType type, boolean nonConstructorInjections) {
        this._elements = Objects.requireNonNull(elements);
        this._sourceVersion = Objects.requireNonNull(sourceVersion);
        this._name = Objects.requireNonNull(name);
        this._packageElement = Objects.requireNonNull(packageElement);
        this._element = Objects.requireNonNull(element);
        this._type = Objects.requireNonNull(type);
        this._nonConstructorInjections = nonConstructorInjections;
        if (ElementKind.CLASS != element.getKind()) {
            throw new ReactProcessorException("@ReactComponent target must be a class", element);
        }
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ReactProcessorException("@ReactComponent target must not be final", element);
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ReactProcessorException("@ReactComponent target must be abstract", element);
        }
        if (NestingKind.TOP_LEVEL != element.getNestingKind() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ReactProcessorException("@ReactComponent target must not be a non-static nested class", element);
        }
        List constructors = element.getEnclosedElements().stream().filter(m -> m.getKind() == ElementKind.CONSTRUCTOR).map(m -> (ExecutableElement)m).collect(Collectors.toList());
        if (1 != constructors.size() || !this.isConstructorValid((ExecutableElement)constructors.get(0))) {
            throw new ReactProcessorException("@ReactComponent target must have a single, package-access constructor or the default constructor", element);
        }
        this._constructor = (ExecutableElement)constructors.get(0);
        for (VariableElement variableElement : this._constructor.getParameters()) {
            if (!ProcessorUtil.hasAnnotationOfType(variableElement, "arez.annotations.PerInstance")) continue;
            throw new ReactProcessorException("@ReactComponent target has a constructor with a parameter named '" + variableElement.getSimpleName().toString() + "' that is incorrectly annotated with the " + "arez.annotations.PerInstance" + " annotation.", element);
        }
    }

    private boolean isConstructorValid(@Nonnull ExecutableElement ctor) {
        List<? extends VariableElement> parameters = ctor.getParameters();
        Set<Modifier> modifiers = ctor.getModifiers();
        if (parameters.isEmpty()) {
            return !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
        }
        return !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED);
    }

    @Nonnull
    Elements getElements() {
        return this._elements;
    }

    @Nonnull
    ExecutableElement getConstructor() {
        return this._constructor;
    }

    private boolean hasConstructorParams() {
        return !this._constructor.getParameters().isEmpty();
    }

    @Nonnull
    SourceVersion getSourceVersion() {
        return this._sourceVersion;
    }

    @Nonnull
    String getPackageName() {
        return this._packageElement.getQualifiedName().toString();
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    boolean nonConstructorInjections() {
        return this._nonConstructorInjections;
    }

    @Nonnull
    ClassName getClassName() {
        return ClassName.get(this.getElement());
    }

    @Nonnull
    TypeElement getElement() {
        return this._element;
    }

    @Nonnull
    DeclaredType getDeclaredType() {
        return (DeclaredType)this._element.asType();
    }

    @Nonnull
    ClassName getEnhancedClassName() {
        return ClassName.get(this.getPackageName(), this.getNestedClassPrefix() + "React4j_" + this._element.getSimpleName(), new String[0]);
    }

    @Nonnull
    ClassName getBuilderClassName() {
        return ClassName.get(this.getPackageName(), this.getNestedClassPrefix() + this._element.getSimpleName() + "Builder", new String[0]);
    }

    @Nonnull
    ClassName getDaggerComponentExtensionClassName() {
        return ClassName.get(this.getPackageName(), this.getNestedClassPrefix() + this._element.getSimpleName() + "DaggerComponentExtension", new String[0]);
    }

    @Nonnull
    ClassName getArezDaggerExtensionClassName() {
        return ClassName.get(this.getPackageName(), this.getNestedClassPrefix() + "React4j_" + this._element.getSimpleName() + "DaggerComponentExtension", new String[0]);
    }

    @Nonnull
    ClassName getArezClassName() {
        String simpleName = "Arez_" + this.getNestedClassPrefix() + "React4j_" + this._element.getSimpleName();
        return ClassName.get(this.getPackageName(), simpleName, new String[0]);
    }

    @Nonnull
    TypeName getComponentType() {
        List<TypeName> typeNames = this.getDeclaredType().getTypeArguments().stream().map(TypeName::get).collect(Collectors.toList());
        if (!typeNames.isEmpty()) {
            return ParameterizedTypeName.get(ClassName.get(this.getElement()), typeNames.toArray(new TypeName[0]));
        }
        return ClassName.get(this.getElement());
    }

    boolean needsInjection() {
        return this.nonConstructorInjections() || this.hasConstructorParams();
    }

    boolean trackRender() {
        return ComponentType.MAYBE_TRACKING == this._type || ComponentType.TRACKING == this._type;
    }

    void setHasArezElements(boolean hasArezElements) {
        this._hasArezElements = hasArezElements;
    }

    public ComponentType getType() {
        return this._type;
    }

    @Nonnull
    private String getNestedClassPrefix() {
        StringBuilder name = new StringBuilder();
        TypeElement t = this.getElement();
        while (NestingKind.TOP_LEVEL != t.getNestingKind()) {
            t = (TypeElement)t.getEnclosingElement();
            name.insert(0, t.getSimpleName() + "_");
        }
        return name.toString();
    }

    @Nonnull
    List<String> getPriorityOverrides() {
        assert (null != this._priorityOverrides);
        return this._priorityOverrides;
    }

    void setPriorityOverrides(@Nonnull List<String> priorityOverrides) {
        this._priorityOverrides = Objects.requireNonNull(priorityOverrides);
    }

    int syntheticKeyComponents() {
        return (int)this.getProps().stream().filter(PropDescriptor::isImmutable).count();
    }

    @Nonnull
    List<PropDescriptor> getProps() {
        assert (null != this._props);
        return this._props;
    }

    @Nullable
    PropDescriptor findPropNamed(@Nonnull String name) {
        return this.getProps().stream().filter(p -> p.getName().equals(name)).findAny().orElse(null);
    }

    void setProps(@Nonnull List<PropDescriptor> events) {
        this._props = Objects.requireNonNull(events);
    }

    void sortProps() {
        assert (null != this._props);
        this._props.sort(PropComparator.COMPARATOR);
    }

    @Nonnull
    List<OnPropChangeDescriptor> getPreUpdateOnPropChangeDescriptors() {
        return this.getOnPropChangeDescriptors().stream().filter(OnPropChangeDescriptor::isPreUpdate).collect(Collectors.toList());
    }

    @Nonnull
    List<OnPropChangeDescriptor> getPostUpdateOnPropChangeDescriptors() {
        return this.getOnPropChangeDescriptors().stream().filter(o -> !o.isPreUpdate()).collect(Collectors.toList());
    }

    @Nonnull
    private List<OnPropChangeDescriptor> getOnPropChangeDescriptors() {
        assert (null != this._onPropChangeDescriptors);
        return this._onPropChangeDescriptors;
    }

    void setOnPropChangeDescriptors(@Nonnull List<OnPropChangeDescriptor> onPropChangeDescriptors) {
        this._onPropChangeDescriptors = Objects.requireNonNull(onPropChangeDescriptors);
    }

    boolean hasObservableProps() {
        return this.getProps().stream().anyMatch(PropDescriptor::isObservable);
    }

    @Nullable
    ExecutableElement getPreUpdate() {
        return this._preUpdate;
    }

    void setPreUpdate(@Nonnull ExecutableElement preUpdate) throws ReactProcessorException {
        MethodChecks.mustBeLifecycleHook(this.getElement(), "react4j.annotations.PreUpdate", preUpdate);
        if (null != this._preUpdate) {
            throw new ReactProcessorException("@PreUpdate target duplicates existing method named " + this._preUpdate.getSimpleName(), preUpdate);
        }
        this._preUpdate = preUpdate;
    }

    @Nullable
    ExecutableElement getPostRender() {
        return this._postRender;
    }

    void setPostRender(@Nonnull ExecutableElement postRender) throws ReactProcessorException {
        MethodChecks.mustBeLifecycleHook(this.getElement(), "react4j.annotations.PostMountOrUpdate", postRender);
        if (null != this._postRender) {
            throw new ReactProcessorException("@PostMountOrUpdate target duplicates existing method named " + this._postRender.getSimpleName(), postRender);
        }
        this._postRender = postRender;
    }

    @Nullable
    ExecutableElement getPostUpdate() {
        return this._postUpdate;
    }

    void setPostUpdate(@Nonnull ExecutableElement postUpdate) throws ReactProcessorException {
        MethodChecks.mustBeLifecycleHook(this.getElement(), "react4j.annotations.PostUpdate", postUpdate);
        if (null != this._postUpdate) {
            throw new ReactProcessorException("@PostUpdate target duplicates existing method named " + this._postUpdate.getSimpleName(), postUpdate);
        }
        this._postUpdate = postUpdate;
    }

    @Nullable
    ExecutableElement getPostMount() {
        return this._postMount;
    }

    void setPostMount(@Nonnull ExecutableElement postMount) throws ReactProcessorException {
        MethodChecks.mustBeLifecycleHook(this.getElement(), "react4j.annotations.PostMount", postMount);
        if (null != this._postMount) {
            throw new ReactProcessorException("@PostMount target duplicates existing method named " + this._postMount.getSimpleName(), postMount);
        }
        this._postMount = postMount;
    }

    @Nullable
    ExecutableElement getOnError() {
        return this._onError;
    }

    void setOnError(@Nonnull ExecutableElement onError) throws ReactProcessorException {
        MethodChecks.mustNotBeAbstract("react4j.annotations.OnError", onError);
        MethodChecks.mustNotBePublic("react4j.annotations.OnError", onError);
        MethodChecks.mustBeSubclassCallable(this.getElement(), "react4j.annotations.OnError", onError);
        MethodChecks.mustNotReturnAValue("react4j.annotations.OnError", onError);
        MethodChecks.mustNotThrowAnyExceptions("react4j.annotations.OnError", onError);
        boolean infoFound = false;
        boolean errorFound = false;
        for (VariableElement variableElement : onError.getParameters()) {
            TypeName typeName = TypeName.get(variableElement.asType());
            if (typeName.toString().equals("react4j.ReactErrorInfo")) {
                if (infoFound) {
                    throw new ReactProcessorException("@OnError target has multiple parameters of type react4j.ReactErrorInfo", onError);
                }
                infoFound = true;
                continue;
            }
            if (typeName.toString().equals("elemental2.core.JsError")) {
                if (errorFound) {
                    throw new ReactProcessorException("@OnError target has multiple parameters of type elemental2.core.JsError", onError);
                }
                errorFound = true;
                continue;
            }
            throw new ReactProcessorException("@OnError target has parameter of invalid type named " + variableElement.getSimpleName().toString(), variableElement);
        }
        if (null != this._onError) {
            throw new ReactProcessorException("@OnError target duplicates existing method named " + this._onError.getSimpleName(), onError);
        }
        this._onError = onError;
    }

    private boolean shouldGenerateLifecycle() {
        return this.generateComponentDidMount() || this.generateShouldComponentUpdate() || this.generateComponentPreUpdate() || this.generateComponentDidUpdate() || this.generateComponentWillUnmount() || this.generateComponentDidCatch();
    }

    boolean shouldGenerateLiteLifecycle() {
        return (this.generateComponentDidUpdateInLiteLifecycle() != this.generateComponentDidUpdate() || this.generateComponentWillUnmountInLiteLifecycle() != this.generateComponentWillUnmount() || this.generateShouldComponentUpdateInLiteLifecycle() != this.generateShouldComponentUpdate() || this.generateComponentDidMountInLiteLifecycle() != this.generateComponentDidMount()) && this.shouldGenerateLifecycle();
    }

    boolean generateShouldComponentUpdate() {
        return this.generateShouldComponentUpdateInLiteLifecycle() || this.hasValidatedProps();
    }

    boolean generateShouldComponentUpdateInLiteLifecycle() {
        return true;
    }

    boolean generateComponentDidCatch() {
        return null != this._onError;
    }

    boolean generateComponentWillUnmountInLiteLifecycle() {
        return this._hasArezElements;
    }

    boolean generateComponentWillUnmount() {
        return true;
    }

    boolean generateComponentPreUpdate() {
        return this.hasPreUpdateOnPropChange() || null != this._preUpdate;
    }

    boolean generateComponentDidMount() {
        return this.generateComponentDidMountInLiteLifecycle() || this.trackRender();
    }

    boolean generateComponentDidMountInLiteLifecycle() {
        return null != this._postMount || null != this._postRender;
    }

    boolean hasPreUpdateOnPropChange() {
        return !this.getPreUpdateOnPropChangeDescriptors().isEmpty();
    }

    boolean hasPostUpdateOnPropChange() {
        return !this.getPostUpdateOnPropChangeDescriptors().isEmpty();
    }

    boolean generateComponentDidUpdate() {
        return this.generateComponentDidUpdateInLiteLifecycle() || this.trackRender();
    }

    boolean generateComponentDidUpdateInLiteLifecycle() {
        return this.hasPostUpdateOnPropChange() || null != this._postUpdate || null != this._postRender;
    }

    boolean hasValidatedProps() {
        if (null == this._hasValidatedProps) {
            this._hasValidatedProps = this.getProps().stream().anyMatch(PropDescriptor::hasValidateMethod);
        }
        return this._hasValidatedProps;
    }
}

