/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.google.common.collect;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import react4j.processor.vendor.google.common.annotations.GwtCompatible;
import react4j.processor.vendor.google.common.base.Preconditions;
import react4j.processor.vendor.google.common.collect.Multiset;
import react4j.processor.vendor.google.errorprone.annotations.CanIgnoreReturnValue;
import react4j.processor.vendor.google.errorprone.annotations.CompatibleWith;

@GwtCompatible
public interface Multimap<K, V> {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(@NullableDecl @CompatibleWith(value="K") Object var1);

    public boolean containsValue(@NullableDecl @CompatibleWith(value="V") Object var1);

    public boolean containsEntry(@NullableDecl @CompatibleWith(value="K") Object var1, @NullableDecl @CompatibleWith(value="V") Object var2);

    @CanIgnoreReturnValue
    public boolean put(@NullableDecl K var1, @NullableDecl V var2);

    @CanIgnoreReturnValue
    public boolean remove(@NullableDecl @CompatibleWith(value="K") Object var1, @NullableDecl @CompatibleWith(value="V") Object var2);

    @CanIgnoreReturnValue
    public boolean putAll(@NullableDecl K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public boolean putAll(Multimap<? extends K, ? extends V> var1);

    @CanIgnoreReturnValue
    public Collection<V> replaceValues(@NullableDecl K var1, Iterable<? extends V> var2);

    @CanIgnoreReturnValue
    public Collection<V> removeAll(@NullableDecl @CompatibleWith(value="K") Object var1);

    public void clear();

    public Collection<V> get(@NullableDecl K var1);

    public Set<K> keySet();

    public Multiset<K> keys();

    public Collection<V> values();

    public Collection<Map.Entry<K, V>> entries();

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries().forEach((? super T entry) -> action.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    public Map<K, Collection<V>> asMap();

    public boolean equals(@NullableDecl Object var1);

    public int hashCode();
}

