/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.processing.Filer;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import react4j.processor.vendor.google.auto.common.MoreElements;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.JavaFile;
import react4j.processor.vendor.javapoet.TypeSpec;

final class GeneratorUtil {
    private GeneratorUtil() {
    }

    @Nonnull
    static ClassName getGeneratedClassName(@Nonnull TypeElement element, @Nonnull String prefix, @Nonnull String postfix) {
        return ClassName.get(GeneratorUtil.getQualifiedPackageName(element), GeneratorUtil.getGeneratedSimpleClassName(element, prefix, postfix), new String[0]);
    }

    @Nonnull
    static String getQualifiedPackageName(@Nonnull TypeElement element) {
        return GeneratorUtil.getPackageElement(element).getQualifiedName().toString();
    }

    @Nonnull
    static String getGeneratedSimpleClassName(@Nonnull TypeElement element, @Nonnull String prefix, @Nonnull String postfix) {
        return GeneratorUtil.getNestedClassPrefix(element) + prefix + element.getSimpleName() + postfix;
    }

    @Nonnull
    private static String getNestedClassPrefix(@Nonnull TypeElement element) {
        StringBuilder name = new StringBuilder();
        TypeElement t = element;
        while (NestingKind.TOP_LEVEL != t.getNestingKind()) {
            t = (TypeElement)t.getEnclosingElement();
            name.insert(0, t.getSimpleName() + "_");
        }
        return name.toString();
    }

    @Nonnull
    static PackageElement getPackageElement(@Nonnull TypeElement element) {
        return MoreElements.getPackage(element);
    }

    static void emitJavaType(@Nonnull String packageName, @Nonnull TypeSpec typeSpec, Filer filer) throws IOException {
        JavaFile.builder(packageName, typeSpec).skipJavaLangImports(true).build().writeTo(filer);
    }
}

