/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import react4j.processor.GeneratorUtil;
import react4j.processor.ProcessorException;
import react4j.processor.ProcessorUtil;

final class MemberChecks {
    private MemberChecks() {
    }

    static void mustBeWrappable(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        MemberChecks.mustBeOverridable(targetType, scopeAnnotationName, annotationName, element);
        MemberChecks.mustNotBeAbstract(annotationName, element);
    }

    static void mustBeOverridable(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        MemberChecks.mustNotBeFinal(annotationName, element);
        MemberChecks.mustBeSubclassCallable(targetType, scopeAnnotationName, annotationName, element);
    }

    static void mustBeSubclassCallable(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        MemberChecks.mustNotBeStatic(annotationName, element);
        MemberChecks.mustNotBePrivate(annotationName, element);
        MemberChecks.mustNotBePackageAccessInDifferentPackage(targetType, scopeAnnotationName, annotationName, element);
    }

    static void mustBeStaticallySubclassCallable(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element method) throws ProcessorException {
        MemberChecks.mustBeStatic(annotationName, method);
        MemberChecks.mustNotBePrivate(annotationName, method);
        MemberChecks.mustNotBePackageAccessInDifferentPackage(targetType, scopeAnnotationName, annotationName, method);
    }

    static void mustBeLifecycleHook(@Nonnull TypeElement targetType, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        MemberChecks.mustNotBeAbstract(annotationName, method);
        MemberChecks.mustBeSubclassCallable(targetType, scopeAnnotationName, annotationName, method);
        MemberChecks.mustNotHaveAnyParameters(annotationName, method);
        MemberChecks.mustNotReturnAnyValue(annotationName, method);
        MemberChecks.mustNotThrowAnyExceptions(annotationName, method);
    }

    static void mustBeStatic(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be static"), element);
        }
    }

    static void mustNotBeStatic(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be static"), element);
        }
    }

    static void mustBeAbstract(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be abstract"), element);
        }
    }

    static void mustNotBeAbstract(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be abstract"), element);
        }
    }

    static void mustBeFinal(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be final"), element);
        }
    }

    static void mustNotBeFinal(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be final"), element);
        }
    }

    static void mustBePublic(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be public"), element);
        }
    }

    static void mustNotBePublic(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be public"), element);
        }
    }

    static void mustBePrivate(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (!element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ProcessorException(MemberChecks.must(annotationName, "be private"), element);
        }
    }

    static void mustNotBePrivate(@Nonnull String annotationName, @Nonnull Element element) throws ProcessorException {
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "be private"), element);
        }
    }

    static void mustNotBePackageAccessInDifferentPackage(@Nonnull TypeElement element, @Nonnull String scopeAnnotationName, @Nonnull String annotationName, @Nonnull Element other) throws ProcessorException {
        boolean isPackageAccess;
        Set<Modifier> modifiers = other.getModifiers();
        boolean bl = isPackageAccess = !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PUBLIC);
        if (isPackageAccess) {
            PackageElement packageElement = GeneratorUtil.getPackageElement(element);
            PackageElement otherPackageElement = GeneratorUtil.getPackageElement((TypeElement)other.getEnclosingElement());
            if (!Objects.equals(packageElement.getQualifiedName(), otherPackageElement.getQualifiedName())) {
                throw new ProcessorException(MemberChecks.mustNot(annotationName, "be package access if the " + (other instanceof ExecutableElement ? "method" : "field") + " is in a different package from the type annotated with the " + MemberChecks.toSimpleName(scopeAnnotationName) + " annotation"), other);
            }
        }
    }

    static void mustNotHaveAnyParameters(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        if (!method.getParameters().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "have any parameters"), method);
        }
    }

    static void mustNotReturnAnyValue(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        if (TypeKind.VOID != method.getReturnType().getKind()) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "return a value"), method);
        }
    }

    static void mustReturnAValue(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        if (TypeKind.VOID == method.getReturnType().getKind()) {
            throw new ProcessorException(MemberChecks.must(annotationName, "return a value"), method);
        }
    }

    static void mustNotThrowAnyExceptions(@Nonnull String annotationName, @Nonnull ExecutableElement method) throws ProcessorException {
        if (!method.getThrownTypes().isEmpty()) {
            throw new ProcessorException(MemberChecks.mustNot(annotationName, "throw any exceptions"), method);
        }
    }

    static void verifyNoOverlappingAnnotations(@Nonnull Element element, @Nonnull Collection<String> annotations, @Nonnull Map<String, Collection<String>> exceptions) throws ProcessorException {
        String[] annotationTypes = annotations.toArray(new String[0]);
        for (int i = 0; i < annotationTypes.length; ++i) {
            String type1 = annotationTypes[i];
            AnnotationMirror annotation1 = ProcessorUtil.findAnnotationByType(element, type1);
            if (null == annotation1) continue;
            for (int j = i + 1; j < annotationTypes.length; ++j) {
                AnnotationMirror annotation2;
                String type2 = annotationTypes[j];
                if (MemberChecks.isException(exceptions, type1, type2) || null == (annotation2 = ProcessorUtil.findAnnotationByType(element, type2))) continue;
                String message = "Method can not be annotated with both " + MemberChecks.toSimpleName(type1) + " and " + MemberChecks.toSimpleName(type2);
                throw new ProcessorException(message, element);
            }
        }
    }

    private static boolean isException(@Nonnull Map<String, Collection<String>> exceptions, @Nonnull String type1, @Nonnull String type2) {
        return exceptions.containsKey(type1) && exceptions.get(type1).contains(type2) || exceptions.containsKey(type2) && exceptions.get(type2).contains(type1);
    }

    @Nonnull
    private static String must(@Nonnull String annotationName, @Nonnull String message) {
        return MemberChecks.toSimpleName(annotationName) + " target must " + message;
    }

    @Nonnull
    private static String mustNot(@Nonnull String annotationName, @Nonnull String message) {
        return MemberChecks.must(annotationName, "not " + message);
    }

    @Nonnull
    private static String toSimpleName(@Nonnull String annotationName) {
        return "@" + annotationName.replaceAll(".*\\.", "");
    }
}

