/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import react4j.processor.AnnotationsUtil;
import react4j.processor.ProcessorException;

final class ProcessorUtil {
    private static final Pattern GETTER_PATTERN = Pattern.compile("^get([A-Z].*)$");
    private static final Pattern ISSER_PATTERN = Pattern.compile("^is([A-Z].*)$");

    private ProcessorUtil() {
    }

    static boolean isWarningSuppressed(@Nonnull Element element, @Nonnull String warning, @Nullable String alternativeSuppressWarnings) {
        Element enclosingElement;
        SuppressWarnings annotation;
        String[] value;
        AnnotationMirror suppress;
        if (null != alternativeSuppressWarnings && null != (suppress = AnnotationsUtil.findAnnotationByType(element, alternativeSuppressWarnings)) && null != (value = AnnotationsUtil.findAnnotationValueNoDefaults(suppress, "value"))) {
            List warnings = (List)value.getValue();
            for (AnnotationValue annotationValue : warnings) {
                if (!warning.equals(annotationValue.getValue())) continue;
                return true;
            }
        }
        if (null != (annotation = element.getAnnotation(SuppressWarnings.class))) {
            for (String string : annotation.value()) {
                if (!warning.equals(string)) continue;
                return true;
            }
        }
        return null != (enclosingElement = element.getEnclosingElement()) && ProcessorUtil.isWarningSuppressed(enclosingElement, warning, alternativeSuppressWarnings);
    }

    @Nonnull
    static List<TypeElement> getSuperTypes(@Nonnull TypeElement element) {
        ArrayList<TypeElement> superTypes = new ArrayList<TypeElement>();
        ProcessorUtil.enumerateSuperTypes(element, superTypes);
        return superTypes;
    }

    private static void enumerateSuperTypes(@Nonnull TypeElement element, @Nonnull List<TypeElement> superTypes) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            superTypes.add(superclassElement);
            ProcessorUtil.enumerateSuperTypes(superclassElement, superTypes);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ProcessorUtil.enumerateSuperTypes(interfaceElement, superTypes);
        }
    }

    @Nonnull
    static List<ExecutableElement> getMethods(@Nonnull TypeElement element, @Nonnull Types typeUtils) {
        LinkedHashMap<String, ExecutableElement> methodMap = new LinkedHashMap<String, ExecutableElement>();
        ProcessorUtil.enumerateMethods(element, typeUtils, element, methodMap);
        return new ArrayList<ExecutableElement>(methodMap.values());
    }

    private static void enumerateMethods(@Nonnull TypeElement scope, @Nonnull Types typeUtils, @Nonnull TypeElement element, @Nonnull Map<String, ExecutableElement> methods) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            ProcessorUtil.enumerateMethods(scope, typeUtils, (TypeElement)((DeclaredType)superclass).asElement(), methods);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ProcessorUtil.enumerateMethods(scope, typeUtils, interfaceElement, methods);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.METHOD) continue;
            ExecutableType methodType = (ExecutableType)typeUtils.asMemberOf((DeclaredType)scope.asType(), element2);
            methods.put(element2.getSimpleName() + methodType.toString(), (ExecutableElement)element2);
        }
    }

    @Nonnull
    static List<VariableElement> getFieldElements(@Nonnull TypeElement element) {
        LinkedHashMap<String, VariableElement> methodMap = new LinkedHashMap<String, VariableElement>();
        ProcessorUtil.enumerateFieldElements(element, methodMap);
        return new ArrayList<VariableElement>(methodMap.values());
    }

    private static void enumerateFieldElements(@Nonnull TypeElement element, @Nonnull Map<String, VariableElement> fields) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            ProcessorUtil.enumerateFieldElements((TypeElement)((DeclaredType)superclass).asElement(), fields);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.FIELD) continue;
            fields.put(element2.getSimpleName().toString(), (VariableElement)element2);
        }
    }

    @Nonnull
    static String getPropertyAccessorName(@Nonnull ExecutableElement method, @Nonnull String specifiedName, @Nonnull String sentinelName) throws ProcessorException {
        String name = ProcessorUtil.deriveName(method, GETTER_PATTERN, specifiedName, sentinelName);
        if (null != name) {
            return name;
        }
        if (method.getReturnType().getKind() == TypeKind.BOOLEAN && null != (name = ProcessorUtil.deriveName(method, ISSER_PATTERN, specifiedName, sentinelName))) {
            return name;
        }
        return method.getSimpleName().toString();
    }

    @Nullable
    static String deriveName(@Nonnull Element method, @Nonnull Pattern pattern, @Nonnull String name, @Nonnull String sentinelName) throws ProcessorException {
        if (sentinelName.equals(name)) {
            String methodName = method.getSimpleName().toString();
            Matcher matcher = pattern.matcher(methodName);
            if (matcher.find()) {
                String candidate = matcher.group(1);
                return Character.toLowerCase(candidate.charAt(0)) + candidate.substring(1);
            }
            return null;
        }
        return name;
    }
}

