/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import react4j.processor.AnnotationsUtil;
import react4j.processor.BuilderDescriptor;
import react4j.processor.ComponentDescriptor;
import react4j.processor.ComponentType;
import react4j.processor.GeneratorUtil;
import react4j.processor.ImmutablePropKeyStrategy;
import react4j.processor.MemberChecks;
import react4j.processor.OnPropChangeDescriptor;
import react4j.processor.ProcessorException;
import react4j.processor.PropDescriptor;
import react4j.processor.React4jProcessor;
import react4j.processor.Step;
import react4j.processor.StepMethod;
import react4j.processor.StepMethodType;
import react4j.processor.vendor.javapoet.AnnotationSpec;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.CodeBlock;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.javapoet.TypeVariableName;
import react4j.processor.vendor.javapoet.WildcardTypeName;

final class Generator {
    private static final ClassName NONNULL_CLASSNAME = ClassName.get("javax.annotation", "Nonnull", new String[0]);
    private static final ClassName NULLABLE_CLASSNAME = ClassName.get("javax.annotation", "Nullable", new String[0]);
    private static final ClassName GUARDS_CLASSNAME = ClassName.get("org.realityforge.braincheck", "Guards", new String[0]);
    private static final ClassName AREZ_CLASSNAME = ClassName.get("arez", "Arez", new String[0]);
    private static final ClassName OBSERVER_CLASSNAME = ClassName.get("arez", "Observer", new String[0]);
    private static final ClassName OBSERVABLE_CLASSNAME = ClassName.get("arez", "ObservableValue", new String[0]);
    private static final ClassName DISPOSABLE_CLASSNAME = ClassName.get("arez", "Disposable", new String[0]);
    private static final ClassName AREZ_FEATURE_CLASSNAME = ClassName.get("arez.annotations", "Feature", new String[0]);
    private static final ClassName AREZ_INJECT_MODE_CLASSNAME = ClassName.get("arez.annotations", "InjectMode", new String[0]);
    private static final ClassName ACTION_CLASSNAME = ClassName.get("arez.annotations", "Action", new String[0]);
    private static final ClassName DEP_TYPE_CLASSNAME = ClassName.get("arez.annotations", "DepType", new String[0]);
    private static final ClassName PER_INSTANCE_CLASSNAME = ClassName.get("arez.annotations", "PerInstance", new String[0]);
    private static final ClassName PRIORITY_CLASSNAME = ClassName.get("arez.annotations", "Priority", new String[0]);
    private static final ClassName EXECUTOR_CLASSNAME = ClassName.get("arez.annotations", "Executor", new String[0]);
    private static final ClassName OBSERVABLE_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "Observable", new String[0]);
    private static final ClassName OBSERVE_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "Observe", new String[0]);
    private static final ClassName OBSERVER_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ObserverRef", new String[0]);
    private static final ClassName COMPONENT_STATE_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ComponentStateRef", new String[0]);
    private static final ClassName OBSERVABLE_VALUE_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ObservableValueRef", new String[0]);
    private static final ClassName AREZ_COMPONENT_CLASSNAME = ClassName.get("arez.annotations", "ArezComponent", new String[0]);
    private static final ClassName IDENTIFIABLE_CLASSNAME = ClassName.get("arez.component", "Identifiable", new String[0]);
    private static final ClassName JS_ARRAY_CLASSNAME = ClassName.get("elemental2.core", "JsArray", new String[0]);
    private static final ClassName JS_ERROR_CLASSNAME = ClassName.get("elemental2.core", "JsError", new String[0]);
    private static final ClassName JS_CONSTRUCTOR_CLASSNAME = ClassName.get("jsinterop.annotations", "JsConstructor", new String[0]);
    private static final ClassName JS_CLASSNAME = ClassName.get("jsinterop.base", "Js", new String[0]);
    private static final ClassName JS_PROPERTY_MAP_CLASSNAME = ClassName.get("jsinterop.base", "JsPropertyMap", new String[0]);
    private static final ParameterizedTypeName JS_PROPERTY_MAP_T_OBJECT_CLASSNAME = ParameterizedTypeName.get(JS_PROPERTY_MAP_CLASSNAME, TypeName.OBJECT);
    private static final ClassName REACT_NODE_CLASSNAME = ClassName.get("react4j", "ReactNode", new String[0]);
    private static final ClassName KEYED_CLASSNAME = ClassName.get("react4j", "Keyed", new String[0]);
    private static final ClassName REACT_ELEMENT_CLASSNAME = ClassName.get("react4j", "ReactElement", new String[0]);
    private static final ClassName REACT_ERROR_INFO_CLASSNAME = ClassName.get("react4j", "ReactErrorInfo", new String[0]);
    private static final ClassName REACT_CLASSNAME = ClassName.get("react4j", "React", new String[0]);
    private static final ClassName COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME = ClassName.get("react4j.internal", "ComponentConstructorFunction", new String[0]);
    private static final ClassName ON_COMPONENT_DID_MOUNT_CLASSNAME = ClassName.get("react4j.internal", "OnComponentDidMount", new String[0]);
    private static final ClassName ON_COMPONENT_DID_UPDATE_CLASSNAME = ClassName.get("react4j.internal", "OnComponentDidUpdate", new String[0]);
    private static final ClassName ON_COMPONENT_WILL_UNMOUNT_CLASSNAME = ClassName.get("react4j.internal", "OnComponentWillUnmount", new String[0]);
    private static final ClassName ON_GET_SNAPSHOT_BEFORE_UPDATE_CLASSNAME = ClassName.get("react4j.internal", "OnGetSnapshotBeforeUpdate", new String[0]);
    private static final ClassName ON_COMPONENT_SHOULD_UPDATE_CLASSNAME = ClassName.get("react4j.internal", "OnShouldComponentUpdate", new String[0]);
    private static final ClassName ON_COMPONENT_DID_CATCH_CLASSNAME = ClassName.get("react4j.internal", "OnComponentDidCatch", new String[0]);
    private static final ClassName REACT_NATIVE_COMPONENT_CLASSNAME = ClassName.get("react4j.internal", "NativeComponent", new String[0]);
    private static final ClassName COMPONENT_STATE_CLASSNAME = ClassName.get("react4j.internal.arez", "ComponentState", new String[0]);
    private static final ClassName SCHEDULER_UTIL_CLASSNAME = ClassName.get("react4j.internal.arez", "SchedulerUtil", new String[0]);
    private static final ClassName INTROSPECT_UTIL_CLASSNAME = ClassName.get("react4j.internal.arez", "IntrospectUtil", new String[0]);
    private static final String FRAMEWORK_INTERNAL_PREFIX = "$$react4j$$_";
    private static final String SHOULD_COMPONENT_UPDATE_METHOD = "$$react4j$$_shouldComponentUpdate";
    private static final String COMPONENT_PRE_UPDATE_METHOD = "$$react4j$$_componentPreUpdate";
    private static final String COMPONENT_DID_UPDATE_METHOD = "$$react4j$$_componentDidUpdate";
    private static final String COMPONENT_DID_MOUNT_METHOD = "$$react4j$$_componentDidMount";
    private static final String COMPONENT_WILL_UNMOUNT_METHOD = "$$react4j$$_componentWillUnmount";
    private static final String VALIDATE_PROPS_METHOD = "$$react4j$$_validatePropValues";
    private static final String COMPONENT_STATE_FIELD = "$$react4j$$_state";
    private static final String COMPONENT_FIELD = "$$react4j$$_component";
    private static final String IS_READY_METHOD = "$$react4j$$_isReady";
    @Nonnull
    private static final List<String> ANNOTATION_WHITELIST = Arrays.asList("javax.annotation.Nonnull", "javax.annotation.Nullable", SuppressWarnings.class.getName(), Deprecated.class.getName());

    private Generator() {
    }

    @Nonnull
    static TypeSpec buildComponentBuilder(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getBuilderClassName());
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        Generator.addGeneratedAnnotation(processingEnv, builder);
        builder.addModifiers(Modifier.FINAL);
        GeneratorUtil.copyAccessModifiers(descriptor.getElement(), builder);
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)descriptor.getElement(), builder, Collections.singletonList(Deprecated.class.getName()));
        if (descriptor.builderAccessesDeprecatedElements()) {
            builder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "deprecation").build());
        }
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        BuilderDescriptor builderDescriptor = Generator.buildBuilderDescriptor(descriptor);
        List<Step> steps = builderDescriptor.getSteps();
        for (Step step : steps) {
            builder.addType(Generator.buildBuilderStepInterface(descriptor, step));
        }
        Generator.buildStaticStepMethodMethods(descriptor, builder, steps.get(0));
        builder.addType(Generator.buildBuilder(descriptor, builderDescriptor));
        return builder.build();
    }

    private static void buildStaticStepMethodMethods(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeSpec.Builder builder, @Nonnull Step step) {
        for (StepMethod method : step.getMethods()) {
            builder.addMethod(Generator.buildStaticStepMethodMethod(descriptor, step, method));
        }
    }

    @Nonnull
    private static MethodSpec buildStaticStepMethodMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        ExecutableType propMethodType;
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName()).addAnnotation(NONNULL_CLASSNAME);
        method.addModifiers(Modifier.STATIC);
        if (descriptor.getDeclaredType().asElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            method.addModifiers(Modifier.PUBLIC);
        }
        if (null != (propMethodType = stepMethod.getPropMethodType())) {
            GeneratorUtil.copyTypeParameters(propMethodType, method);
        }
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), method);
        if (stepMethod.isBuildIntrinsic()) {
            String infix = Generator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            method.addStatement("return new $T" + infix + "().build()", ClassName.bestGuess("Builder"));
        } else {
            ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), Modifier.FINAL);
            ExecutableElement propMethod = stepMethod.getPropMethod();
            if (null != propMethod) {
                Generator.copyWhitelistedAnnotations(propMethod, parameter);
            } else if (stepMethod.isChildrenStreamIntrinsic()) {
                parameter.addAnnotation(NONNULL_CLASSNAME);
            }
            method.addParameter(parameter.build());
            String infix = Generator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            method.addStatement("return new $T" + infix + "().$N( $N )", ClassName.bestGuess("Builder"), stepMethod.getName(), stepMethod.getName());
        }
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildStepInterfaceMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull String name, @Nonnull Step step, @Nonnull StepMethodType stepMethodType, @Nonnull Consumer<MethodSpec.Builder> action) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(name);
        method.addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
        method.addAnnotation(NONNULL_CLASSNAME);
        action.accept(method);
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethodType);
        return method;
    }

    private static void configureStepMethodReturns(@Nonnull ComponentDescriptor descriptor, @Nonnull MethodSpec.Builder method, @Nonnull Step step, @Nonnull StepMethodType stepMethodType) {
        if (StepMethodType.TERMINATE == stepMethodType) {
            method.returns(REACT_NODE_CLASSNAME);
        } else {
            int returnIndex = step.getIndex() + (StepMethodType.STAY == stepMethodType ? 0 : 1);
            ClassName className = ClassName.bestGuess("Step" + returnIndex);
            List<TypeVariableName> variableNames = GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType());
            if (variableNames.isEmpty()) {
                method.returns(className);
            } else {
                method.returns(ParameterizedTypeName.get(className, variableNames.toArray(new TypeName[0])));
            }
        }
    }

    @Nonnull
    private static TypeSpec buildBuilderStepInterface(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step) {
        int stepIndex = step.getIndex();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("Step" + stepIndex);
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builder.addTypeVariables(GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        if (!descriptor.getDeclaredType().getTypeArguments().isEmpty()) {
            builder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "unused").build());
        }
        for (StepMethod stepMethod : step.getMethods()) {
            StepMethodType stepMethodType = stepMethod.getStepMethodType();
            if (stepMethod.isBuildIntrinsic()) {
                builder.addMethod(Generator.buildStepInterfaceMethod(descriptor, "build", step, stepMethodType, m -> {}).build());
                continue;
            }
            builder.addMethod(Generator.buildStepInterfaceMethod(descriptor, stepMethod.getName(), step, stepMethodType, m -> {
                ExecutableType propMethodType = stepMethod.getPropMethodType();
                if (null != propMethodType) {
                    GeneratorUtil.copyTypeParameters(propMethodType, m);
                }
                if (stepMethod.isChildrenIntrinsic()) {
                    m.varargs();
                }
                ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), new Modifier[0]);
                ExecutableElement propMethod = stepMethod.getPropMethod();
                if (null != propMethod) {
                    Generator.copyWhitelistedAnnotations(propMethod, parameter);
                } else if (stepMethod.isChildrenStreamIntrinsic()) {
                    parameter.addAnnotation(NONNULL_CLASSNAME);
                }
                m.addParameter(parameter.build());
            }).build());
        }
        return builder.build();
    }

    @Nonnull
    private static MethodSpec buildBuilderStepImpl(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName());
        method.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        method.addAnnotation(Override.class);
        method.addAnnotation(NONNULL_CLASSNAME);
        PropDescriptor prop = stepMethod.getProp();
        ExecutableType propMethodType = stepMethod.getPropMethodType();
        if (null != propMethodType) {
            GeneratorUtil.copyTypeParameters(propMethodType, method);
        }
        ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), Modifier.FINAL);
        ExecutableElement propMethod = stepMethod.getPropMethod();
        if (null != propMethod) {
            Generator.copyWhitelistedAnnotations(propMethod, parameter);
        } else if (stepMethod.isChildrenStreamIntrinsic()) {
            parameter.addAnnotation(NONNULL_CLASSNAME);
        }
        method.addParameter(parameter.build());
        if (null != prop && prop.isImmutable() && 1 == descriptor.syntheticKeyComponents()) {
            ImmutablePropKeyStrategy strategy = prop.getImmutablePropKeyStrategy();
            if (ImmutablePropKeyStrategy.KEYED == strategy) {
                method.addStatement("_element.setKey( $T.class.getName() + $T.getKey( $N ) )", descriptor.getClassName(), KEYED_CLASSNAME, stepMethod.getName());
            } else if (ImmutablePropKeyStrategy.IS_STRING == strategy) {
                method.addStatement("_element.setKey( $T.class.getName() + $N )", descriptor.getClassName(), stepMethod.getName());
            } else if (ImmutablePropKeyStrategy.TO_STRING == strategy) {
                method.addStatement("_element.setKey( $T.class.getName() + $N )", descriptor.getClassName(), stepMethod.getName());
            } else if (ImmutablePropKeyStrategy.ENUM == strategy) {
                method.addStatement("_element.setKey( $T.class.getName() + $N.name() )", descriptor.getClassName(), stepMethod.getName());
            } else {
                assert (ImmutablePropKeyStrategy.AREZ_IDENTIFIABLE == strategy);
                method.addStatement("_element.setKey( $T.class.getName() + $T.<Object>getArezId( $N ) )", descriptor.getClassName(), IDENTIFIABLE_CLASSNAME, stepMethod.getName());
            }
        }
        if (stepMethod.isChildrenIntrinsic()) {
            method.varargs();
            assert (null != prop);
            method.addStatement("_element.props().set( $T.Props.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
        } else if (stepMethod.isChildrenStreamIntrinsic()) {
            method.addStatement("children( $N.toArray( $T[]::new ) )", stepMethod.getName(), REACT_NODE_CLASSNAME);
        } else if (stepMethod.isChildIntrinsic()) {
            assert (null != propMethod);
            assert (null != prop);
            if (Generator.isNonnull(propMethod)) {
                method.addStatement("_element.props().set( $T.Props.$N, $T.of( $T.requireNonNull( $N ) ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, Objects.class, stepMethod.getName());
            } else {
                method.addStatement("_element.props().set( $T.Props.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
            }
        } else {
            if (null != propMethod && Generator.isNonnull(propMethod) && !stepMethod.getType().isPrimitive()) {
                method.addStatement("$T.requireNonNull( $N )", Objects.class, stepMethod.getName());
            }
            assert (null != prop);
            method.addStatement("_element.props().set( $T.Props.$N, $N )", descriptor.getEnhancedClassName(), prop.getConstantName(), stepMethod.getName());
        }
        if (StepMethodType.TERMINATE == stepMethod.getStepMethodType()) {
            method.addStatement("return build()", new Object[0]);
        } else {
            method.addStatement("return this", new Object[0]);
        }
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildBuildStepImpl(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        List syntheticProps = descriptor.getProps().stream().filter(PropDescriptor::isImmutable).collect(Collectors.toList());
        if (syntheticProps.size() > 1) {
            method.addStatement("final $T props = _element.props()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME);
            StringBuilder sb = new StringBuilder();
            sb.append("_element.setKey( $T.class.getName()");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(descriptor.getClassName());
            for (PropDescriptor prop : syntheticProps) {
                sb.append(" + \"-\" + ");
                ImmutablePropKeyStrategy strategy = prop.getImmutablePropKeyStrategy();
                if (ImmutablePropKeyStrategy.KEYED == strategy) {
                    sb.append("$T.getKey( ($T) props.get( $T.Props.$N ) )");
                    params.add(KEYED_CLASSNAME);
                    params.add(prop.getMethodType().getReturnType());
                    params.add(descriptor.getEnhancedClassName());
                    params.add(prop.getConstantName());
                    continue;
                }
                if (ImmutablePropKeyStrategy.IS_STRING == strategy || ImmutablePropKeyStrategy.ENUM == strategy) {
                    sb.append("( ($T) props.get( $T.Props.$N ) )");
                    params.add(prop.getMethodType().getReturnType());
                    params.add(descriptor.getEnhancedClassName());
                    params.add(prop.getConstantName());
                    continue;
                }
                if (ImmutablePropKeyStrategy.TO_STRING == strategy) {
                    sb.append("$T.valueOf( ($T) props.get( $T.Props.$N ) )");
                    params.add(String.class);
                    params.add(prop.getMethodType().getReturnType());
                    params.add(descriptor.getEnhancedClassName());
                    params.add(prop.getConstantName());
                    continue;
                }
                assert (ImmutablePropKeyStrategy.AREZ_IDENTIFIABLE == strategy);
                sb.append("$T.valueOf( $T.<Object>getArezId( ($T) props.get( $T.Props.$N ) ) )");
                params.add(String.class);
                params.add(IDENTIFIABLE_CLASSNAME);
                params.add(prop.getMethodType().getReturnType());
                params.add(descriptor.getEnhancedClassName());
                params.add(prop.getConstantName());
            }
            sb.append(" )");
            method.addStatement(sb.toString(), params.toArray());
        }
        method.addStatement("_element.complete()", new Object[0]).addStatement("return _element", new Object[0]).returns(REACT_NODE_CLASSNAME);
        return method.build();
    }

    @Nonnull
    private static TypeSpec buildBuilder(@Nonnull ComponentDescriptor descriptor, @Nonnull BuilderDescriptor builderDescriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Builder");
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PRIVATE, Modifier.STATIC);
        List<Step> steps = builderDescriptor.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            builder.addSuperinterface(Generator.getParameterizedTypeName(descriptor, ClassName.bestGuess("Step" + (i + 1))));
        }
        List propsWithDefaults = descriptor.getProps().stream().filter(p -> p.hasDefaultField() || p.hasDefaultMethod()).collect(Collectors.toList());
        if (!propsWithDefaults.isEmpty()) {
            MethodSpec.Builder method = MethodSpec.constructorBuilder();
            method.addStatement("_element = $T.createComponentElement( $T.Factory.TYPE )", REACT_ELEMENT_CLASSNAME, descriptor.getEnhancedClassName());
            method.addStatement("final $T props = _element.props()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME);
            for (PropDescriptor prop : propsWithDefaults) {
                method.addStatement("props.set( $T.Props.$N, $T.$N" + (prop.hasDefaultField() ? "" : "()") + " )", descriptor.getEnhancedClassName(), prop.getConstantName(), descriptor.getClassName(), prop.hasDefaultField() ? prop.getDefaultField().getSimpleName() : prop.getDefaultMethod().getSimpleName());
            }
            builder.addMethod(method.build());
        }
        HashSet<String> stepMethodsAdded = new HashSet<String>();
        for (Step step : steps) {
            for (StepMethod stepMethod : step.getMethods()) {
                if (!stepMethodsAdded.add(stepMethod.getName() + stepMethod.getType().toString()) || stepMethod.isBuildIntrinsic()) continue;
                builder.addMethod(Generator.buildBuilderStepImpl(descriptor, step, stepMethod));
            }
        }
        FieldSpec.Builder field = FieldSpec.builder(REACT_ELEMENT_CLASSNAME, "_element", Modifier.PRIVATE, Modifier.FINAL);
        if (propsWithDefaults.isEmpty()) {
            field.initializer("$T.createComponentElement( $T.Factory.TYPE )", REACT_ELEMENT_CLASSNAME, descriptor.getEnhancedClassName());
        }
        builder.addField(field.build());
        builder.addMethod(Generator.buildBuildStepImpl(descriptor));
        return builder.build();
    }

    @Nonnull
    private static TypeName getParameterizedTypeName(@Nonnull ComponentDescriptor descriptor, @Nonnull ClassName baseName) {
        List<? extends TypeMirror> arguments = descriptor.getDeclaredType().getTypeArguments();
        if (arguments.isEmpty()) {
            return baseName;
        }
        return ParameterizedTypeName.get(baseName, (TypeName[])arguments.stream().map(TypeName::get).toArray(TypeName[]::new));
    }

    @Nonnull
    static TypeSpec buildEnhancedComponent(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getEnhancedClassName());
        builder.addTypeVariables(GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)descriptor.getElement(), builder, Collections.singletonList(Deprecated.class.getName()));
        builder.superclass(descriptor.getComponentType());
        AnnotationSpec.Builder warningsAnnotation = AnnotationSpec.builder(SuppressWarnings.class);
        if (descriptor.enhanceComponentAccessesDeprecatedElements()) {
            warningsAnnotation.addMember("value", "{ $S, $S }", "Arez:UnnecessaryAllowEmpty", "deprecation");
        } else {
            warningsAnnotation.addMember("value", "$S", "Arez:UnnecessaryAllowEmpty");
        }
        builder.addAnnotation(warningsAnnotation.build());
        AnnotationSpec.Builder arezAnnotation = AnnotationSpec.builder(AREZ_COMPONENT_CLASSNAME).addMember("name", "$S", descriptor.getName()).addMember("disposeNotifier", "$T.DISABLE", AREZ_FEATURE_CLASSNAME);
        if (!descriptor.trackRender()) {
            arezAnnotation.addMember("allowEmpty", "true", new Object[0]);
        } else if (descriptor.shouldSetDefaultPriority()) {
            arezAnnotation.addMember("defaultPriority", "$T.LOWEST", PRIORITY_CLASSNAME);
        }
        if (descriptor.needsInjection()) {
            arezAnnotation.addMember("inject", "$T.CONSUME", AREZ_INJECT_MODE_CLASSNAME);
        } else {
            arezAnnotation.addMember("inject", "$T.NONE", AREZ_INJECT_MODE_CLASSNAME);
        }
        builder.addAnnotation(arezAnnotation.build());
        builder.addModifiers(Modifier.ABSTRACT);
        Generator.addGeneratedAnnotation(processingEnv, builder);
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        builder.addMethod(Generator.buildConstructor(descriptor).build());
        if (descriptor.trackRender()) {
            builder.addField(FieldSpec.builder(TypeName.INT, COMPONENT_STATE_FIELD, Modifier.PRIVATE).build());
        }
        builder.addType(Generator.buildFactory());
        if (!descriptor.getProps().isEmpty()) {
            builder.addType(Generator.buildPropsType(descriptor));
        }
        builder.addMethod(Generator.buildConstructorFnMethod(descriptor).build());
        if (descriptor.getProps().stream().anyMatch(PropDescriptor::needsMutablePropAccessedInPostConstructInvariant)) {
            builder.addMethod(Generator.buildIsReadyMethod().build());
        }
        for (PropDescriptor prop : descriptor.getProps()) {
            builder.addMethod(Generator.buildPropMethod(prop).build());
            if (!prop.isObservable()) continue;
            builder.addMethod(Generator.buildPropObservableValueRefMethod(prop).build());
        }
        if (descriptor.hasValidatedProps()) {
            builder.addMethod(Generator.buildPropValidatorMethod(descriptor).build());
        }
        if (descriptor.generateShouldComponentUpdate()) {
            builder.addMethod(Generator.buildShouldComponentUpdate(descriptor).build());
        }
        if (descriptor.generateComponentDidMount()) {
            builder.addMethod(Generator.buildComponentDidMount(descriptor).build());
        }
        if (descriptor.generateComponentPreUpdate()) {
            builder.addMethod(Generator.buildComponentPreUpdate(descriptor).build());
        }
        if (descriptor.generateComponentDidUpdate()) {
            builder.addMethod(Generator.buildComponentDidUpdate(descriptor).build());
        }
        if (descriptor.generateComponentWillUnmount()) {
            builder.addMethod(Generator.buildComponentWillUnmount(descriptor).build());
        }
        if (descriptor.trackRender() || descriptor.getProps().stream().anyMatch(PropDescriptor::isDisposable)) {
            builder.addMethod(Generator.buildRender(descriptor).build());
        }
        if (descriptor.trackRender()) {
            builder.addMethod(Generator.buildOnRenderDepsChange(descriptor).build());
            builder.addMethod(Generator.buildGetRenderObserver(descriptor).build());
            builder.addMethod(Generator.buildPopulateDebugData(descriptor).build());
        }
        if (descriptor.shouldGenerateLiteLifecycle()) {
            builder.addType(Generator.buildNativeComponent(descriptor, true));
        }
        builder.addType(Generator.buildNativeComponent(descriptor, false));
        return builder.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructor(@Nonnull ComponentDescriptor descriptor) {
        String componentParameterName = "$$react4j$$_nativeComponent";
        ParameterSpec.Builder componentParameter = ParameterSpec.builder(REACT_NATIVE_COMPONENT_CLASSNAME, "$$react4j$$_nativeComponent", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        if (descriptor.needsInjection()) {
            componentParameter.addAnnotation(PER_INSTANCE_CLASSNAME);
        }
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        ctor.addParameter(componentParameter.build());
        List<? extends VariableElement> parameters = descriptor.getConstructor().getParameters();
        if (!parameters.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> params = new ArrayList<String>();
            sb.append("super( ");
            boolean first = true;
            for (VariableElement variableElement : parameters) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append("$N");
                String name = variableElement.getSimpleName().toString();
                params.add(name);
                ParameterSpec.Builder ctorParameter = ParameterSpec.builder(TypeName.get(variableElement.asType()), name, Modifier.FINAL);
                Generator.copyWhitelistedAnnotations(variableElement, ctorParameter);
                ctor.addParameter(ctorParameter.build());
            }
            sb.append(" )");
            ctor.addStatement(sb.toString(), params.toArray());
        }
        ctor.addStatement("bindComponent( $N )", "$$react4j$$_nativeComponent");
        return ctor;
    }

    @Nonnull
    private static FieldSpec.Builder buildPropKeyConstantField(@Nonnull PropDescriptor descriptor, int index) {
        String name = descriptor.getName();
        FieldSpec.Builder field = FieldSpec.builder(TypeName.get(String.class), descriptor.getConstantName(), Modifier.STATIC, Modifier.FINAL);
        if (descriptor.isSpecialChildrenProp()) {
            return field.initializer("$S", "children");
        }
        return field.initializer("$T.shouldMinimizePropKeys() ? $S : $S", REACT_CLASSNAME, Character.toString((char)(97 + index)), name);
    }

    @Nonnull
    private static MethodSpec.Builder buildPropMethod(@Nonnull PropDescriptor prop) {
        ExecutableElement methodElement = prop.getMethod();
        ExecutableType methodType = prop.getMethodType();
        TypeMirror returnType = methodType.getReturnType();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodElement.getSimpleName().toString()).returns(TypeName.get(returnType));
        GeneratorUtil.copyTypeParameters(methodType, method);
        GeneratorUtil.copyAccessModifiers(methodElement, method);
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)methodElement, method, ANNOTATION_WHITELIST);
        method.addAnnotation(Override.class);
        if (prop.isObservable()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(OBSERVABLE_ANNOTATION_CLASSNAME).addMember("name", "$S", prop.getName()).addMember("expectSetter", "false", new Object[0]).addMember("readOutsideTransaction", "$T.ENABLE", AREZ_FEATURE_CLASSNAME);
            method.addAnnotation(annotation.build());
        }
        if (prop.needsMutablePropAccessedInPostConstructInvariant()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
            block.addStatement("$T.apiInvariant( () -> $N(), () -> \"The component '\" + this + \"' accessed the prop named '" + prop.getName() + "' before the component is ready (possibly in a @PostConstruct annotated method?) and does not have a @OnPropChange annotated method to cover the prop and reflect changes of the prop onto the component. This is considered a likely bug and the @Prop should be made immutable or an @OnPropChange method added to cover the prop. " + MemberChecks.suppressedBy("React4j:MutablePropAccessedInPostConstruct", "react4j.annotations.SuppressReact4jWarnings").replace("\"", "\\\"") + " to the @Prop annotated method.\" )", GUARDS_CLASSNAME, IS_READY_METHOD);
            block.endControlFlow();
            method.addCode(block.build());
        }
        String convertMethodName = Generator.getConverter(returnType, methodElement);
        TypeKind resultKind = methodElement.getReturnType().getKind();
        if (!resultKind.isPrimitive() && !Generator.isNonnull(methodElement)) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
            block.addStatement("return null != props().getAsAny( Props.$N ) ? props().getAsAny( Props.$N ).$N() : null", prop.getConstantName(), prop.getConstantName(), convertMethodName);
            block.nextControlFlow("else", new Object[0]);
            block.addStatement("return $T.uncheckedCast( props().getAsAny( Props.$N ) )", JS_CLASSNAME, prop.getConstantName());
            block.endControlFlow();
            method.addCode(block.build());
        } else {
            method.addStatement("return props().getAsAny( Props.$N ).$N()", prop.getConstantName(), convertMethodName);
        }
        return method;
    }

    @Nonnull
    private static String getConverter(@Nonnull TypeMirror type, @Nonnull Element element) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "asBoolean";
            }
            case BYTE: {
                return "asByte";
            }
            case CHAR: {
                return "asChar";
            }
            case DOUBLE: {
                return "asDouble";
            }
            case FLOAT: {
                return "asFloat";
            }
            case INT: {
                return "asInt";
            }
            case LONG: {
                return "asLong";
            }
            case SHORT: {
                return "asShort";
            }
            case TYPEVAR: 
            case ARRAY: {
                return "cast";
            }
            case DECLARED: {
                if (type.toString().equals("java.lang.String")) {
                    return "asString";
                }
                return "cast";
            }
        }
        throw new ProcessorException("Return type of @Prop method is not yet handled. Type: " + (Object)((Object)type.getKind()), element);
    }

    @Nonnull
    private static MethodSpec.Builder buildPropObservableValueRefMethod(@Nonnull PropDescriptor prop) {
        return MethodSpec.methodBuilder(Generator.toObservableValueRefMethodName(prop)).addModifiers(Modifier.ABSTRACT).addAnnotation(NONNULL_CLASSNAME).addAnnotation(OBSERVABLE_VALUE_REF_ANNOTATION_CLASSNAME).returns(ParameterizedTypeName.get(OBSERVABLE_CLASSNAME, WildcardTypeName.subtypeOf(TypeName.OBJECT)));
    }

    @Nonnull
    private static String toObservableValueRefMethodName(@Nonnull PropDescriptor prop) {
        String name = prop.getName();
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "ObservableValue";
    }

    private static void buildOnPropChangeInvocations(@Nonnull CodeBlock.Builder code, @Nonnull List<OnPropChangeDescriptor> onPropChanges) {
        List props = onPropChanges.stream().flatMap(d -> d.getProps().stream()).distinct().collect(Collectors.toList());
        for (PropDescriptor prop : props) {
            code.addStatement("final boolean $N = !$T.isTripleEqual( props.get( Props.$N ), prevProps.get( Props.$N ) )", prop.getName(), JS_CLASSNAME, prop.getConstantName(), prop.getConstantName());
        }
        for (OnPropChangeDescriptor onPropChange : onPropChanges) {
            CodeBlock.Builder onChangeBlock = CodeBlock.builder();
            onChangeBlock.beginControlFlow("if ( " + onPropChange.getProps().stream().map(PropDescriptor::getName).collect(Collectors.joining(" && ")) + " )", new Object[0]);
            StringBuilder sb = new StringBuilder();
            ArrayList<Object> params = new ArrayList<Object>();
            sb.append("$N( ");
            params.add(onPropChange.getMethod().getSimpleName().toString());
            boolean requireComma = false;
            for (PropDescriptor prop : onPropChange.getProps()) {
                if (requireComma) {
                    sb.append(", ");
                }
                requireComma = true;
                String convertMethodName = Generator.getConverter(prop.getMethod().getReturnType(), prop.getMethod());
                TypeKind resultKind = prop.getMethod().getReturnType().getKind();
                if (!resultKind.isPrimitive() && !Generator.isNonnull(prop.getMethod())) {
                    sb.append("$T.uncheckedCast( props.getAsAny( Props.$N ) )");
                    params.add(JS_CLASSNAME);
                    params.add(prop.getConstantName());
                    continue;
                }
                sb.append("props.getAsAny( Props.$N ).$N()");
                params.add(prop.getConstantName());
                params.add(convertMethodName);
            }
            sb.append(" )");
            onChangeBlock.addStatement(sb.toString(), params.toArray());
            onChangeBlock.endControlFlow();
            code.add(onChangeBlock.build());
        }
    }

    @Nonnull
    private static MethodSpec.Builder buildComponentDidMount(@Nonnull ComponentDescriptor descriptor) {
        ExecutableElement postMount;
        MethodSpec.Builder method = MethodSpec.methodBuilder(COMPONENT_DID_MOUNT_METHOD).addModifiers(Modifier.PRIVATE);
        ExecutableElement postRender = descriptor.getPostRender();
        if (null != postRender) {
            method.addStatement("$N()", postRender.getSimpleName().toString());
        }
        if (null != (postMount = descriptor.getPostMount())) {
            method.addStatement("$N()", postMount.getSimpleName().toString());
        }
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldStoreDebugDataAsState() )", REACT_CLASSNAME);
        block.addStatement("storeDebugDataAsState()", new Object[0]);
        block.endControlFlow();
        method.addCode(block.build());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildShouldComponentUpdate(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(SHOULD_COMPONENT_UPDATE_METHOD).returns(TypeName.BOOLEAN).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextProps", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME).build());
        List observableProps = descriptor.getProps().stream().filter(PropDescriptor::isObservable).collect(Collectors.toList());
        if (!observableProps.isEmpty()) {
            method.addAnnotation(AnnotationSpec.builder(ACTION_CLASSNAME).addMember("verifyRequired", "false", new Object[0]).build());
        } else {
            method.addModifiers(Modifier.PRIVATE);
        }
        method.addStatement("assert null != nextProps", new Object[0]);
        if (descriptor.hasValidatedProps()) {
            CodeBlock.Builder validateBlock = CodeBlock.builder();
            validateBlock.beginControlFlow("if ( $T.shouldValidatePropValues() )", REACT_CLASSNAME);
            validateBlock.addStatement("$N( nextProps )", VALIDATE_PROPS_METHOD);
            validateBlock.endControlFlow();
            method.addCode(validateBlock.build());
        }
        List updateOnChangeProps = descriptor.getProps().stream().filter(PropDescriptor::shouldUpdateOnChange).filter(p -> !p.isObservable()).collect(Collectors.toList());
        if (observableProps.isEmpty() && updateOnChangeProps.isEmpty()) {
            if (descriptor.trackRender()) {
                method.addStatement("return $T.SCHEDULED == $N", COMPONENT_STATE_CLASSNAME, COMPONENT_STATE_FIELD);
            } else {
                method.addStatement("return false", new Object[0]);
            }
        } else {
            CodeBlock.Builder block;
            method.addStatement("final $T props = props()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME);
            boolean hasObservablePropsToUpdateOnChange = observableProps.stream().anyMatch(PropDescriptor::shouldUpdateOnChange);
            if (hasObservablePropsToUpdateOnChange) {
                method.addStatement("boolean modified = false", new Object[0]);
            }
            for (PropDescriptor prop : observableProps) {
                block = CodeBlock.builder();
                block.beginControlFlow("if ( !$T.isTripleEqual( props.get( Props.$N ), nextProps.get( Props.$N ) ) )", JS_CLASSNAME, prop.getConstantName(), prop.getConstantName());
                block.addStatement("$N().reportChanged()", Generator.toObservableValueRefMethodName(prop));
                if (prop.shouldUpdateOnChange()) {
                    block.addStatement("modified = true", new Object[0]);
                }
                block.endControlFlow();
                method.addCode(block.build());
            }
            for (PropDescriptor prop : updateOnChangeProps) {
                block = CodeBlock.builder();
                block.beginControlFlow("if ( !$T.isTripleEqual( props.get( Props.$N ), nextProps.get( Props.$N ) ) )", JS_CLASSNAME, prop.getConstantName(), prop.getConstantName());
                block.addStatement("return true", new Object[0]);
                block.endControlFlow();
                method.addCode(block.build());
            }
            if (hasObservablePropsToUpdateOnChange) {
                if (descriptor.trackRender()) {
                    method.addStatement("return modified || $T.SCHEDULED == $N", COMPONENT_STATE_CLASSNAME, COMPONENT_STATE_FIELD);
                } else {
                    method.addStatement("return modified", new Object[0]);
                }
            } else if (descriptor.trackRender()) {
                method.addStatement("return $T.SCHEDULED == $N", COMPONENT_STATE_CLASSNAME, COMPONENT_STATE_FIELD);
            } else {
                method.addStatement("return false", new Object[0]);
            }
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildComponentPreUpdate(@Nonnull ComponentDescriptor descriptor) {
        ExecutableElement preUpdate;
        MethodSpec.Builder method = MethodSpec.methodBuilder(COMPONENT_PRE_UPDATE_METHOD).addModifiers(Modifier.PRIVATE).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevProps", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME).build());
        boolean hasPreUpdateOnPropChange = descriptor.hasPreUpdateOnPropChange();
        if (hasPreUpdateOnPropChange) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( null != prevProps )", new Object[0]);
            block.addStatement("final $T props = props()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME);
            Generator.buildOnPropChangeInvocations(block, descriptor.getPreUpdateOnPropChangeDescriptors());
            block.endControlFlow();
            method.addCode(block.build());
        }
        if (null != (preUpdate = descriptor.getPreUpdate())) {
            method.addStatement("$N()", preUpdate.getSimpleName().toString());
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildComponentDidUpdate(@Nonnull ComponentDescriptor descriptor) {
        ExecutableElement postUpdate;
        ExecutableElement postRender;
        MethodSpec.Builder method = MethodSpec.methodBuilder(COMPONENT_DID_UPDATE_METHOD).addModifiers(Modifier.PRIVATE);
        if (descriptor.hasPostUpdateOnPropChange()) {
            method.addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevProps", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME).build());
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( null != prevProps )", new Object[0]);
            block.addStatement("final $T props = props()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME);
            Generator.buildOnPropChangeInvocations(block, descriptor.getPostUpdateOnPropChangeDescriptors());
            block.endControlFlow();
            method.addCode(block.build());
        }
        if (null != (postRender = descriptor.getPostRender())) {
            method.addStatement("$N()", postRender.getSimpleName().toString());
        }
        if (null != (postUpdate = descriptor.getPostUpdate())) {
            method.addStatement("$N()", postUpdate.getSimpleName().toString());
        }
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldStoreDebugDataAsState() )", REACT_CLASSNAME);
        block.addStatement("storeDebugDataAsState()", new Object[0]);
        block.endControlFlow();
        method.addCode(block.build());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildComponentWillUnmount(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(COMPONENT_WILL_UNMOUNT_METHOD).addModifiers(Modifier.PRIVATE);
        if (descriptor.trackRender()) {
            method.addStatement("$N = $T.UNMOUNTED", COMPONENT_STATE_FIELD, COMPONENT_STATE_CLASSNAME);
        }
        method.addStatement("(($T) this).dispose()", descriptor.getArezClassName());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildRender(@Nonnull ComponentDescriptor descriptor) {
        assert (descriptor.trackRender() || descriptor.getProps().stream().anyMatch(PropDescriptor::isDisposable));
        MethodSpec.Builder method = MethodSpec.methodBuilder("render").addAnnotation(Override.class).addAnnotation(NULLABLE_CLASSNAME).addModifiers(Modifier.PROTECTED).returns(REACT_NODE_CLASSNAME);
        if (descriptor.trackRender()) {
            AnnotationSpec.Builder observe = AnnotationSpec.builder(OBSERVE_ANNOTATION_CLASSNAME).addMember("name", "$S", "render").addMember("priority", "$T.LOW", PRIORITY_CLASSNAME).addMember("executor", "$T.EXTERNAL", EXECUTOR_CLASSNAME).addMember("depType", "$T.AREZ_OR_NONE", DEP_TYPE_CLASSNAME).addMember("observeLowerPriorityDependencies", "true", new Object[0]).addMember("reportResult", "false", new Object[0]);
            method.addAnnotation(observe.build());
            method.addStatement("$N = $T.IDLE", COMPONENT_STATE_FIELD, COMPONENT_STATE_CLASSNAME);
            method.addStatement("$T.pauseUntilRenderLoopComplete()", SCHEDULER_UTIL_CLASSNAME);
        }
        method.addStatement("assert $T.isNotDisposed( this )", DISPOSABLE_CLASSNAME);
        List disposableProps = descriptor.getProps().stream().filter(PropDescriptor::isDisposable).collect(Collectors.toList());
        for (PropDescriptor prop : disposableProps) {
            String varName = "$$react4jv$$_" + prop.getMethod().getSimpleName();
            method.addStatement("final $T $N = $N()", prop.getMethodType().getReturnType(), varName, prop.getMethod().getSimpleName().toString());
            CodeBlock.Builder block = CodeBlock.builder();
            if (prop.isOptional()) {
                block.beginControlFlow("if ( null != $N && $T.isDisposed( $N ) )", varName, DISPOSABLE_CLASSNAME, varName);
            } else {
                block.beginControlFlow("if ( $T.isDisposed( $N ) )", DISPOSABLE_CLASSNAME, varName);
            }
            block.addStatement("return null", new Object[0]);
            block.endControlFlow();
            method.addCode(block.build());
        }
        if (ComponentType.TRACKING == descriptor.getType()) {
            method.addStatement("final $T result = super.render()", REACT_NODE_CLASSNAME);
            CodeBlock.Builder depCheckBlock = CodeBlock.builder();
            depCheckBlock.beginControlFlow("if ( $T.shouldCheckInvariants() && $T.areSpiesEnabled() )", AREZ_CLASSNAME, AREZ_CLASSNAME);
            depCheckBlock.addStatement("$T.invariant( () -> !getRenderObserver().getContext().getSpy().asObserverInfo( getRenderObserver() ).getDependencies().isEmpty(), () -> \"Component render completed on '\" + this + \"' without accessing any Arez dependencies but has a type set to TRACKING. The render method needs to access an Arez dependency or the type should be changed to STATEFUL or MAYBE_TRACKING.\" )", GUARDS_CLASSNAME);
            depCheckBlock.endControlFlow();
            method.addCode(depCheckBlock.build());
            method.addStatement("return result", new Object[0]);
        } else {
            method.addStatement("return super.render()", new Object[0]);
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildGetRenderObserver(@Nonnull ComponentDescriptor descriptor) {
        assert (descriptor.trackRender());
        return MethodSpec.methodBuilder("getRenderObserver").addAnnotation(NONNULL_CLASSNAME).addAnnotation(OBSERVER_REF_ANNOTATION_CLASSNAME).addModifiers(Modifier.ABSTRACT).returns(OBSERVER_CLASSNAME);
    }

    @Nonnull
    private static MethodSpec.Builder buildPopulateDebugData(@Nonnull ComponentDescriptor descriptor) {
        assert (descriptor.trackRender());
        MethodSpec.Builder method = MethodSpec.methodBuilder("populateDebugData").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PROTECTED).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "data", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldStoreDebugDataAsState() && $T.areSpiesEnabled() )", REACT_CLASSNAME, AREZ_CLASSNAME);
        block.addStatement("$T.collectDependencyDebugData( getRenderObserver(), data )", INTROSPECT_UTIL_CLASSNAME);
        block.endControlFlow();
        method.addCode(block.build());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildOnRenderDepsChange(@Nonnull ComponentDescriptor descriptor) {
        assert (descriptor.trackRender());
        MethodSpec.Builder method = MethodSpec.methodBuilder("onRenderDepsChange").addModifiers(Modifier.FINAL);
        CodeBlock.Builder outer = CodeBlock.builder();
        outer.beginControlFlow("if ( $T.IDLE == $N )", COMPONENT_STATE_CLASSNAME, COMPONENT_STATE_FIELD);
        outer.addStatement("$N = $T.SCHEDULED", COMPONENT_STATE_FIELD, COMPONENT_STATE_CLASSNAME);
        if (descriptor.hasObservableProps()) {
            outer.addStatement("scheduleRender( false )", new Object[0]);
        } else {
            outer.addStatement("scheduleRender()", new Object[0]);
        }
        outer.endControlFlow();
        method.addCode(outer.build());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildIsReadyMethod() {
        return MethodSpec.methodBuilder(IS_READY_METHOD).addModifiers(Modifier.ABSTRACT).returns(TypeName.BOOLEAN).addAnnotation(COMPONENT_STATE_REF_ANNOTATION_CLASSNAME);
    }

    @Nonnull
    private static MethodSpec.Builder buildPropValidatorMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(VALIDATE_PROPS_METHOD).addModifiers(Modifier.PRIVATE).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "props", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        for (PropDescriptor prop : descriptor.getProps()) {
            CodeBlock.Builder block;
            String name = prop.getName();
            String rawName = "raw$" + name;
            String typedName = "typed$" + name;
            method.addStatement("final $T $N = props.get( Props.$N )", Object.class, rawName, prop.getConstantName());
            boolean isNonNull = Generator.isNonnull(prop.getMethod());
            if (!prop.isOptional() && isNonNull) {
                block = CodeBlock.builder();
                block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
                block.addStatement("$T.apiInvariant( () -> null != $N, () -> \"Required prop named '$N' is missing from component named '$N' so it was either incorrectly omitted or a null value has been incorrectly specified.\" ) ", GUARDS_CLASSNAME, rawName, prop.getName(), descriptor.getName());
                block.endControlFlow();
                method.addCode(block.build());
            }
            block = CodeBlock.builder();
            block.beginControlFlow("if ( null != $N )", rawName);
            TypeMirror returnType = prop.getMethodType().getReturnType();
            block.addStatement("final $T $N = $T.$N( $N )", returnType, typedName, JS_CLASSNAME, Generator.getConverter(returnType, prop.getMethod()), rawName);
            if (prop.hasValidateMethod()) {
                block.addStatement("$N( $N )", prop.getValidateMethod().getSimpleName().toString(), typedName);
            }
            block.endControlFlow();
            method.addCode(block.build());
        }
        return method;
    }

    @Nonnull
    private static TypeSpec buildInjectSupport(@Nonnull ComponentDescriptor descriptor) {
        assert (descriptor.needsInjection());
        TypeSpec.Builder builder = TypeSpec.classBuilder("InjectSupport").addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        builder.addField(Generator.buildFactoryField(descriptor).build());
        builder.addMethod(Generator.buildSetFactoryMethod(descriptor).build());
        builder.addMethod(Generator.buildInjectCreateMethod(descriptor).build());
        return builder.build();
    }

    @Nonnull
    private static FieldSpec.Builder buildFactoryField(@Nonnull ComponentDescriptor descriptor) {
        return FieldSpec.builder(descriptor.getArezClassName().nestedClass("Factory"), "c_factory", Modifier.STATIC, Modifier.PRIVATE);
    }

    @Nonnull
    private static MethodSpec.Builder buildSetFactoryMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("setFactory").addModifiers(Modifier.STATIC).addParameter(ParameterSpec.builder(descriptor.getArezClassName().nestedClass("Factory"), "factory", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
        block.addStatement("$T.invariant( () -> null == c_factory, () -> \"Attempted to re-initialize the React4j dependency injection provider for the component named '$N'. Initialization should only occur a single time.\" )", GUARDS_CLASSNAME, descriptor.getName());
        block.endControlFlow();
        method.addCode(block.build());
        method.addStatement("c_factory = factory", new Object[0]);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildInjectCreateMethod(@Nonnull ComponentDescriptor descriptor) {
        ParameterSpec.Builder parameter = ParameterSpec.builder(REACT_NATIVE_COMPONENT_CLASSNAME, "nativeComponent", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        MethodSpec.Builder method = MethodSpec.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addParameter(parameter.build()).addAnnotation(NONNULL_CLASSNAME).returns(descriptor.getEnhancedClassName());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
        block.addStatement("$T.invariant( () -> null != c_factory, () -> \"Attempted to create an instance of the React4j component named '$N' before the dependency injection provider has been initialized. Please see the documentation at https://react4j.github.io/dependency_injection for directions how to configure dependency injection.\" )", GUARDS_CLASSNAME, descriptor.getName());
        block.endControlFlow();
        method.addCode(block.build());
        return method.addStatement("return c_factory.create( nativeComponent )", new Object[0]);
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructorFnMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("getConstructorFunction").addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.STATIC, Modifier.PRIVATE).returns(COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME);
        boolean shouldGenerateLiteLifecycle = descriptor.shouldGenerateLiteLifecycle();
        if (shouldGenerateLiteLifecycle) {
            method.addStatement("final $T componentConstructor = ( $T.shouldStoreDebugDataAsState() || $T.shouldValidatePropValues() ) ? $T::new : $T::new", COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, REACT_CLASSNAME, REACT_CLASSNAME, ClassName.bestGuess("NativeReactComponent"), ClassName.bestGuess("LiteNativeReactComponent"));
        } else {
            method.addStatement("final $T componentConstructor = $T::new", COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, ClassName.bestGuess("NativeReactComponent"));
        }
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( $T.enableComponentNames() )", REACT_CLASSNAME);
        codeBlock.addStatement("$T.asPropertyMap( componentConstructor ).set( \"displayName\", $S )", JS_CLASSNAME, descriptor.getName());
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        method.addStatement("return componentConstructor", new Object[0]);
        return method;
    }

    @Nonnull
    private static TypeSpec buildPropsType(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Props");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        List<PropDescriptor> props = descriptor.getProps();
        int propCount = props.size();
        for (int i = 0; i < propCount; ++i) {
            builder.addField(Generator.buildPropKeyConstantField(props.get(i), i).build());
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildFactory() {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Factory");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        FieldSpec.Builder field = FieldSpec.builder(COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, "TYPE", Modifier.STATIC, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).initializer("getConstructorFunction()", new Object[0]);
        builder.addField(field.build());
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildNativeComponent(@Nonnull ComponentDescriptor descriptor, boolean lite) {
        TypeName componentFieldType;
        TypeSpec.Builder builder = TypeSpec.classBuilder((lite ? "Lite" : "") + "NativeReactComponent");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        builder.addModifiers(Modifier.PRIVATE);
        builder.superclass(REACT_NATIVE_COMPONENT_CLASSNAME);
        builder.addTypeVariables(GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        if (descriptor.getElement().getTypeParameters().isEmpty()) {
            componentFieldType = descriptor.getEnhancedClassName();
        } else {
            TypeName[] typeNames = GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()).toArray(new TypeName[0]);
            componentFieldType = ParameterizedTypeName.get(descriptor.getEnhancedClassName(), typeNames);
        }
        builder.addField(FieldSpec.builder(componentFieldType, COMPONENT_FIELD, Modifier.PRIVATE, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        if (lite) {
            if (descriptor.generateComponentDidMountInLiteLifecycle()) {
                builder.addSuperinterface(ON_COMPONENT_DID_MOUNT_CLASSNAME);
            }
            if (descriptor.generateComponentDidUpdateInLiteLifecycle()) {
                builder.addSuperinterface(ON_COMPONENT_DID_UPDATE_CLASSNAME);
            }
            if (descriptor.generateShouldComponentUpdateInLiteLifecycle()) {
                builder.addSuperinterface(ON_COMPONENT_SHOULD_UPDATE_CLASSNAME);
            }
            if (descriptor.generateComponentWillUnmountInLiteLifecycle()) {
                builder.addSuperinterface(ON_COMPONENT_WILL_UNMOUNT_CLASSNAME);
            }
        } else {
            if (descriptor.generateComponentDidMount()) {
                builder.addSuperinterface(ON_COMPONENT_DID_MOUNT_CLASSNAME);
            }
            if (descriptor.generateComponentDidUpdate()) {
                builder.addSuperinterface(ON_COMPONENT_DID_UPDATE_CLASSNAME);
            }
            if (descriptor.generateShouldComponentUpdate()) {
                builder.addSuperinterface(ON_COMPONENT_SHOULD_UPDATE_CLASSNAME);
            }
            if (descriptor.generateComponentWillUnmount()) {
                builder.addSuperinterface(ON_COMPONENT_WILL_UNMOUNT_CLASSNAME);
            }
        }
        if (descriptor.generateComponentPreUpdate()) {
            builder.addSuperinterface(ON_GET_SNAPSHOT_BEFORE_UPDATE_CLASSNAME);
        }
        if (descriptor.generateComponentDidCatch()) {
            builder.addSuperinterface(ON_COMPONENT_DID_CATCH_CLASSNAME);
        }
        ParameterSpec.Builder props = ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "props", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME);
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addParameter(props.build()).addAnnotation(JS_CONSTRUCTOR_CLASSNAME);
        method.addStatement("super( props )", new Object[0]);
        if (descriptor.needsInjection()) {
            method.addStatement("$N = $T.InjectSupport.create( this )", COMPONENT_FIELD, descriptor.getDaggerComponentExtensionClassName());
        } else {
            String infix = Generator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            method.addStatement("$N = new $T" + infix + "( this )", COMPONENT_FIELD, descriptor.getArezClassName());
        }
        if (descriptor.hasValidatedProps()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.shouldValidatePropValues() )", REACT_CLASSNAME);
            block.addStatement("assert null != props", new Object[0]);
            block.addStatement("$N.$N( props )", COMPONENT_FIELD, VALIDATE_PROPS_METHOD);
            block.endControlFlow();
            method.addCode(block.build());
        }
        builder.addMethod(method.build());
        if (lite ? descriptor.generateComponentDidMountInLiteLifecycle() : descriptor.generateComponentDidMount()) {
            builder.addMethod(Generator.buildNativeComponentDidMount().build());
        }
        if (lite ? descriptor.generateShouldComponentUpdateInLiteLifecycle() : descriptor.generateShouldComponentUpdate()) {
            builder.addMethod(Generator.buildNativeShouldComponentUpdate().build());
        }
        if (descriptor.generateComponentPreUpdate()) {
            builder.addMethod(Generator.buildNativeComponentPreUpdate().build());
        }
        if (lite ? descriptor.generateComponentDidUpdateInLiteLifecycle() : descriptor.generateComponentDidUpdate()) {
            builder.addMethod(Generator.buildNativeComponentDidUpdate(descriptor).build());
        }
        if (lite ? descriptor.generateComponentWillUnmountInLiteLifecycle() : descriptor.generateComponentWillUnmount()) {
            builder.addMethod(Generator.buildNativeComponentWillUnmount().build());
        }
        if (descriptor.generateComponentDidCatch()) {
            builder.addMethod(Generator.buildNativeComponentDidCatch(descriptor).build());
        }
        builder.addMethod(Generator.buildNativeRender().build());
        return builder.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildNativeRender() {
        return MethodSpec.methodBuilder("render").addAnnotation(Override.class).addAnnotation(NULLABLE_CLASSNAME).addModifiers(Modifier.FINAL, Modifier.PUBLIC).returns(REACT_NODE_CLASSNAME).addStatement("return $N.render()", COMPONENT_FIELD);
    }

    @Nonnull
    private static MethodSpec.Builder buildNativeComponentDidMount() {
        return MethodSpec.methodBuilder("componentDidMount").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).addStatement("$N.$N()", COMPONENT_FIELD, COMPONENT_DID_MOUNT_METHOD);
    }

    @Nonnull
    private static MethodSpec.Builder buildNativeShouldComponentUpdate() {
        return MethodSpec.methodBuilder("shouldComponentUpdate").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).returns(TypeName.BOOLEAN).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextProps", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build()).addStatement("return $N.$N( nextProps )", COMPONENT_FIELD, SHOULD_COMPONENT_UPDATE_METHOD);
    }

    @Nonnull
    private static MethodSpec.Builder buildNativeComponentPreUpdate() {
        return MethodSpec.methodBuilder("getSnapshotBeforeUpdate").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).returns(TypeName.get(Object.class)).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevProps", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build()).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevState", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build()).addStatement("$N.$N( prevProps )", COMPONENT_FIELD, COMPONENT_PRE_UPDATE_METHOD).addStatement("return null", new Object[0]);
    }

    @Nonnull
    private static MethodSpec.Builder buildNativeComponentDidUpdate(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("componentDidUpdate").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevProps", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        if (descriptor.hasPostUpdateOnPropChange()) {
            return method.addStatement("$N.$N( prevProps )", COMPONENT_FIELD, COMPONENT_DID_UPDATE_METHOD);
        }
        return method.addStatement("$N.$N()", COMPONENT_FIELD, COMPONENT_DID_UPDATE_METHOD);
    }

    @Nonnull
    private static MethodSpec.Builder buildNativeComponentWillUnmount() {
        return MethodSpec.methodBuilder("componentWillUnmount").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).addStatement("$N.$N()", COMPONENT_FIELD, COMPONENT_WILL_UNMOUNT_METHOD);
    }

    @Nonnull
    private static MethodSpec.Builder buildNativeComponentDidCatch(@Nonnull ComponentDescriptor descriptor) {
        ExecutableElement onError = descriptor.getOnError();
        assert (null != onError);
        MethodSpec.Builder method = MethodSpec.methodBuilder("componentDidCatch").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).addParameter(ParameterSpec.builder(JS_ERROR_CLASSNAME, "error", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build()).addParameter(ParameterSpec.builder(REACT_ERROR_INFO_CLASSNAME, "info", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        List<? extends VariableElement> parameters = onError.getParameters();
        String args = parameters.isEmpty() ? "()" : "( " + parameters.stream().map(p -> TypeName.get(p.asType()).toString().equals("elemental2.core.JsError") ? "error" : "info").collect(Collectors.joining(", ")) + " )";
        method.addStatement("$N.$N" + args, COMPONENT_FIELD, onError.getSimpleName());
        return method;
    }

    private static String asTypeArgumentsInfix(DeclaredType declaredType) {
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        return typeArguments.isEmpty() ? "" : "<" + typeArguments.stream().map(TypeMirror::toString).collect(Collectors.joining(", ")) + ">";
    }

    @Nonnull
    static TypeSpec buildDaggerComponentExtension(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder(descriptor.getDaggerComponentExtensionClassName());
        ClassName superClassName = descriptor.getArezDaggerExtensionClassName();
        builder.addSuperinterface(superClassName);
        Generator.addGeneratedAnnotation(processingEnv, builder);
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PUBLIC);
        MethodSpec.Builder method = MethodSpec.methodBuilder("bind" + descriptor.getName()).addModifiers(Modifier.PUBLIC, Modifier.DEFAULT);
        method.addStatement("InjectSupport.setFactory( $N().createFactory() )", "get" + descriptor.getName() + "DaggerSubcomponent");
        builder.addMethod(method.build());
        builder.addMethod(MethodSpec.methodBuilder("get" + descriptor.getName() + "DaggerSubcomponent").addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).addAnnotation(Override.class).returns(ClassName.bestGuess("DaggerSubcomponent")).build());
        if (descriptor.needsInjection()) {
            builder.addType(Generator.buildInjectSupport(descriptor));
        }
        return builder.build();
    }

    @Nonnull
    private static BuilderDescriptor buildBuilderDescriptor(@Nonnull ComponentDescriptor descriptor) {
        BuilderDescriptor builder = new BuilderDescriptor();
        Step optionalPropStep = null;
        List<PropDescriptor> props = descriptor.getProps();
        int propsSize = props.size();
        boolean hasSingleOptional = props.stream().filter(PropDescriptor::isOptional).count() == 1L;
        boolean hasRequiredAfterOptional = false;
        for (int i = 0; i < propsSize; ++i) {
            boolean isLast;
            PropDescriptor prop = props.get(i);
            boolean bl = isLast = i == propsSize - 1;
            if (prop.isOptional()) {
                if (null == optionalPropStep) {
                    optionalPropStep = builder.addStep();
                }
                if (prop.getName().equals("children")) {
                    Generator.addChildrenStreamPropStepMethod(optionalPropStep);
                }
                optionalPropStep.addMethod(prop, hasSingleOptional ? StepMethodType.TERMINATE : StepMethodType.STAY);
                continue;
            }
            if (null != optionalPropStep) {
                optionalPropStep.addMethod(prop, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
                if (prop.getName().equals("children")) {
                    Generator.addChildrenStreamPropStepMethod(optionalPropStep);
                }
                hasRequiredAfterOptional = true;
            }
            Step step = builder.addStep();
            step.addMethod(prop, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
            if (!prop.getName().equals("children")) continue;
            Generator.addChildrenStreamPropStepMethod(step);
            Generator.addBuildStep(step);
        }
        if (null != optionalPropStep && !hasRequiredAfterOptional) {
            Generator.addBuildStep(optionalPropStep);
        }
        if (props.isEmpty()) {
            Generator.addBuildStep(builder.addStep());
        }
        return builder;
    }

    private static void addBuildStep(@Nonnull Step step) {
        step.addTerminalMethod("build", "build", REACT_NODE_CLASSNAME);
    }

    private static void addChildrenStreamPropStepMethod(@Nonnull Step step) {
        ParameterizedTypeName typeName = ParameterizedTypeName.get(ClassName.get(Stream.class), WildcardTypeName.subtypeOf(REACT_NODE_CLASSNAME));
        step.addTerminalMethod("children", "*children_stream*", typeName);
    }

    private static void addGeneratedAnnotation(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder builder) {
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, React4jProcessor.class.getName());
    }

    private static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull ParameterSpec.Builder builder) {
        GeneratorUtil.copyWhitelistedAnnotations(element, builder, ANNOTATION_WHITELIST);
    }

    private static boolean isNonnull(@Nonnull ExecutableElement method) {
        return AnnotationsUtil.hasAnnotationOfType(method, "javax.annotation.Nonnull");
    }
}

