/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import react4j.processor.BuilderDescriptor;
import react4j.processor.ComponentDescriptor;
import react4j.processor.ImmutablePropKeyStrategy;
import react4j.processor.PropDescriptor;
import react4j.processor.React4jProcessor;
import react4j.processor.Step;
import react4j.processor.StepMethod;
import react4j.processor.StepMethodType;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.javapoet.TypeVariableName;
import react4j.processor.vendor.javapoet.WildcardTypeName;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.GeneratorUtil;
import react4j.processor.vendor.proton.SuppressWarningsUtil;

final class BuilderGenerator {
    private static final ClassName NONNULL_CLASSNAME = ClassName.get("javax.annotation", "Nonnull", new String[0]);
    private static final ClassName JS_ARRAY_CLASSNAME = ClassName.get("elemental2.core", "JsArray", new String[0]);
    private static final ClassName IDENTIFIABLE_CLASSNAME = ClassName.get("arez.component", "Identifiable", new String[0]);
    private static final ClassName REACT_ELEMENT_CLASSNAME = ClassName.get("react4j", "ReactElement", new String[0]);
    private static final ClassName KEYED_CLASSNAME = ClassName.get("react4j", "Keyed", new String[0]);
    private static final ClassName REACT_NODE_CLASSNAME = ClassName.get("react4j", "ReactNode", new String[0]);
    private static final ClassName JS_PROPERTY_MAP_CLASSNAME = ClassName.get("jsinterop.base", "JsPropertyMap", new String[0]);
    private static final ParameterizedTypeName JS_PROPERTY_MAP_T_OBJECT_CLASSNAME = ParameterizedTypeName.get(JS_PROPERTY_MAP_CLASSNAME, TypeName.OBJECT);

    private BuilderGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getBuilderClassName());
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, React4jProcessor.class.getName());
        builder.addModifiers(Modifier.FINAL);
        GeneratorUtil.copyAccessModifiers(descriptor.getElement(), builder);
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)descriptor.getElement(), builder, Collections.singletonList(Deprecated.class.getName()));
        if (descriptor.builderAccessesDeprecatedElements()) {
            builder.addAnnotation(SuppressWarningsUtil.suppressWarningsAnnotation("deprecation"));
        }
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        BuilderDescriptor builderDescriptor = BuilderGenerator.buildBuilderDescriptor(descriptor);
        List<Step> steps = builderDescriptor.getSteps();
        builder.addMethod(BuilderGenerator.buildStaticNewBuilderMethod(descriptor));
        for (Step step : steps) {
            builder.addType(BuilderGenerator.buildBuilderStepInterface(processingEnv, descriptor, step));
        }
        BuilderGenerator.buildStaticStepMethodMethods(processingEnv, descriptor, builder, steps.get(0));
        builder.addType(BuilderGenerator.buildBuilder(processingEnv, descriptor, builderDescriptor));
        return builder.build();
    }

    private static void buildStaticStepMethodMethods(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor, @Nonnull TypeSpec.Builder builder, @Nonnull Step step) {
        for (StepMethod method : step.getMethods()) {
            builder.addMethod(BuilderGenerator.buildStaticStepMethodMethod(processingEnv, descriptor, step, method));
        }
    }

    @Nonnull
    private static MethodSpec buildStaticNewBuilderMethod(@Nonnull ComponentDescriptor descriptor) {
        String infix = descriptor.getDeclaredType().getTypeArguments().isEmpty() ? "" : "<>";
        MethodSpec.Builder method = MethodSpec.methodBuilder("newBuilder").addModifiers(Modifier.PRIVATE, Modifier.STATIC).addAnnotation(NONNULL_CLASSNAME).returns(BuilderGenerator.parameterizeIfRequired(descriptor, ClassName.bestGuess("Step1"))).addStatement("return new $T" + infix + "()", ClassName.bestGuess("Builder"));
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), method);
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildStaticStepMethodMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName()).addAnnotation(NONNULL_CLASSNAME);
        method.addModifiers(Modifier.STATIC);
        if (descriptor.getDeclaredType().asElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            method.addModifiers(Modifier.PUBLIC);
        }
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), method);
        if (stepMethod.isBuildIntrinsic()) {
            method.addStatement("return newBuilder().build()", new Object[0]);
        } else {
            ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), Modifier.FINAL);
            ExecutableElement propMethod = stepMethod.getPropMethod();
            if (null != propMethod) {
                GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)propMethod, parameter);
                ExecutableType methodType = stepMethod.getPropMethodType();
                assert (null != methodType);
                SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, parameter, methodType.getReturnType());
            } else if (stepMethod.isChildrenStreamIntrinsic()) {
                parameter.addAnnotation(NONNULL_CLASSNAME);
            }
            method.addParameter(parameter.build());
            String infix = BuilderGenerator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            if (infix.isEmpty()) {
                method.addStatement("return newBuilder().$N( $N )", stepMethod.getName(), stepMethod.getName());
            } else {
                method.addStatement("return $T." + infix + "newBuilder().$N( $N )", descriptor.getBuilderClassName(), stepMethod.getName(), stepMethod.getName());
            }
        }
        BuilderGenerator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildStepInterfaceMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull String name, @Nonnull Step step, @Nonnull StepMethodType stepMethodType, @Nonnull Consumer<MethodSpec.Builder> action) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(name);
        method.addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
        method.addAnnotation(NONNULL_CLASSNAME);
        action.accept(method);
        BuilderGenerator.configureStepMethodReturns(descriptor, method, step, stepMethodType);
        return method;
    }

    private static void configureStepMethodReturns(@Nonnull ComponentDescriptor descriptor, @Nonnull MethodSpec.Builder method, @Nonnull Step step, @Nonnull StepMethodType stepMethodType) {
        if (StepMethodType.TERMINATE == stepMethodType) {
            method.returns(REACT_NODE_CLASSNAME);
        } else {
            int returnIndex = step.getIndex() + (StepMethodType.STAY == stepMethodType ? 0 : 1);
            method.returns(BuilderGenerator.parameterizeIfRequired(descriptor, ClassName.bestGuess("Step" + returnIndex)));
        }
    }

    @Nonnull
    private static TypeName parameterizeIfRequired(@Nonnull ComponentDescriptor descriptor, @Nonnull ClassName className) {
        List<TypeVariableName> variableNames = GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType());
        if (variableNames.isEmpty()) {
            return className;
        }
        return ParameterizedTypeName.get(className, variableNames.toArray(new TypeName[0]));
    }

    @Nonnull
    private static TypeSpec buildBuilderStepInterface(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor, @Nonnull Step step) {
        int stepIndex = step.getIndex();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("Step" + stepIndex);
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builder.addTypeVariables(GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        if (!descriptor.getDeclaredType().getTypeArguments().isEmpty()) {
            builder.addAnnotation(SuppressWarningsUtil.suppressWarningsAnnotation("unused"));
        }
        for (StepMethod stepMethod : step.getMethods()) {
            StepMethodType stepMethodType = stepMethod.getStepMethodType();
            if (stepMethod.isBuildIntrinsic()) {
                builder.addMethod(BuilderGenerator.buildStepInterfaceMethod(descriptor, "build", step, stepMethodType, m -> {}).build());
                continue;
            }
            builder.addMethod(BuilderGenerator.buildStepInterfaceMethod(descriptor, stepMethod.getName(), step, stepMethodType, m -> {
                ExecutableType propMethodType = stepMethod.getPropMethodType();
                if (null != propMethodType) {
                    GeneratorUtil.copyTypeParameters(propMethodType, m);
                }
                if (stepMethod.isChildrenIntrinsic()) {
                    m.varargs();
                }
                ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), new Modifier[0]);
                ExecutableElement propMethod = stepMethod.getPropMethod();
                if (null != propMethod) {
                    GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)propMethod, parameter);
                    ExecutableType methodType = stepMethod.getPropMethodType();
                    assert (null != methodType);
                    SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, parameter, methodType.getReturnType());
                } else if (stepMethod.isChildrenStreamIntrinsic()) {
                    parameter.addAnnotation(NONNULL_CLASSNAME);
                }
                m.addParameter(parameter.build());
            }).build());
        }
        return builder.build();
    }

    @Nonnull
    private static MethodSpec buildBuilderStepImpl(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName());
        method.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        method.addAnnotation(Override.class);
        method.addAnnotation(NONNULL_CLASSNAME);
        PropDescriptor prop = stepMethod.getProp();
        ExecutableType propMethodType = stepMethod.getPropMethodType();
        if (null != propMethodType) {
            GeneratorUtil.copyTypeParameters(propMethodType, method);
        }
        ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), Modifier.FINAL);
        ExecutableElement propMethod = stepMethod.getPropMethod();
        if (null != propMethod) {
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)propMethod, parameter);
            ExecutableType methodType = stepMethod.getPropMethodType();
            assert (null != methodType);
            SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, parameter, methodType.getReturnType());
        } else if (stepMethod.isChildrenStreamIntrinsic()) {
            parameter.addAnnotation(NONNULL_CLASSNAME);
        }
        method.addParameter(parameter.build());
        if (null != prop && prop.isImmutable() && 1 == descriptor.syntheticKeyComponents()) {
            ImmutablePropKeyStrategy strategy = prop.getImmutablePropKeyStrategy();
            if (ImmutablePropKeyStrategy.KEYED == strategy) {
                method.addStatement("_element.setKey( $T.class.getName() + $T.getKey( $N ) )", descriptor.getClassName(), KEYED_CLASSNAME, stepMethod.getName());
            } else if (ImmutablePropKeyStrategy.IS_STRING == strategy) {
                method.addStatement("_element.setKey( $T.class.getName() + $N )", descriptor.getClassName(), stepMethod.getName());
            } else if (ImmutablePropKeyStrategy.TO_STRING == strategy) {
                method.addStatement("_element.setKey( $T.class.getName() + $N )", descriptor.getClassName(), stepMethod.getName());
            } else if (ImmutablePropKeyStrategy.ENUM == strategy) {
                method.addStatement("_element.setKey( $T.class.getName() + $N.name() )", descriptor.getClassName(), stepMethod.getName());
            } else {
                assert (ImmutablePropKeyStrategy.AREZ_IDENTIFIABLE == strategy);
                method.addStatement("_element.setKey( $T.class.getName() + $T.<Object>getArezId( $N ) )", descriptor.getClassName(), IDENTIFIABLE_CLASSNAME, stepMethod.getName());
            }
        }
        if (stepMethod.isChildrenIntrinsic()) {
            method.varargs();
            assert (null != prop);
            method.addStatement("_element.props().set( $T.Props.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
        } else if (stepMethod.isChildrenStreamIntrinsic()) {
            method.addStatement("children( $N.toArray( $T[]::new ) )", stepMethod.getName(), REACT_NODE_CLASSNAME);
        } else if (stepMethod.isChildIntrinsic()) {
            assert (null != propMethod);
            assert (null != prop);
            if (AnnotationsUtil.hasNonnullAnnotation(propMethod)) {
                method.addStatement("_element.props().set( $T.Props.$N, $T.of( $T.requireNonNull( $N ) ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, Objects.class, stepMethod.getName());
            } else {
                method.addStatement("_element.props().set( $T.Props.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), prop.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
            }
        } else {
            if (null != propMethod && AnnotationsUtil.hasNonnullAnnotation(propMethod) && !stepMethod.getType().isPrimitive()) {
                method.addStatement("$T.requireNonNull( $N )", Objects.class, stepMethod.getName());
            }
            assert (null != prop);
            method.addStatement("_element.props().set( $T.Props.$N, $N )", descriptor.getEnhancedClassName(), prop.getConstantName(), stepMethod.getName());
        }
        if (StepMethodType.TERMINATE == stepMethod.getStepMethodType()) {
            method.addStatement("return build()", new Object[0]);
        } else {
            method.addStatement("return this", new Object[0]);
        }
        BuilderGenerator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildBuildStepImpl(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        List syntheticProps = descriptor.getProps().stream().filter(PropDescriptor::isImmutable).collect(Collectors.toList());
        if (syntheticProps.size() > 1) {
            method.addStatement("final $T props = _element.props()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME);
            StringBuilder sb = new StringBuilder();
            sb.append("_element.setKey( $T.class.getName()");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(descriptor.getClassName());
            for (PropDescriptor prop : syntheticProps) {
                sb.append(" + \"-\" + ");
                ImmutablePropKeyStrategy strategy = prop.getImmutablePropKeyStrategy();
                if (ImmutablePropKeyStrategy.KEYED == strategy) {
                    sb.append("$T.getKey( ($T) props.get( $T.Props.$N ) )");
                    params.add(KEYED_CLASSNAME);
                    params.add(prop.getMethodType().getReturnType());
                    params.add(descriptor.getEnhancedClassName());
                    params.add(prop.getConstantName());
                    continue;
                }
                if (ImmutablePropKeyStrategy.IS_STRING == strategy || ImmutablePropKeyStrategy.ENUM == strategy) {
                    sb.append("( ($T) props.get( $T.Props.$N ) )");
                    params.add(prop.getMethodType().getReturnType());
                    params.add(descriptor.getEnhancedClassName());
                    params.add(prop.getConstantName());
                    continue;
                }
                if (ImmutablePropKeyStrategy.TO_STRING == strategy) {
                    sb.append("$T.valueOf( ($T) props.get( $T.Props.$N ) )");
                    params.add(String.class);
                    params.add(prop.getMethodType().getReturnType());
                    params.add(descriptor.getEnhancedClassName());
                    params.add(prop.getConstantName());
                    continue;
                }
                assert (ImmutablePropKeyStrategy.AREZ_IDENTIFIABLE == strategy);
                sb.append("$T.valueOf( $T.<Object>getArezId( ($T) props.get( $T.Props.$N ) ) )");
                params.add(String.class);
                params.add(IDENTIFIABLE_CLASSNAME);
                params.add(prop.getMethodType().getReturnType());
                params.add(descriptor.getEnhancedClassName());
                params.add(prop.getConstantName());
            }
            sb.append(" )");
            method.addStatement(sb.toString(), params.toArray());
        }
        method.addStatement("_element.complete()", new Object[0]).addStatement("return _element", new Object[0]).returns(REACT_NODE_CLASSNAME);
        return method.build();
    }

    @Nonnull
    private static TypeSpec buildBuilder(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor, @Nonnull BuilderDescriptor builderDescriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Builder");
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PRIVATE, Modifier.STATIC);
        List<Step> steps = builderDescriptor.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            builder.addSuperinterface(BuilderGenerator.getParameterizedTypeName(descriptor, ClassName.bestGuess("Step" + (i + 1))));
        }
        List propsWithDefaults = descriptor.getProps().stream().filter(p -> p.hasDefaultField() || p.hasDefaultMethod()).collect(Collectors.toList());
        if (!propsWithDefaults.isEmpty()) {
            MethodSpec.Builder method = MethodSpec.constructorBuilder();
            method.addStatement("_element = $T.createComponentElement( $T.Factory.TYPE )", REACT_ELEMENT_CLASSNAME, descriptor.getEnhancedClassName());
            method.addStatement("final $T props = _element.props()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME);
            for (PropDescriptor prop : propsWithDefaults) {
                method.addStatement("props.set( $T.Props.$N, $T.$N" + (prop.hasDefaultField() ? "" : "()") + " )", descriptor.getEnhancedClassName(), prop.getConstantName(), descriptor.getClassName(), prop.hasDefaultField() ? prop.getDefaultField().getSimpleName() : prop.getDefaultMethod().getSimpleName());
            }
            builder.addMethod(method.build());
        }
        HashSet<String> stepMethodsAdded = new HashSet<String>();
        for (Step step : steps) {
            for (StepMethod stepMethod : step.getMethods()) {
                if (!stepMethodsAdded.add(stepMethod.getName() + stepMethod.getType().toString()) || stepMethod.isBuildIntrinsic()) continue;
                builder.addMethod(BuilderGenerator.buildBuilderStepImpl(processingEnv, descriptor, step, stepMethod));
            }
        }
        FieldSpec.Builder field = FieldSpec.builder(REACT_ELEMENT_CLASSNAME, "_element", Modifier.PRIVATE, Modifier.FINAL);
        if (propsWithDefaults.isEmpty()) {
            field.initializer("$T.createComponentElement( $T.Factory.TYPE )", REACT_ELEMENT_CLASSNAME, descriptor.getEnhancedClassName());
        }
        builder.addField(field.build());
        builder.addMethod(BuilderGenerator.buildBuildStepImpl(descriptor));
        return builder.build();
    }

    @Nonnull
    private static TypeName getParameterizedTypeName(@Nonnull ComponentDescriptor descriptor, @Nonnull ClassName baseName) {
        List<? extends TypeMirror> arguments = descriptor.getDeclaredType().getTypeArguments();
        if (arguments.isEmpty()) {
            return baseName;
        }
        return ParameterizedTypeName.get(baseName, (TypeName[])arguments.stream().map(TypeName::get).toArray(TypeName[]::new));
    }

    static String asTypeArgumentsInfix(DeclaredType declaredType) {
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        return typeArguments.isEmpty() ? "" : "<" + typeArguments.stream().map(TypeMirror::toString).collect(Collectors.joining(", ")) + ">";
    }

    @Nonnull
    private static BuilderDescriptor buildBuilderDescriptor(@Nonnull ComponentDescriptor descriptor) {
        BuilderDescriptor builder = new BuilderDescriptor();
        Step optionalPropStep = null;
        List<PropDescriptor> props = descriptor.getProps();
        int propsSize = props.size();
        boolean hasSingleOptional = props.stream().filter(PropDescriptor::isOptional).count() == 1L;
        boolean hasRequiredAfterOptional = false;
        for (int i = 0; i < propsSize; ++i) {
            boolean isLast;
            PropDescriptor prop = props.get(i);
            boolean bl = isLast = i == propsSize - 1;
            if (prop.isOptional()) {
                if (null == optionalPropStep) {
                    optionalPropStep = builder.addStep();
                }
                if (prop.getName().equals("children")) {
                    BuilderGenerator.addChildrenStreamPropStepMethod(optionalPropStep);
                }
                optionalPropStep.addMethod(prop, hasSingleOptional ? StepMethodType.TERMINATE : StepMethodType.STAY);
                continue;
            }
            if (null != optionalPropStep) {
                optionalPropStep.addMethod(prop, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
                if (prop.getName().equals("children")) {
                    BuilderGenerator.addChildrenStreamPropStepMethod(optionalPropStep);
                }
                hasRequiredAfterOptional = true;
            }
            Step step = builder.addStep();
            step.addMethod(prop, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
            if (!prop.getName().equals("children")) continue;
            BuilderGenerator.addChildrenStreamPropStepMethod(step);
            BuilderGenerator.addBuildStep(step);
        }
        if (null != optionalPropStep && !hasRequiredAfterOptional) {
            BuilderGenerator.addBuildStep(optionalPropStep);
        }
        if (props.isEmpty()) {
            BuilderGenerator.addBuildStep(builder.addStep());
        }
        return builder;
    }

    private static void addBuildStep(@Nonnull Step step) {
        step.addTerminalMethod("build", "build", REACT_NODE_CLASSNAME);
    }

    private static void addChildrenStreamPropStepMethod(@Nonnull Step step) {
        ParameterizedTypeName typeName = ParameterizedTypeName.get(ClassName.get(Stream.class), WildcardTypeName.subtypeOf(REACT_NODE_CLASSNAME));
        step.addTerminalMethod("children", "*children_stream*", typeName);
    }
}

