/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import react4j.processor.ComponentType;
import react4j.processor.OnPropChangeDescriptor;
import react4j.processor.PropComparator;
import react4j.processor.PropDescriptor;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.GeneratorUtil;
import react4j.processor.vendor.proton.ProcessorException;

final class ComponentDescriptor {
    @Nonnull
    private final String _name;
    @Nonnull
    private final TypeElement _element;
    @Nonnull
    private final ComponentType _type;
    private final boolean _hasPostConstruct;
    private final boolean _shouldSetDefaultPriority;
    @Nonnull
    private final ExecutableElement _constructor;
    @Nullable
    private ExecutableElement _preUpdate;
    @Nullable
    private ExecutableElement _postRender;
    @Nullable
    private ExecutableElement _postUpdate;
    @Nullable
    private ExecutableElement _postMount;
    @Nullable
    private ExecutableElement _onError;
    @Nullable
    private List<PropDescriptor> _props;
    @Nullable
    private List<OnPropChangeDescriptor> _onPropChangeDescriptors;
    private Boolean _hasValidatedProps;
    private Boolean _enhanceComponentAccessesDeprecatedElements;
    private Boolean _builderAccessesDeprecatedElements;
    private boolean _hasArezElements;

    ComponentDescriptor(@Nonnull String name, @Nonnull TypeElement element, @Nonnull ComponentType type, boolean hasPostConstruct, boolean shouldSetDefaultPriority) {
        this._name = Objects.requireNonNull(name);
        this._element = Objects.requireNonNull(element);
        this._type = Objects.requireNonNull(type);
        this._hasPostConstruct = hasPostConstruct;
        this._shouldSetDefaultPriority = shouldSetDefaultPriority;
        if (ElementKind.CLASS != element.getKind()) {
            throw new ProcessorException("@ReactComponent target must be a class", element);
        }
        if (element.getModifiers().contains((Object)Modifier.FINAL)) {
            throw new ProcessorException("@ReactComponent target must not be final", element);
        }
        if (!element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new ProcessorException("@ReactComponent target must be abstract", element);
        }
        if (NestingKind.TOP_LEVEL != element.getNestingKind() && !element.getModifiers().contains((Object)Modifier.STATIC)) {
            throw new ProcessorException("@ReactComponent target must not be a non-static nested class", element);
        }
        List constructors = element.getEnclosedElements().stream().filter(m -> m.getKind() == ElementKind.CONSTRUCTOR).map(m -> (ExecutableElement)m).collect(Collectors.toList());
        if (1 != constructors.size() || !this.isConstructorValid((ExecutableElement)constructors.get(0))) {
            throw new ProcessorException("@ReactComponent target must have a single, package-access constructor or the default constructor", element);
        }
        this._constructor = (ExecutableElement)constructors.get(0);
        for (VariableElement variableElement : this._constructor.getParameters()) {
            if (!AnnotationsUtil.hasAnnotationOfType(variableElement, "arez.annotations.PerInstance")) continue;
            throw new ProcessorException("@ReactComponent target has a constructor with a parameter named '" + variableElement.getSimpleName().toString() + "' that is incorrectly annotated with the " + "arez.annotations.PerInstance" + " annotation.", element);
        }
    }

    private boolean isConstructorValid(@Nonnull ExecutableElement ctor) {
        List<? extends VariableElement> parameters = ctor.getParameters();
        Set<Modifier> modifiers = ctor.getModifiers();
        if (parameters.isEmpty()) {
            return !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
        }
        return !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED);
    }

    @Nonnull
    ExecutableElement getConstructor() {
        return this._constructor;
    }

    private boolean hasConstructorParams() {
        return !this._constructor.getParameters().isEmpty();
    }

    boolean hasPostConstruct() {
        return this._hasPostConstruct;
    }

    boolean shouldSetDefaultPriority() {
        return this._shouldSetDefaultPriority;
    }

    @Nonnull
    String getPackageName() {
        return GeneratorUtil.getQualifiedPackageName(this._element);
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    ClassName getClassName() {
        return ClassName.get(this.getElement());
    }

    @Nonnull
    TypeElement getElement() {
        return this._element;
    }

    @Nonnull
    DeclaredType getDeclaredType() {
        return (DeclaredType)this._element.asType();
    }

    @Nonnull
    ClassName getEnhancedClassName() {
        return GeneratorUtil.getGeneratedClassName(this._element, "React4j_", "");
    }

    @Nonnull
    ClassName getBuilderClassName() {
        return GeneratorUtil.getGeneratedClassName(this._element, "", "Builder");
    }

    @Nonnull
    ClassName getDaggerComponentExtensionClassName() {
        return GeneratorUtil.getGeneratedClassName(this._element, "", "DaggerComponentExtension");
    }

    @Nonnull
    ClassName getArezDaggerExtensionClassName() {
        return GeneratorUtil.getGeneratedClassName(this._element, "React4j_", "DaggerComponentExtension");
    }

    @Nonnull
    ClassName getArezClassName() {
        String simpleName = "Arez_" + GeneratorUtil.getGeneratedSimpleClassName(this._element, "React4j_", "");
        return ClassName.get(this.getPackageName(), simpleName, new String[0]);
    }

    @Nonnull
    TypeName getComponentType() {
        List<TypeName> typeNames = this.getDeclaredType().getTypeArguments().stream().map(TypeName::get).collect(Collectors.toList());
        if (!typeNames.isEmpty()) {
            return ParameterizedTypeName.get(ClassName.get(this.getElement()), typeNames.toArray(new TypeName[0]));
        }
        return ClassName.get(this.getElement());
    }

    boolean needsInjection() {
        return this.hasConstructorParams();
    }

    boolean trackRender() {
        return ComponentType.MAYBE_TRACKING == this._type || ComponentType.TRACKING == this._type;
    }

    void setHasArezElements(boolean hasArezElements) {
        this._hasArezElements = hasArezElements;
    }

    @Nonnull
    ComponentType getType() {
        return this._type;
    }

    int syntheticKeyComponents() {
        return (int)this.getProps().stream().filter(PropDescriptor::isImmutable).count();
    }

    @Nonnull
    List<PropDescriptor> getProps() {
        assert (null != this._props);
        return this._props;
    }

    void setProps(@Nonnull List<PropDescriptor> events) {
        this._props = Objects.requireNonNull(events);
    }

    @Nullable
    PropDescriptor findPropNamed(@Nonnull String name) {
        return this.getProps().stream().filter(p -> p.getName().equals(name)).findAny().orElse(null);
    }

    void sortProps() {
        assert (null != this._props);
        this._props.sort(PropComparator.COMPARATOR);
    }

    @Nonnull
    List<OnPropChangeDescriptor> getPreUpdateOnPropChangeDescriptors() {
        return this.getOnPropChangeDescriptors().stream().filter(OnPropChangeDescriptor::isPreUpdate).collect(Collectors.toList());
    }

    @Nonnull
    List<OnPropChangeDescriptor> getPostUpdateOnPropChangeDescriptors() {
        return this.getOnPropChangeDescriptors().stream().filter(o -> !o.isPreUpdate()).collect(Collectors.toList());
    }

    @Nonnull
    private List<OnPropChangeDescriptor> getOnPropChangeDescriptors() {
        assert (null != this._onPropChangeDescriptors);
        return this._onPropChangeDescriptors;
    }

    void setOnPropChangeDescriptors(@Nonnull List<OnPropChangeDescriptor> onPropChangeDescriptors) {
        this._onPropChangeDescriptors = Objects.requireNonNull(onPropChangeDescriptors);
    }

    boolean hasObservableProps() {
        return this.getProps().stream().anyMatch(PropDescriptor::isObservable);
    }

    @Nullable
    ExecutableElement getPreUpdate() {
        return this._preUpdate;
    }

    void setPreUpdate(@Nonnull ExecutableElement preUpdate) throws ProcessorException {
        if (null != this._preUpdate) {
            throw new ProcessorException("@PreUpdate target duplicates existing method named " + this._preUpdate.getSimpleName(), preUpdate);
        }
        this._preUpdate = preUpdate;
    }

    @Nullable
    ExecutableElement getPostRender() {
        return this._postRender;
    }

    void setPostRender(@Nonnull ExecutableElement postRender) throws ProcessorException {
        if (null != this._postRender) {
            throw new ProcessorException("@PostMountOrUpdate target duplicates existing method named " + this._postRender.getSimpleName(), postRender);
        }
        this._postRender = postRender;
    }

    @Nullable
    ExecutableElement getPostUpdate() {
        return this._postUpdate;
    }

    void setPostUpdate(@Nonnull ExecutableElement postUpdate) throws ProcessorException {
        if (null != this._postUpdate) {
            throw new ProcessorException("@PostUpdate target duplicates existing method named " + this._postUpdate.getSimpleName(), postUpdate);
        }
        this._postUpdate = postUpdate;
    }

    @Nullable
    ExecutableElement getPostMount() {
        return this._postMount;
    }

    void setPostMount(@Nonnull ExecutableElement postMount) throws ProcessorException {
        if (null != this._postMount) {
            throw new ProcessorException("@PostMount target duplicates existing method named " + this._postMount.getSimpleName(), postMount);
        }
        this._postMount = postMount;
    }

    @Nullable
    ExecutableElement getOnError() {
        return this._onError;
    }

    void setOnError(@Nonnull ExecutableElement onError) throws ProcessorException {
        if (null != this._onError) {
            throw new ProcessorException("@OnError target duplicates existing method named " + this._onError.getSimpleName(), onError);
        }
        this._onError = onError;
    }

    private boolean shouldGenerateLifecycle() {
        return this.generateComponentDidMount() || this.generateShouldComponentUpdate() || this.generateComponentPreUpdate() || this.generateComponentDidUpdate() || this.generateComponentWillUnmount() || this.generateComponentDidCatch();
    }

    boolean shouldGenerateLiteLifecycle() {
        return (this.generateComponentDidUpdateInLiteLifecycle() != this.generateComponentDidUpdate() || this.generateComponentWillUnmountInLiteLifecycle() != this.generateComponentWillUnmount() || this.generateShouldComponentUpdateInLiteLifecycle() != this.generateShouldComponentUpdate() || this.generateComponentDidMountInLiteLifecycle() != this.generateComponentDidMount()) && this.shouldGenerateLifecycle();
    }

    boolean generateShouldComponentUpdate() {
        return this.generateShouldComponentUpdateInLiteLifecycle() || this.hasValidatedProps();
    }

    boolean generateShouldComponentUpdateInLiteLifecycle() {
        return true;
    }

    boolean generateComponentDidCatch() {
        return null != this._onError;
    }

    boolean generateComponentWillUnmountInLiteLifecycle() {
        return this._hasArezElements;
    }

    boolean generateComponentWillUnmount() {
        return true;
    }

    boolean generateComponentPreUpdate() {
        return this.hasPreUpdateOnPropChange() || null != this._preUpdate;
    }

    boolean generateComponentDidMount() {
        return this.generateComponentDidMountInLiteLifecycle() || this.trackRender();
    }

    boolean generateComponentDidMountInLiteLifecycle() {
        return null != this._postMount || null != this._postRender;
    }

    boolean hasPreUpdateOnPropChange() {
        return !this.getPreUpdateOnPropChangeDescriptors().isEmpty();
    }

    boolean hasPostUpdateOnPropChange() {
        return !this.getPostUpdateOnPropChangeDescriptors().isEmpty();
    }

    boolean generateComponentDidUpdate() {
        return this.generateComponentDidUpdateInLiteLifecycle() || this.trackRender();
    }

    boolean generateComponentDidUpdateInLiteLifecycle() {
        return this.hasPostUpdateOnPropChange() || null != this._postUpdate || null != this._postRender;
    }

    boolean hasValidatedProps() {
        if (null == this._hasValidatedProps) {
            this._hasValidatedProps = this.getProps().stream().anyMatch(PropDescriptor::hasValidateMethod);
        }
        return this._hasValidatedProps;
    }

    boolean enhanceComponentAccessesDeprecatedElements() {
        if (null == this._enhanceComponentAccessesDeprecatedElements) {
            this._enhanceComponentAccessesDeprecatedElements = this.isDeprecated(this._element) || this.isDeprecated(this._constructor) || this.isDeprecated(this._preUpdate) || this.isDeprecated(this._postRender) || this.isDeprecated(this._postMount) || this.isDeprecated(this._postUpdate) || this.isDeprecated(this._onError) || this.getProps().stream().anyMatch(p -> this.isDeprecated(p.getMethod()) || p.hasValidateMethod() && this.isDeprecated(p.getValidateMethod())) || this.getPostUpdateOnPropChangeDescriptors().stream().anyMatch(d -> this.isDeprecated(d.getMethod()));
        }
        return this._enhanceComponentAccessesDeprecatedElements;
    }

    boolean builderAccessesDeprecatedElements() {
        if (null == this._builderAccessesDeprecatedElements) {
            this._builderAccessesDeprecatedElements = this.isDeprecated(this._element) || this.getProps().stream().anyMatch(p -> p.hasDefaultMethod() && this.isDeprecated(p.getDefaultMethod()) || p.hasDefaultField() && this.isDeprecated(p.getDefaultField()));
        }
        return this._builderAccessesDeprecatedElements;
    }

    private boolean isDeprecated(@Nullable Element element) {
        return null != element && null != element.getAnnotation(Deprecated.class);
    }
}

