/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import react4j.processor.ComponentDescriptor;
import react4j.processor.React4jProcessor;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.CodeBlock;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.proton.GeneratorUtil;

final class DaggerComponentExtensionGenerator {
    private static final ClassName NONNULL_CLASSNAME = ClassName.get("javax.annotation", "Nonnull", new String[0]);
    private static final ClassName GUARDS_CLASSNAME = ClassName.get("org.realityforge.braincheck", "Guards", new String[0]);
    private static final ClassName REACT_CLASSNAME = ClassName.get("react4j", "React", new String[0]);

    private DaggerComponentExtensionGenerator() {
    }

    @Nonnull
    private static TypeSpec buildInjectSupport(@Nonnull ComponentDescriptor descriptor) {
        assert (descriptor.needsInjection());
        TypeSpec.Builder builder = TypeSpec.classBuilder("InjectSupport").addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        builder.addField(DaggerComponentExtensionGenerator.buildFactoryField(descriptor).build());
        builder.addMethod(DaggerComponentExtensionGenerator.buildSetFactoryMethod(descriptor).build());
        builder.addMethod(DaggerComponentExtensionGenerator.buildInjectCreateMethod(descriptor).build());
        return builder.build();
    }

    @Nonnull
    private static FieldSpec.Builder buildFactoryField(@Nonnull ComponentDescriptor descriptor) {
        return FieldSpec.builder(descriptor.getArezClassName().nestedClass("Factory"), "c_factory", Modifier.STATIC, Modifier.PRIVATE);
    }

    @Nonnull
    private static MethodSpec.Builder buildSetFactoryMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("setFactory").addModifiers(Modifier.STATIC).addParameter(ParameterSpec.builder(descriptor.getArezClassName().nestedClass("Factory"), "factory", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).build());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
        block.addStatement("$T.invariant( () -> null == c_factory, () -> \"Attempted to re-initialize the React4j dependency injection provider for the component named '$N'. Initialization should only occur a single time.\" )", GUARDS_CLASSNAME, descriptor.getName());
        block.endControlFlow();
        method.addCode(block.build());
        method.addStatement("c_factory = factory", new Object[0]);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildInjectCreateMethod(@Nonnull ComponentDescriptor descriptor) {
        ParameterSpec.Builder parameter = ParameterSpec.builder(ClassName.get("react4j.internal", "NativeComponent", new String[0]), "nativeComponent", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        MethodSpec.Builder method = MethodSpec.methodBuilder("create").addModifiers(Modifier.PUBLIC, Modifier.STATIC).addParameter(parameter.build()).addAnnotation(NONNULL_CLASSNAME).returns(descriptor.getEnhancedClassName());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
        block.addStatement("$T.invariant( () -> null != c_factory, () -> \"Attempted to create an instance of the React4j component named '$N' before the dependency injection provider has been initialized. Please see the documentation at https://react4j.github.io/dependency_injection for directions how to configure dependency injection.\" )", GUARDS_CLASSNAME, descriptor.getName());
        block.endControlFlow();
        method.addCode(block.build());
        return method.addStatement("return c_factory.create( nativeComponent )", new Object[0]);
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder(descriptor.getDaggerComponentExtensionClassName());
        ClassName superClassName = descriptor.getArezDaggerExtensionClassName();
        builder.addSuperinterface(superClassName);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, React4jProcessor.class.getName());
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PUBLIC);
        MethodSpec.Builder method = MethodSpec.methodBuilder("bind" + descriptor.getName()).addModifiers(Modifier.PUBLIC, Modifier.DEFAULT);
        method.addStatement("InjectSupport.setFactory( $N().createFactory() )", "get" + descriptor.getName() + "DaggerSubcomponent");
        builder.addMethod(method.build());
        builder.addMethod(MethodSpec.methodBuilder("get" + descriptor.getName() + "DaggerSubcomponent").addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).addAnnotation(Override.class).returns(ClassName.bestGuess("DaggerSubcomponent")).build());
        if (descriptor.needsInjection()) {
            builder.addType(DaggerComponentExtensionGenerator.buildInjectSupport(descriptor));
        }
        return builder.build();
    }
}

