/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.proton;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.proton.ElementsUtil;
import react4j.processor.vendor.proton.GeneratorUtil;
import react4j.processor.vendor.proton.ProcessorException;
import react4j.processor.vendor.proton.SuperficialValidation;

public abstract class AbstractStandardProcessor
extends AbstractProcessor {
    @Nonnull
    private Set<TypeElement> _deferred = new HashSet<TypeElement>();
    private int _invalidTypeCount;

    protected final void processTypeElements(@Nonnull RoundEnvironment env, @Nonnull Collection<TypeElement> elements, @Nonnull Action action) {
        if (this.shouldDeferUnresolved()) {
            Collection<TypeElement> elementsToProcess = this.deriveElementsToProcess(elements);
            this.doProcessTypeElements(env, elementsToProcess, action);
            if (env.getRootElements().isEmpty() && !this._deferred.isEmpty()) {
                this._deferred.forEach(e -> this.processingErrorMessage(env, (TypeElement)e));
                this._deferred.clear();
            }
        } else {
            this.doProcessTypeElements(env, new ArrayList<TypeElement>(elements), action);
        }
    }

    protected final void errorIfProcessingOverAndInvalidTypesDetected(@Nonnull RoundEnvironment env) {
        if (env.processingOver()) {
            if (0 != this._invalidTypeCount) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getSimpleName() + " failed to process " + this._invalidTypeCount + " types. See earlier warnings for further details.");
            }
            this._invalidTypeCount = 0;
        }
    }

    protected boolean shouldDeferUnresolved() {
        Map<String, String> options = this.processingEnv.getOptions();
        String deferUnresolvedValue = options.get(this.getOptionPrefix() + ".defer.unresolved");
        return null == deferUnresolvedValue || "true".equals(deferUnresolvedValue);
    }

    @Nonnull
    protected abstract String getIssueTrackerURL();

    @Nonnull
    protected abstract String getOptionPrefix();

    private void processingErrorMessage(@Nonnull RoundEnvironment env, @Nonnull TypeElement target) {
        this.reportError(env, this.getClass().getSimpleName() + " unable to process " + target.getQualifiedName() + " because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.", target);
    }

    protected final void reportError(@Nonnull RoundEnvironment env, @Nonnull String message, @Nullable Element element) {
        String deferErrorsValue = this.processingEnv.getOptions().get(this.getOptionPrefix() + ".defer.errors");
        boolean deferErrors = null == deferErrorsValue || "true".equals(deferErrorsValue);
        ++this._invalidTypeCount;
        if (!deferErrors || env.errorRaised() || env.processingOver()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
        } else {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, element);
        }
    }

    private void doProcessTypeElements(@Nonnull RoundEnvironment env, @Nonnull Collection<TypeElement> elements, @Nonnull Action action) {
        for (TypeElement element : elements) {
            this.performAction(env, action, element);
        }
    }

    protected final void performAction(@Nonnull RoundEnvironment env, @Nonnull Action action, @Nonnull TypeElement element) {
        try {
            action.process(element);
        }
        catch (IOException ioe) {
            this.reportError(env, ioe.getMessage(), element);
        }
        catch (ProcessorException e) {
            Element errorLocation = e.getElement();
            Element outerElement = ElementsUtil.getTopLevelElement(errorLocation);
            if (!env.getRootElements().contains(outerElement)) {
                String location;
                TypeElement typeElement;
                if (errorLocation instanceof ExecutableElement) {
                    ExecutableElement executableElement = (ExecutableElement)errorLocation;
                    typeElement = (TypeElement)executableElement.getEnclosingElement();
                    location = typeElement.getQualifiedName() + "." + executableElement.getSimpleName();
                } else if (errorLocation instanceof VariableElement) {
                    VariableElement variableElement = (VariableElement)errorLocation;
                    typeElement = (TypeElement)variableElement.getEnclosingElement();
                    location = typeElement.getQualifiedName() + "." + variableElement.getSimpleName();
                } else {
                    assert (errorLocation instanceof TypeElement);
                    TypeElement typeElement2 = (TypeElement)errorLocation;
                    location = typeElement2.getQualifiedName().toString();
                }
                StringWriter sw = new StringWriter();
                this.processingEnv.getElementUtils().printElements(sw, errorLocation);
                sw.flush();
                String message = "An error was generated processing the element " + element.getSimpleName() + " but the error was triggered by code not currently being compiled but inherited or implemented by the element and may not be highlighted by your tooling or IDE. The error occurred at " + location + " and may look like:\n" + sw.toString();
                this.reportError(env, e.getMessage(), element);
                this.reportError(env, message, null);
            }
            this.reportError(env, e.getMessage(), e.getElement());
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            sw.flush();
            String message = "Unexpected error running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state. Please report the failure to the developers so that it can be fixed.\n Report the error at: " + this.getIssueTrackerURL() + "\n\n\n" + sw.toString();
            this.reportError(env, message, element);
        }
    }

    @Nonnull
    private Collection<TypeElement> deriveElementsToProcess(@Nonnull Collection<TypeElement> elements) {
        List<TypeElement> deferred = this._deferred.stream().map(e -> this.processingEnv.getElementUtils().getTypeElement(e.getQualifiedName())).collect(Collectors.toList());
        this._deferred = new HashSet<TypeElement>();
        ArrayList<TypeElement> elementsToProcess = new ArrayList<TypeElement>();
        this.collectElementsToProcess(elements, elementsToProcess);
        this.collectElementsToProcess(deferred, elementsToProcess);
        return elementsToProcess;
    }

    private void collectElementsToProcess(@Nonnull Collection<TypeElement> elements, @Nonnull List<TypeElement> elementsToProcess) {
        for (TypeElement element : elements) {
            if (SuperficialValidation.validateElement(this.processingEnv, element)) {
                elementsToProcess.add(element);
                continue;
            }
            this.deferElement(element);
        }
    }

    protected final void deferElement(@Nonnull TypeElement element) {
        this._deferred.add(element);
    }

    protected final void emitTypeSpec(@Nonnull String packageName, @Nonnull TypeSpec typeSpec) throws IOException {
        GeneratorUtil.emitJavaType(packageName, typeSpec, this.processingEnv.getFiler());
    }

    @FunctionalInterface
    public static interface Action {
        public void process(@Nonnull TypeElement var1) throws Exception;
    }
}

