/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.proton;

import java.util.List;
import javax.annotation.Nonnull;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class TypesUtil {
    private TypesUtil() {
    }

    public static boolean containsArrayType(@Nonnull TypeMirror type) {
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (!TypesUtil.containsArrayType(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return TypeKind.ARRAY == type.getKind();
    }

    public static boolean containsRawType(@Nonnull TypeMirror type) {
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.isEmpty() && !((TypeElement)declaredType.asElement()).getTypeParameters().isEmpty()) {
                return true;
            }
            for (TypeMirror typeMirror : typeArguments) {
                if (!TypesUtil.containsRawType(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean containsWildcard(@Nonnull TypeMirror type) {
        if (TypeKind.WILDCARD == type.getKind()) {
            return true;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            DeclaredType declaredType = (DeclaredType)type;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                if (!TypesUtil.containsWildcard(typeMirror)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

