/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import react4j.processor.vendor.proton.ProcessorException;

final class ProcessorUtil {
    private static final Pattern GETTER_PATTERN = Pattern.compile("^get([A-Z].*)$");
    private static final Pattern ISSER_PATTERN = Pattern.compile("^is([A-Z].*)$");

    private ProcessorUtil() {
    }

    @Nonnull
    static String getPropertyAccessorName(@Nonnull ExecutableElement method, @Nonnull String specifiedName, @Nonnull String sentinelName) throws ProcessorException {
        String name = ProcessorUtil.deriveName(method, GETTER_PATTERN, specifiedName, sentinelName);
        if (null != name) {
            return name;
        }
        if (method.getReturnType().getKind() == TypeKind.BOOLEAN && null != (name = ProcessorUtil.deriveName(method, ISSER_PATTERN, specifiedName, sentinelName))) {
            return name;
        }
        return method.getSimpleName().toString();
    }

    @Nullable
    static String deriveName(@Nonnull Element method, @Nonnull Pattern pattern, @Nonnull String name, @Nonnull String sentinelName) throws ProcessorException {
        if (sentinelName.equals(name)) {
            String methodName = method.getSimpleName().toString();
            Matcher matcher = pattern.matcher(methodName);
            if (matcher.find()) {
                String candidate = matcher.group(1);
                return Character.toLowerCase(candidate.charAt(0)) + candidate.substring(1);
            }
            return null;
        }
        return name;
    }

    @Nullable
    static ExecutableElement getOverridenMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement method) {
        TypeMirror superclass = typeElement.getSuperclass();
        if (TypeKind.NONE == superclass.getKind()) {
            return null;
        }
        TypeElement parent = (TypeElement)processingEnv.getTypeUtils().asElement(superclass);
        List<? extends Element> enclosedElements = parent.getEnclosedElements();
        for (Element element : enclosedElements) {
            if (ElementKind.METHOD != element.getKind() || !processingEnv.getElementUtils().overrides(method, (ExecutableElement)element, typeElement)) continue;
            return (ExecutableElement)element;
        }
        return null;
    }
}

