/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import react4j.processor.BuilderGenerator;
import react4j.processor.ComponentDescriptor;
import react4j.processor.ComponentGenerator;
import react4j.processor.ComponentType;
import react4j.processor.FactoryGenerator;
import react4j.processor.ImmutablePropKeyStrategy;
import react4j.processor.OnPropChangeDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.PropDescriptor;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.proton.AbstractStandardProcessor;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.DeferredElementSet;
import react4j.processor.vendor.proton.ElementsUtil;
import react4j.processor.vendor.proton.MemberChecks;
import react4j.processor.vendor.proton.ProcessorException;

@SupportedAnnotationTypes(value={"react4j.annotations.ReactComponent"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"react4j.defer.unresolved", "react4j.defer.errors", "react4j.debug"})
public final class React4jProcessor
extends AbstractStandardProcessor {
    private static final String SENTINEL_NAME = "<default>";
    private static final Pattern DEFAULT_GETTER_PATTERN = Pattern.compile("^get([A-Z].*)Default$");
    private static final Pattern VALIDATE_PROP_PATTERN = Pattern.compile("^validate([A-Z].*)$");
    private static final Pattern LAST_PROP_PATTERN = Pattern.compile("^last([A-Z].*)$");
    private static final Pattern PREV_PROP_PATTERN = Pattern.compile("^prev([A-Z].*)$");
    private static final Pattern PROP_PATTERN = Pattern.compile("^([a-z].*)$");
    @Nonnull
    private final DeferredElementSet _deferredTypes = new DeferredElementSet();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.processTypeElements(annotations, env, "react4j.annotations.ReactComponent", this._deferredTypes, this::process);
        this.errorIfProcessingOverAndInvalidTypesDetected(env);
        return true;
    }

    @Override
    @Nonnull
    protected final String getIssueTrackerURL() {
        return "https://github.com/react4j/react4j/issues";
    }

    @Override
    @Nonnull
    protected final String getOptionPrefix() {
        return "react4j";
    }

    private void process(@Nonnull TypeElement element) throws IOException, ProcessorException {
        ComponentDescriptor descriptor = this.parse(element);
        String packageName = descriptor.getPackageName();
        this.emitTypeSpec(packageName, ComponentGenerator.buildType(this.processingEnv, descriptor));
        this.emitTypeSpec(packageName, BuilderGenerator.buildType(this.processingEnv, descriptor));
        if (descriptor.needsInjection()) {
            this.emitTypeSpec(packageName, FactoryGenerator.buildType(this.processingEnv, descriptor));
        }
    }

    private boolean hasPostConstruct(@Nonnull TypeElement typeElement) {
        return this.getMethods(typeElement).stream().anyMatch(e -> AnnotationsUtil.hasAnnotationOfType(e, "arez.annotations.PostConstruct"));
    }

    @Nonnull
    private ComponentDescriptor parse(@Nonnull TypeElement typeElement) {
        boolean hasNamedAnnotation;
        String name = this.deriveComponentName(typeElement);
        ComponentType type = this.extractComponentType(typeElement);
        boolean hasPostConstruct = this.hasPostConstruct(typeElement);
        boolean shouldSetDefaultPriority = this.shouldSetDefaultPriority(typeElement);
        MemberChecks.mustNotBeFinal("react4j.annotations.ReactComponent", typeElement);
        MemberChecks.mustBeAbstract("react4j.annotations.ReactComponent", typeElement);
        if (ElementKind.CLASS != typeElement.getKind()) {
            throw new ProcessorException("@ReactComponent target must be a class", typeElement);
        }
        if (ElementsUtil.isNonStaticNestedClass(typeElement)) {
            throw new ProcessorException("@ReactComponent target must not be a non-static nested class", typeElement);
        }
        List<ExecutableElement> constructors = ElementsUtil.getConstructors(typeElement);
        if (1 != constructors.size() || !this.isConstructorValid(constructors.get(0))) {
            throw new ProcessorException(MemberChecks.must("react4j.annotations.ReactComponent", "have a single, package-access constructor or the default constructor"), typeElement);
        }
        ExecutableElement constructor = constructors.get(0);
        boolean inject = this.deriveInject(typeElement, constructor);
        boolean sting = this.deriveSting(typeElement, constructor);
        List<? extends VariableElement> parameters = constructor.getParameters();
        if (inject) {
            if (parameters.isEmpty()) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.ReactComponent", "have specified inject=ENABLED if the constructor has no parameters"), typeElement);
            }
        } else {
            hasNamedAnnotation = parameters.stream().anyMatch(p -> AnnotationsUtil.hasAnnotationOfType(p, "javax.inject.Named"));
            if (hasNamedAnnotation) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.ReactComponent", "have specified inject=DISABLED and have a constructor parameter annotated with the javax.inject.Named annotation"), constructor);
            }
        }
        if (sting) {
            if (parameters.isEmpty()) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.ReactComponent", "have specified sting=ENABLED if the constructor has no parameters"), typeElement);
            }
        } else {
            hasNamedAnnotation = parameters.stream().anyMatch(p -> AnnotationsUtil.hasAnnotationOfType(p, "sting.Named"));
            if (hasNamedAnnotation) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.ReactComponent", "have specified sting=DISABLED and have a constructor parameter annotated with the sting.Named annotation"), constructor);
            }
        }
        ComponentDescriptor descriptor = new ComponentDescriptor(name, typeElement, constructor, type, inject, sting, hasPostConstruct, shouldSetDefaultPriority);
        for (Element element : descriptor.getElement().getEnclosedElements()) {
            String message;
            if (ElementKind.METHOD != element.getKind()) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (method.getModifiers().contains((Object)Modifier.PUBLIC) && MemberChecks.doesMethodNotOverrideInterfaceMethod(this.processingEnv, typeElement, method) && ElementsUtil.isWarningNotSuppressed(method, "React4j:PublicMethod", "react4j.annotations.SuppressReact4jWarnings")) {
                message = MemberChecks.shouldNot("react4j.annotations.ReactComponent", "declare a public method. " + MemberChecks.suppressedBy("React4j:PublicMethod", "react4j.annotations.SuppressReact4jWarnings"));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, method);
            }
            if (method.getModifiers().contains((Object)Modifier.FINAL) && ElementsUtil.isWarningNotSuppressed(method, "React4j:FinalMethod", "react4j.annotations.SuppressReact4jWarnings")) {
                message = MemberChecks.shouldNot("react4j.annotations.ReactComponent", "declare a final method. " + MemberChecks.suppressedBy("React4j:FinalMethod", "react4j.annotations.SuppressReact4jWarnings"));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, method);
            }
            if (!method.getModifiers().contains((Object)Modifier.PROTECTED) || !ElementsUtil.isWarningNotSuppressed(method, "React4j:ProtectedMethod", "react4j.annotations.SuppressReact4jWarnings") || this.isMethodAProtectedOverride(typeElement, method)) continue;
            message = MemberChecks.shouldNot("react4j.annotations.ReactComponent", "declare a protected method. " + MemberChecks.suppressedBy("React4j:ProtectedMethod", "react4j.annotations.SuppressReact4jWarnings"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, method);
        }
        this.determineComponentCapabilities(descriptor, typeElement);
        this.determineProps(descriptor);
        this.determinePropValidatesMethods(descriptor);
        this.determineOnPropChangeMethods(descriptor);
        this.determineDefaultPropsMethods(descriptor);
        this.determineDefaultPropsFields(descriptor);
        this.determinePreUpdateMethod(typeElement, descriptor);
        this.determinePostMountOrUpdateMethod(typeElement, descriptor);
        this.determinePostUpdateMethod(typeElement, descriptor);
        this.determinePostMountMethod(typeElement, descriptor);
        this.determineOnErrorMethod(typeElement, descriptor);
        for (PropDescriptor propDescriptor : descriptor.getProps()) {
            if (!this.isPropRequired(propDescriptor)) {
                propDescriptor.markAsOptional();
                continue;
            }
            if (!propDescriptor.isContextProp()) continue;
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.Prop", "specify require=ENABLE parameter when the for source=CONTEXT parameter is specified"), propDescriptor.getMethod());
        }
        descriptor.sortProps();
        this.verifyPropsNotAnnotatedWithArezAnnotations(descriptor);
        this.verifyPropsNotCollectionOfArezComponents(descriptor);
        return descriptor;
    }

    private boolean isMethodAProtectedOverride(@Nonnull TypeElement typeElement, ExecutableElement method) {
        ExecutableElement overridenMethod = ProcessorUtil.getOverridenMethod(this.processingEnv, typeElement, method);
        return null != overridenMethod && overridenMethod.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    private boolean deriveInject(@Nonnull TypeElement typeElement, @Nonnull ExecutableElement constructor) {
        String inject = AnnotationsUtil.getEnumAnnotationParameter(typeElement, "react4j.annotations.ReactComponent", "inject");
        if ("ENABLE".equals(inject)) {
            return true;
        }
        if ("DISABLE".equals(inject)) {
            return false;
        }
        return !constructor.getParameters().isEmpty() && null != this.processingEnv.getElementUtils().getTypeElement("javax.inject.Inject");
    }

    private boolean deriveSting(@Nonnull TypeElement typeElement, @Nonnull ExecutableElement constructor) {
        String inject = AnnotationsUtil.getEnumAnnotationParameter(typeElement, "react4j.annotations.ReactComponent", "sting");
        if ("ENABLE".equals(inject)) {
            return true;
        }
        if ("DISABLE".equals(inject)) {
            return false;
        }
        return !constructor.getParameters().isEmpty() && null != this.processingEnv.getElementUtils().getTypeElement("sting.Injectable");
    }

    private boolean isConstructorValid(@Nonnull ExecutableElement ctor) {
        if (ElementsUtil.isSynthetic(ctor)) {
            return true;
        }
        Set<Modifier> modifiers = ctor.getModifiers();
        return !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED);
    }

    private void verifyPropsNotCollectionOfArezComponents(@Nonnull ComponentDescriptor descriptor) {
        for (PropDescriptor prop : descriptor.getProps()) {
            ArrayType arrayType;
            ExecutableElement method = prop.getMethod();
            TypeMirror returnType = method.getReturnType();
            if (TypeKind.DECLARED == returnType.getKind()) {
                DeclaredType declaredType = (DeclaredType)returnType;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!(this.isCollection(declaredType) ? 1 == typeArguments.size() && this.isArezComponent(typeArguments.get(0)) : this.isMap(declaredType) && 2 == typeArguments.size() && (this.isArezComponent(typeArguments.get(0)) || this.isArezComponent(typeArguments.get(1))))) continue;
                throw new ProcessorException("@Prop target is a collection that contains Arez components. This is not a safe pattern when the arez components can be disposed.", method);
            }
            if (TypeKind.ARRAY != returnType.getKind() || !this.isArezComponent((arrayType = (ArrayType)returnType).getComponentType())) continue;
            throw new ProcessorException("@Prop target is an array that contains Arez components. This is not a safe pattern when the arez components can be disposed.", method);
        }
    }

    private boolean isCollection(@Nonnull DeclaredType declaredType) {
        TypeElement returnType = (TypeElement)this.processingEnv.getTypeUtils().asElement(declaredType);
        String classname = returnType.getQualifiedName().toString();
        return Collection.class.getName().equals(classname) || Set.class.getName().equals(classname) || List.class.getName().equals(classname) || HashSet.class.getName().equals(classname) || ArrayList.class.getName().equals(classname);
    }

    private boolean isMap(@Nonnull DeclaredType declaredType) {
        TypeElement returnType = (TypeElement)this.processingEnv.getTypeUtils().asElement(declaredType);
        String classname = returnType.getQualifiedName().toString();
        return Map.class.getName().equals(classname) || HashMap.class.getName().equals(classname);
    }

    private boolean isArezComponent(@Nonnull TypeMirror typeMirror) {
        return typeMirror instanceof DeclaredType && this.processingEnv.getTypeUtils().asElement(typeMirror).getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().equals("arez.annotations.ArezComponent"));
    }

    private void verifyPropsNotAnnotatedWithArezAnnotations(@Nonnull ComponentDescriptor descriptor) {
        for (PropDescriptor prop : descriptor.getProps()) {
            ExecutableElement method = prop.getMethod();
            for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                String classname = annotationMirror.getAnnotationType().toString();
                if (!classname.startsWith("arez.annotations.")) continue;
                throw new ProcessorException("@Prop target must not be annotated with any arez annotations but is annotated by '" + classname + "'.", method);
            }
        }
    }

    private void determineOnPropChangeMethods(@Nonnull ComponentDescriptor descriptor) {
        List methods = this.getMethods(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.OnPropChange")).collect(Collectors.toList());
        ArrayList<OnPropChangeDescriptor> onPropChangeDescriptors = new ArrayList<OnPropChangeDescriptor>();
        for (ExecutableElement method : methods) {
            VariableElement phase = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.OnPropChange", "phase").getValue();
            boolean preUpdate = phase.getSimpleName().toString().equals("PRE");
            List<? extends VariableElement> parameters = method.getParameters();
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
            MemberChecks.mustBeSubclassCallable(descriptor.getElement(), "react4j.annotations.ReactComponent", "react4j.annotations.OnPropChange", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.OnPropChange", method);
            MemberChecks.mustNotReturnAnyValue("react4j.annotations.OnPropChange", method);
            int parameterCount = parameters.size();
            if (0 == parameterCount) {
                throw new ProcessorException("@OnPropChange target must have at least 1 parameter.", method);
            }
            ArrayList<PropDescriptor> propDescriptors = new ArrayList<PropDescriptor>(parameterCount);
            for (int i = 0; i < parameterCount; ++i) {
                boolean mismatchedNullability;
                VariableElement parameter = parameters.get(i);
                String name = this.deriveOnPropChangeName(parameter);
                PropDescriptor prop = descriptor.findPropNamed(name);
                if (null == prop) {
                    throw new ProcessorException("@OnPropChange target has a parameter named '" + parameter.getSimpleName() + "' and the parameter is associated with a @Prop named '" + name + "' but there is no corresponding @Prop annotated method.", parameter);
                }
                Types typeUtils = this.processingEnv.getTypeUtils();
                if (!typeUtils.isAssignable(parameterTypes.get(i), prop.getMethodType().getReturnType())) {
                    throw new ProcessorException("@OnPropChange target has a parameter named '" + parameter.getSimpleName() + "' and the parameter type is not assignable to the return type of the associated @Prop annotated method.", method);
                }
                boolean bl = mismatchedNullability = AnnotationsUtil.hasNonnullAnnotation(parameter) && AnnotationsUtil.hasNullableAnnotation(prop.getMethod()) || AnnotationsUtil.hasNullableAnnotation(parameter) && AnnotationsUtil.hasNonnullAnnotation(prop.getMethod());
                if (mismatchedNullability) {
                    throw new ProcessorException("@OnPropChange target has a parameter named '" + parameter.getSimpleName() + "' that has a nullability annotation incompatible with the associated @Prop method named " + method.getSimpleName(), method);
                }
                if (prop.isImmutable()) {
                    throw new ProcessorException("@OnPropChange target has a parameter named '" + parameter.getSimpleName() + "' that is associated with a @Prop annotated method and the prop is specified as immutable.", method);
                }
                propDescriptors.add(prop);
            }
            onPropChangeDescriptors.add(new OnPropChangeDescriptor(method, propDescriptors, preUpdate));
        }
        descriptor.setOnPropChangeDescriptors(onPropChangeDescriptors);
    }

    @Nonnull
    private String deriveOnPropChangeName(@Nonnull VariableElement parameter) {
        AnnotationValue value = AnnotationsUtil.findAnnotationValue(parameter, "react4j.annotations.PropRef", "value");
        if (null != value) {
            return (String)value.getValue();
        }
        String parameterName = parameter.getSimpleName().toString();
        if (LAST_PROP_PATTERN.matcher(parameterName).matches() || PREV_PROP_PATTERN.matcher(parameterName).matches()) {
            return Character.toLowerCase(parameterName.charAt(4)) + parameterName.substring(5);
        }
        if (PROP_PATTERN.matcher(parameterName).matches()) {
            return parameterName;
        }
        throw new ProcessorException("@OnPropChange target has a parameter named '" + parameterName + "' is not explicitly associated with a prop using @PropRef nor does it follow required naming conventions 'prev[MyProp]', 'last[MyProp]' or '[myProp]'.", parameter);
    }

    private void determinePropValidatesMethods(@Nonnull ComponentDescriptor descriptor) {
        List methods = this.getMethods(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.PropValidate")).collect(Collectors.toList());
        for (ExecutableElement method : methods) {
            boolean mismatchedNullability;
            String name = this.derivePropValidateName(method);
            PropDescriptor prop = descriptor.findPropNamed(name);
            if (null == prop) {
                throw new ProcessorException("@PropValidate target for prop named '" + name + "' has no corresponding @Prop annotated method.", method);
            }
            if (1 != method.getParameters().size()) {
                throw new ProcessorException("@PropValidate target must have exactly 1 parameter", method);
            }
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            if (!this.processingEnv.getTypeUtils().isAssignable(methodType.getParameterTypes().get(0), prop.getMethodType().getReturnType())) {
                throw new ProcessorException("@PropValidate target has a parameter type that is not assignable to the return type of the associated @Prop annotated method.", method);
            }
            MemberChecks.mustBeSubclassCallable(descriptor.getElement(), "react4j.annotations.ReactComponent", "react4j.annotations.PropValidate", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.PropValidate", method);
            MemberChecks.mustNotReturnAnyValue("react4j.annotations.PropValidate", method);
            VariableElement param = method.getParameters().get(0);
            boolean bl = mismatchedNullability = AnnotationsUtil.hasNonnullAnnotation(param) && AnnotationsUtil.hasNullableAnnotation(prop.getMethod()) || AnnotationsUtil.hasNullableAnnotation(param) && AnnotationsUtil.hasNonnullAnnotation(prop.getMethod());
            if (mismatchedNullability) {
                throw new ProcessorException("@PropValidate target has a parameter that has a nullability annotation incompatible with the associated @Prop method named " + prop.getMethod().getSimpleName(), method);
            }
            prop.setValidateMethod(method);
        }
    }

    @Nonnull
    private String derivePropValidateName(@Nonnull Element element) throws ProcessorException {
        String name = (String)AnnotationsUtil.getAnnotationValue(element, "react4j.annotations.PropValidate", "name").getValue();
        if (this.isSentinelName(name)) {
            String deriveName = ProcessorUtil.deriveName(element, VALIDATE_PROP_PATTERN, name, SENTINEL_NAME);
            if (null == deriveName) {
                throw new ProcessorException("@PropValidate target has not specified name nor is it named according to the convention 'validate[Name]Prop'.", element);
            }
            return deriveName;
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ProcessorException("@PropValidate target specified an invalid name '" + name + "'. The name must be a valid java identifier.", element);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ProcessorException("@PropValidate target specified an invalid name '" + name + "'. The name must not be a java keyword.", element);
        }
        return name;
    }

    private void determineDefaultPropsMethods(@Nonnull ComponentDescriptor descriptor) {
        List defaultPropsMethods = this.getMethods(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.PropDefault")).collect(Collectors.toList());
        for (ExecutableElement method : defaultPropsMethods) {
            String name = this.derivePropDefaultName(method);
            PropDescriptor prop = descriptor.findPropNamed(name);
            if (null == prop) {
                throw new ProcessorException("@PropDefault target for prop named '" + name + "' has no corresponding @Prop annotated method.", method);
            }
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            if (!this.processingEnv.getTypeUtils().isAssignable(methodType.getReturnType(), prop.getMethodType().getReturnType())) {
                throw new ProcessorException("@PropDefault target has a return type that is not assignable to the return type of the associated @Prop annotated method.", method);
            }
            MemberChecks.mustBeStaticallySubclassCallable(descriptor.getElement(), "react4j.annotations.ReactComponent", "react4j.annotations.PropDefault", method);
            MemberChecks.mustNotHaveAnyParameters("react4j.annotations.PropDefault", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.PropDefault", method);
            MemberChecks.mustReturnAValue("react4j.annotations.PropDefault", method);
            prop.setDefaultMethod(method);
        }
    }

    private void determineDefaultPropsFields(@Nonnull ComponentDescriptor descriptor) {
        List defaultPropsFields = ElementsUtil.getFields(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.PropDefault")).collect(Collectors.toList());
        for (VariableElement field : defaultPropsFields) {
            String name = this.derivePropDefaultName(field);
            PropDescriptor prop = descriptor.findPropNamed(name);
            if (null == prop) {
                throw new ProcessorException("@PropDefault target for prop named '" + name + "' has no corresponding @Prop annotated method.", field);
            }
            if (!this.processingEnv.getTypeUtils().isAssignable(field.asType(), prop.getMethodType().getReturnType())) {
                throw new ProcessorException("@PropDefault target has a type that is not assignable to the return type of the associated @Prop annotated method.", field);
            }
            MemberChecks.mustBeStaticallySubclassCallable(descriptor.getElement(), "react4j.annotations.ReactComponent", "react4j.annotations.PropDefault", field);
            MemberChecks.mustBeFinal("react4j.annotations.PropDefault", field);
            prop.setDefaultField(field);
        }
    }

    @Nonnull
    private String derivePropDefaultName(@Nonnull Element element) throws ProcessorException {
        String name = (String)AnnotationsUtil.getAnnotationValue(element, "react4j.annotations.PropDefault", "name").getValue();
        if (this.isSentinelName(name)) {
            if (element instanceof ExecutableElement) {
                String deriveName = ProcessorUtil.deriveName(element, DEFAULT_GETTER_PATTERN, name, SENTINEL_NAME);
                if (null == deriveName) {
                    throw new ProcessorException("@PropDefault target has not specified name nor is it named according to the convention 'get[Name]Default'.", element);
                }
                return deriveName;
            }
            String fieldName = element.getSimpleName().toString();
            boolean matched = true;
            int lengthPrefix = "DEFAULT_".length();
            int length = fieldName.length();
            if (fieldName.startsWith("DEFAULT_") && length > lengthPrefix) {
                for (int i = lengthPrefix; i < length; ++i) {
                    char ch = fieldName.charAt(i);
                    if (!Character.isLowerCase(ch) && (i == lengthPrefix && Character.isJavaIdentifierStart(ch) || i != lengthPrefix && Character.isJavaIdentifierPart(ch))) continue;
                    matched = false;
                    break;
                }
            } else {
                matched = false;
            }
            if (matched) {
                return this.uppercaseConstantToPascalCase(fieldName.substring(lengthPrefix));
            }
            throw new ProcessorException("@PropDefault target has not specified name nor is it named according to the convention 'DEFAULT_[NAME]'.", element);
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ProcessorException("@PropDefault target specified an invalid name '" + name + "'. The name must be a valid java identifier.", element);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ProcessorException("@PropDefault target specified an invalid name '" + name + "'. The name must not be a java keyword.", element);
        }
        return name;
    }

    @Nonnull
    private String uppercaseConstantToPascalCase(@Nonnull String candidate) {
        String s = candidate.toLowerCase();
        StringBuilder sb = new StringBuilder();
        boolean uppercase = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if ('_' == ch) {
                uppercase = true;
                continue;
            }
            if (uppercase) {
                sb.append(Character.toUpperCase(ch));
                uppercase = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private void determineProps(@Nonnull ComponentDescriptor descriptor) {
        List<PropDescriptor> props = this.getMethods(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.Prop")).map(m -> this.createPropDescriptor(descriptor, (ExecutableElement)m)).collect(Collectors.toList());
        PropDescriptor childrenProp = props.stream().filter(p -> p.getName().equals("children")).findAny().orElse(null);
        PropDescriptor childProp = props.stream().filter(p -> p.getName().equals("child")).findAny().orElse(null);
        if (null != childrenProp && null != childProp) {
            throw new ProcessorException("Multiple candidate children @Prop annotated methods: " + childrenProp.getMethod().getSimpleName() + " and " + childProp.getMethod().getSimpleName(), childrenProp.getMethod());
        }
        descriptor.setProps(props);
    }

    private boolean isPropRequired(@Nonnull PropDescriptor prop) {
        String requiredValue = prop.getRequiredValue();
        if ("ENABLE".equals(requiredValue)) {
            return true;
        }
        if ("DISABLE".equals(requiredValue)) {
            return false;
        }
        if (prop.isContextProp()) {
            return false;
        }
        return !prop.hasDefaultMethod() && !prop.hasDefaultField() && !AnnotationsUtil.hasNullableAnnotation(prop.getMethod());
    }

    @Nonnull
    private PropDescriptor createPropDescriptor(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method) {
        ImmutablePropKeyStrategy strategy;
        String name = this.derivePropName(method);
        ExecutableType methodType = this.resolveMethodType(descriptor, method);
        this.verifyNoDuplicateAnnotations(method);
        MemberChecks.mustBeAbstract("react4j.annotations.Prop", method);
        MemberChecks.mustNotHaveAnyParameters("react4j.annotations.Prop", method);
        MemberChecks.mustReturnAValue("react4j.annotations.Prop", method);
        MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.Prop", method);
        MemberChecks.mustNotBePackageAccessInDifferentPackage(descriptor.getElement(), "react4j.annotations.ReactComponent", "react4j.annotations.Prop", method);
        TypeMirror returnType = method.getReturnType();
        if ("build".equals(name)) {
            throw new ProcessorException("@Prop named 'build' is invalid as it conflicts with the method named build() that is used in the generated Builder classes", method);
        }
        if ("child".equals(name) && returnType.getKind() != TypeKind.DECLARED && !"react4j.ReactNode".equals(returnType.toString())) {
            throw new ProcessorException("@Prop named 'child' should be of type react4j.ReactNode", method);
        }
        if ("children".equals(name) && returnType.getKind() != TypeKind.DECLARED && !"react4j.ReactNode[]".equals(returnType.toString())) {
            throw new ProcessorException("@Prop named 'children' should be of type react4j.ReactNode[]", method);
        }
        if (returnType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)returnType;
            String typeVariableName = typeVariable.asElement().getSimpleName().toString();
            List<? extends TypeParameterElement> typeParameters = method.getTypeParameters();
            if (typeParameters.stream().anyMatch(p -> p.getSimpleName().toString().equals(typeVariableName))) {
                throw new ProcessorException("@Prop named '" + name + "' is has a type variable as a return type that is declared on the method.", method);
            }
        }
        String qualifier = (String)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Prop", "qualifier").getValue();
        boolean contextProp = this.isContextProp(method);
        Element propType = this.processingEnv.getTypeUtils().asElement(returnType);
        boolean immutable = this.isPropImmutable(method);
        boolean shouldUpdateOnChange = this.shouldUpdateOnChange(method, immutable);
        boolean observable = this.isPropObservable(descriptor, method, shouldUpdateOnChange, immutable);
        boolean disposable = null != propType && this.isPropDisposable(method, propType);
        TypeName typeName = TypeName.get(returnType);
        if (typeName.isBoxedPrimitive() && AnnotationsUtil.hasNonnullAnnotation(method)) {
            throw new ProcessorException("@Prop named '" + name + "' is a boxed primitive annotated with a @Nonnull annotation. The return type should be the primitive type.", method);
        }
        ImmutablePropKeyStrategy immutablePropKeyStrategy = strategy = immutable ? this.getImmutablePropKeyStrategy(typeName, propType) : null;
        if (immutable && null == strategy) {
            throw new ProcessorException("@Prop named '" + name + "' has specified the 'immutable' parameter as true but the annotation processor can not extract a key part from the type. This is because the type is not recognized as conforming to the rules as documented in the javadocs for the immutable parameter of the @Prop annotation.", method);
        }
        if (!"".equals(qualifier) && !contextProp) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.Prop", "specify qualifier parameter unless source=CONTEXT is also specified"), method);
        }
        String requiredValue = ((VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Prop", "require").getValue()).getSimpleName().toString();
        PropDescriptor propDescriptor = new PropDescriptor(descriptor, name, qualifier, method, methodType, contextProp, shouldUpdateOnChange, observable, disposable, strategy, requiredValue);
        if (propDescriptor.mayNeedMutablePropAccessedInPostConstructInvariant() && ElementsUtil.isWarningSuppressed(method, "React4j:MutablePropAccessedInPostConstruct", "react4j.annotations.SuppressReact4jWarnings")) {
            propDescriptor.suppressMutablePropAccessedInPostConstruct();
        }
        return propDescriptor;
    }

    @Nullable
    private ImmutablePropKeyStrategy getImmutablePropKeyStrategy(@Nonnull TypeName typeName, @Nullable Element element) {
        if (typeName.toString().equals("java.lang.String")) {
            return ImmutablePropKeyStrategy.IS_STRING;
        }
        if (typeName.isBoxedPrimitive() || typeName.isPrimitive()) {
            return ImmutablePropKeyStrategy.TO_STRING;
        }
        if (null != element) {
            if ((ElementKind.CLASS == element.getKind() || ElementKind.INTERFACE == element.getKind()) && this.isAssignableToKeyed(element)) {
                return ImmutablePropKeyStrategy.KEYED;
            }
            if (ElementKind.CLASS == element.getKind() && AnnotationsUtil.hasAnnotationOfType(element, "arez.annotations.ArezComponent") && this.isIdRequired((TypeElement)element)) {
                return ImmutablePropKeyStrategy.AREZ_IDENTIFIABLE;
            }
            if ((ElementKind.CLASS == element.getKind() || ElementKind.INTERFACE == element.getKind()) && AnnotationsUtil.hasAnnotationOfType(element, "arez.annotations.ActAsComponent")) {
                return ImmutablePropKeyStrategy.AREZ_IDENTIFIABLE;
            }
            if (ElementKind.ENUM == element.getKind()) {
                return ImmutablePropKeyStrategy.ENUM;
            }
        }
        return null;
    }

    private boolean isAssignableToKeyed(@Nonnull Element element) {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement("react4j.Keyed");
        return this.processingEnv.getTypeUtils().isAssignable(element.asType(), typeElement.asType());
    }

    private boolean isIdRequired(@Nonnull TypeElement element) {
        VariableElement requireIdParameter = (VariableElement)AnnotationsUtil.getAnnotationValue(element, "arez.annotations.ArezComponent", "requireId").getValue();
        switch (requireIdParameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        if (AnnotationsUtil.hasAnnotationOfType(element, "arez.annotations.Repository")) {
            return true;
        }
        return this.getMethods(element).stream().anyMatch(m -> AnnotationsUtil.hasAnnotationOfType(m, "arez.annotations.ComponentId") || AnnotationsUtil.hasAnnotationOfType(m, "arez.annotations.ComponentIdRef"));
    }

    @Nonnull
    private String derivePropName(@Nonnull ExecutableElement method) throws ProcessorException {
        String specifiedName = (String)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Prop", "name").getValue();
        String name = ProcessorUtil.getPropertyAccessorName(method, specifiedName, SENTINEL_NAME);
        if (!SourceVersion.isIdentifier(name)) {
            throw new ProcessorException("@Prop target specified an invalid name '" + specifiedName + "'. The name must be a valid java identifier.", method);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ProcessorException("@Prop target specified an invalid name '" + specifiedName + "'. The name must not be a java keyword.", method);
        }
        return name;
    }

    private void determineOnErrorMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.OnError")) continue;
            MemberChecks.mustNotBeAbstract("react4j.annotations.OnError", method);
            MemberChecks.mustBeSubclassCallable(typeElement, "react4j.annotations.ReactComponent", "react4j.annotations.OnError", method);
            MemberChecks.mustNotReturnAnyValue("react4j.annotations.OnError", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.OnError", method);
            boolean infoFound = false;
            boolean errorFound = false;
            for (VariableElement variableElement : method.getParameters()) {
                TypeName typeName = TypeName.get(variableElement.asType());
                if (typeName.toString().equals("react4j.ReactErrorInfo")) {
                    if (infoFound) {
                        throw new ProcessorException("@OnError target has multiple parameters of type react4j.ReactErrorInfo", method);
                    }
                    infoFound = true;
                    continue;
                }
                if (typeName.toString().equals("elemental2.core.JsError")) {
                    if (errorFound) {
                        throw new ProcessorException("@OnError target has multiple parameters of type elemental2.core.JsError", method);
                    }
                    errorFound = true;
                    continue;
                }
                throw new ProcessorException("@OnError target has parameter of invalid type named " + variableElement.getSimpleName().toString(), variableElement);
            }
            descriptor.setOnError(method);
        }
    }

    private void determinePostMountMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.PostMount")) continue;
            MemberChecks.mustBeLifecycleHook(typeElement, "react4j.annotations.ReactComponent", "react4j.annotations.PostMount", method);
            descriptor.setPostMount(method);
        }
    }

    private void determinePostMountOrUpdateMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.PostMountOrUpdate")) continue;
            MemberChecks.mustBeLifecycleHook(typeElement, "react4j.annotations.ReactComponent", "react4j.annotations.PostMountOrUpdate", method);
            descriptor.setPostRender(method);
        }
    }

    private void determinePostUpdateMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.PostUpdate")) continue;
            MemberChecks.mustBeLifecycleHook(typeElement, "react4j.annotations.ReactComponent", "react4j.annotations.PostUpdate", method);
            descriptor.setPostUpdate(method);
        }
    }

    private void determinePreUpdateMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.PreUpdate")) continue;
            MemberChecks.mustBeLifecycleHook(typeElement, "react4j.annotations.ReactComponent", "react4j.annotations.PreUpdate", method);
            descriptor.setPreUpdate(method);
        }
    }

    private ExecutableType resolveMethodType(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method) {
        return (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
    }

    @Nonnull
    private String deriveComponentName(@Nonnull TypeElement typeElement) {
        String name = (String)AnnotationsUtil.getAnnotationValue(typeElement, "react4j.annotations.ReactComponent", "name").getValue();
        if (this.isSentinelName(name)) {
            return typeElement.getSimpleName().toString();
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ProcessorException("@ReactComponent target specified an invalid name '" + name + "'. The name must be a valid java identifier.", typeElement);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ProcessorException("@ReactComponent target specified an invalid name '" + name + "'. The name must not be a java keyword.", typeElement);
        }
        return name;
    }

    private void determineComponentCapabilities(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeElement typeElement) {
        TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.Component");
        TypeMirror rawComponentType = this.processingEnv.getTypeUtils().erasure(componentType.asType());
        DeclaredType declaredType = descriptor.getDeclaredType();
        boolean isComponent = this.processingEnv.getTypeUtils().isSubtype(declaredType, rawComponentType);
        if (!isComponent) {
            throw new ProcessorException(MemberChecks.must("react4j.annotations.ReactComponent", "be a subclass of react4j.Component"), typeElement);
        }
        if (AnnotationsUtil.hasAnnotationOfType(typeElement, "arez.annotations.ArezComponent")) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.ReactComponent", "be annotated with the " + MemberChecks.toSimpleName("arez.annotations.ArezComponent") + " as React4j will add the annotation."), typeElement);
        }
        if (descriptor.needsInjection() && !descriptor.getDeclaredType().getTypeArguments().isEmpty()) {
            throw new ProcessorException(MemberChecks.toSimpleName("react4j.annotations.ReactComponent") + " target has enabled injection integration but the class has type arguments which is incompatible with injection integration.", typeElement);
        }
        boolean hasArezElements = descriptor.trackRender() || this.getMethods(typeElement).stream().anyMatch(e -> e.getAnnotationMirrors().stream().map(a -> a.getAnnotationType().toString()).anyMatch(n -> n.startsWith("arez.annotations.") && !n.endsWith("PostConstruct") && !n.endsWith("ContextRef") && !n.endsWith("ComponentTypeNameRef") && !n.endsWith("ComponentNameRef") && !n.endsWith("ComponentIdRef") && !n.endsWith("ComponentId") && !n.endsWith("Action"))) || ElementsUtil.getFields(typeElement).stream().anyMatch(e -> e.getAnnotationMirrors().stream().map(a -> a.getAnnotationType().toString()).anyMatch(n -> n.equals("arez.annotations.CascadeDispose") || n.equals("arez.annotations.ComponentDependency")));
        descriptor.setHasArezElements(hasArezElements);
    }

    @Nonnull
    private ComponentType extractComponentType(@Nonnull TypeElement typeElement) {
        VariableElement declaredTypeEnum = (VariableElement)AnnotationsUtil.getAnnotationValue(typeElement, "react4j.annotations.ReactComponent", "type").getValue();
        return ComponentType.valueOf(declaredTypeEnum.getSimpleName().toString());
    }

    private boolean shouldUpdateOnChange(@Nonnull ExecutableElement method, boolean immutable) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Prop", "shouldUpdateOnChange").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                if (immutable) {
                    throw new ProcessorException("@Prop target has specified both immutable=true and shouldUpdateOnChange=ENABLE which is an invalid combination.", method);
                }
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return !immutable;
    }

    private boolean isPropObservable(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method, boolean shouldUpdateOnChange, boolean immutable) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Prop", "observable").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                if (immutable) {
                    throw new ProcessorException("@Prop target has specified both immutable=true and observable=ENABLE which is an invalid combination.", method);
                }
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return shouldUpdateOnChange && this.hasAnyArezObserverMethods(descriptor.getElement());
    }

    private boolean hasAnyArezObserverMethods(@Nonnull TypeElement typeElement) {
        return this.getMethods(typeElement).stream().anyMatch(m -> AnnotationsUtil.hasAnnotationOfType(m, "arez.annotations.Memoize") || AnnotationsUtil.hasAnnotationOfType(m, "arez.annotations.Observe") && (!m.getParameters().isEmpty() || !m.getSimpleName().toString().equals("trackRender")));
    }

    private boolean isPropImmutable(@Nonnull ExecutableElement method) {
        return (Boolean)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Prop", "immutable").getValue();
    }

    private boolean isPropDisposable(@Nonnull ExecutableElement method, @Nonnull Element propType) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Prop", "disposable").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return ElementKind.CLASS == propType.getKind() && AnnotationsUtil.hasAnnotationOfType(propType, "arez.annotations.ArezComponent") || (ElementKind.CLASS == propType.getKind() || ElementKind.INTERFACE == propType.getKind()) && AnnotationsUtil.hasAnnotationOfType(propType, "arez.annotations.ActAsComponent");
    }

    private boolean isContextProp(@Nonnull ExecutableElement method) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Prop", "source").getValue();
        return "CONTEXT".equals(parameter.getSimpleName().toString());
    }

    private boolean shouldSetDefaultPriority(@Nonnull TypeElement typeElement) {
        List<ExecutableElement> methods = this.getMethods(typeElement);
        return methods.stream().filter(method -> !method.getModifiers().contains((Object)Modifier.PRIVATE)).anyMatch(method -> AnnotationsUtil.hasAnnotationOfType(method, "arez.annotations.Memoize") || AnnotationsUtil.hasAnnotationOfType(method, "arez.annotations.Observe"));
    }

    private void verifyNoDuplicateAnnotations(@Nonnull ExecutableElement method) throws ProcessorException {
        List<String> annotations = Arrays.asList("react4j.annotations.PropDefault", "react4j.annotations.PropValidate", "react4j.annotations.OnPropChange", "react4j.annotations.Prop");
        MemberChecks.verifyNoOverlappingAnnotations(method, annotations, Collections.emptyMap());
    }

    @Nonnull
    private List<ExecutableElement> getMethods(@Nonnull TypeElement typeElement) {
        return ElementsUtil.getMethods(typeElement, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
    }

    private boolean isSentinelName(@Nonnull String name) {
        return SENTINEL_NAME.equals(name);
    }
}

