/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import elemental2.core.JsObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsPropertyMap;
import jsinterop.base.JsPropertyMapOfAny;
import react4j.core.ComponentConstructorFunction;
import react4j.core.NativeAdapterComponent;
import react4j.core.PropType;
import react4j.core.React;
import react4j.core.ReactConfig;
import react4j.core.ReactNode;
import react4j.processor.ComponentDescriptor;
import react4j.processor.EventHandlerDescriptor;
import react4j.processor.MethodDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.ReactProcessor;

final class Generator {
    private Generator() {
    }

    @Nonnull
    static TypeSpec buildEnhancedComponent(@Nonnull ComponentDescriptor descriptor) {
        TypeElement element = descriptor.getElement();
        String name = descriptor.getNestedClassPrefix() + descriptor.getEnhancedName();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)name);
        builder.superclass((TypeName)descriptor.getClassName());
        if (descriptor.isArezComponent()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.realityforge.arez.annotations", (String)"ArezComponent", (String[])new String[0])).addMember("type", "$S", new Object[]{descriptor.getName()});
            builder.addAnnotation(annotation.build());
        }
        ProcessorUtil.copyAccessModifiers(element, builder);
        builder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{ReactProcessor.class.getName()}).build());
        FieldSpec.Builder field = FieldSpec.builder((TypeName)Generator.getJsConstructorFnType(descriptor), (String)"TYPE", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE}).initializer("getConstructorFunction()", new Object[0]);
        builder.addField(field.build());
        for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
            builder.addField(Generator.buildEventHandlerField(eventHandler).build());
        }
        builder.addMethod(Generator.buildFactoryMethod().build());
        builder.addMethod(Generator.buildFactory2Method(descriptor).build());
        builder.addMethod(Generator.buildFactory3Method(descriptor).build());
        builder.addMethod(Generator.buildConstructorFnMethod(descriptor).build());
        for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
            builder.addMethod(Generator.buildStaticEventHandlerMethod(descriptor, eventHandler).build());
        }
        MethodDescriptor renderMethod = descriptor.getRenderMethod();
        if (!renderMethod.getMethod().getSimpleName().toString().equals("render")) {
            builder.addMethod(Generator.buildRenderAdapterMethod(renderMethod).build());
        }
        for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
            builder.addMethod(Generator.buildEventHandlerBuilderMethod(descriptor, eventHandler).build());
        }
        if (descriptor.isArezComponent()) {
            for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
                AnnotationMirror nonActionAnnotation = eventHandler.getMethod().getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().toString().equals("react4j.arez.NoAutoAction")).findAny().orElse(null);
                if (null != nonActionAnnotation) continue;
                builder.addMethod(Generator.buildEventHandlerActionMethod(eventHandler).build());
            }
        }
        if (!descriptor.getLifecycleMethods().isEmpty()) {
            builder.addType(Generator.buildNativeLifecycleInterface(descriptor));
        }
        builder.addType(Generator.buildNativeComponent(descriptor));
        return builder.build();
    }

    @Nonnull
    private static ParameterizedTypeName getJsConstructorFnType(@Nonnull ComponentDescriptor descriptor) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(ComponentConstructorFunction.class), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)descriptor.getPropsType().asType()), TypeName.get((TypeMirror)descriptor.getContextType().asType())});
    }

    @Nonnull
    private static FieldSpec.Builder buildEventHandlerField(@Nonnull EventHandlerDescriptor eventHandler) {
        TypeName handlerType = TypeName.get((TypeMirror)eventHandler.getEventHandlerType().asType());
        String handlerName = "_" + eventHandler.getMethod().getSimpleName().toString();
        return FieldSpec.builder((TypeName)handlerType, (String)handlerName, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).addAnnotation(Nonnull.class).initializer("create$N()", new Object[]{handlerName});
    }

    @Nonnull
    private static MethodSpec.Builder buildStaticEventHandlerMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull EventHandlerDescriptor eventHandler) {
        TypeName handlerType = TypeName.get((TypeMirror)eventHandler.getEventHandlerType().asType());
        String handlerName = "_" + eventHandler.getMethod().getSimpleName();
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)handlerName).addAnnotation(Nonnull.class).returns(handlerType);
        method.addModifiers(new Modifier[]{Modifier.STATIC});
        ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)descriptor.getElement().asType()), (String)"component", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class);
        method.addParameter(parameter.build());
        method.addStatement("return (($T) component).$N", new Object[]{descriptor.getEnhancedClassName(), handlerName});
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildRenderAdapterMethod(@Nonnull MethodDescriptor renderMethod) {
        return MethodSpec.methodBuilder((String)"render").addModifiers(new Modifier[]{Modifier.PROTECTED}).addAnnotation(Override.class).addAnnotation(Nullable.class).returns(ReactNode.class).addStatement("return $T.of( $N() )", new Object[]{ReactNode.class, renderMethod.getMethod().getSimpleName().toString()});
    }

    @Nonnull
    private static MethodSpec.Builder buildEventHandlerBuilderMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull EventHandlerDescriptor eventHandler) {
        int paramCount;
        String args;
        TypeName handlerType = TypeName.get((TypeMirror)eventHandler.getEventHandlerType().asType());
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)("create_" + eventHandler.getMethod().getSimpleName())).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(Nonnull.class).returns(handlerType);
        ExecutableElement target = eventHandler.getEventHandlerMethod();
        int targetParameterCount = target.getParameters().size();
        String string = args = 0 == targetParameterCount ? "()" : IntStream.range(0, targetParameterCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        if (1 < targetParameterCount) {
            args = "(" + args + ")";
        }
        String params = 0 == (paramCount = eventHandler.getMethod().getParameters().size()) ? "" : IntStream.range(0, paramCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        method.addStatement("final $T handler = " + args + " -> this.$N(" + params + ")", new Object[]{handlerType, eventHandler.getMethod().getSimpleName()});
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if( $T.enableComponentNames() )", new Object[]{ReactConfig.class});
        String code = "$T.defineProperty( $T.cast( handler ), \"name\", $T.cast( JsPropertyMap.of( \"value\", $S ) ) )";
        block.addStatement("$T.defineProperty( $T.cast( handler ), \"name\", $T.cast( JsPropertyMap.of( \"value\", $S ) ) )", new Object[]{JsObject.class, Js.class, Js.class, descriptor.getName() + "." + eventHandler.getName()});
        block.endControlFlow();
        method.addCode(block.build());
        method.addStatement("return handler", new Object[0]);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildEventHandlerActionMethod(@Nonnull EventHandlerDescriptor eventHandler) {
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)eventHandler.getMethod().getSimpleName().toString()).returns(TypeName.get((TypeMirror)eventHandler.getMethodType().getReturnType()));
        ProcessorUtil.copyTypeParameters(eventHandler.getMethodType(), method);
        ProcessorUtil.copyAccessModifiers(eventHandler.getMethod(), method);
        ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)eventHandler.getMethod(), method);
        AnnotationSpec.Builder annotation = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.realityforge.arez.annotations", (String)"Action", (String[])new String[0])).addMember("reportParameters", "false", new Object[0]);
        method.addAnnotation(annotation.build());
        int paramCount = eventHandler.getMethod().getParameters().size();
        for (int i2 = 0; i2 < paramCount; ++i2) {
            TypeMirror paramType = eventHandler.getMethodType().getParameterTypes().get(i2);
            ParameterSpec.Builder parameter = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)paramType), (String)("arg" + i2), (Modifier[])new Modifier[]{Modifier.FINAL});
            ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)eventHandler.getMethod().getParameters().get(i2), parameter);
            method.addParameter(parameter.build());
        }
        String params = 0 == paramCount ? "" : IntStream.range(0, paramCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        boolean isVoid = eventHandler.getMethodType().getReturnType().getKind() == TypeKind.VOID;
        method.addStatement((isVoid ? "" : "return ") + "super.$N(" + params + ")", new Object[]{eventHandler.getMethod().getSimpleName()});
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildFactoryMethod() {
        return MethodSpec.methodBuilder((String)"_create").addAnnotation(Nonnull.class).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get(ReactNode.class)).addStatement("return $T.createElement( TYPE )", new Object[]{React.class});
    }

    @Nonnull
    private static MethodSpec.Builder buildFactory2Method(@Nonnull ComponentDescriptor descriptor) {
        return MethodSpec.methodBuilder((String)"_create").addAnnotation(Nonnull.class).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get(ReactNode.class)).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)descriptor.getPropsType()), (String)"props", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addStatement("return $T.createElement( TYPE, props )", new Object[]{React.class});
    }

    @Nonnull
    private static MethodSpec.Builder buildFactory3Method(@Nonnull ComponentDescriptor descriptor) {
        return MethodSpec.methodBuilder((String)"_create").addAnnotation(Nonnull.class).addModifiers(new Modifier[]{Modifier.STATIC}).returns((TypeName)ClassName.get(ReactNode.class)).addParameter(ParameterSpec.builder((TypeName)ClassName.get((TypeElement)descriptor.getPropsType()), (String)"props", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addParameter(ParameterSpec.builder(ReactNode.class, (String)"child", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nullable.class).build()).addStatement("return $T.createElement( TYPE, props, child )", new Object[]{React.class});
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructorFnMethod(@Nonnull ComponentDescriptor descriptor) {
        ParameterizedTypeName constructorType = Generator.getJsConstructorFnType(descriptor);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"getConstructorFunction").addAnnotation(Nonnull.class).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PRIVATE}).returns((TypeName)constructorType);
        method.addStatement("final $T componentConstructor = $T::new", new Object[]{constructorType, ClassName.bestGuess((String)"NativeReactComponent")});
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( $T.enableComponentNames() )", new Object[]{ReactConfig.class});
        codeBlock.addStatement("$T.of( componentConstructor ).set( \"displayName\", $S )", new Object[]{JsPropertyMap.class, descriptor.getName()});
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        Map<Object, Object> childContextTypeFields = descriptor.hasChildContextFields() ? descriptor.getChildContextTypeFields() : Collections.emptyMap();
        Map<String, TypeMirror> contextTypeFields = descriptor.getContextTypeFields();
        if (!childContextTypeFields.isEmpty() || !contextTypeFields.isEmpty()) {
            method.addStatement("final $T valid = () -> null", new Object[]{PropType.class});
        }
        if (!contextTypeFields.isEmpty()) {
            method.addStatement("final $T contextTypes = $T.of()", new Object[]{JsPropertyMapOfAny.class, JsPropertyMap.class});
            for (String string : contextTypeFields.keySet()) {
                method.addStatement("contextTypes.set( $S, valid )", new Object[]{string});
            }
            method.addStatement("$T.of( componentConstructor ).set( \"contextTypes\", contextTypes )", new Object[]{JsPropertyMap.class});
        }
        if (!childContextTypeFields.isEmpty()) {
            method.addStatement("final $T childContextTypes = $T.of()", new Object[]{JsPropertyMapOfAny.class, JsPropertyMap.class});
            for (String string : childContextTypeFields.keySet()) {
                method.addStatement("childContextTypes.set( $S, valid )", new Object[]{string});
            }
            method.addStatement("$T.of( componentConstructor ).set( \"childContextTypes\", childContextTypes )", new Object[]{JsPropertyMap.class});
        }
        if (descriptor.hasDefaultPropsMethod()) {
            method.addStatement("$T.of( componentConstructor ).set( \"defaultProps\", $T.$N() )", new Object[]{JsPropertyMap.class, descriptor.getClassName(), descriptor.getDefaultPropsMethod().getSimpleName().toString()});
        }
        method.addStatement("return componentConstructor", new Object[0]);
        return method;
    }

    @Nonnull
    private static TypeSpec buildNativeComponent(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"NativeReactComponent");
        builder.addModifiers(new Modifier[]{Modifier.FINAL});
        builder.addModifiers(new Modifier[]{Modifier.STATIC});
        ParameterizedTypeName superType = ParameterizedTypeName.get((ClassName)ClassName.get(NativeAdapterComponent.class), (TypeName[])new TypeName[]{ClassName.get((TypeMirror)descriptor.getPropsType().asType()), ClassName.get((TypeMirror)descriptor.getStateType().asType()), ClassName.get((TypeMirror)descriptor.getContextType().asType()), ClassName.get((TypeElement)descriptor.getElement())});
        builder.superclass((TypeName)superType);
        if (!descriptor.getLifecycleMethods().isEmpty()) {
            builder.addSuperinterface((TypeName)ClassName.bestGuess((String)"Lifecycle"));
        }
        ParameterSpec.Builder props = ParameterSpec.builder((TypeName)ClassName.get((TypeElement)descriptor.getPropsType()), (String)"props", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class);
        ParameterSpec.Builder context = ParameterSpec.builder((TypeName)ClassName.get((TypeElement)descriptor.getContextType()), (String)"context", (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class);
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addParameter(props.build()).addParameter(context.build());
        method.addStatement("super( props, context )", new Object[0]);
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder((String)"createComponent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)ClassName.get((TypeElement)descriptor.getElement()));
        method2.addStatement("return new $T()", new Object[]{descriptor.getClassNameToConstruct()});
        builder.addMethod(method2.build());
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
            MethodSpec.Builder method3 = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(ClassName.get((TypeMirror)lifecycleMethod.getMethodType().getReturnType()));
            ProcessorUtil.copyTypeParameters(lifecycleMethod.getMethodType(), method3);
            StringJoiner params = new StringJoiner(",");
            List<? extends VariableElement> sourceParameters = lifecycleMethod.getMethod().getParameters();
            List<? extends TypeMirror> sourceParameterTypes = lifecycleMethod.getMethodType().getParameterTypes();
            int parameterCount = sourceParameters.size();
            for (int i = 0; i < parameterCount; ++i) {
                VariableElement parameter = sourceParameters.get(i);
                TypeMirror parameterType = sourceParameterTypes.get(i);
                String parameterName = parameter.getSimpleName().toString();
                ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)parameterType), (String)parameterName, (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(Nonnull.class);
                method3.addParameter(parameterSpec.build());
                params.add(parameterName);
            }
            StringBuilder sb = new StringBuilder();
            if (TypeKind.VOID != lifecycleMethod.getMethodType().getReturnType().getKind()) {
                sb.append("return ");
            }
            sb.append("perform");
            sb.append(Character.toUpperCase(methodName.charAt(0)));
            sb.append(methodName.substring(1));
            sb.append("(");
            sb.append(params.toString());
            sb.append(")");
            method3.addStatement(sb.toString(), new Object[0]);
            builder.addMethod(method3.build());
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildNativeLifecycleInterface(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)"Lifecycle");
        builder.addAnnotation(AnnotationSpec.builder(JsType.class).addMember("isNative", "true", new Object[0]).build());
        builder.addModifiers(new Modifier[]{Modifier.STATIC});
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
            MethodSpec.Builder method = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).returns(ClassName.get((TypeMirror)lifecycleMethod.getMethodType().getReturnType()));
            ProcessorUtil.copyTypeParameters(lifecycleMethod.getMethodType(), method);
            List<? extends VariableElement> sourceParameters = lifecycleMethod.getMethod().getParameters();
            List<? extends TypeMirror> sourceParameterTypes = lifecycleMethod.getMethodType().getParameterTypes();
            int parameterCount = sourceParameters.size();
            for (int i = 0; i < parameterCount; ++i) {
                VariableElement parameter = sourceParameters.get(i);
                TypeMirror parameterType = sourceParameterTypes.get(i);
                String parameterName = parameter.getSimpleName().toString();
                ParameterSpec.Builder parameterSpec = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)parameterType), (String)parameterName, (Modifier[])new Modifier[0]).addAnnotation(Nonnull.class);
                method.addParameter(parameterSpec.build());
            }
            builder.addMethod(method.build());
        }
        return builder.build();
    }
}

