/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.annotation.Documented;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;

final class ProcessorUtil {
    private static final String SENTINEL_NAME = "<default>";

    private ProcessorUtil() {
    }

    @Nonnull
    static List<ExecutableElement> getMethods(@Nonnull TypeElement element, @Nonnull Types typeUtils) {
        LinkedHashMap<String, ExecutableElement> methodMap = new LinkedHashMap<String, ExecutableElement>();
        ProcessorUtil.enumerateMethods(element, typeUtils, element, methodMap);
        return new ArrayList<ExecutableElement>(methodMap.values());
    }

    private static void enumerateMethods(@Nonnull TypeElement scope, @Nonnull Types typeUtils, @Nonnull TypeElement element, @Nonnull Map<String, ExecutableElement> methods) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            ProcessorUtil.enumerateMethods(scope, typeUtils, (TypeElement)((DeclaredType)superclass).asElement(), methods);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement interfaceElement = (TypeElement)((DeclaredType)typeMirror).asElement();
            ProcessorUtil.enumerateMethods(scope, typeUtils, interfaceElement, methods);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.METHOD) continue;
            ExecutableType methodType = (ExecutableType)typeUtils.asMemberOf((DeclaredType)scope.asType(), element2);
            methods.put(element2.getSimpleName() + methodType.toString(), (ExecutableElement)element2);
        }
    }

    @Nonnull
    static Map<String, TypeMirror> getFields(@Nonnull TypeElement element, @Nonnull Types typeUtils) {
        LinkedHashMap<String, TypeMirror> methodMap = new LinkedHashMap<String, TypeMirror>();
        ProcessorUtil.enumerateFields(element, typeUtils, element, methodMap);
        return methodMap;
    }

    private static void enumerateFields(@Nonnull TypeElement scope, @Nonnull Types typeUtils, @Nonnull TypeElement element, @Nonnull Map<String, TypeMirror> fields) {
        TypeMirror superclass = element.getSuperclass();
        if (TypeKind.NONE != superclass.getKind()) {
            ProcessorUtil.enumerateFields(scope, typeUtils, (TypeElement)((DeclaredType)superclass).asElement(), fields);
        }
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.FIELD) continue;
            TypeMirror fieldType = typeUtils.asMemberOf((DeclaredType)scope.asType(), element2);
            fields.put(element2.getSimpleName().toString(), fieldType);
        }
    }

    static void copyAccessModifiers(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
    }

    static void copyAccessModifiers(@Nonnull TypeElement element, @Nonnull MethodSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        }
    }

    static void copyAccessModifiers(@Nonnull ExecutableElement element, @Nonnull MethodSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        } else if (element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            builder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        }
    }

    static void copyDocumentedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull MethodSpec.Builder builder) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (annotationType.toString().startsWith("react4j.annotations.") || null == annotationType.asElement().getAnnotation(Documented.class)) continue;
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
    }

    static void copyDocumentedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull ParameterSpec.Builder builder) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (null == annotationMirror.getAnnotationType().asElement().getAnnotation(Documented.class)) continue;
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
    }

    static void copyTypeParameters(@Nonnull ExecutableType action, @Nonnull MethodSpec.Builder builder) {
        for (TypeVariable typeVariable : action.getTypeVariables()) {
            builder.addTypeVariable(TypeVariableName.get((TypeVariable)typeVariable));
        }
    }

    static boolean isSentinelName(@Nonnull String name) {
        return SENTINEL_NAME.equals(name);
    }

    static boolean isJavaIdentifier(@Nonnull String value) {
        if (!Character.isJavaIdentifierStart(value.charAt(0))) {
            return false;
        }
        int length = value.length();
        for (int i = 1; i < length; ++i) {
            if (Character.isJavaIdentifierPart(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    static DeclaredType getTypeMirrorAnnotationParameter(@Nonnull Element typeElement, @Nonnull String parameterName, @Nonnull Class<?> annotationType) {
        AnnotationMirror mirror = typeElement.getAnnotationMirrors().stream().filter(a -> a.getAnnotationType().toString().equals(annotationType.getName())).findFirst().orElse(null);
        assert (null != mirror);
        ExecutableElement annotationKey = mirror.getElementValues().keySet().stream().filter(k -> parameterName.equals(k.getSimpleName().toString())).findFirst().orElse(null);
        AnnotationValue annotationValue = mirror.getElementValues().get(annotationKey);
        return null == annotationValue ? null : (DeclaredType)annotationValue.getValue();
    }
}

