/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import react4j.processor.ComponentDescriptor;
import react4j.processor.ImmutablePropKeyStrategy;
import react4j.processor.vendor.proton.MemberChecks;
import react4j.processor.vendor.proton.ProcessorException;

final class PropDescriptor {
    @Nonnull
    private final ComponentDescriptor _descriptor;
    @Nonnull
    private final String _name;
    @Nonnull
    private final String _qualifier;
    @Nonnull
    private final ExecutableElement _method;
    @Nonnull
    private final ExecutableType _methodType;
    private final boolean _contextProp;
    private final boolean _shouldUpdateOnChange;
    private final boolean _observable;
    private final boolean _disposable;
    @Nullable
    private final ImmutablePropKeyStrategy _immutablePropKeyStrategy;
    @Nonnull
    private final String _requiredValue;
    private boolean _onChangePresent;
    private boolean _suppressMutablePropAccessedInPostConstruct;
    @Nullable
    private VariableElement _defaultField;
    @Nullable
    private ExecutableElement _defaultMethod;
    @Nullable
    private ExecutableElement _validateMethod;
    private boolean _optional;

    PropDescriptor(@Nonnull ComponentDescriptor descriptor, @Nonnull String name, @Nonnull String qualifier, @Nonnull ExecutableElement method, @Nonnull ExecutableType methodType, boolean contextProp, boolean shouldUpdateOnChange, boolean observable, boolean disposable, @Nullable ImmutablePropKeyStrategy immutablePropKeyStrategy, @Nonnull String requiredValue) {
        this._descriptor = Objects.requireNonNull(descriptor);
        this._name = Objects.requireNonNull(name);
        this._qualifier = Objects.requireNonNull(qualifier);
        this._method = Objects.requireNonNull(method);
        this._methodType = Objects.requireNonNull(methodType);
        this._contextProp = contextProp;
        this._shouldUpdateOnChange = shouldUpdateOnChange;
        this._observable = observable;
        this._disposable = disposable;
        this._immutablePropKeyStrategy = immutablePropKeyStrategy;
        this._requiredValue = Objects.requireNonNull(requiredValue);
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    String getQualifier() {
        return this._qualifier;
    }

    @Nonnull
    ExecutableElement getMethod() {
        return this._method;
    }

    @Nonnull
    ExecutableType getMethodType() {
        return this._methodType;
    }

    boolean shouldUpdateOnChange() {
        return this._shouldUpdateOnChange;
    }

    boolean isObservable() {
        return this._observable;
    }

    boolean isDisposable() {
        return this._disposable;
    }

    boolean isImmutable() {
        return null != this._immutablePropKeyStrategy;
    }

    @Nonnull
    String getRequiredValue() {
        return this._requiredValue;
    }

    void markAsOnChangePresent() {
        this._onChangePresent = true;
    }

    void suppressMutablePropAccessedInPostConstruct() {
        this._suppressMutablePropAccessedInPostConstruct = true;
    }

    boolean needsMutablePropAccessedInPostConstructInvariant() {
        return !this._suppressMutablePropAccessedInPostConstruct && this.mayNeedMutablePropAccessedInPostConstructInvariant();
    }

    boolean mayNeedMutablePropAccessedInPostConstructInvariant() {
        return !this.isImmutable() && !this._onChangePresent && this._descriptor.hasPostConstruct();
    }

    @Nonnull
    ImmutablePropKeyStrategy getImmutablePropKeyStrategy() {
        assert (null != this._immutablePropKeyStrategy);
        return this._immutablePropKeyStrategy;
    }

    boolean hasValidateMethod() {
        return null != this._validateMethod;
    }

    @Nonnull
    ExecutableElement getValidateMethod() {
        assert (null != this._validateMethod);
        return this._validateMethod;
    }

    void setValidateMethod(@Nonnull ExecutableElement method) {
        if (null != this._validateMethod) {
            throw new ProcessorException("@PropValidate target duplicates existing method named " + this._validateMethod.getSimpleName(), method);
        }
        this._validateMethod = Objects.requireNonNull(method);
    }

    boolean hasDefaultField() {
        return null != this._defaultField;
    }

    @Nonnull
    VariableElement getDefaultField() {
        assert (null != this._defaultField);
        return this._defaultField;
    }

    void setDefaultField(@Nonnull VariableElement field) {
        if (this.isContextProp()) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.PropDefault", "be specified for a @Prop method that specifies source=CONTEXT"), field);
        }
        if (null != this._defaultMethod) {
            throw new ProcessorException("@PropDefault target duplicates existing method named " + this._defaultMethod.getSimpleName(), field);
        }
        if (null != this._defaultField) {
            throw new ProcessorException("@PropDefault target duplicates existing field named " + this._defaultField.getSimpleName(), field);
        }
        this._defaultField = Objects.requireNonNull(field);
    }

    boolean hasDefaultMethod() {
        return null != this._defaultMethod;
    }

    @Nonnull
    ExecutableElement getDefaultMethod() {
        assert (null != this._defaultMethod);
        return this._defaultMethod;
    }

    void setDefaultMethod(@Nonnull ExecutableElement method) {
        if (this.isContextProp()) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.PropDefault", "be specified for a @Prop method that specifies source=CONTEXT"), method);
        }
        if (null != this._defaultMethod) {
            throw new ProcessorException("@PropDefault target duplicates existing method named " + this._defaultMethod.getSimpleName(), method);
        }
        assert (null == this._defaultField);
        this._defaultMethod = Objects.requireNonNull(method);
    }

    boolean isOptional() {
        return this._optional;
    }

    void markAsOptional() {
        this._optional = true;
    }

    @Nonnull
    String getConstantName() {
        return this.getName();
    }

    boolean isContextProp() {
        return this._contextProp;
    }

    boolean isSpecialChildrenProp() {
        return this.getName().equals("children") || this.getName().equals("child");
    }
}

