/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import react4j.processor.ImmutableInputKeyStrategy;
import react4j.processor.ViewDescriptor;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.MemberChecks;
import react4j.processor.vendor.proton.ProcessorException;

final class InputDescriptor {
    @Nonnull
    private final ViewDescriptor _descriptor;
    @Nonnull
    private final String _name;
    @Nonnull
    private final String _qualifier;
    @Nonnull
    private final ExecutableElement _method;
    @Nonnull
    private final ExecutableType _methodType;
    private final boolean _contextSource;
    private final boolean _shouldUpdateOnChange;
    private final boolean _observable;
    private final boolean _disposable;
    @Nullable
    private final ImmutableInputKeyStrategy _immutableInputKeyStrategy;
    @Nonnull
    private final String _requiredValue;
    private boolean _onChangePresent;
    private boolean _suppressMutableInputAccessedInPostConstruct;
    @Nullable
    private VariableElement _defaultField;
    @Nullable
    private ExecutableElement _defaultMethod;
    @Nullable
    private ExecutableElement _validateMethod;
    private boolean _optional;
    @Nullable
    private Boolean _isNonNull;

    InputDescriptor(@Nonnull ViewDescriptor descriptor, @Nonnull String name, @Nonnull String qualifier, @Nonnull ExecutableElement method, @Nonnull ExecutableType methodType, boolean contextSource, boolean shouldUpdateOnChange, boolean observable, boolean disposable, @Nullable ImmutableInputKeyStrategy immutableInputKeyStrategy, @Nonnull String requiredValue) {
        this._descriptor = Objects.requireNonNull(descriptor);
        this._name = Objects.requireNonNull(name);
        this._qualifier = Objects.requireNonNull(qualifier);
        this._method = Objects.requireNonNull(method);
        this._methodType = Objects.requireNonNull(methodType);
        this._contextSource = contextSource;
        this._shouldUpdateOnChange = shouldUpdateOnChange;
        this._observable = observable;
        this._disposable = disposable;
        this._immutableInputKeyStrategy = immutableInputKeyStrategy;
        this._requiredValue = Objects.requireNonNull(requiredValue);
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    String getQualifier() {
        return this._qualifier;
    }

    @Nonnull
    ExecutableElement getMethod() {
        return this._method;
    }

    @Nonnull
    ExecutableType getMethodType() {
        return this._methodType;
    }

    boolean shouldUpdateOnChange() {
        return this._shouldUpdateOnChange;
    }

    boolean isObservable() {
        return this._observable;
    }

    boolean isDisposable() {
        return this._disposable;
    }

    boolean isImmutable() {
        return null != this._immutableInputKeyStrategy;
    }

    @Nonnull
    String getRequiredValue() {
        return this._requiredValue;
    }

    void markAsOnChangePresent() {
        this._onChangePresent = true;
    }

    void suppressMutableInputAccessedInPostConstruct() {
        this._suppressMutableInputAccessedInPostConstruct = true;
    }

    boolean needsMutableInputAccessedInPostConstructInvariant() {
        return !this._suppressMutableInputAccessedInPostConstruct && this.mayNeedMutableInputAccessedInPostConstructInvariant();
    }

    boolean mayNeedMutableInputAccessedInPostConstructInvariant() {
        return !this.isImmutable() && !this._onChangePresent && this._descriptor.hasPostConstruct();
    }

    @Nonnull
    ImmutableInputKeyStrategy getImmutableInputKeyStrategy() {
        assert (null != this._immutableInputKeyStrategy);
        return this._immutableInputKeyStrategy;
    }

    boolean hasValidateMethod() {
        return null != this._validateMethod;
    }

    @Nonnull
    ExecutableElement getValidateMethod() {
        assert (null != this._validateMethod);
        return this._validateMethod;
    }

    void setValidateMethod(@Nonnull ExecutableElement method) {
        if (null != this._validateMethod) {
            throw new ProcessorException(MemberChecks.toSimpleName("react4j.annotations.InputValidate") + " target duplicates existing method named " + this._validateMethod.getSimpleName(), method);
        }
        this._validateMethod = Objects.requireNonNull(method);
    }

    boolean hasDefaultField() {
        return null != this._defaultField;
    }

    @Nonnull
    VariableElement getDefaultField() {
        assert (null != this._defaultField);
        return this._defaultField;
    }

    void setDefaultField(@Nonnull VariableElement field) {
        if (this.isContextSource()) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.InputDefault", "be specified for a @Input method that specifies source=CONTEXT"), field);
        }
        if (null != this._defaultMethod) {
            throw new ProcessorException("@InputDefault target duplicates existing method named " + this._defaultMethod.getSimpleName(), field);
        }
        if (null != this._defaultField) {
            throw new ProcessorException("@InputDefault target duplicates existing field named " + this._defaultField.getSimpleName(), field);
        }
        this._defaultField = Objects.requireNonNull(field);
    }

    boolean hasDefaultMethod() {
        return null != this._defaultMethod;
    }

    @Nonnull
    ExecutableElement getDefaultMethod() {
        assert (null != this._defaultMethod);
        return this._defaultMethod;
    }

    void setDefaultMethod(@Nonnull ExecutableElement method) {
        if (this.isContextSource()) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.InputDefault", "be specified for a @Input method that specifies source=CONTEXT"), method);
        }
        if (null != this._defaultMethod) {
            throw new ProcessorException("@InputDefault target duplicates existing method named " + this._defaultMethod.getSimpleName(), method);
        }
        assert (null == this._defaultField);
        this._defaultMethod = Objects.requireNonNull(method);
    }

    boolean isOptional() {
        return this._optional;
    }

    boolean isRequired() {
        return !this.isOptional();
    }

    boolean isNonNull() {
        if (null == this._isNonNull) {
            this._isNonNull = AnnotationsUtil.hasNonnullAnnotation(this.getMethod());
        }
        return this._isNonNull;
    }

    void markAsOptional() {
        this._optional = true;
    }

    @Nonnull
    String getConstantName() {
        return this.getName();
    }

    boolean isContextSource() {
        return this._contextSource;
    }

    boolean isSpecialChildrenInput() {
        return this.getName().equals("children") || this.getName().equals("child");
    }
}

