/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import react4j.processor.BuilderGenerator;
import react4j.processor.FactoryGenerator;
import react4j.processor.ImmutableInputKeyStrategy;
import react4j.processor.InputDescriptor;
import react4j.processor.OnInputChangeDescriptor;
import react4j.processor.PublishDescriptor;
import react4j.processor.ScheduleRenderDescriptor;
import react4j.processor.ViewDescriptor;
import react4j.processor.ViewGenerator;
import react4j.processor.ViewType;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.proton.AbstractStandardProcessor;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.DeferredElementSet;
import react4j.processor.vendor.proton.ElementsUtil;
import react4j.processor.vendor.proton.MemberChecks;
import react4j.processor.vendor.proton.ProcessorException;

@SupportedAnnotationTypes(value={"react4j.annotations.View"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"react4j.defer.unresolved", "react4j.defer.errors", "react4j.debug"})
public final class React4jProcessor
extends AbstractStandardProcessor {
    private static final String SENTINEL_NAME = "<default>";
    private static final Pattern DEFAULT_GETTER_PATTERN = Pattern.compile("^get([A-Z].*)Default$");
    private static final Pattern VALIDATE_INPUT_PATTERN = Pattern.compile("^validate([A-Z].*)$");
    private static final Pattern LAST_INPUT_PATTERN = Pattern.compile("^last([A-Z].*)$");
    private static final Pattern PREV_INPUT_PATTERN = Pattern.compile("^prev([A-Z].*)$");
    private static final Pattern INPUT_PATTERN = Pattern.compile("^([a-z].*)$");
    private static final Pattern GETTER_PATTERN = Pattern.compile("^get([A-Z].*)$");
    private static final Pattern ISSER_PATTERN = Pattern.compile("^is([A-Z].*)$");
    @Nonnull
    private final DeferredElementSet _deferredTypes = new DeferredElementSet();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.processTypeElements(annotations, env, "react4j.annotations.View", this._deferredTypes, this::process);
        this.errorIfProcessingOverAndInvalidTypesDetected(env);
        return true;
    }

    @Override
    @Nonnull
    protected String getIssueTrackerURL() {
        return "https://github.com/react4j/react4j/issues";
    }

    @Override
    @Nonnull
    protected String getOptionPrefix() {
        return "react4j";
    }

    private void process(@Nonnull TypeElement element) throws IOException, ProcessorException {
        ViewDescriptor descriptor = this.parse(element);
        String packageName = descriptor.getPackageName();
        this.emitTypeSpec(packageName, ViewGenerator.buildType(this.processingEnv, descriptor));
        this.emitTypeSpec(packageName, BuilderGenerator.buildType(this.processingEnv, descriptor));
        if (descriptor.needsInjection()) {
            this.emitTypeSpec(packageName, FactoryGenerator.buildType(this.processingEnv, descriptor));
        }
    }

    private boolean hasPostConstruct(@Nonnull TypeElement typeElement) {
        return this.getMethods(typeElement).stream().anyMatch(e -> AnnotationsUtil.hasAnnotationOfType(e, "arez.annotations.PostConstruct"));
    }

    @Nonnull
    private ViewDescriptor parse(@Nonnull TypeElement typeElement) {
        boolean hasNamedAnnotation;
        String name = this.deriveViewName(typeElement);
        ViewType type = this.extractViewType(typeElement);
        boolean hasPostConstruct = this.hasPostConstruct(typeElement);
        boolean shouldSetDefaultPriority = this.shouldSetDefaultPriority(typeElement);
        boolean requireRender = (Boolean)AnnotationsUtil.getAnnotationValue(typeElement, "react4j.annotations.View", "requireRender").getValue();
        MemberChecks.mustNotBeFinal("react4j.annotations.View", typeElement);
        MemberChecks.mustBeAbstract("react4j.annotations.View", typeElement);
        if (ElementKind.CLASS != typeElement.getKind()) {
            throw new ProcessorException(MemberChecks.must("react4j.annotations.View", "be a class"), typeElement);
        }
        if (ElementsUtil.isNonStaticNestedClass(typeElement)) {
            throw new ProcessorException(MemberChecks.toSimpleName("react4j.annotations.View") + " target must not be a non-static nested class", typeElement);
        }
        List<ExecutableElement> constructors = ElementsUtil.getConstructors(typeElement);
        if (1 != constructors.size() || !this.isConstructorValid(constructors.get(0))) {
            throw new ProcessorException(MemberChecks.must("react4j.annotations.View", "have a single, package-access constructor or the default constructor"), typeElement);
        }
        ExecutableElement constructor = constructors.get(0);
        boolean inject = this.deriveInject(typeElement, constructor);
        boolean sting = this.deriveSting(typeElement, constructor);
        boolean notSyntheticConstructor = ElementsUtil.isNotSynthetic(constructor);
        List<? extends VariableElement> parameters = constructor.getParameters();
        if (inject) {
            if (parameters.isEmpty()) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.View", "have specified inject=ENABLED if the constructor has no parameters"), typeElement);
            }
        } else {
            hasNamedAnnotation = parameters.stream().anyMatch(p -> AnnotationsUtil.hasAnnotationOfType(p, "javax.inject.Named"));
            if (hasNamedAnnotation) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.View", "have specified inject=DISABLED and have a constructor parameter annotated with the javax.inject.Named annotation"), constructor);
            }
        }
        if (sting) {
            if (parameters.isEmpty()) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.View", "have specified sting=ENABLED if the constructor has no parameters"), typeElement);
            }
        } else {
            hasNamedAnnotation = parameters.stream().anyMatch(p -> AnnotationsUtil.hasAnnotationOfType(p, "sting.Named"));
            if (hasNamedAnnotation) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.View", "have specified sting=DISABLED and have a constructor parameter annotated with the sting.Named annotation"), constructor);
            }
        }
        ViewDescriptor descriptor = new ViewDescriptor(name, typeElement, constructor, type, inject, sting, notSyntheticConstructor, hasPostConstruct, shouldSetDefaultPriority, requireRender);
        for (Element element : descriptor.getElement().getEnclosedElements()) {
            String message;
            if (ElementKind.METHOD != element.getKind()) continue;
            ExecutableElement method = (ExecutableElement)element;
            if (method.getModifiers().contains((Object)Modifier.PUBLIC) && MemberChecks.doesMethodNotOverrideInterfaceMethod(this.processingEnv, typeElement, method) && ElementsUtil.isWarningNotSuppressed(method, "React4j:PublicMethod", "react4j.annotations.SuppressReact4jWarnings")) {
                message = MemberChecks.shouldNot("react4j.annotations.View", "declare a public method. " + MemberChecks.suppressedBy("React4j:PublicMethod", "react4j.annotations.SuppressReact4jWarnings"));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, method);
            }
            if (method.getModifiers().contains((Object)Modifier.FINAL) && ElementsUtil.isWarningNotSuppressed(method, "React4j:FinalMethod", "react4j.annotations.SuppressReact4jWarnings")) {
                message = MemberChecks.shouldNot("react4j.annotations.View", "declare a final method. " + MemberChecks.suppressedBy("React4j:FinalMethod", "react4j.annotations.SuppressReact4jWarnings"));
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, method);
            }
            if (!method.getModifiers().contains((Object)Modifier.PROTECTED) || !ElementsUtil.isWarningNotSuppressed(method, "React4j:ProtectedMethod", "react4j.annotations.SuppressReact4jWarnings") || this.isMethodAProtectedOverride(typeElement, method)) continue;
            message = MemberChecks.shouldNot("react4j.annotations.View", "declare a protected method. " + MemberChecks.suppressedBy("React4j:ProtectedMethod", "react4j.annotations.SuppressReact4jWarnings"));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message, method);
        }
        this.determineViewCapabilities(descriptor, typeElement);
        this.determineInputs(descriptor);
        this.determineInputValidatesMethods(descriptor);
        this.determineOnInputChangeMethods(descriptor);
        this.determineDefaultInputsMethods(descriptor);
        this.determineDefaultInputsFields(descriptor);
        this.determinePreUpdateMethod(typeElement, descriptor);
        this.determinePostMountOrUpdateMethod(typeElement, descriptor);
        this.determinePostUpdateMethod(typeElement, descriptor);
        this.determinePostMountMethod(typeElement, descriptor);
        this.determineOnErrorMethod(typeElement, descriptor);
        this.determineScheduleRenderMethods(typeElement, descriptor);
        this.determinePublishMethods(typeElement, descriptor);
        this.determineRenderMethod(typeElement, descriptor);
        for (InputDescriptor inputDescriptor : descriptor.getInputs()) {
            if (!this.isInputRequired(inputDescriptor)) {
                inputDescriptor.markAsOptional();
                continue;
            }
            if (!inputDescriptor.isContextSource()) continue;
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.Input", "specify require=ENABLE parameter when the for source=CONTEXT parameter is specified"), inputDescriptor.getMethod());
        }
        descriptor.sortInputs();
        this.verifyInputsNotAnnotatedWithArezAnnotations(descriptor);
        this.verifyInputsNotCollectionOfArezComponents(descriptor);
        return descriptor;
    }

    private boolean isMethodAProtectedOverride(@Nonnull TypeElement typeElement, @Nonnull ExecutableElement method) {
        ExecutableElement overriddenMethod = ElementsUtil.getOverriddenMethod(this.processingEnv, typeElement, method);
        return null != overriddenMethod && overriddenMethod.getModifiers().contains((Object)Modifier.PROTECTED);
    }

    private boolean deriveInject(@Nonnull TypeElement typeElement, @Nonnull ExecutableElement constructor) {
        String inject = AnnotationsUtil.getEnumAnnotationParameter(typeElement, "react4j.annotations.View", "inject");
        if ("ENABLE".equals(inject)) {
            return true;
        }
        if ("DISABLE".equals(inject)) {
            return false;
        }
        return !constructor.getParameters().isEmpty() && null != this.processingEnv.getElementUtils().getTypeElement("javax.inject.Inject");
    }

    private boolean deriveSting(@Nonnull TypeElement typeElement, @Nonnull ExecutableElement constructor) {
        String inject = AnnotationsUtil.getEnumAnnotationParameter(typeElement, "react4j.annotations.View", "sting");
        if ("ENABLE".equals(inject)) {
            return true;
        }
        if ("DISABLE".equals(inject)) {
            return false;
        }
        return !constructor.getParameters().isEmpty() && null != this.processingEnv.getElementUtils().getTypeElement("sting.Injectable");
    }

    private boolean isConstructorValid(@Nonnull ExecutableElement ctor) {
        if (ElementsUtil.isSynthetic(ctor)) {
            return true;
        }
        Set<Modifier> modifiers = ctor.getModifiers();
        return !modifiers.contains((Object)Modifier.PRIVATE) && !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED);
    }

    private void verifyInputsNotCollectionOfArezComponents(@Nonnull ViewDescriptor descriptor) {
        for (InputDescriptor input : descriptor.getInputs()) {
            ArrayType arrayType;
            ExecutableElement method = input.getMethod();
            TypeMirror returnType = method.getReturnType();
            if (TypeKind.DECLARED == returnType.getKind()) {
                DeclaredType declaredType = (DeclaredType)returnType;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                if (!(this.isCollection(declaredType) ? 1 == typeArguments.size() && this.isArezComponent(typeArguments.get(0)) : this.isMap(declaredType) && 2 == typeArguments.size() && (this.isArezComponent(typeArguments.get(0)) || this.isArezComponent(typeArguments.get(1))))) continue;
                throw new ProcessorException("@Input target is a collection that contains Arez components. This is not a safe pattern when the arez components can be disposed.", method);
            }
            if (TypeKind.ARRAY != returnType.getKind() || !this.isArezComponent((arrayType = (ArrayType)returnType).getComponentType())) continue;
            throw new ProcessorException("@Input target is an array that contains Arez components. This is not a safe pattern when the arez components can be disposed.", method);
        }
    }

    private boolean isCollection(@Nonnull DeclaredType declaredType) {
        TypeElement returnType = (TypeElement)this.processingEnv.getTypeUtils().asElement(declaredType);
        String classname = returnType.getQualifiedName().toString();
        return Collection.class.getName().equals(classname) || Set.class.getName().equals(classname) || List.class.getName().equals(classname) || HashSet.class.getName().equals(classname) || ArrayList.class.getName().equals(classname);
    }

    private boolean isMap(@Nonnull DeclaredType declaredType) {
        TypeElement returnType = (TypeElement)this.processingEnv.getTypeUtils().asElement(declaredType);
        String classname = returnType.getQualifiedName().toString();
        return Map.class.getName().equals(classname) || HashMap.class.getName().equals(classname);
    }

    private boolean isArezComponent(@Nonnull TypeMirror typeMirror) {
        return typeMirror instanceof DeclaredType && this.processingEnv.getTypeUtils().asElement(typeMirror).getAnnotationMirrors().stream().anyMatch(a -> a.getAnnotationType().toString().equals("arez.annotations.ArezComponent"));
    }

    private void verifyInputsNotAnnotatedWithArezAnnotations(@Nonnull ViewDescriptor descriptor) {
        for (InputDescriptor input : descriptor.getInputs()) {
            ExecutableElement method = input.getMethod();
            for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                String classname = annotationMirror.getAnnotationType().toString();
                if (!classname.startsWith("arez.annotations.")) continue;
                throw new ProcessorException("@Input target must not be annotated with any arez annotations but is annotated by '" + classname + "'.", method);
            }
        }
    }

    private void determineOnInputChangeMethods(@Nonnull ViewDescriptor descriptor) {
        List methods = this.getMethods(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.OnInputChange")).collect(Collectors.toList());
        ArrayList<OnInputChangeDescriptor> onInputChangeDescriptors = new ArrayList<OnInputChangeDescriptor>();
        for (ExecutableElement method : methods) {
            VariableElement phase = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.OnInputChange", "phase").getValue();
            boolean preUpdate = phase.getSimpleName().toString().equals("PRE");
            List<? extends VariableElement> parameters = method.getParameters();
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
            MemberChecks.mustBeSubclassCallable(descriptor.getElement(), "react4j.annotations.View", "react4j.annotations.OnInputChange", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.OnInputChange", method);
            MemberChecks.mustNotReturnAnyValue("react4j.annotations.OnInputChange", method);
            int parameterCount = parameters.size();
            if (0 == parameterCount) {
                throw new ProcessorException("@OnInputChange target must have at least 1 parameter.", method);
            }
            ArrayList<InputDescriptor> inputDescriptors = new ArrayList<InputDescriptor>(parameterCount);
            for (int i = 0; i < parameterCount; ++i) {
                boolean mismatchedNullability;
                VariableElement parameter = parameters.get(i);
                String name = this.deriveOnInputChangeName(parameter);
                InputDescriptor input = descriptor.findInputNamed(name);
                if (null == input) {
                    throw new ProcessorException("@OnInputChange target has a parameter named '" + parameter.getSimpleName() + "' and the parameter is associated with a @Input named '" + name + "' but there is no corresponding @Input annotated method.", parameter);
                }
                Types typeUtils = this.processingEnv.getTypeUtils();
                if (!typeUtils.isAssignable(parameterTypes.get(i), input.getMethodType().getReturnType())) {
                    throw new ProcessorException("@OnInputChange target has a parameter named '" + parameter.getSimpleName() + "' and the parameter type is not assignable to the return type of the associated @Input annotated method.", method);
                }
                boolean bl = mismatchedNullability = AnnotationsUtil.hasNonnullAnnotation(parameter) && AnnotationsUtil.hasNullableAnnotation(input.getMethod()) || AnnotationsUtil.hasNullableAnnotation(parameter) && input.isNonNull();
                if (mismatchedNullability) {
                    throw new ProcessorException("@OnInputChange target has a parameter named '" + parameter.getSimpleName() + "' that has a nullability annotation incompatible with the associated @Input method named " + method.getSimpleName(), method);
                }
                if (input.isImmutable()) {
                    throw new ProcessorException("@OnInputChange target has a parameter named '" + parameter.getSimpleName() + "' that is associated with a @Input annotated method and the input is specified as immutable.", method);
                }
                inputDescriptors.add(input);
            }
            onInputChangeDescriptors.add(new OnInputChangeDescriptor(method, inputDescriptors, preUpdate));
        }
        descriptor.setOnInputChangeDescriptors(onInputChangeDescriptors);
    }

    @Nonnull
    private String deriveOnInputChangeName(@Nonnull VariableElement parameter) {
        AnnotationValue value = AnnotationsUtil.findAnnotationValue(parameter, "react4j.annotations.InputRef", "value");
        if (null != value) {
            return (String)value.getValue();
        }
        String parameterName = parameter.getSimpleName().toString();
        if (LAST_INPUT_PATTERN.matcher(parameterName).matches() || PREV_INPUT_PATTERN.matcher(parameterName).matches()) {
            return Character.toLowerCase(parameterName.charAt(4)) + parameterName.substring(5);
        }
        if (INPUT_PATTERN.matcher(parameterName).matches()) {
            return parameterName;
        }
        throw new ProcessorException("@OnInputChange target has a parameter named '" + parameterName + "' is not explicitly associated with a input using @InputRef nor does it follow required naming conventions 'prev[MyInput]', 'last[MyInput]' or '[myInput]'.", parameter);
    }

    private void determineInputValidatesMethods(@Nonnull ViewDescriptor descriptor) {
        List methods = this.getMethods(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.InputValidate")).collect(Collectors.toList());
        for (ExecutableElement method : methods) {
            boolean mismatchedNullability;
            String name = this.deriveInputValidateName(method);
            InputDescriptor input = descriptor.findInputNamed(name);
            if (null == input) {
                throw new ProcessorException("@InputValidate target for input named '" + name + "' has no corresponding @Input annotated method.", method);
            }
            if (1 != method.getParameters().size()) {
                throw new ProcessorException("@InputValidate target must have exactly 1 parameter", method);
            }
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            if (!this.processingEnv.getTypeUtils().isAssignable(methodType.getParameterTypes().get(0), input.getMethodType().getReturnType())) {
                throw new ProcessorException("@InputValidate target has a parameter type that is not assignable to the return type of the associated @Input annotated method.", method);
            }
            MemberChecks.mustBeSubclassCallable(descriptor.getElement(), "react4j.annotations.View", "react4j.annotations.InputValidate", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.InputValidate", method);
            MemberChecks.mustNotReturnAnyValue("react4j.annotations.InputValidate", method);
            VariableElement param = method.getParameters().get(0);
            boolean bl = mismatchedNullability = AnnotationsUtil.hasNonnullAnnotation(param) && AnnotationsUtil.hasNullableAnnotation(input.getMethod()) || AnnotationsUtil.hasNullableAnnotation(param) && input.isNonNull();
            if (mismatchedNullability) {
                throw new ProcessorException("@InputValidate target has a parameter that has a nullability annotation incompatible with the associated @Input method named " + input.getMethod().getSimpleName(), method);
            }
            input.setValidateMethod(method);
        }
    }

    @Nonnull
    private String deriveInputValidateName(@Nonnull Element element) throws ProcessorException {
        String name = (String)AnnotationsUtil.getAnnotationValue(element, "react4j.annotations.InputValidate", "name").getValue();
        if (this.isSentinelName(name)) {
            String deriveName = this.deriveName(element, VALIDATE_INPUT_PATTERN, name);
            if (null == deriveName) {
                throw new ProcessorException("@InputValidate target has not specified name nor is it named according to the convention 'validate[Name]Input'.", element);
            }
            return deriveName;
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ProcessorException("@InputValidate target specified an invalid name '" + name + "'. The name must be a valid java identifier.", element);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ProcessorException("@InputValidate target specified an invalid name '" + name + "'. The name must not be a java keyword.", element);
        }
        return name;
    }

    private void determineDefaultInputsMethods(@Nonnull ViewDescriptor descriptor) {
        List defaultInputsMethods = this.getMethods(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.InputDefault")).collect(Collectors.toList());
        for (ExecutableElement method : defaultInputsMethods) {
            String name = this.deriveInputDefaultName(method);
            InputDescriptor input = descriptor.findInputNamed(name);
            if (null == input) {
                throw new ProcessorException("@InputDefault target for input named '" + name + "' has no corresponding @Input annotated method.", method);
            }
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            if (!this.processingEnv.getTypeUtils().isAssignable(methodType.getReturnType(), input.getMethodType().getReturnType())) {
                throw new ProcessorException("@InputDefault target has a return type that is not assignable to the return type of the associated @Input annotated method.", method);
            }
            MemberChecks.mustBeStaticallySubclassCallable(descriptor.getElement(), "react4j.annotations.View", "react4j.annotations.InputDefault", method);
            MemberChecks.mustNotHaveAnyParameters("react4j.annotations.InputDefault", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.InputDefault", method);
            MemberChecks.mustReturnAValue("react4j.annotations.InputDefault", method);
            input.setDefaultMethod(method);
        }
    }

    private void determineDefaultInputsFields(@Nonnull ViewDescriptor descriptor) {
        List defaultInputsFields = ElementsUtil.getFields(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.InputDefault")).collect(Collectors.toList());
        for (VariableElement field : defaultInputsFields) {
            String name = this.deriveInputDefaultName(field);
            InputDescriptor input = descriptor.findInputNamed(name);
            if (null == input) {
                throw new ProcessorException("@InputDefault target for input named '" + name + "' has no corresponding @Input annotated method.", field);
            }
            if (!this.processingEnv.getTypeUtils().isAssignable(field.asType(), input.getMethodType().getReturnType())) {
                throw new ProcessorException("@InputDefault target has a type that is not assignable to the return type of the associated @Input annotated method.", field);
            }
            MemberChecks.mustBeStaticallySubclassCallable(descriptor.getElement(), "react4j.annotations.View", "react4j.annotations.InputDefault", field);
            MemberChecks.mustBeFinal("react4j.annotations.InputDefault", field);
            input.setDefaultField(field);
        }
    }

    @Nonnull
    private String deriveInputDefaultName(@Nonnull Element element) throws ProcessorException {
        String name = (String)AnnotationsUtil.getAnnotationValue(element, "react4j.annotations.InputDefault", "name").getValue();
        if (this.isSentinelName(name)) {
            if (element instanceof ExecutableElement) {
                String deriveName = this.deriveName(element, DEFAULT_GETTER_PATTERN, name);
                if (null == deriveName) {
                    throw new ProcessorException("@InputDefault target has not specified name nor is it named according to the convention 'get[Name]Default'.", element);
                }
                return deriveName;
            }
            String fieldName = element.getSimpleName().toString();
            boolean matched = true;
            int lengthPrefix = "DEFAULT_".length();
            int length = fieldName.length();
            if (fieldName.startsWith("DEFAULT_") && length > lengthPrefix) {
                for (int i = lengthPrefix; i < length; ++i) {
                    char ch = fieldName.charAt(i);
                    if (!Character.isLowerCase(ch) && (i == lengthPrefix && Character.isJavaIdentifierStart(ch) || i != lengthPrefix && Character.isJavaIdentifierPart(ch))) continue;
                    matched = false;
                    break;
                }
            } else {
                matched = false;
            }
            if (matched) {
                return this.uppercaseConstantToPascalCase(fieldName.substring(lengthPrefix));
            }
            throw new ProcessorException("@InputDefault target has not specified name nor is it named according to the convention 'DEFAULT_[NAME]'.", element);
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ProcessorException("@InputDefault target specified an invalid name '" + name + "'. The name must be a valid java identifier.", element);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ProcessorException("@InputDefault target specified an invalid name '" + name + "'. The name must not be a java keyword.", element);
        }
        return name;
    }

    @Nonnull
    private String uppercaseConstantToPascalCase(@Nonnull String candidate) {
        String s = candidate.toLowerCase();
        StringBuilder sb = new StringBuilder();
        boolean uppercase = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if ('_' == ch) {
                uppercase = true;
                continue;
            }
            if (uppercase) {
                sb.append(Character.toUpperCase(ch));
                uppercase = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private void determineInputs(@Nonnull ViewDescriptor descriptor) {
        List<InputDescriptor> inputs = this.getMethods(descriptor.getElement()).stream().filter(m -> AnnotationsUtil.hasAnnotationOfType(m, "react4j.annotations.Input")).map(m -> this.createInputDescriptor(descriptor, (ExecutableElement)m)).collect(Collectors.toList());
        InputDescriptor childrenInput = inputs.stream().filter(p -> p.getName().equals("children")).findAny().orElse(null);
        InputDescriptor childInput = inputs.stream().filter(p -> p.getName().equals("child")).findAny().orElse(null);
        if (null != childrenInput && null != childInput) {
            throw new ProcessorException("Multiple candidate children @Input annotated methods: " + childrenInput.getMethod().getSimpleName() + " and " + childInput.getMethod().getSimpleName(), childrenInput.getMethod());
        }
        descriptor.setInputs(inputs);
    }

    private boolean isInputRequired(@Nonnull InputDescriptor input) {
        String requiredValue = input.getRequiredValue();
        if ("ENABLE".equals(requiredValue)) {
            return true;
        }
        if ("DISABLE".equals(requiredValue)) {
            return false;
        }
        if (input.isContextSource()) {
            return false;
        }
        return !input.hasDefaultMethod() && !input.hasDefaultField() && !AnnotationsUtil.hasNullableAnnotation(input.getMethod());
    }

    @Nonnull
    private InputDescriptor createInputDescriptor(@Nonnull ViewDescriptor descriptor, @Nonnull ExecutableElement method) {
        ImmutableInputKeyStrategy strategy;
        String name = this.deriveInputName(method);
        ExecutableType methodType = this.resolveMethodType(descriptor, method);
        this.verifyNoDuplicateAnnotations(method);
        MemberChecks.mustBeAbstract("react4j.annotations.Input", method);
        MemberChecks.mustNotHaveAnyParameters("react4j.annotations.Input", method);
        MemberChecks.mustReturnAValue("react4j.annotations.Input", method);
        MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.Input", method);
        MemberChecks.mustNotBePackageAccessInDifferentPackage(descriptor.getElement(), "react4j.annotations.View", "react4j.annotations.Input", method);
        TypeMirror returnType = method.getReturnType();
        if ("build".equals(name)) {
            throw new ProcessorException("@Input named 'build' is invalid as it conflicts with the method named build() that is used in the generated Builder classes", method);
        }
        if ("child".equals(name) && returnType.getKind() != TypeKind.DECLARED && !"react4j.ReactNode".equals(returnType.toString())) {
            throw new ProcessorException("@Input named 'child' should be of type react4j.ReactNode", method);
        }
        if ("children".equals(name) && returnType.getKind() != TypeKind.DECLARED && !"react4j.ReactNode[]".equals(returnType.toString())) {
            throw new ProcessorException("@Input named 'children' should be of type react4j.ReactNode[]", method);
        }
        if (returnType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)returnType;
            String typeVariableName = typeVariable.asElement().getSimpleName().toString();
            List<? extends TypeParameterElement> typeParameters = method.getTypeParameters();
            if (typeParameters.stream().anyMatch(p -> p.getSimpleName().toString().equals(typeVariableName))) {
                throw new ProcessorException("@Input named '" + name + "' is has a type variable as a return type that is declared on the method.", method);
            }
        }
        String qualifier = (String)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Input", "qualifier").getValue();
        boolean contextInput = this.isContextInput(method);
        Element inputType = this.processingEnv.getTypeUtils().asElement(returnType);
        boolean immutable = this.isInputImmutable(method);
        boolean shouldUpdateOnChange = this.shouldUpdateOnChange(method, immutable);
        boolean observable = this.isInputObservable(descriptor, method, shouldUpdateOnChange, immutable);
        boolean disposable = null != inputType && this.isInputDisposable(method, inputType);
        TypeName typeName = TypeName.get(returnType);
        if (typeName.isBoxedPrimitive() && AnnotationsUtil.hasNonnullAnnotation(method)) {
            throw new ProcessorException("@Input named '" + name + "' is a boxed primitive annotated with a @Nonnull annotation. The return type should be the primitive type.", method);
        }
        ImmutableInputKeyStrategy immutableInputKeyStrategy = strategy = immutable ? this.getImmutableInputKeyStrategy(typeName, inputType) : null;
        if (!"".equals(qualifier) && !contextInput) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.Input", "specify qualifier parameter unless source=CONTEXT is also specified"), method);
        }
        String requiredValue = ((VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Input", "require").getValue()).getSimpleName().toString();
        InputDescriptor inputDescriptor = new InputDescriptor(descriptor, name, qualifier, method, methodType, contextInput, shouldUpdateOnChange, observable, disposable, strategy, requiredValue);
        if (inputDescriptor.mayNeedMutableInputAccessedInPostConstructInvariant() && ElementsUtil.isWarningSuppressed(method, "React4j:MutableInputAccessedInPostConstruct", "react4j.annotations.SuppressReact4jWarnings")) {
            inputDescriptor.suppressMutableInputAccessedInPostConstruct();
        }
        return inputDescriptor;
    }

    @Nonnull
    private ImmutableInputKeyStrategy getImmutableInputKeyStrategy(@Nonnull TypeName typeName, @Nullable Element element) {
        if (typeName.toString().equals("java.lang.String")) {
            return ImmutableInputKeyStrategy.IS_STRING;
        }
        if (typeName.isBoxedPrimitive() || typeName.isPrimitive()) {
            return ImmutableInputKeyStrategy.TO_STRING;
        }
        if (null != element) {
            if ((ElementKind.CLASS == element.getKind() || ElementKind.INTERFACE == element.getKind()) && this.isAssignableToKeyed(element)) {
                return ImmutableInputKeyStrategy.KEYED;
            }
            if ((ElementKind.CLASS == element.getKind() || ElementKind.INTERFACE == element.getKind()) && (this.isAssignableToIdentifiable(element) || AnnotationsUtil.hasAnnotationOfType(element, "arez.annotations.ActAsComponent") || AnnotationsUtil.hasAnnotationOfType(element, "arez.annotations.ArezComponent") && this.isIdRequired((TypeElement)element))) {
                return ImmutableInputKeyStrategy.AREZ_IDENTIFIABLE;
            }
            if (ElementKind.ENUM == element.getKind()) {
                return ImmutableInputKeyStrategy.ENUM;
            }
        }
        return ImmutableInputKeyStrategy.DYNAMIC;
    }

    private boolean isAssignableToKeyed(@Nonnull Element element) {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement("react4j.Keyed");
        return this.processingEnv.getTypeUtils().isAssignable(element.asType(), typeElement.asType());
    }

    private boolean isAssignableToIdentifiable(@Nonnull Element element) {
        TypeElement typeElement = this.processingEnv.getElementUtils().getTypeElement("arez.component.Identifiable");
        TypeMirror identifiableErasure = this.processingEnv.getTypeUtils().erasure(typeElement.asType());
        return this.processingEnv.getTypeUtils().isAssignable(element.asType(), identifiableErasure);
    }

    private boolean isIdRequired(@Nonnull TypeElement element) {
        VariableElement requireIdParameter = (VariableElement)AnnotationsUtil.getAnnotationValue(element, "arez.annotations.ArezComponent", "requireId").getValue();
        return !"DISABLE".equals(requireIdParameter.getSimpleName().toString());
    }

    @Nonnull
    private String deriveInputName(@Nonnull ExecutableElement method) throws ProcessorException {
        String specifiedName = (String)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Input", "name").getValue();
        String name = this.getPropertyAccessorName(method, specifiedName);
        if (!SourceVersion.isIdentifier(name)) {
            throw new ProcessorException("@Input target specified an invalid name '" + specifiedName + "'. The name must be a valid java identifier.", method);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ProcessorException("@Input target specified an invalid name '" + specifiedName + "'. The name must not be a java keyword.", method);
        }
        return name;
    }

    private void determineOnErrorMethod(@Nonnull TypeElement typeElement, @Nonnull ViewDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.OnError")) continue;
            MemberChecks.mustNotBeAbstract("react4j.annotations.OnError", method);
            MemberChecks.mustBeSubclassCallable(typeElement, "react4j.annotations.View", "react4j.annotations.OnError", method);
            MemberChecks.mustNotReturnAnyValue("react4j.annotations.OnError", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.OnError", method);
            boolean infoFound = false;
            boolean errorFound = false;
            for (VariableElement variableElement : method.getParameters()) {
                TypeName typeName = TypeName.get(variableElement.asType());
                if (typeName.toString().equals("react4j.ReactErrorInfo")) {
                    if (infoFound) {
                        throw new ProcessorException("@OnError target has multiple parameters of type react4j.ReactErrorInfo", method);
                    }
                    infoFound = true;
                    continue;
                }
                if (typeName.toString().equals("elemental2.core.JsError")) {
                    if (errorFound) {
                        throw new ProcessorException("@OnError target has multiple parameters of type elemental2.core.JsError", method);
                    }
                    errorFound = true;
                    continue;
                }
                throw new ProcessorException("@OnError target has parameter of invalid type named " + variableElement.getSimpleName().toString(), variableElement);
            }
            descriptor.setOnError(method);
        }
    }

    private void determineScheduleRenderMethods(@Nonnull TypeElement typeElement, @Nonnull ViewDescriptor descriptor) {
        ArrayList<ScheduleRenderDescriptor> scheduleRenderDescriptors = new ArrayList<ScheduleRenderDescriptor>();
        for (ExecutableElement method : this.getMethods(typeElement)) {
            AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(method, "react4j.annotations.ScheduleRender");
            if (null == annotation) continue;
            MemberChecks.mustBeAbstract("react4j.annotations.ScheduleRender", method);
            MemberChecks.mustBeSubclassCallable(typeElement, "react4j.annotations.View", "react4j.annotations.ScheduleRender", method);
            MemberChecks.mustNotReturnAnyValue("react4j.annotations.ScheduleRender", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.ScheduleRender", method);
            ViewType viewType = descriptor.getType();
            if (ViewType.STATEFUL != viewType) {
                String message = MemberChecks.mustNot("react4j.annotations.ScheduleRender", "be enclosed in a type if it is annotated by @View(type=" + (Object)((Object)viewType) + "). The type must be STATEFUL");
                throw new ProcessorException(message, method);
            }
            boolean skipShouldViewUpdate = (Boolean)AnnotationsUtil.getAnnotationValueValue(annotation, "skipShouldViewUpdate");
            scheduleRenderDescriptors.add(new ScheduleRenderDescriptor(method, skipShouldViewUpdate));
        }
        descriptor.setScheduleRenderDescriptors(scheduleRenderDescriptors);
    }

    private void determinePublishMethods(@Nonnull TypeElement typeElement, @Nonnull ViewDescriptor descriptor) {
        ArrayList<PublishDescriptor> descriptors = new ArrayList<PublishDescriptor>();
        for (ExecutableElement method : this.getMethods(typeElement)) {
            AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(method, "react4j.annotations.Publish");
            if (null == annotation) continue;
            MemberChecks.mustBeSubclassCallable(typeElement, "react4j.annotations.View", "react4j.annotations.Publish", method);
            MemberChecks.mustNotHaveAnyParameters("react4j.annotations.Publish", method);
            MemberChecks.mustNotHaveAnyTypeParameters("react4j.annotations.Publish", method);
            MemberChecks.mustReturnAValue("react4j.annotations.Publish", method);
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.Publish", method);
            String qualifier = (String)AnnotationsUtil.getAnnotationValueValue(annotation, "qualifier");
            ExecutableType methodType = this.resolveMethodType(descriptor, method);
            if (TypeKind.TYPEVAR == methodType.getReturnType().getKind()) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.Publish", "return a type variable"), method);
            }
            descriptors.add(new PublishDescriptor(qualifier, method, methodType));
        }
        descriptor.setPublishDescriptors(descriptors);
    }

    private void determineRenderMethod(@Nonnull TypeElement typeElement, @Nonnull ViewDescriptor descriptor) {
        boolean foundRender = false;
        for (ExecutableElement method : this.getMethods(typeElement)) {
            AnnotationMirror annotation = AnnotationsUtil.findAnnotationByType(method, "react4j.annotations.Render");
            if (null == annotation) continue;
            MemberChecks.mustNotBeAbstract("react4j.annotations.Render", method);
            MemberChecks.mustBeSubclassCallable(typeElement, "react4j.annotations.View", "react4j.annotations.Render", method);
            MemberChecks.mustNotHaveAnyParameters("react4j.annotations.Render", method);
            MemberChecks.mustReturnAnInstanceOf(this.processingEnv, method, "react4j.annotations.Render", "react4j.ReactNode");
            MemberChecks.mustNotThrowAnyExceptions("react4j.annotations.Render", method);
            MemberChecks.mustNotHaveAnyTypeParameters("react4j.annotations.Render", method);
            descriptor.setRender(method);
            foundRender = true;
        }
        boolean requireRender = descriptor.requireRender();
        if (requireRender && !foundRender) {
            throw new ProcessorException(MemberChecks.must("react4j.annotations.View", "contain a method annotated with the " + MemberChecks.toSimpleName("react4j.annotations.Render") + " annotation or must specify requireRender=false"), typeElement);
        }
        if (!requireRender) {
            if (foundRender) {
                throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.View", "contain a method annotated with the " + MemberChecks.toSimpleName("react4j.annotations.Render") + " annotation or must not specify requireRender=false"), typeElement);
            }
            if (!(descriptor.hasConstructor() || descriptor.hasPostConstruct() || null != descriptor.getPostMount() || null != descriptor.getPostRender() || null != descriptor.getPreUpdate() || null != descriptor.getPostUpdate() || descriptor.hasPreUpdateOnInputChange() || descriptor.hasPostUpdateOnInputChange())) {
                throw new ProcessorException(MemberChecks.must("react4j.annotations.View", "contain lifecycle methods if the the @View(requireRender=false) parameter is specified"), typeElement);
            }
        }
    }

    private void determinePostMountMethod(@Nonnull TypeElement typeElement, @Nonnull ViewDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.PostMount")) continue;
            MemberChecks.mustBeLifecycleHook(typeElement, "react4j.annotations.View", "react4j.annotations.PostMount", method);
            descriptor.setPostMount(method);
        }
    }

    private void determinePostMountOrUpdateMethod(@Nonnull TypeElement typeElement, @Nonnull ViewDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.PostMountOrUpdate")) continue;
            MemberChecks.mustBeLifecycleHook(typeElement, "react4j.annotations.View", "react4j.annotations.PostMountOrUpdate", method);
            descriptor.setPostRender(method);
        }
    }

    private void determinePostUpdateMethod(@Nonnull TypeElement typeElement, @Nonnull ViewDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.PostUpdate")) continue;
            MemberChecks.mustBeLifecycleHook(typeElement, "react4j.annotations.View", "react4j.annotations.PostUpdate", method);
            descriptor.setPostUpdate(method);
        }
    }

    private void determinePreUpdateMethod(@Nonnull TypeElement typeElement, @Nonnull ViewDescriptor descriptor) {
        for (ExecutableElement method : this.getMethods(typeElement)) {
            if (!AnnotationsUtil.hasAnnotationOfType(method, "react4j.annotations.PreUpdate")) continue;
            MemberChecks.mustBeLifecycleHook(typeElement, "react4j.annotations.View", "react4j.annotations.PreUpdate", method);
            descriptor.setPreUpdate(method);
        }
    }

    private ExecutableType resolveMethodType(@Nonnull ViewDescriptor descriptor, @Nonnull ExecutableElement method) {
        return (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
    }

    @Nonnull
    private String deriveViewName(@Nonnull TypeElement typeElement) {
        String name = (String)AnnotationsUtil.getAnnotationValue(typeElement, "react4j.annotations.View", "name").getValue();
        if (this.isSentinelName(name)) {
            return typeElement.getSimpleName().toString();
        }
        if (!SourceVersion.isIdentifier(name)) {
            throw new ProcessorException(MemberChecks.toSimpleName("react4j.annotations.View") + " target specified an invalid name '" + name + "'. The name must be a valid java identifier.", typeElement);
        }
        if (SourceVersion.isKeyword(name)) {
            throw new ProcessorException(MemberChecks.toSimpleName("react4j.annotations.View") + " target specified an invalid name '" + name + "'. The name must not be a java keyword.", typeElement);
        }
        return name;
    }

    private void determineViewCapabilities(@Nonnull ViewDescriptor descriptor, @Nonnull TypeElement typeElement) {
        if (AnnotationsUtil.hasAnnotationOfType(typeElement, "arez.annotations.ArezComponent")) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.View", "be annotated with the " + MemberChecks.toSimpleName("arez.annotations.ArezComponent") + " as React4j will add the annotation."), typeElement);
        }
        if (descriptor.needsInjection() && !descriptor.getDeclaredType().getTypeArguments().isEmpty()) {
            throw new ProcessorException(MemberChecks.toSimpleName("react4j.annotations.View") + " target has enabled injection integration but the class has type arguments which is incompatible with injection integration.", typeElement);
        }
    }

    @Nonnull
    private ViewType extractViewType(@Nonnull TypeElement typeElement) {
        VariableElement declaredTypeEnum = (VariableElement)AnnotationsUtil.getAnnotationValue(typeElement, "react4j.annotations.View", "type").getValue();
        return ViewType.valueOf(declaredTypeEnum.getSimpleName().toString());
    }

    private boolean shouldUpdateOnChange(@Nonnull ExecutableElement method, boolean immutable) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Input", "shouldUpdateOnChange").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                if (immutable) {
                    throw new ProcessorException("@Input target has specified both immutable=true and shouldUpdateOnChange=ENABLE which is an invalid combination.", method);
                }
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return !immutable;
    }

    private boolean isInputObservable(@Nonnull ViewDescriptor descriptor, @Nonnull ExecutableElement method, boolean shouldUpdateOnChange, boolean immutable) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Input", "observable").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                if (immutable) {
                    throw new ProcessorException("@Input target has specified both immutable=true and observable=ENABLE which is an invalid combination.", method);
                }
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return shouldUpdateOnChange && this.hasAnyArezObserverMethods(descriptor.getElement());
    }

    private boolean hasAnyArezObserverMethods(@Nonnull TypeElement typeElement) {
        return this.getMethods(typeElement).stream().anyMatch(m -> AnnotationsUtil.hasAnnotationOfType(m, "arez.annotations.Memoize") || AnnotationsUtil.hasAnnotationOfType(m, "arez.annotations.Observe") && (!m.getParameters().isEmpty() || !m.getSimpleName().toString().equals("trackRender")));
    }

    private boolean isInputImmutable(@Nonnull ExecutableElement method) {
        return (Boolean)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Input", "immutable").getValue();
    }

    private boolean isInputDisposable(@Nonnull ExecutableElement method, @Nonnull Element inputType) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Input", "disposable").getValue();
        switch (parameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return ElementKind.CLASS == inputType.getKind() && AnnotationsUtil.hasAnnotationOfType(inputType, "arez.annotations.ArezComponent") || (ElementKind.CLASS == inputType.getKind() || ElementKind.INTERFACE == inputType.getKind()) && AnnotationsUtil.hasAnnotationOfType(inputType, "arez.annotations.ActAsComponent");
    }

    private boolean isContextInput(@Nonnull ExecutableElement method) {
        VariableElement parameter = (VariableElement)AnnotationsUtil.getAnnotationValue(method, "react4j.annotations.Input", "source").getValue();
        return "CONTEXT".equals(parameter.getSimpleName().toString());
    }

    private boolean shouldSetDefaultPriority(@Nonnull TypeElement typeElement) {
        List<ExecutableElement> methods = this.getMethods(typeElement);
        return methods.stream().filter(method -> !method.getModifiers().contains((Object)Modifier.PRIVATE)).anyMatch(method -> AnnotationsUtil.hasAnnotationOfType(method, "arez.annotations.Memoize") || AnnotationsUtil.hasAnnotationOfType(method, "arez.annotations.Observe"));
    }

    private void verifyNoDuplicateAnnotations(@Nonnull ExecutableElement method) throws ProcessorException {
        List<String> annotations = Arrays.asList("react4j.annotations.InputDefault", "react4j.annotations.InputValidate", "react4j.annotations.OnInputChange", "react4j.annotations.Input");
        MemberChecks.verifyNoOverlappingAnnotations(method, annotations, Collections.emptyMap());
    }

    @Nonnull
    private List<ExecutableElement> getMethods(@Nonnull TypeElement typeElement) {
        return ElementsUtil.getMethods(typeElement, this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils());
    }

    private boolean isSentinelName(@Nonnull String name) {
        return SENTINEL_NAME.equals(name);
    }

    @Nonnull
    private String getPropertyAccessorName(@Nonnull ExecutableElement method, @Nonnull String specifiedName) throws ProcessorException {
        String name = this.deriveName(method, GETTER_PATTERN, specifiedName);
        if (null != name) {
            return name;
        }
        if (method.getReturnType().getKind() == TypeKind.BOOLEAN && null != (name = this.deriveName(method, ISSER_PATTERN, specifiedName))) {
            return name;
        }
        return method.getSimpleName().toString();
    }

    @Nullable
    private String deriveName(@Nonnull Element method, @Nonnull Pattern pattern, @Nonnull String name) throws ProcessorException {
        if (this.isSentinelName(name)) {
            String methodName = method.getSimpleName().toString();
            Matcher matcher = pattern.matcher(methodName);
            if (matcher.find()) {
                String candidate = matcher.group(1);
                return Character.toLowerCase(candidate.charAt(0)) + candidate.substring(1);
            }
            return null;
        }
        return name;
    }
}

