/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import react4j.processor.BuilderGenerator;
import react4j.processor.InputDescriptor;
import react4j.processor.OnInputChangeDescriptor;
import react4j.processor.PublishDescriptor;
import react4j.processor.React4jProcessor;
import react4j.processor.ScheduleRenderDescriptor;
import react4j.processor.ViewDescriptor;
import react4j.processor.ViewType;
import react4j.processor.vendor.javapoet.AnnotationSpec;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.CodeBlock;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.javapoet.WildcardTypeName;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.GeneratorUtil;
import react4j.processor.vendor.proton.MemberChecks;
import react4j.processor.vendor.proton.ProcessorException;
import react4j.processor.vendor.proton.SuppressWarningsUtil;

final class ViewGenerator {
    private static final ClassName GUARDS_CLASSNAME = ClassName.get("org.realityforge.braincheck", "Guards", new String[0]);
    private static final ClassName AREZ_CLASSNAME = ClassName.get("arez", "Arez", new String[0]);
    private static final ClassName OBSERVER_CLASSNAME = ClassName.get("arez", "Observer", new String[0]);
    private static final ClassName OBSERVABLE_CLASSNAME = ClassName.get("arez", "ObservableValue", new String[0]);
    private static final ClassName DISPOSABLE_CLASSNAME = ClassName.get("arez", "Disposable", new String[0]);
    private static final ClassName AREZ_FEATURE_CLASSNAME = ClassName.get("arez.annotations", "Feature", new String[0]);
    private static final ClassName SUPPRESS_AREZ_WARNINGS_CLASSNAME = ClassName.get("arez.annotations", "SuppressArezWarnings", new String[0]);
    private static final ClassName ACTION_CLASSNAME = ClassName.get("arez.annotations", "Action", new String[0]);
    private static final ClassName DEP_TYPE_CLASSNAME = ClassName.get("arez.annotations", "DepType", new String[0]);
    private static final ClassName PRIORITY_CLASSNAME = ClassName.get("arez.annotations", "Priority", new String[0]);
    private static final ClassName EXECUTOR_CLASSNAME = ClassName.get("arez.annotations", "Executor", new String[0]);
    private static final ClassName OBSERVABLE_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "Observable", new String[0]);
    private static final ClassName OBSERVE_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "Observe", new String[0]);
    private static final ClassName OBSERVER_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ObserverRef", new String[0]);
    private static final ClassName COMPONENT_DEPENDENCY_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ComponentDependency", new String[0]);
    private static final ClassName COMPONENT_NAME_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ComponentNameRef", new String[0]);
    private static final ClassName COMPONENT_ID_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ComponentIdRef", new String[0]);
    private static final ClassName COMPONENT_STATE_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ComponentStateRef", new String[0]);
    private static final ClassName OBSERVABLE_VALUE_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ObservableValueRef", new String[0]);
    private static final ClassName AREZ_COMPONENT_CLASSNAME = ClassName.get("arez.annotations", "ArezComponent", new String[0]);
    private static final ClassName JS_ERROR_CLASSNAME = ClassName.get("akasha.core", "JsError", new String[0]);
    private static final ClassName JS_CONSTRUCTOR_CLASSNAME = ClassName.get("jsinterop.annotations", "JsConstructor", new String[0]);
    private static final ClassName JS_CLASSNAME = ClassName.get("jsinterop.base", "Js", new String[0]);
    private static final ClassName JS_PROPERTY_MAP_CLASSNAME = ClassName.get("jsinterop.base", "JsPropertyMap", new String[0]);
    private static final ParameterizedTypeName JS_PROPERTY_MAP_T_OBJECT_CLASSNAME = ParameterizedTypeName.get(JS_PROPERTY_MAP_CLASSNAME, TypeName.OBJECT);
    private static final ClassName REACT_NODE_CLASSNAME = ClassName.get("react4j", "ReactNode", new String[0]);
    private static final ClassName REACT_ERROR_INFO_CLASSNAME = ClassName.get("react4j", "ReactErrorInfo", new String[0]);
    private static final ClassName REACT_CLASSNAME = ClassName.get("react4j", "React", new String[0]);
    private static final ClassName CONTEXT_CLASSNAME = ClassName.get("react4j", "Context", new String[0]);
    private static final ClassName CONTEXTS_CLASSNAME = ClassName.get("react4j", "Contexts", new String[0]);
    private static final ClassName VIEW_CONSTRUCTOR_FUNCTION_CLASSNAME = ClassName.get("react4j.internal", "ViewConstructorFunction", new String[0]);
    private static final ClassName ON_COMPONENT_DID_MOUNT_CLASSNAME = ClassName.get("react4j.internal", "OnComponentDidMount", new String[0]);
    private static final ClassName ON_COMPONENT_DID_UPDATE_CLASSNAME = ClassName.get("react4j.internal", "OnComponentDidUpdate", new String[0]);
    private static final ClassName ON_COMPONENT_WILL_UNMOUNT_CLASSNAME = ClassName.get("react4j.internal", "OnComponentWillUnmount", new String[0]);
    private static final ClassName ON_GET_SNAPSHOT_BEFORE_UPDATE_CLASSNAME = ClassName.get("react4j.internal", "OnGetSnapshotBeforeUpdate", new String[0]);
    private static final ClassName ON_COMPONENT_SHOULD_UPDATE_CLASSNAME = ClassName.get("react4j.internal", "OnShouldComponentUpdate", new String[0]);
    private static final ClassName ON_COMPONENT_DID_CATCH_CLASSNAME = ClassName.get("react4j.internal", "OnComponentDidCatch", new String[0]);
    private static final ClassName NATIVE_VIEW_CLASSNAME = ClassName.get("react4j.internal", "NativeView", new String[0]);
    private static final ClassName VIEW_STATE_CLASSNAME = ClassName.get("react4j.internal", "ViewState", new String[0]);
    private static final ClassName SCHEDULER_UTIL_CLASSNAME = ClassName.get("react4j.internal", "SchedulerUtil", new String[0]);
    private static final ClassName INTROSPECT_UTIL_CLASSNAME = ClassName.get("react4j.internal", "IntrospectUtil", new String[0]);
    private static final String FRAMEWORK_INTERNAL_PREFIX = "$$react4j$$_";
    private static final String RENDER_METHOD = "$$react4j$$_render";
    private static final String SHOULD_COMPONENT_UPDATE_METHOD = "$$react4j$$_shouldComponentUpdate";
    private static final String COMPONENT_PRE_UPDATE_METHOD = "$$react4j$$_componentPreUpdate";
    private static final String COMPONENT_DID_UPDATE_METHOD = "$$react4j$$_componentDidUpdate";
    private static final String COMPONENT_DID_MOUNT_METHOD = "$$react4j$$_componentDidMount";
    private static final String COMPONENT_WILL_UNMOUNT_METHOD = "$$react4j$$_componentWillUnmount";
    private static final String VALIDATE_INPUTS_METHOD = "$$react4j$$_validateInputValues";
    private static final String STATE_FIELD = "$$react4j$$_state";
    private static final String VIEW_FIELD = "$$react4j$$_view";
    private static final String IS_READY_METHOD = "$$react4j$$_isReady";
    private static final String NATIVE_VIEW_FIELD = "$$react4j$$_nativeView";
    private static final String FRAMEWORK_INTERNAL_IMMUTABLE_INPUT_PREFIX = "$$react4j_immutable_input$$_";

    private ViewGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ViewDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getEnhancedClassName());
        builder.addTypeVariables(GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        TypeElement typeElement = descriptor.getElement();
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)typeElement, builder, Collections.singletonList(Deprecated.class.getName()));
        builder.superclass(descriptor.getViewType());
        AnnotationSpec suppression = SuppressWarningsUtil.maybeSuppressWarningsAnnotation(descriptor.viewAccessesDeprecatedElements() ? "deprecation" : null);
        if (null != suppression) {
            builder.addAnnotation(suppression);
        }
        if (!descriptor.trackRender()) {
            builder.addAnnotation(AnnotationSpec.builder(SUPPRESS_AREZ_WARNINGS_CLASSNAME).addMember("value", "$S", "Arez:UnnecessaryAllowEmpty").build());
        }
        AnnotationSpec.Builder arezAnnotation = AnnotationSpec.builder(AREZ_COMPONENT_CLASSNAME).addMember("name", "$S", typeElement.getQualifiedName().toString().replace(".", "_")).addMember("disposeNotifier", "$T.DISABLE", AREZ_FEATURE_CLASSNAME).addMember("dagger", "$T.DISABLE", AREZ_FEATURE_CLASSNAME).addMember("sting", "$T.DISABLE", AREZ_FEATURE_CLASSNAME);
        if (!descriptor.trackRender()) {
            arezAnnotation.addMember("allowEmpty", "true", new Object[0]);
        } else if (descriptor.shouldSetDefaultPriority()) {
            arezAnnotation.addMember("defaultPriority", "$T.LOWEST", PRIORITY_CLASSNAME);
        }
        builder.addAnnotation(arezAnnotation.build());
        builder.addModifiers(Modifier.ABSTRACT);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, React4jProcessor.class.getName());
        GeneratorUtil.addOriginatingTypes(typeElement, builder);
        if (!descriptor.getPublishDescriptors().isEmpty()) {
            builder.addType(ViewGenerator.buildContextHolder(descriptor));
        }
        builder.addField(FieldSpec.builder(NATIVE_VIEW_CLASSNAME, NATIVE_VIEW_FIELD, Modifier.PRIVATE, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        for (InputDescriptor input : descriptor.getImmutableInputs()) {
            builder.addField(ViewGenerator.buildImmutableField(input));
        }
        builder.addMethod(ViewGenerator.buildConstructor(processingEnv, descriptor).build());
        for (ScheduleRenderDescriptor element : descriptor.getScheduleRenderDescriptors()) {
            MethodSpec.Builder method = GeneratorUtil.overrideMethod(processingEnv, typeElement, element.getMethod());
            if (element.skipShouldViewUpdate()) {
                method.addStatement("$N.forceUpdate()", NATIVE_VIEW_FIELD);
            } else {
                method.addStatement("$N.setState( $T.of() )", NATIVE_VIEW_FIELD, JS_PROPERTY_MAP_CLASSNAME);
            }
            builder.addMethod(method.build());
        }
        if (descriptor.trackRender()) {
            builder.addField(FieldSpec.builder(TypeName.INT, STATE_FIELD, Modifier.PRIVATE).build());
        }
        builder.addType(ViewGenerator.buildFactory());
        if (!descriptor.getInputs().isEmpty()) {
            builder.addType(ViewGenerator.buildInputsType(descriptor));
        }
        builder.addMethod(ViewGenerator.buildConstructorFnMethod(descriptor).build());
        if (descriptor.getInputs().stream().anyMatch(InputDescriptor::needsMutableInputAccessedInPostConstructInvariant)) {
            builder.addMethod(ViewGenerator.buildIsReadyMethod().build());
        }
        for (InputDescriptor input : descriptor.getInputs()) {
            builder.addMethod(ViewGenerator.buildInputMethod(input).build());
            if (!input.isObservable()) continue;
            builder.addMethod(ViewGenerator.buildInputObservableValueRefMethod(input).build());
        }
        if (descriptor.shouldValidateInputs()) {
            builder.addMethod(ViewGenerator.buildInputValidatorMethod(descriptor).build());
        }
        if (descriptor.generateShouldComponentUpdate()) {
            builder.addMethod(ViewGenerator.buildShouldComponentUpdate(descriptor).build());
        }
        if (descriptor.generateComponentDidMount()) {
            builder.addMethod(ViewGenerator.buildComponentDidMount(descriptor).build());
        }
        if (descriptor.generateComponentPreUpdate()) {
            builder.addMethod(ViewGenerator.buildComponentPreUpdate(descriptor).build());
        }
        if (descriptor.generateComponentDidUpdate()) {
            builder.addMethod(ViewGenerator.buildComponentDidUpdate(descriptor).build());
        }
        if (descriptor.generateComponentWillUnmount()) {
            builder.addMethod(ViewGenerator.buildComponentWillUnmount(descriptor).build());
        }
        if (descriptor.hasRender()) {
            builder.addMethod(ViewGenerator.buildRender(descriptor).build());
        }
        if (descriptor.trackRender()) {
            builder.addField(FieldSpec.builder(TypeName.BOOLEAN, "$$react4j$$_scheduledDebugStateUpdate", Modifier.PRIVATE).build());
            builder.addMethod(ViewGenerator.buildOnRenderDepsChange(descriptor).build());
            builder.addMethod(ViewGenerator.buildGetRenderObserver(descriptor).build());
            builder.addMethod(ViewGenerator.buildGetComponentId().build());
            builder.addMethod(ViewGenerator.buildGetComponentName().build());
            builder.addMethod(ViewGenerator.buildStoreDebugDataAsState().build());
        }
        if (descriptor.shouldGenerateLiteLifecycle()) {
            builder.addType(ViewGenerator.buildNativeView(descriptor, true));
        }
        builder.addType(ViewGenerator.buildNativeView(descriptor, false));
        return builder.build();
    }

    @Nonnull
    private static FieldSpec buildImmutableField(@Nonnull InputDescriptor input) {
        FieldSpec.Builder field = FieldSpec.builder(TypeName.get(input.getMethodType().getReturnType()), FRAMEWORK_INTERNAL_IMMUTABLE_INPUT_PREFIX + input.getName(), Modifier.FINAL);
        if (input.isDependency()) {
            Element inputType = input.getInputType();
            boolean isTypeCompatible = null != inputType && (ElementKind.CLASS == inputType.getKind() && AnnotationsUtil.hasAnnotationOfType(inputType, "arez.annotations.ArezComponent") || (ElementKind.CLASS == inputType.getKind() || ElementKind.INTERFACE == inputType.getKind()) && AnnotationsUtil.hasAnnotationOfType(inputType, "arez.annotations.ActAsComponent"));
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(COMPONENT_DEPENDENCY_ANNOTATION_CLASSNAME);
            if (!isTypeCompatible) {
                annotation.addMember("validateTypeAtRuntime", "true", new Object[0]);
            }
            field.addAnnotation(annotation.build());
        } else {
            field.addModifiers(Modifier.PRIVATE);
            field.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "Arez:UnmanagedComponentReference").build());
        }
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)input.getMethod(), field);
        return field.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructor(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ViewDescriptor descriptor) {
        ParameterSpec.Builder componentParameter = ParameterSpec.builder(NATIVE_VIEW_CLASSNAME, NATIVE_VIEW_FIELD, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder();
        ctor.addParameter(componentParameter.build());
        List<? extends VariableElement> parameters = descriptor.getConstructor().getParameters();
        if (!parameters.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            ArrayList<String> params = new ArrayList<String>();
            sb.append("super( ");
            boolean first = true;
            for (VariableElement variableElement : parameters) {
                if (!first) {
                    sb.append(", ");
                }
                first = false;
                sb.append("$N");
                String name = variableElement.getSimpleName().toString();
                params.add(name);
                ParameterSpec.Builder ctorParameter = ParameterSpec.builder(TypeName.get(variableElement.asType()), name, Modifier.FINAL);
                GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)variableElement, ctorParameter);
                SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, ctor, variableElement.asType());
                ctor.addParameter(ctorParameter.build());
            }
            sb.append(" )");
            ctor.addStatement(sb.toString(), params.toArray());
        }
        ctor.addStatement("this.$N = $T.requireNonNull( $N )", NATIVE_VIEW_FIELD, Objects.class, NATIVE_VIEW_FIELD);
        for (InputDescriptor input : descriptor.getImmutableInputs()) {
            ExecutableType methodType = input.getMethodType();
            ExecutableElement methodElement = input.getMethod();
            String string = ViewGenerator.getConverter(methodType.getReturnType(), methodElement);
            TypeKind resultKind = methodElement.getReturnType().getKind();
            if (!resultKind.isPrimitive() && !AnnotationsUtil.hasNonnullAnnotation(methodElement)) {
                CodeBlock.Builder block = CodeBlock.builder();
                block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
                block.addStatement("$N = null != $N.inputs().getAsAny( Inputs.$N ) ? $N.inputs().getAsAny( Inputs.$N ).$N() : null", FRAMEWORK_INTERNAL_IMMUTABLE_INPUT_PREFIX + input.getName(), NATIVE_VIEW_FIELD, input.getConstantName(), NATIVE_VIEW_FIELD, input.getConstantName(), string);
                block.nextControlFlow("else", new Object[0]);
                block.addStatement("$N = $T.uncheckedCast( $N.inputs().getAsAny( Inputs.$N ) )", FRAMEWORK_INTERNAL_IMMUTABLE_INPUT_PREFIX + input.getName(), JS_CLASSNAME, NATIVE_VIEW_FIELD, input.getConstantName());
                block.endControlFlow();
                ctor.addCode(block.build());
                continue;
            }
            ctor.addStatement("$N = $N.inputs().getAsAny( Inputs.$N ).$N()", FRAMEWORK_INTERNAL_IMMUTABLE_INPUT_PREFIX + input.getName(), NATIVE_VIEW_FIELD, input.getConstantName(), string);
        }
        return ctor;
    }

    @Nonnull
    private static FieldSpec.Builder buildInputKeyConstantField(@Nonnull InputDescriptor descriptor, int index) {
        String name = descriptor.getName();
        FieldSpec.Builder field = FieldSpec.builder(TypeName.get(String.class), descriptor.getConstantName(), Modifier.STATIC, Modifier.FINAL);
        if (descriptor.isSpecialChildrenInput()) {
            return field.initializer("$S", "children");
        }
        return field.initializer("$T.shouldMinimizeInputKeys() ? $S : $S", REACT_CLASSNAME, Character.toString((char)(97 + index)), name);
    }

    @Nonnull
    private static MethodSpec.Builder buildInputMethod(@Nonnull InputDescriptor input) {
        ExecutableElement methodElement = input.getMethod();
        ExecutableType methodType = input.getMethodType();
        TypeMirror returnType = methodType.getReturnType();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodElement.getSimpleName().toString()).returns(TypeName.get(returnType));
        GeneratorUtil.copyTypeParameters(methodType, method);
        GeneratorUtil.copyAccessModifiers(methodElement, method);
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)methodElement, method);
        method.addAnnotation(Override.class);
        if (input.isObservable()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(OBSERVABLE_ANNOTATION_CLASSNAME).addMember("name", "$S", input.getName()).addMember("expectSetter", "false", new Object[0]).addMember("readOutsideTransaction", "$T.ENABLE", AREZ_FEATURE_CLASSNAME);
            method.addAnnotation(annotation.build());
        }
        if (input.needsMutableInputAccessedInPostConstructInvariant()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
            block.addStatement("$T.apiInvariant( () -> $N(), () -> \"The view '\" + this + \"' accessed the input named '" + input.getName() + "' before the view is ready (possibly in a @PostConstruct annotated method?) and does not have a @OnInputChange annotated method to cover the input and reflect changes of the input onto the view. This is considered a likely bug and the @Input should be made immutable or an @OnInputChange method added to cover the input. " + MemberChecks.suppressedBy("React4j:MutableInputAccessedInPostConstruct", "react4j.annotations.SuppressReact4jWarnings").replace("\"", "\\\"") + " to the @Input annotated method.\" )", GUARDS_CLASSNAME, IS_READY_METHOD);
            block.endControlFlow();
            method.addCode(block.build());
        }
        if (input.isImmutable()) {
            method.addStatement("return $N", FRAMEWORK_INTERNAL_IMMUTABLE_INPUT_PREFIX + input.getName());
        } else {
            String convertMethodName = ViewGenerator.getConverter(returnType, methodElement);
            TypeKind resultKind = methodElement.getReturnType().getKind();
            if (!resultKind.isPrimitive() && !AnnotationsUtil.hasNonnullAnnotation(methodElement)) {
                CodeBlock.Builder block = CodeBlock.builder();
                block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
                block.addStatement("return null != $N.inputs().getAsAny( Inputs.$N ) ? $N.inputs().getAsAny( Inputs.$N ).$N() : null", NATIVE_VIEW_FIELD, input.getConstantName(), NATIVE_VIEW_FIELD, input.getConstantName(), convertMethodName);
                block.nextControlFlow("else", new Object[0]);
                block.addStatement("return $T.uncheckedCast( $N.inputs().getAsAny( Inputs.$N ) )", JS_CLASSNAME, NATIVE_VIEW_FIELD, input.getConstantName());
                block.endControlFlow();
                method.addCode(block.build());
            } else {
                method.addStatement("return $N.inputs().getAsAny( Inputs.$N ).$N()", NATIVE_VIEW_FIELD, input.getConstantName(), convertMethodName);
            }
        }
        return method;
    }

    @Nonnull
    private static String getConverter(@Nonnull TypeMirror type, @Nonnull Element element) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "asBoolean";
            }
            case BYTE: {
                return "asByte";
            }
            case CHAR: {
                return "asChar";
            }
            case DOUBLE: {
                return "asDouble";
            }
            case FLOAT: {
                return "asFloat";
            }
            case INT: {
                return "asInt";
            }
            case LONG: {
                return "asLong";
            }
            case SHORT: {
                return "asShort";
            }
            case TYPEVAR: 
            case ARRAY: {
                return "cast";
            }
            case DECLARED: {
                if (type.toString().equals("java.lang.String")) {
                    return "asString";
                }
                return "cast";
            }
        }
        throw new ProcessorException("Return type of @Input method is not yet handled. Type: " + (Object)((Object)type.getKind()), element);
    }

    @Nonnull
    private static MethodSpec.Builder buildInputObservableValueRefMethod(@Nonnull InputDescriptor input) {
        return MethodSpec.methodBuilder(ViewGenerator.toObservableValueRefMethodName(input)).addModifiers(Modifier.ABSTRACT).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).addAnnotation(OBSERVABLE_VALUE_REF_ANNOTATION_CLASSNAME).returns(ParameterizedTypeName.get(OBSERVABLE_CLASSNAME, WildcardTypeName.subtypeOf(TypeName.OBJECT)));
    }

    @Nonnull
    private static String toObservableValueRefMethodName(@Nonnull InputDescriptor input) {
        String name = input.getName();
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "ObservableValue";
    }

    private static void buildOnInputChangeInvocations(@Nonnull CodeBlock.Builder code, @Nonnull List<OnInputChangeDescriptor> onInputChanges) {
        List inputs = onInputChanges.stream().flatMap(d -> d.getInputs().stream()).distinct().collect(Collectors.toList());
        for (InputDescriptor input : inputs) {
            code.addStatement("final boolean $N = !$T.isTripleEqual( inputs.get( Inputs.$N ), prevInputs.get( Inputs.$N ) )", input.getName(), JS_CLASSNAME, input.getConstantName(), input.getConstantName());
        }
        for (OnInputChangeDescriptor onInputChange : onInputChanges) {
            CodeBlock.Builder onChangeBlock = CodeBlock.builder();
            onChangeBlock.beginControlFlow("if ( " + onInputChange.getInputs().stream().map(InputDescriptor::getName).collect(Collectors.joining(" && ")) + " )", new Object[0]);
            StringBuilder sb = new StringBuilder();
            ArrayList<Object> params = new ArrayList<Object>();
            sb.append("$N( ");
            params.add(onInputChange.getMethod().getSimpleName().toString());
            boolean requireComma = false;
            for (InputDescriptor input : onInputChange.getInputs()) {
                if (requireComma) {
                    sb.append(", ");
                }
                requireComma = true;
                String convertMethodName = ViewGenerator.getConverter(input.getMethod().getReturnType(), input.getMethod());
                TypeKind resultKind = input.getMethod().getReturnType().getKind();
                if (!resultKind.isPrimitive() && !input.isNonNull()) {
                    sb.append("$T.uncheckedCast( inputs.getAsAny( Inputs.$N ) )");
                    params.add(JS_CLASSNAME);
                    params.add(input.getConstantName());
                    continue;
                }
                sb.append("inputs.getAsAny( Inputs.$N ).$N()");
                params.add(input.getConstantName());
                params.add(convertMethodName);
            }
            sb.append(" )");
            onChangeBlock.addStatement(sb.toString(), params.toArray());
            onChangeBlock.endControlFlow();
            code.add(onChangeBlock.build());
        }
    }

    @Nonnull
    private static MethodSpec.Builder buildComponentDidMount(@Nonnull ViewDescriptor descriptor) {
        ExecutableElement postMount;
        MethodSpec.Builder method = MethodSpec.methodBuilder(COMPONENT_DID_MOUNT_METHOD).addModifiers(Modifier.PRIVATE);
        ExecutableElement postRender = descriptor.getPostRender();
        if (null != postRender) {
            method.addStatement("$N()", postRender.getSimpleName().toString());
        }
        if (null != (postMount = descriptor.getPostMount())) {
            method.addStatement("$N()", postMount.getSimpleName().toString());
        }
        if (descriptor.trackRender()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.shouldStoreDebugDataAsState() && $T.areSpiesEnabled() )", REACT_CLASSNAME, AREZ_CLASSNAME);
            block.addStatement("$N()", "$$react4j$$_storeDebugDataAsState");
            block.endControlFlow();
            method.addCode(block.build());
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildShouldComponentUpdate(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(SHOULD_COMPONENT_UPDATE_METHOD).returns(TypeName.BOOLEAN).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextInputs", Modifier.FINAL).addAnnotation(GeneratorUtil.NULLABLE_CLASSNAME).build());
        List observableInputs = descriptor.getInputs().stream().filter(InputDescriptor::isObservable).collect(Collectors.toList());
        if (!observableInputs.isEmpty()) {
            method.addAnnotation(AnnotationSpec.builder(ACTION_CLASSNAME).addMember("verifyRequired", "false", new Object[0]).build());
        } else {
            method.addModifiers(Modifier.PRIVATE);
        }
        method.addStatement("assert null != nextInputs", new Object[0]);
        if (descriptor.shouldValidateInputs()) {
            CodeBlock.Builder validateBlock = CodeBlock.builder();
            validateBlock.beginControlFlow("if ( $T.shouldValidateInputValues() )", REACT_CLASSNAME);
            validateBlock.addStatement("$N( nextInputs )", VALIDATE_INPUTS_METHOD);
            validateBlock.endControlFlow();
            method.addCode(validateBlock.build());
        }
        List updateOnChangeInputs = descriptor.getInputs().stream().filter(InputDescriptor::shouldUpdateOnChange).filter(p -> !p.isObservable()).collect(Collectors.toList());
        if (observableInputs.isEmpty() && updateOnChangeInputs.isEmpty()) {
            if (descriptor.trackRender()) {
                method.addStatement("return $T.SCHEDULED == $N", VIEW_STATE_CLASSNAME, STATE_FIELD);
            } else {
                method.addStatement("return false", new Object[0]);
            }
        } else {
            CodeBlock.Builder block;
            method.addStatement("final $T inputs = $N.inputs()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, NATIVE_VIEW_FIELD);
            boolean hasObservableInputsToUpdateOnChange = observableInputs.stream().anyMatch(InputDescriptor::shouldUpdateOnChange);
            if (hasObservableInputsToUpdateOnChange) {
                method.addStatement("boolean modified = false", new Object[0]);
            }
            for (InputDescriptor input : observableInputs) {
                block = CodeBlock.builder();
                block.beginControlFlow("if ( !$T.isTripleEqual( inputs.get( Inputs.$N ), nextInputs.get( Inputs.$N ) ) )", JS_CLASSNAME, input.getConstantName(), input.getConstantName());
                block.addStatement("$N().reportChanged()", ViewGenerator.toObservableValueRefMethodName(input));
                if (input.shouldUpdateOnChange()) {
                    block.addStatement("modified = true", new Object[0]);
                }
                block.endControlFlow();
                method.addCode(block.build());
            }
            for (InputDescriptor input : updateOnChangeInputs) {
                block = CodeBlock.builder();
                block.beginControlFlow("if ( !$T.isTripleEqual( inputs.get( Inputs.$N ), nextInputs.get( Inputs.$N ) ) )", JS_CLASSNAME, input.getConstantName(), input.getConstantName());
                block.addStatement("return true", new Object[0]);
                block.endControlFlow();
                method.addCode(block.build());
            }
            if (hasObservableInputsToUpdateOnChange) {
                if (descriptor.trackRender()) {
                    method.addStatement("return modified || $T.SCHEDULED == $N", VIEW_STATE_CLASSNAME, STATE_FIELD);
                } else {
                    method.addStatement("return modified", new Object[0]);
                }
            } else if (descriptor.trackRender()) {
                method.addStatement("return $T.SCHEDULED == $N", VIEW_STATE_CLASSNAME, STATE_FIELD);
            } else {
                method.addStatement("return false", new Object[0]);
            }
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildComponentPreUpdate(@Nonnull ViewDescriptor descriptor) {
        ExecutableElement preUpdate;
        MethodSpec.Builder method = MethodSpec.methodBuilder(COMPONENT_PRE_UPDATE_METHOD).addModifiers(Modifier.PRIVATE).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevInputs", Modifier.FINAL).addAnnotation(GeneratorUtil.NULLABLE_CLASSNAME).build());
        boolean hasPreUpdateOnInputChange = descriptor.hasPreUpdateOnInputChange();
        if (hasPreUpdateOnInputChange) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( null != prevInputs )", new Object[0]);
            block.addStatement("final $T inputs = $N.inputs()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, NATIVE_VIEW_FIELD);
            ViewGenerator.buildOnInputChangeInvocations(block, descriptor.getPreUpdateOnInputChangeDescriptors());
            block.endControlFlow();
            method.addCode(block.build());
        }
        if (null != (preUpdate = descriptor.getPreUpdate())) {
            method.addStatement("$N()", preUpdate.getSimpleName().toString());
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildComponentDidUpdate(@Nonnull ViewDescriptor descriptor) {
        ExecutableElement postUpdate;
        ExecutableElement postRender;
        MethodSpec.Builder method = MethodSpec.methodBuilder(COMPONENT_DID_UPDATE_METHOD).addModifiers(Modifier.PRIVATE);
        if (descriptor.hasPostUpdateOnInputChange()) {
            method.addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevInputs", Modifier.FINAL).addAnnotation(GeneratorUtil.NULLABLE_CLASSNAME).build());
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( null != prevInputs )", new Object[0]);
            block.addStatement("final $T inputs = $N.inputs()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, NATIVE_VIEW_FIELD);
            ViewGenerator.buildOnInputChangeInvocations(block, descriptor.getPostUpdateOnInputChangeDescriptors());
            block.endControlFlow();
            method.addCode(block.build());
        }
        if (null != (postRender = descriptor.getPostRender())) {
            method.addStatement("$N()", postRender.getSimpleName().toString());
        }
        if (null != (postUpdate = descriptor.getPostUpdate())) {
            method.addStatement("$N()", postUpdate.getSimpleName().toString());
        }
        if (descriptor.trackRender()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.shouldStoreDebugDataAsState() && $T.areSpiesEnabled() )", REACT_CLASSNAME, AREZ_CLASSNAME);
            block.addStatement("$N()", "$$react4j$$_storeDebugDataAsState");
            block.endControlFlow();
            method.addCode(block.build());
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildComponentWillUnmount(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(COMPONENT_WILL_UNMOUNT_METHOD).addModifiers(Modifier.PRIVATE);
        if (descriptor.trackRender()) {
            method.addStatement("$N = $T.UNMOUNTED", STATE_FIELD, VIEW_STATE_CLASSNAME);
        }
        method.addStatement("(($T) this).dispose()", descriptor.getArezClassName());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildRender(@Nonnull ViewDescriptor descriptor) {
        ExecutableElement render = descriptor.getRender();
        MethodSpec.Builder method = MethodSpec.methodBuilder(RENDER_METHOD).addAnnotation(GeneratorUtil.NULLABLE_CLASSNAME).returns(REACT_NODE_CLASSNAME);
        if (descriptor.trackRender()) {
            AnnotationSpec.Builder observe = AnnotationSpec.builder(OBSERVE_ANNOTATION_CLASSNAME).addMember("name", "$S", "render").addMember("priority", "$T.LOW", PRIORITY_CLASSNAME).addMember("executor", "$T.EXTERNAL", EXECUTOR_CLASSNAME).addMember("depType", "$T.AREZ_OR_NONE", DEP_TYPE_CLASSNAME).addMember("observeLowerPriorityDependencies", "true", new Object[0]).addMember("reportResult", "false", new Object[0]);
            method.addAnnotation(observe.build());
            method.addStatement("$N = $T.IDLE", STATE_FIELD, VIEW_STATE_CLASSNAME);
        }
        method.addStatement("assert $T.isNotDisposed( this )", DISPOSABLE_CLASSNAME);
        List disposableInputs = descriptor.getInputs().stream().filter(InputDescriptor::isDisposable).filter(input -> !input.isDependency()).collect(Collectors.toList());
        for (InputDescriptor input2 : disposableInputs) {
            String varName = "$$react4jv$$_" + input2.getMethod().getSimpleName();
            method.addStatement("final $T $N = $N()", input2.getMethodType().getReturnType(), varName, input2.getMethod().getSimpleName().toString());
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.isDisposed( $N ) )", DISPOSABLE_CLASSNAME, varName);
            block.addStatement("return null", new Object[0]);
            block.endControlFlow();
            method.addCode(block.build());
        }
        if (descriptor.trackRender()) {
            method.addStatement("$T.pauseUntilRenderLoopComplete()", SCHEDULER_UTIL_CLASSNAME);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> args = new ArrayList<Object>();
        List<PublishDescriptor> publishDescriptors = descriptor.getPublishDescriptors();
        for (PublishDescriptor publish : publishDescriptors) {
            sb.append("$T.$N.provide( $N(), ");
            args.add(ClassName.bestGuess("ContextHolder"));
            args.add("CONTEXT_" + publish.getMethod().getSimpleName().toString());
            args.add(publish.getMethod().getSimpleName());
        }
        sb.append("$N()");
        args.add(render.getSimpleName().toString());
        int publishCount = publishDescriptors.size();
        for (int i = 0; i < publishCount; ++i) {
            sb.append(" )");
        }
        if (ViewType.TRACKING == descriptor.getType()) {
            args.add(0, REACT_NODE_CLASSNAME);
            method.addStatement("final $T result = " + sb, args.toArray());
            CodeBlock.Builder depCheckBlock = CodeBlock.builder();
            depCheckBlock.beginControlFlow("if ( $T.shouldCheckInvariants() && $T.areSpiesEnabled() )", AREZ_CLASSNAME, AREZ_CLASSNAME);
            String getObserverMethodName = "$$react4j$$_getRenderObserver";
            depCheckBlock.addStatement("$T.invariant( () -> !$N().getContext().getSpy().asObserverInfo( $N() ).getDependencies().isEmpty(), () -> \"View render completed on '\" + this + \"' without accessing any Arez dependencies but has a type set to TRACKING. The render method needs to access an Arez dependency or the type should be changed to STATEFUL or MAYBE_TRACKING.\" )", GUARDS_CLASSNAME, "$$react4j$$_getRenderObserver", "$$react4j$$_getRenderObserver");
            depCheckBlock.endControlFlow();
            method.addCode(depCheckBlock.build());
            method.addStatement("return result", new Object[0]);
        } else {
            method.addStatement("return " + sb, args.toArray());
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildGetComponentId() {
        return MethodSpec.methodBuilder("$$react4j$$_getComponentId").addAnnotation(COMPONENT_ID_REF_ANNOTATION_CLASSNAME).addModifiers(Modifier.ABSTRACT).returns(TypeName.INT);
    }

    @Nonnull
    private static MethodSpec.Builder buildGetComponentName() {
        return MethodSpec.methodBuilder("$$react4j$$_getComponentName").addAnnotation(COMPONENT_NAME_REF_ANNOTATION_CLASSNAME).addModifiers(Modifier.ABSTRACT).returns(ClassName.get(String.class));
    }

    @Nonnull
    private static MethodSpec.Builder buildGetRenderObserver(@Nonnull ViewDescriptor descriptor) {
        assert (descriptor.trackRender());
        return MethodSpec.methodBuilder("$$react4j$$_getRenderObserver").addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).addAnnotation(AnnotationSpec.builder(OBSERVER_REF_ANNOTATION_CLASSNAME).addMember("name", "$S", "render").build()).addModifiers(Modifier.ABSTRACT).returns(OBSERVER_CLASSNAME);
    }

    @Nonnull
    private static MethodSpec.Builder buildStoreDebugDataAsState() {
        MethodSpec.Builder method = MethodSpec.methodBuilder("$$react4j$$_storeDebugDataAsState").addModifiers(Modifier.PRIVATE);
        CodeBlock.Builder block = CodeBlock.builder();
        String flag = "$$react4j$$_scheduledDebugStateUpdate";
        block.beginControlFlow("if ( $N )", "$$react4j$$_scheduledDebugStateUpdate");
        block.addStatement("$N = false", "$$react4j$$_scheduledDebugStateUpdate");
        block.nextControlFlow("else", new Object[0]);
        block.addStatement("final $T newState = $T.of()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, JS_PROPERTY_MAP_CLASSNAME);
        block.addStatement("newState.set( $S, $N() )", "Arez.id", "$$react4j$$_getComponentId");
        block.addStatement("newState.set( $S, $N() )", "Arez.name", "$$react4j$$_getComponentName");
        block.addStatement("$T.collectDependencyDebugData( $N(), newState )", INTROSPECT_UTIL_CLASSNAME, "$$react4j$$_getRenderObserver");
        CodeBlock.Builder onUpdateBlock = CodeBlock.builder();
        onUpdateBlock.beginControlFlow("if ( $T.prepareStateUpdate( newState, $N.state() ) )", INTROSPECT_UTIL_CLASSNAME, NATIVE_VIEW_FIELD);
        onUpdateBlock.addStatement("$N.setState( newState )", NATIVE_VIEW_FIELD);
        onUpdateBlock.addStatement("$N.forceUpdate()", NATIVE_VIEW_FIELD);
        onUpdateBlock.addStatement("$N = true", "$$react4j$$_scheduledDebugStateUpdate");
        onUpdateBlock.endControlFlow();
        block.add(onUpdateBlock.build());
        block.endControlFlow();
        method.addCode(block.build());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildOnRenderDepsChange(@Nonnull ViewDescriptor descriptor) {
        assert (descriptor.trackRender());
        MethodSpec.Builder method = MethodSpec.methodBuilder("onRenderDepsChange");
        CodeBlock.Builder outer = CodeBlock.builder();
        outer.beginControlFlow("if ( $T.IDLE == $N )", VIEW_STATE_CLASSNAME, STATE_FIELD);
        outer.addStatement("$N = $T.SCHEDULED", STATE_FIELD, VIEW_STATE_CLASSNAME);
        if (descriptor.hasObservableInputs()) {
            outer.addStatement("$N.setState( $T.of() )", NATIVE_VIEW_FIELD, JS_PROPERTY_MAP_CLASSNAME);
        } else {
            outer.addStatement("$N.forceUpdate()", NATIVE_VIEW_FIELD);
        }
        outer.endControlFlow();
        method.addCode(outer.build());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildIsReadyMethod() {
        return MethodSpec.methodBuilder(IS_READY_METHOD).addModifiers(Modifier.ABSTRACT).returns(TypeName.BOOLEAN).addAnnotation(COMPONENT_STATE_REF_ANNOTATION_CLASSNAME);
    }

    @Nonnull
    private static MethodSpec.Builder buildInputValidatorMethod(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(VALIDATE_INPUTS_METHOD).addModifiers(Modifier.PRIVATE).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "inputs", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        for (InputDescriptor input : descriptor.getInputs()) {
            CodeBlock.Builder block;
            boolean requiresNonnullInvariant;
            boolean bl = requiresNonnullInvariant = input.isNonNull() && (input.isRequired() || input.isContextSource());
            if (!requiresNonnullInvariant && !input.hasValidateMethod()) continue;
            String name = input.getName();
            String rawName = "raw$" + name;
            String typedName = "typed$" + name;
            method.addStatement("final $T $N = inputs.get( Inputs.$N )", Object.class, rawName, input.getConstantName());
            if (requiresNonnullInvariant) {
                block = CodeBlock.builder();
                block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CLASSNAME);
                if (input.isContextSource()) {
                    String qualifier = input.getQualifier();
                    if (qualifier.isEmpty()) {
                        block.addStatement("$T.apiInvariant( () -> null != $N, () -> \"Context value of type $N is missing when constructing view named '$N'. Ensure a parent view publishes the value to the context.\" ) ", GUARDS_CLASSNAME, rawName, input.getMethodType().getReturnType().toString(), descriptor.getName());
                    } else {
                        block.addStatement("$T.apiInvariant( () -> null != $N, () -> \"Context value of type $N with qualifier '$N' is missing when constructing view named '$N'. Ensure a parent view publishes the value to the context.\" ) ", GUARDS_CLASSNAME, rawName, input.getMethodType().getReturnType().toString(), qualifier, descriptor.getName());
                    }
                } else {
                    block.addStatement("$T.apiInvariant( () -> null != $N, () -> \"Required input named '$N' is missing from view named '$N' so it was either incorrectly omitted or a null value has been incorrectly specified.\" ) ", GUARDS_CLASSNAME, rawName, input.getName(), descriptor.getName());
                }
                block.endControlFlow();
                method.addCode(block.build());
            }
            if (!input.hasValidateMethod()) continue;
            block = CodeBlock.builder();
            block.beginControlFlow("if ( null != $N )", rawName);
            TypeMirror returnType = input.getMethodType().getReturnType();
            block.addStatement("final $T $N = $T.$N( $N )", returnType, typedName, JS_CLASSNAME, ViewGenerator.getConverter(returnType, input.getMethod()), rawName);
            block.addStatement("$N( $N )", input.getValidateMethod().getSimpleName().toString(), typedName);
            block.endControlFlow();
            method.addCode(block.build());
        }
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructorFnMethod(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("getConstructorFunction").addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).addModifiers(Modifier.STATIC, Modifier.PRIVATE).returns(VIEW_CONSTRUCTOR_FUNCTION_CLASSNAME);
        boolean shouldGenerateLiteLifecycle = descriptor.shouldGenerateLiteLifecycle();
        if (shouldGenerateLiteLifecycle) {
            method.addStatement("final $T viewConstructor = ( $T.shouldStoreDebugDataAsState() || $T.shouldValidateInputValues() ) ? $T::new : $T::new", VIEW_CONSTRUCTOR_FUNCTION_CLASSNAME, REACT_CLASSNAME, REACT_CLASSNAME, ClassName.bestGuess("NativeView"), ClassName.bestGuess("LiteNativeView"));
        } else {
            method.addStatement("final $T viewConstructor = $T::new", VIEW_CONSTRUCTOR_FUNCTION_CLASSNAME, ClassName.bestGuess("NativeView"));
        }
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( $T.enableViewNames() )", REACT_CLASSNAME);
        codeBlock.addStatement("$T.asPropertyMap( viewConstructor ).set( \"displayName\", $S )", JS_CLASSNAME, descriptor.getName());
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        method.addStatement("return viewConstructor", new Object[0]);
        return method;
    }

    @Nonnull
    private static TypeSpec buildInputsType(@Nonnull ViewDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Inputs");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        List<InputDescriptor> inputs = descriptor.getInputs();
        int inputCount = inputs.size();
        for (int i = 0; i < inputCount; ++i) {
            builder.addField(ViewGenerator.buildInputKeyConstantField(inputs.get(i), i).build());
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildFactory() {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Factory");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        FieldSpec.Builder field = FieldSpec.builder(VIEW_CONSTRUCTOR_FUNCTION_CLASSNAME, "TYPE", Modifier.STATIC, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).initializer("getConstructorFunction()", new Object[0]);
        builder.addField(field.build());
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildNativeView(@Nonnull ViewDescriptor descriptor, boolean lite) {
        TypeName viewFieldType;
        TypeSpec.Builder builder = TypeSpec.classBuilder((lite ? "Lite" : "") + "NativeView");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        builder.addModifiers(Modifier.PRIVATE);
        builder.superclass(NATIVE_VIEW_CLASSNAME);
        builder.addTypeVariables(GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        if (descriptor.getElement().getTypeParameters().isEmpty()) {
            viewFieldType = descriptor.getEnhancedClassName();
        } else {
            TypeName[] typeNames = GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()).toArray(new TypeName[0]);
            viewFieldType = ParameterizedTypeName.get(descriptor.getEnhancedClassName(), typeNames);
        }
        builder.addField(FieldSpec.builder(viewFieldType, VIEW_FIELD, Modifier.PRIVATE, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        if (lite) {
            if (descriptor.generateComponentDidMountInLiteLifecycle()) {
                builder.addSuperinterface(ON_COMPONENT_DID_MOUNT_CLASSNAME);
            }
            if (descriptor.generateComponentDidUpdateInLiteLifecycle()) {
                builder.addSuperinterface(ON_COMPONENT_DID_UPDATE_CLASSNAME);
            }
            if (descriptor.generateShouldComponentUpdateInLiteLifecycle()) {
                builder.addSuperinterface(ON_COMPONENT_SHOULD_UPDATE_CLASSNAME);
            }
            if (descriptor.generateComponentWillUnmountInLiteLifecycle()) {
                builder.addSuperinterface(ON_COMPONENT_WILL_UNMOUNT_CLASSNAME);
            }
        } else {
            if (descriptor.generateComponentDidMount()) {
                builder.addSuperinterface(ON_COMPONENT_DID_MOUNT_CLASSNAME);
            }
            if (descriptor.generateComponentDidUpdate()) {
                builder.addSuperinterface(ON_COMPONENT_DID_UPDATE_CLASSNAME);
            }
            if (descriptor.generateShouldComponentUpdate()) {
                builder.addSuperinterface(ON_COMPONENT_SHOULD_UPDATE_CLASSNAME);
            }
            if (descriptor.generateComponentWillUnmount()) {
                builder.addSuperinterface(ON_COMPONENT_WILL_UNMOUNT_CLASSNAME);
            }
        }
        if (descriptor.generateComponentPreUpdate()) {
            builder.addSuperinterface(ON_GET_SNAPSHOT_BEFORE_UPDATE_CLASSNAME);
        }
        if (descriptor.generateComponentDidCatch()) {
            builder.addSuperinterface(ON_COMPONENT_DID_CATCH_CLASSNAME);
        }
        ParameterSpec.Builder inputs = ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "inputs", Modifier.FINAL).addAnnotation(GeneratorUtil.NULLABLE_CLASSNAME);
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addParameter(inputs.build()).addAnnotation(JS_CONSTRUCTOR_CLASSNAME);
        method.addStatement("super( inputs )", new Object[0]);
        if (descriptor.needsInjection()) {
            method.addStatement("$N = $T.create( this )", VIEW_FIELD, descriptor.getFactoryClassName());
        } else {
            String infix = BuilderGenerator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            method.addStatement("$N = new $T" + infix + "( this )", VIEW_FIELD, descriptor.getArezClassName());
        }
        if (descriptor.shouldValidateInputs()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.shouldValidateInputValues() )", REACT_CLASSNAME);
            block.addStatement("assert null != inputs", new Object[0]);
            block.addStatement("$N.$N( inputs )", VIEW_FIELD, VALIDATE_INPUTS_METHOD);
            block.endControlFlow();
            method.addCode(block.build());
        }
        builder.addMethod(method.build());
        if (lite ? descriptor.generateComponentDidMountInLiteLifecycle() : descriptor.generateComponentDidMount()) {
            builder.addMethod(ViewGenerator.buildNativeViewDidMount(descriptor));
        }
        if (lite ? descriptor.generateShouldComponentUpdateInLiteLifecycle() : descriptor.generateShouldComponentUpdate()) {
            builder.addMethod(ViewGenerator.buildNativeShouldComponentUpdate(descriptor));
        }
        if (descriptor.generateComponentPreUpdate()) {
            builder.addMethod(ViewGenerator.buildNativeViewPreUpdate(descriptor));
        }
        if (lite ? descriptor.generateComponentDidUpdateInLiteLifecycle() : descriptor.generateComponentDidUpdate()) {
            builder.addMethod(ViewGenerator.buildNativeViewDidUpdate(descriptor));
        }
        if (lite ? descriptor.generateComponentWillUnmountInLiteLifecycle() : descriptor.generateComponentWillUnmount()) {
            builder.addMethod(ViewGenerator.buildNativeViewWillUnmount(descriptor));
        }
        if (descriptor.generateComponentDidCatch()) {
            builder.addMethod(ViewGenerator.buildNativeViewDidCatch(descriptor).build());
        }
        builder.addMethod(ViewGenerator.buildNativeRender(descriptor));
        return builder.build();
    }

    @Nonnull
    private static MethodSpec buildNativeRender(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("render").addAnnotation(Override.class).addAnnotation(GeneratorUtil.NULLABLE_CLASSNAME).addModifiers(Modifier.FINAL, Modifier.PUBLIC).returns(REACT_NODE_CLASSNAME);
        if (descriptor.hasRender()) {
            if (descriptor.hasDependencyInput()) {
                CodeBlock.Builder block = CodeBlock.builder();
                block.beginControlFlow("if ( $T.isNotDisposed( $N ) )", DISPOSABLE_CLASSNAME, VIEW_FIELD);
                block.addStatement("return $N.$N()", VIEW_FIELD, RENDER_METHOD);
                block.nextControlFlow("else", new Object[0]);
                block.addStatement("return null", new Object[0]);
                block.endControlFlow();
                method.addCode(block.build());
            } else {
                method.addStatement("return $N.$N()", VIEW_FIELD, RENDER_METHOD);
            }
        } else {
            method.addStatement("return null", new Object[0]);
        }
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildNativeViewDidMount(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("componentDidMount").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC);
        if (descriptor.hasDependencyInput()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.isNotDisposed( $N ) )", DISPOSABLE_CLASSNAME, VIEW_FIELD);
            block.addStatement("$N.$N()", VIEW_FIELD, COMPONENT_DID_MOUNT_METHOD);
            block.endControlFlow();
            method.addCode(block.build());
        } else {
            method.addStatement("$N.$N()", VIEW_FIELD, COMPONENT_DID_MOUNT_METHOD);
        }
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildNativeShouldComponentUpdate(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("shouldComponentUpdate").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).returns(TypeName.BOOLEAN).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextInputs", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        if (descriptor.hasDependencyInput()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.isNotDisposed( $N ) )", DISPOSABLE_CLASSNAME, VIEW_FIELD);
            block.addStatement("return $N.$N( nextInputs )", VIEW_FIELD, SHOULD_COMPONENT_UPDATE_METHOD);
            block.nextControlFlow("else", new Object[0]);
            block.addStatement("return false", new Object[0]);
            block.endControlFlow();
            method.addCode(block.build());
        } else {
            method.addStatement("return $N.$N( nextInputs )", VIEW_FIELD, SHOULD_COMPONENT_UPDATE_METHOD);
        }
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildNativeViewPreUpdate(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("getSnapshotBeforeUpdate").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).returns(TypeName.get(Object.class)).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevInputs", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build()).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevState", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        if (descriptor.hasDependencyInput()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.isNotDisposed( $N ) )", DISPOSABLE_CLASSNAME, VIEW_FIELD);
            block.addStatement("$N.$N( prevInputs )", VIEW_FIELD, COMPONENT_PRE_UPDATE_METHOD);
            block.endControlFlow();
            method.addCode(block.build());
        } else {
            method.addStatement("$N.$N( prevInputs )", VIEW_FIELD, COMPONENT_PRE_UPDATE_METHOD);
        }
        method.addStatement("return null", new Object[0]);
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildNativeViewDidUpdate(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("componentDidUpdate").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "prevInputs", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        if (descriptor.hasDependencyInput()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.isNotDisposed( $N ) )", DISPOSABLE_CLASSNAME, VIEW_FIELD);
            if (descriptor.hasPostUpdateOnInputChange()) {
                block.addStatement("$N.$N( prevInputs )", VIEW_FIELD, COMPONENT_DID_UPDATE_METHOD);
            } else {
                block.addStatement("$N.$N()", VIEW_FIELD, COMPONENT_DID_UPDATE_METHOD);
            }
            block.endControlFlow();
            method.addCode(block.build());
        } else if (descriptor.hasPostUpdateOnInputChange()) {
            method.addStatement("$N.$N( prevInputs )", VIEW_FIELD, COMPONENT_DID_UPDATE_METHOD);
        } else {
            method.addStatement("$N.$N()", VIEW_FIELD, COMPONENT_DID_UPDATE_METHOD);
        }
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildNativeViewWillUnmount(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("componentWillUnmount").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC);
        if (descriptor.hasDependencyInput()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.isNotDisposed( $N ) )", DISPOSABLE_CLASSNAME, VIEW_FIELD);
            block.addStatement("$N.$N()", VIEW_FIELD, COMPONENT_WILL_UNMOUNT_METHOD);
            block.endControlFlow();
            method.addCode(block.build());
        } else {
            method.addStatement("$N.$N()", VIEW_FIELD, COMPONENT_WILL_UNMOUNT_METHOD);
        }
        return method.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildNativeViewDidCatch(@Nonnull ViewDescriptor descriptor) {
        String args;
        ExecutableElement onError = descriptor.getOnError();
        assert (null != onError);
        MethodSpec.Builder method = MethodSpec.methodBuilder("componentDidCatch").addAnnotation(Override.class).addModifiers(Modifier.FINAL, Modifier.PUBLIC).addParameter(ParameterSpec.builder(JS_ERROR_CLASSNAME, "error", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build()).addParameter(ParameterSpec.builder(REACT_ERROR_INFO_CLASSNAME, "info", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        List<? extends VariableElement> parameters = onError.getParameters();
        String string = args = parameters.isEmpty() ? "()" : "( " + parameters.stream().map(p -> TypeName.get(p.asType()).toString().equals("akasha.core.JsError") ? "error" : "info").collect(Collectors.joining(", ")) + " )";
        if (descriptor.hasDependencyInput()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( $T.isNotDisposed( $N ) )", DISPOSABLE_CLASSNAME, VIEW_FIELD);
            block.addStatement("$N.$N" + args, VIEW_FIELD, onError.getSimpleName());
            block.endControlFlow();
            method.addCode(block.build());
        } else {
            method.addStatement("$N.$N" + args, VIEW_FIELD, onError.getSimpleName());
        }
        return method;
    }

    @Nonnull
    private static TypeSpec buildContextHolder(@Nonnull ViewDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("ContextHolder");
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL);
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        for (PublishDescriptor publish : descriptor.getPublishDescriptors()) {
            TypeName type = TypeName.get(publish.getMethodType().getReturnType()).box();
            FieldSpec.Builder field = FieldSpec.builder(ParameterizedTypeName.get(CONTEXT_CLASSNAME, type), "CONTEXT_" + publish.getMethod().getSimpleName().toString(), Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
            String qualifier = publish.getQualifier();
            if ("".equals(qualifier)) {
                field.initializer("$T.get( $T.class )", CONTEXTS_CLASSNAME, type);
            } else {
                field.initializer("$T.get( $T.class, $S )", CONTEXTS_CLASSNAME, type, qualifier);
            }
            builder.addField(field.build());
        }
        return builder.build();
    }
}

