/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.proton;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.proton.DeferredElementSet;
import react4j.processor.vendor.proton.ElementsUtil;
import react4j.processor.vendor.proton.GeneratorUtil;
import react4j.processor.vendor.proton.ProcessorException;
import react4j.processor.vendor.proton.StopWatch;
import react4j.processor.vendor.proton.SuperficialValidation;

public abstract class AbstractStandardProcessor
extends AbstractProcessor {
    @Nonnull
    private final Set<String> _rootTypeNames = new HashSet<String>();
    @Nonnull
    private final StopWatch _emitJavaTypeStopWatch = new StopWatch("Emit Java Type");
    @Nonnull
    private final StopWatch _validateElementStopWatch = new StopWatch("Validate Element");
    @Nonnull
    private final StopWatch _extractDeferredStopWatch = new StopWatch("Extract Deferred");
    private boolean _verboseOutOfRoundErrors;
    private boolean _deferErrors;
    private boolean _deferUnresolved;
    private boolean _debug;
    private boolean _profile;
    private int _invalidTypeCount;

    @Override
    public synchronized void init(@Nonnull ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this._verboseOutOfRoundErrors = this.readBooleanOption("verbose_out_of_round.errors", true);
        this._deferErrors = this.readBooleanOption("defer.errors", true);
        this._deferUnresolved = this.readBooleanOption("defer.unresolved", true);
        this._debug = this.readBooleanOption("debug", false);
        this._profile = this.readBooleanOption("profile", false);
    }

    protected final void debugAnnotationProcessingRootElements(@Nonnull RoundEnvironment env) {
        if (this.isDebugEnabled()) {
            for (Element element : env.getRootElements()) {
                if (!(element instanceof TypeElement)) continue;
                this.debug(() -> "Annotation processing root element " + ((TypeElement)element).getQualifiedName());
            }
        }
    }

    protected final void processTypeElements(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env, @Nonnull String annotationClassname, @Nonnull DeferredElementSet deferredTypes, @Nonnull String label, @Nonnull Action<TypeElement> action, @Nonnull StopWatch actionStopWatch) {
        Collection<TypeElement> newElementsToProcess = this.getNewTypeElementsToProcess(annotations, env, annotationClassname);
        if (!deferredTypes.getDeferred().isEmpty() || !newElementsToProcess.isEmpty()) {
            this.processTypeElements(env, deferredTypes, newElementsToProcess, label, action, actionStopWatch);
        }
    }

    protected final Collection<TypeElement> getNewTypeElementsToProcess(@Nonnull Set<? extends TypeElement> annotations, @Nonnull RoundEnvironment env, @Nonnull String annotationClassname) {
        return annotations.stream().filter(a -> a.getQualifiedName().toString().equals(annotationClassname)).findAny().map(a -> env.getElementsAnnotatedWith((TypeElement)a)).map(elements -> elements.stream().filter(e -> this.isRootType((TypeElement)ElementsUtil.getTopLevelElement(e))).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private boolean isRootType(@Nonnull TypeElement typeElement) {
        return this._rootTypeNames.contains(typeElement.getQualifiedName().toString());
    }

    private void processTypeElements(@Nonnull RoundEnvironment env, @Nonnull DeferredElementSet deferredSet, @Nonnull Collection<TypeElement> elements, @Nonnull String label, @Nonnull Action<TypeElement> action, @Nonnull StopWatch actionStopWatch) {
        if (this.shouldDeferUnresolved()) {
            Collection<TypeElement> elementsToProcess = this.deriveElementsToProcess(deferredSet, elements);
            this.doProcessTypeElements(env, elementsToProcess, label, action, actionStopWatch);
            this.errorIfProcessingOverAndDeferredTypesUnprocessed(env, deferredSet);
        } else {
            this.doProcessTypeElements(env, new ArrayList<TypeElement>(elements), label, action, actionStopWatch);
        }
    }

    private void errorIfProcessingOverAndDeferredTypesUnprocessed(@Nonnull RoundEnvironment env, @Nonnull DeferredElementSet deferredSet) {
        Set<TypeElement> deferred = deferredSet.getDeferred();
        if ((env.processingOver() || env.errorRaised()) && !deferred.isEmpty()) {
            deferred.forEach(e -> this.processingErrorMessage(env, (TypeElement)e));
            deferredSet.clear();
        }
    }

    protected final void errorIfProcessingOverAndInvalidTypesDetected(@Nonnull RoundEnvironment env) {
        if (env.processingOver()) {
            if (0 != this._invalidTypeCount) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getSimpleName() + " failed to process " + this._invalidTypeCount + " types. See earlier warnings for further details.");
            }
            this._invalidTypeCount = 0;
        }
    }

    protected final void collectRootTypeNames(@Nonnull RoundEnvironment env) {
        for (Element element : env.getRootElements()) {
            if (!(element instanceof TypeElement)) continue;
            this._rootTypeNames.add(((TypeElement)element).getQualifiedName().toString());
        }
    }

    protected final void clearRootTypeNamesIfProcessingOver(@Nonnull RoundEnvironment env) {
        if (env.processingOver()) {
            this._rootTypeNames.clear();
        }
    }

    protected boolean shouldDeferUnresolved() {
        return this._deferUnresolved;
    }

    @Nonnull
    protected abstract String getIssueTrackerURL();

    @Nonnull
    protected abstract String getOptionPrefix();

    private void processingErrorMessage(@Nonnull RoundEnvironment env, @Nonnull TypeElement target) {
        this.reportError(env, this.getClass().getSimpleName() + " unable to process " + target.getQualifiedName() + " because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.", target);
    }

    protected final void reportError(@Nonnull RoundEnvironment env, @Nonnull String message, @Nullable Element element) {
        this.reportError(env, message, element, null, null);
    }

    protected final void reportError(@Nonnull RoundEnvironment env, @Nonnull String message, @Nullable Element element, @Nullable AnnotationMirror annotation, @Nullable AnnotationValue annotationValue) {
        ++this._invalidTypeCount;
        Diagnostic.Kind kind = !this._deferErrors || env.errorRaised() || env.processingOver() ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING;
        Messager messager = this.processingEnv.getMessager();
        if (null != annotationValue) {
            messager.printMessage(kind, message, element, annotation, annotationValue);
        } else if (null != annotation) {
            messager.printMessage(kind, message, element, annotation);
        } else {
            messager.printMessage(kind, message, element);
        }
    }

    protected final void reportProfilerTimings() {
        if (this.isProfileEnabled()) {
            Messager messager = this.processingEnv.getMessager();
            ArrayList<StopWatch> stopWatches = new ArrayList<StopWatch>();
            stopWatches.add(this._emitJavaTypeStopWatch);
            stopWatches.add(this._extractDeferredStopWatch);
            stopWatches.add(this._validateElementStopWatch);
            this.collectStopWatches(stopWatches);
            messager.printMessage(Diagnostic.Kind.NOTE, this.getClass().getSimpleName() + " profiler timings");
            stopWatches.stream().sorted(Comparator.comparing(StopWatch::getTotalDuration).reversed()).forEach(stopWatch -> messager.printMessage(Diagnostic.Kind.NOTE, String.format("  %30s: %20d", stopWatch.getName(), stopWatch.getTotalDuration())));
        }
    }

    protected void collectStopWatches(@Nonnull Collection<StopWatch> stopWatches) {
    }

    private void doProcessTypeElements(@Nonnull RoundEnvironment env, @Nonnull Collection<TypeElement> elements, @Nonnull String label, @Nonnull Action<TypeElement> action, @Nonnull StopWatch actionStopWatch) {
        for (TypeElement element : elements) {
            this.performAction(env, label, action, element, actionStopWatch);
        }
    }

    protected final <E extends Element> void performAction(@Nonnull RoundEnvironment env, @Nonnull String label, @Nonnull Action<E> action, @Nonnull E element, @Nonnull StopWatch actionStopWatch) {
        this.debug(() -> "Performing '" + label + "' action on element " + element);
        try {
            if (this._profile) {
                actionStopWatch.start();
            }
            action.process(element);
            if (this._profile) {
                actionStopWatch.stop();
            }
        }
        catch (IOException ioe) {
            String message = "IO error running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state.\n\n\n" + this.printStackTrace(ioe);
            this.reportError(env, message, element);
        }
        catch (ProcessorException e) {
            Element errorLocation = e.getElement();
            if (this._verboseOutOfRoundErrors) {
                Element outerElement = ElementsUtil.getTopLevelElement(errorLocation);
                if (!env.getRootElements().contains(outerElement)) {
                    Object location;
                    if (errorLocation instanceof ExecutableElement) {
                        ExecutableElement executableElement = (ExecutableElement)errorLocation;
                        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
                        location = typeElement.getQualifiedName() + "." + executableElement.getSimpleName();
                    } else if (errorLocation instanceof VariableElement) {
                        VariableElement variableElement = (VariableElement)errorLocation;
                        Element enclosingElement = variableElement.getEnclosingElement();
                        if (enclosingElement instanceof TypeElement) {
                            TypeElement typeElement = (TypeElement)enclosingElement;
                            location = typeElement.getQualifiedName() + "." + variableElement.getSimpleName();
                        } else {
                            ExecutableElement executableElement = (ExecutableElement)enclosingElement;
                            TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
                            location = typeElement.getQualifiedName() + "." + executableElement.getSimpleName() + "(..." + variableElement.getSimpleName() + "...)";
                        }
                    } else {
                        assert (errorLocation instanceof TypeElement);
                        TypeElement typeElement = (TypeElement)errorLocation;
                        location = typeElement.getQualifiedName().toString();
                    }
                    StringWriter sw = new StringWriter();
                    this.processingEnv.getElementUtils().printElements(sw, errorLocation);
                    sw.flush();
                    String message = "An error was generated processing the element " + element.getSimpleName() + " but the error was triggered by code not currently being compiled but inherited or implemented by the element and may not be highlighted by your tooling or IDE. The error occurred at " + (String)location + " and may look like:\n" + sw.toString();
                    this.reportError(env, message, element);
                }
            }
            this.reportError(env, e.getMessage(), e.getElement(), e.getAnnotation(), e.getAnnotationValue());
        }
        catch (Throwable e) {
            String message = "There was an unexpected error running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state. If you believe this is an error with the " + this.getClass().getName() + " processor then please report the failure to the developers so that it can be fixed.\n Report the error at: " + this.getIssueTrackerURL() + "\n\n\n" + this.printStackTrace(e);
            this.reportError(env, message, element);
        }
    }

    @Nonnull
    private String printStackTrace(@Nonnull Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        sw.flush();
        return sw.toString();
    }

    @Nonnull
    private Collection<TypeElement> deriveElementsToProcess(@Nonnull DeferredElementSet deferredSet, @Nonnull Collection<TypeElement> elements) {
        if (this._profile) {
            this._extractDeferredStopWatch.start();
        }
        List<TypeElement> deferred = deferredSet.extractDeferred(this.processingEnv);
        if (this._profile) {
            this._extractDeferredStopWatch.stop();
        }
        ArrayList<TypeElement> elementsToProcess = new ArrayList<TypeElement>();
        this.collectElementsToProcess(elements, deferredSet, elementsToProcess);
        int scheduledFromThisRound = elementsToProcess.size();
        int deferredFromThisRound = deferredSet.getDeferred().size();
        this.debug(() -> scheduledFromThisRound + " elements from this round scheduled for processing, " + deferredFromThisRound + " elements from this round deferred for processing in a later round");
        this.collectElementsToProcess(deferred, deferredSet, elementsToProcess);
        int scheduledFromPreviousRounds = elementsToProcess.size() - scheduledFromThisRound;
        int deferredFromPreviousRounds = deferredSet.getDeferred().size() - deferredFromThisRound;
        this.debug(() -> scheduledFromPreviousRounds + " elements from previous rounds scheduled for processing, " + deferredFromPreviousRounds + " elements from previous rounds deferred for processing in a later round");
        return elementsToProcess;
    }

    private void collectElementsToProcess(@Nonnull Collection<TypeElement> elements, @Nonnull DeferredElementSet deferredSet, @Nonnull List<TypeElement> elementsToProcess) {
        for (TypeElement element : elements) {
            if (this._profile) {
                this._validateElementStopWatch.start();
            }
            boolean valid = SuperficialValidation.validateElement(this.processingEnv, element);
            if (this._profile) {
                this._validateElementStopWatch.stop();
            }
            if (valid) {
                this.debug(() -> "Scheduling element " + element + " for processing");
                elementsToProcess.add(element);
                continue;
            }
            this.debug(() -> "Deferring element " + element + " for processing in a later round as it failed superficial validation");
            deferredSet.deferElement(element);
        }
    }

    protected final boolean isProfileEnabled() {
        return this._profile;
    }

    protected final boolean isDebugEnabled() {
        return this._debug;
    }

    protected final void debug(@Nonnull Supplier<String> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, messageSupplier.get());
        }
    }

    protected final void emitTypeSpec(@Nonnull String packageName, @Nonnull TypeSpec typeSpec) throws IOException {
        if (this._profile) {
            this._emitJavaTypeStopWatch.start();
        }
        GeneratorUtil.emitJavaType(packageName, typeSpec, this.processingEnv.getFiler());
        if (this._profile) {
            this._emitJavaTypeStopWatch.stop();
        }
    }

    protected final boolean readBooleanOption(@Nonnull String relativeKey, boolean defaultValue) {
        String optionValue = this.processingEnv.getOptions().get(this.getOptionPrefix() + "." + relativeKey);
        return null == optionValue ? defaultValue : "true".equals(optionValue);
    }

    @FunctionalInterface
    public static interface Action<E extends Element> {
        public void process(@Nonnull E var1) throws Exception;
    }
}

