/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import react4j.processor.BuilderDescriptor;
import react4j.processor.ImmutableInputKeyStrategy;
import react4j.processor.InputDescriptor;
import react4j.processor.React4jProcessor;
import react4j.processor.Step;
import react4j.processor.StepMethod;
import react4j.processor.StepMethodType;
import react4j.processor.ViewDescriptor;
import react4j.processor.vendor.javapoet.ArrayTypeName;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.javapoet.TypeVariableName;
import react4j.processor.vendor.javapoet.WildcardTypeName;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.GeneratorUtil;
import react4j.processor.vendor.proton.SuppressWarningsUtil;

final class BuilderGenerator {
    @Nonnull
    private static final ClassName JS_ARRAY_CLASSNAME = ClassName.get("akasha.lang", "JsArray", new String[0]);
    @Nonnull
    private static final ClassName IDENTIFIABLE_CLASSNAME = ClassName.get("arez.component", "Identifiable", new String[0]);
    @Nonnull
    private static final ClassName REACT_ELEMENT_CLASSNAME = ClassName.get("react4j", "ReactElement", new String[0]);
    @Nonnull
    private static final ClassName CONTEXT_CLASSNAME = ClassName.get("react4j", "Context", new String[0]);
    @Nonnull
    private static final ClassName CONTEXT_RENDER_FUNCTION_CLASSNAME = ClassName.get("react4j", "Context", "ConsumerRenderFunction");
    @Nonnull
    private static final ClassName CONTEXTS_CLASSNAME = ClassName.get("react4j", "Contexts", new String[0]);
    @Nonnull
    private static final ClassName REACT_CLASSNAME = ClassName.get("react4j", "React", new String[0]);
    @Nonnull
    private static final ClassName KEYED_CLASSNAME = ClassName.get("react4j", "Keyed", new String[0]);
    @Nonnull
    private static final ClassName REACT_NODE_CLASSNAME = ClassName.get("react4j", "ReactNode", new String[0]);
    @Nonnull
    private static final ClassName JS_PROPERTY_MAP_CLASSNAME = ClassName.get("jsinterop.base", "JsPropertyMap", new String[0]);
    @Nonnull
    private static final ParameterizedTypeName JS_PROPERTY_MAP_T_OBJECT_CLASSNAME = ParameterizedTypeName.get(JS_PROPERTY_MAP_CLASSNAME, TypeName.OBJECT);
    @Nonnull
    private static final String CONTEXT_METHOD_PREFIX = "$context_";
    @Nonnull
    private static final String CONTEXT_FIELD_PREFIX = "_$context_";
    @Nonnull
    private static final String CONTEXT_INPUT_PREFIX = "CONTEXT_";
    @Nonnull
    private static final String CONTEXT_HOLDER = "ContextHolder";

    private BuilderGenerator() {
    }

    @Nonnull
    static TypeSpec buildType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ViewDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getBuilderClassName());
        GeneratorUtil.addOriginatingTypes(descriptor.getElement(), builder);
        GeneratorUtil.addGeneratedAnnotation(processingEnv, builder, React4jProcessor.class.getName());
        builder.addModifiers(Modifier.FINAL);
        GeneratorUtil.copyAccessModifiers(descriptor.getElement(), builder);
        GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)descriptor.getElement(), builder, Collections.singletonList(Deprecated.class.getName()));
        if (descriptor.builderAccessesDeprecatedElements()) {
            builder.addAnnotation(SuppressWarningsUtil.suppressWarningsAnnotation("deprecation"));
        }
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        BuilderDescriptor builderDescriptor = BuilderGenerator.buildBuilderDescriptor(descriptor);
        List<Step> steps = builderDescriptor.getSteps();
        builder.addMethod(BuilderGenerator.buildStaticNewBuilderMethod(descriptor));
        for (Step step : steps) {
            builder.addType(BuilderGenerator.buildBuilderStepInterface(processingEnv, descriptor, step));
        }
        BuilderGenerator.buildStaticStepMethodMethods(processingEnv, descriptor, builder, steps.get(0));
        if (descriptor.getInputs().stream().anyMatch(InputDescriptor::isContextSource)) {
            builder.addType(BuilderGenerator.buildContextHolder(descriptor));
        }
        builder.addType(BuilderGenerator.buildBuilder(processingEnv, descriptor, builderDescriptor));
        return builder.build();
    }

    private static void buildStaticStepMethodMethods(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ViewDescriptor descriptor, @Nonnull TypeSpec.Builder builder, @Nonnull Step step) {
        for (StepMethod method : step.getMethods()) {
            builder.addMethod(BuilderGenerator.buildStaticStepMethodMethod(processingEnv, descriptor, step, method));
        }
    }

    @Nonnull
    private static MethodSpec buildStaticNewBuilderMethod(@Nonnull ViewDescriptor descriptor) {
        String infix = descriptor.getDeclaredType().getTypeArguments().isEmpty() ? "" : "<>";
        MethodSpec.Builder method = MethodSpec.methodBuilder("newBuilder").addModifiers(Modifier.PRIVATE, Modifier.STATIC).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).returns(BuilderGenerator.parameterizeIfRequired(descriptor, ClassName.bestGuess("Step1"))).addStatement("return new $T" + infix + "()", ClassName.bestGuess("Builder"));
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), method);
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildStaticStepMethodMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ViewDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName()).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
        method.addModifiers(Modifier.STATIC);
        if (descriptor.getDeclaredType().asElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            method.addModifiers(Modifier.PUBLIC);
        }
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), method);
        if (stepMethod.isBuildIntrinsic()) {
            method.addStatement("return newBuilder().build()", new Object[0]);
        } else {
            TypeName type = stepMethod.getType();
            ParameterSpec.Builder parameter = ParameterSpec.builder(type, stepMethod.getName(), Modifier.FINAL);
            ExecutableElement inputMethod = stepMethod.getMethod();
            if (null != inputMethod) {
                GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)inputMethod, parameter);
                ExecutableType methodType = stepMethod.getMethodType();
                assert (null != methodType);
                SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, parameter, methodType.getReturnType());
            } else if (stepMethod.isChildrenStreamIntrinsic()) {
                parameter.addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
            }
            if (type instanceof ArrayTypeName) {
                method.varargs();
            }
            method.addParameter(parameter.build());
            String infix = BuilderGenerator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            if (infix.isEmpty()) {
                method.addStatement("return newBuilder().$N( $N )", stepMethod.getName(), stepMethod.getName());
            } else {
                method.addStatement("return $T." + infix + "newBuilder().$N( $N )", descriptor.getBuilderClassName(), stepMethod.getName(), stepMethod.getName());
            }
        }
        BuilderGenerator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildStepInterfaceMethod(@Nonnull ViewDescriptor descriptor, @Nonnull String name, @Nonnull Step step, @Nonnull StepMethodType stepMethodType, @Nonnull Consumer<MethodSpec.Builder> action) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(name);
        method.addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
        method.addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
        action.accept(method);
        BuilderGenerator.configureStepMethodReturns(descriptor, method, step, stepMethodType);
        return method;
    }

    private static void configureStepMethodReturns(@Nonnull ViewDescriptor descriptor, @Nonnull MethodSpec.Builder method, @Nonnull Step step, @Nonnull StepMethodType stepMethodType) {
        if (StepMethodType.TERMINATE == stepMethodType) {
            method.returns(REACT_NODE_CLASSNAME);
        } else {
            int returnIndex = step.getIndex() + (StepMethodType.STAY == stepMethodType ? 0 : 1);
            method.returns(BuilderGenerator.parameterizeIfRequired(descriptor, ClassName.bestGuess("Step" + returnIndex)));
        }
    }

    @Nonnull
    private static TypeName parameterizeIfRequired(@Nonnull ViewDescriptor descriptor, @Nonnull ClassName className) {
        List<TypeVariableName> variableNames = GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType());
        if (variableNames.isEmpty()) {
            return className;
        }
        return ParameterizedTypeName.get(className, variableNames.toArray(new TypeName[0]));
    }

    @Nonnull
    private static TypeSpec buildBuilderStepInterface(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ViewDescriptor descriptor, @Nonnull Step step) {
        int stepIndex = step.getIndex();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("Step" + stepIndex);
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builder.addTypeVariables(GeneratorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        if (!descriptor.getDeclaredType().getTypeArguments().isEmpty()) {
            builder.addAnnotation(SuppressWarningsUtil.suppressWarningsAnnotation("unused"));
        }
        for (StepMethod stepMethod : step.getMethods()) {
            StepMethodType stepMethodType = stepMethod.getStepMethodType();
            if (stepMethod.isBuildIntrinsic()) {
                builder.addMethod(BuilderGenerator.buildStepInterfaceMethod(descriptor, "build", step, stepMethodType, m -> {}).build());
                continue;
            }
            builder.addMethod(BuilderGenerator.buildStepInterfaceMethod(descriptor, stepMethod.getName(), step, stepMethodType, m -> {
                TypeName type;
                ExecutableType inputMethodType = stepMethod.getMethodType();
                if (null != inputMethodType) {
                    GeneratorUtil.copyTypeParameters(inputMethodType, m);
                }
                if (stepMethod.isChildrenIntrinsic()) {
                    m.varargs();
                }
                if ((type = stepMethod.getType()) instanceof ArrayTypeName) {
                    m.varargs();
                }
                ParameterSpec.Builder parameter = ParameterSpec.builder(type, stepMethod.getName(), new Modifier[0]);
                ExecutableElement inputMethod = stepMethod.getMethod();
                if (null != inputMethod) {
                    GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)inputMethod, parameter);
                    ExecutableType methodType = stepMethod.getMethodType();
                    assert (null != methodType);
                    SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, parameter, methodType.getReturnType());
                } else if (stepMethod.isChildrenStreamIntrinsic()) {
                    parameter.addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
                }
                m.addParameter(parameter.build());
            }).build());
        }
        return builder.build();
    }

    @Nonnull
    private static MethodSpec buildBuilderStepImpl(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ViewDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        ExecutableElement inputMethod;
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName());
        method.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        method.addAnnotation(Override.class);
        method.addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
        InputDescriptor input = stepMethod.getInput();
        ExecutableType inputMethodType = stepMethod.getMethodType();
        if (null != inputMethodType) {
            GeneratorUtil.copyTypeParameters(inputMethodType, method);
        }
        TypeName type = stepMethod.getType();
        ParameterSpec.Builder parameter = ParameterSpec.builder(type, stepMethod.getName(), Modifier.FINAL);
        if (type instanceof ArrayTypeName) {
            method.varargs();
        }
        if (null != (inputMethod = stepMethod.getMethod())) {
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)inputMethod, parameter);
            ExecutableType methodType = stepMethod.getMethodType();
            assert (null != methodType);
            SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, parameter, methodType.getReturnType());
        } else if (stepMethod.isChildrenStreamIntrinsic()) {
            parameter.addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
        }
        method.addParameter(parameter.build());
        if (null != input && input.isImmutable() && 1 == descriptor.syntheticKeyParts()) {
            ImmutableInputKeyStrategy strategy = input.getImmutableInputKeyStrategy();
            if (ImmutableInputKeyStrategy.KEYED == strategy) {
                method.addStatement("_element.setKey( $T.getKey( $N ) + ( $T.enableViewNames() ? $S : $T.class.getName() ) )", KEYED_CLASSNAME, stepMethod.getName(), REACT_CLASSNAME, descriptor.keySuffix(), descriptor.getClassName());
            } else if (ImmutableInputKeyStrategy.IS_STRING == strategy || ImmutableInputKeyStrategy.TO_STRING == strategy || ImmutableInputKeyStrategy.ENUM == strategy) {
                method.addStatement("_element.setKey( $N + ( $T.enableViewNames() ? $S : $T.class.getName() ) )", stepMethod.getName(), REACT_CLASSNAME, descriptor.keySuffix(), descriptor.getClassName());
            } else if (ImmutableInputKeyStrategy.DYNAMIC == strategy) {
                method.addStatement("_element.setKey( ( $N instanceof $T ? $T.getKey( $N ) : $N instanceof $T ? $T.<$T>getArezId( $N ) : $T.valueOf( $N ) ) + ( $T.enableViewNames() ? $S : $T.class.getName() ) )", stepMethod.getName(), KEYED_CLASSNAME, KEYED_CLASSNAME, stepMethod.getName(), stepMethod.getName(), IDENTIFIABLE_CLASSNAME, IDENTIFIABLE_CLASSNAME, Object.class, stepMethod.getName(), String.class, stepMethod.getName(), REACT_CLASSNAME, descriptor.keySuffix(), descriptor.getClassName());
            } else {
                assert (ImmutableInputKeyStrategy.AREZ_IDENTIFIABLE == strategy);
                method.addStatement("_element.setKey( $T.<Object>getArezId( $N ) + ( $T.enableViewNames() ? $S : $T.class.getName() ) )", IDENTIFIABLE_CLASSNAME, stepMethod.getName(), REACT_CLASSNAME, descriptor.keySuffix(), descriptor.getClassName());
            }
        }
        if (stepMethod.isChildrenIntrinsic()) {
            method.varargs();
            assert (null != input);
            method.addStatement("_element.input( $T.Inputs.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), input.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
        } else if (stepMethod.isChildrenStreamIntrinsic()) {
            method.addStatement("children( $N.toArray( $T[]::new ) )", stepMethod.getName(), REACT_NODE_CLASSNAME);
        } else if (stepMethod.isChildIntrinsic()) {
            assert (null != inputMethod);
            assert (null != input);
            if (AnnotationsUtil.hasNonnullAnnotation(inputMethod)) {
                method.addStatement("_element.input( $T.Inputs.$N, $T.of( $T.requireNonNull( $N ) ) )", descriptor.getEnhancedClassName(), input.getConstantName(), JS_ARRAY_CLASSNAME, Objects.class, stepMethod.getName());
            } else {
                method.addStatement("_element.input( $T.Inputs.$N, $T.of( $N ) )", descriptor.getEnhancedClassName(), input.getConstantName(), JS_ARRAY_CLASSNAME, stepMethod.getName());
            }
        } else {
            if (null != inputMethod && AnnotationsUtil.hasNonnullAnnotation(inputMethod) && !type.isPrimitive()) {
                method.addStatement("$T.requireNonNull( $N )", Objects.class, stepMethod.getName());
            }
            assert (null != input);
            method.addStatement("_element.input( $T.Inputs.$N, $N )", descriptor.getEnhancedClassName(), input.getConstantName(), stepMethod.getName());
        }
        if (StepMethodType.TERMINATE == stepMethod.getStepMethodType()) {
            method.addStatement("return build()", new Object[0]);
        } else {
            method.addStatement("return this", new Object[0]);
        }
        BuilderGenerator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildBuildStepImpl(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
        return BuilderGenerator.buildBuildMethodContent(descriptor, method, "_element");
    }

    @Nonnull
    private static FieldSpec buildContextBuildField(@Nonnull InputDescriptor current) {
        ParameterizedTypeName typeName = ParameterizedTypeName.get(CONTEXT_RENDER_FUNCTION_CLASSNAME, TypeName.get(current.getMethod().getReturnType()).box());
        return FieldSpec.builder(typeName, CONTEXT_FIELD_PREFIX + current.getName(), Modifier.PRIVATE, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).initializer("this::$N", CONTEXT_METHOD_PREFIX + current.getName()).build();
    }

    @Nonnull
    private static MethodSpec buildContextBuildStepImpl(@Nonnull ViewDescriptor descriptor, @Nonnull InputDescriptor current, @Nullable InputDescriptor next) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(CONTEXT_METHOD_PREFIX + current.getName()).addModifiers(Modifier.PRIVATE).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).returns(REACT_NODE_CLASSNAME).addParameter(ParameterSpec.builder(TypeName.get(current.getMethod().getReturnType()), current.getName(), Modifier.FINAL).build()).addStatement("_element.input( $T.Inputs.$N, $N )", descriptor.getEnhancedClassName(), current.getConstantName(), current.getName());
        if (null == next) {
            method.addStatement("return build( _element.dup() )", new Object[0]);
        } else {
            method.addStatement("return $T.$N.consumer().render( $N )", ClassName.bestGuess(CONTEXT_HOLDER), CONTEXT_INPUT_PREFIX + next.getConstantName(), CONTEXT_FIELD_PREFIX + next.getName());
        }
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildContextBuildStepImpl(@Nonnull InputDescriptor firstContextInput) {
        return MethodSpec.methodBuilder("build").addModifiers(Modifier.PUBLIC, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).returns(REACT_NODE_CLASSNAME).addStatement("return $T.$N.consumer().render( $N )", ClassName.bestGuess(CONTEXT_HOLDER), CONTEXT_INPUT_PREFIX + firstContextInput.getConstantName(), CONTEXT_FIELD_PREFIX + firstContextInput.getName()).build();
    }

    @Nonnull
    private static MethodSpec buildInternalBuildStepImpl(@Nonnull ViewDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("build").addModifiers(Modifier.PRIVATE).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).addParameter(ParameterSpec.builder(REACT_ELEMENT_CLASSNAME, "element", Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME).build());
        return BuilderGenerator.buildBuildMethodContent(descriptor, method, "element");
    }

    @Nonnull
    private static MethodSpec buildBuildMethodContent(@Nonnull ViewDescriptor descriptor, @Nonnull MethodSpec.Builder method, @Nonnull String elementName) {
        List<InputDescriptor> syntheticInputs = descriptor.getInputs().stream().filter(InputDescriptor::isImmutable).toList();
        if (syntheticInputs.size() > 1) {
            method.addStatement("final $T inputs = $N.inputs()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, elementName);
            for (InputDescriptor input : syntheticInputs) {
                if (ImmutableInputKeyStrategy.DYNAMIC != input.getImmutableInputKeyStrategy()) continue;
                method.addStatement("final $T $N = inputs.get( $T.Inputs.$N )", Object.class, "$" + input.getName() + "$", descriptor.getEnhancedClassName(), input.getConstantName());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("$N.setKey( ");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(elementName);
            boolean firstInput = true;
            for (InputDescriptor input : syntheticInputs) {
                if (!firstInput) {
                    sb.append(" + \"-\" + ");
                } else {
                    firstInput = false;
                }
                ImmutableInputKeyStrategy strategy = input.getImmutableInputKeyStrategy();
                if (ImmutableInputKeyStrategy.KEYED == strategy) {
                    sb.append("$T.getKey( ($T) inputs.get( $T.Inputs.$N ) )");
                    params.add(KEYED_CLASSNAME);
                    params.add(input.getMethodType().getReturnType());
                    params.add(descriptor.getEnhancedClassName());
                    params.add(input.getConstantName());
                    continue;
                }
                if (ImmutableInputKeyStrategy.IS_STRING == strategy || ImmutableInputKeyStrategy.ENUM == strategy) {
                    sb.append("( ($T) inputs.get( $T.Inputs.$N ) )");
                    params.add(input.getMethodType().getReturnType());
                    params.add(descriptor.getEnhancedClassName());
                    params.add(input.getConstantName());
                    continue;
                }
                if (ImmutableInputKeyStrategy.TO_STRING == strategy) {
                    TypeMirror inputType = input.getMethodType().getReturnType();
                    TypeKind kind = inputType.getKind();
                    if (TypeKind.INT == kind || TypeKind.SHORT == kind || TypeKind.BYTE == kind || TypeKind.FLOAT == kind) {
                        sb.append("$T.valueOf( ($T) (double) inputs.get( $T.Inputs.$N ) )");
                    } else {
                        sb.append("$T.valueOf( ($T) inputs.get( $T.Inputs.$N ) )");
                    }
                    params.add(String.class);
                    params.add(inputType);
                    params.add(descriptor.getEnhancedClassName());
                    params.add(input.getConstantName());
                    continue;
                }
                if (ImmutableInputKeyStrategy.DYNAMIC == strategy) {
                    String name = "$" + input.getName() + "$";
                    sb.append("( $N instanceof $T ? $T.getKey( $N ) : $N instanceof $T ? $T.<$T>getArezId( $N ) : $T.valueOf( $N ) )");
                    params.add(name);
                    params.add(KEYED_CLASSNAME);
                    params.add(KEYED_CLASSNAME);
                    params.add(name);
                    params.add(name);
                    params.add(IDENTIFIABLE_CLASSNAME);
                    params.add(IDENTIFIABLE_CLASSNAME);
                    params.add(Object.class);
                    params.add(name);
                    params.add(String.class);
                    params.add(name);
                    continue;
                }
                assert (ImmutableInputKeyStrategy.AREZ_IDENTIFIABLE == strategy);
                sb.append("$T.valueOf( $T.<$T>getArezId( ($T) inputs.get( $T.Inputs.$N ) ) )");
                params.add(String.class);
                params.add(IDENTIFIABLE_CLASSNAME);
                params.add(Object.class);
                params.add(input.getMethodType().getReturnType());
                params.add(descriptor.getEnhancedClassName());
                params.add(input.getConstantName());
            }
            sb.append(" + ( $T.enableViewNames() ? $S : $T.class.getName() ) )");
            params.add(REACT_CLASSNAME);
            params.add(descriptor.keySuffix());
            params.add(descriptor.getClassName());
            method.addStatement(sb.toString(), params.toArray());
        }
        method.addStatement("return $N", elementName).returns(REACT_NODE_CLASSNAME);
        return method.build();
    }

    @Nonnull
    private static TypeSpec buildContextHolder(@Nonnull ViewDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(CONTEXT_HOLDER);
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PRIVATE, Modifier.STATIC);
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        List<InputDescriptor> contextInputs = descriptor.getInputs().stream().filter(InputDescriptor::isContextSource).toList();
        for (InputDescriptor input : contextInputs) {
            TypeName type = TypeName.get(input.getMethodType().getReturnType()).box();
            FieldSpec.Builder field = FieldSpec.builder(ParameterizedTypeName.get(CONTEXT_CLASSNAME, type), CONTEXT_INPUT_PREFIX + input.getConstantName(), Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
            String qualifier = input.getQualifier();
            if (qualifier.isEmpty()) {
                field.initializer("$T.get( $T.class )", CONTEXTS_CLASSNAME, type);
            } else {
                field.initializer("$T.get( $T.class, $S )", CONTEXTS_CLASSNAME, type, qualifier);
            }
            builder.addField(field.build());
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildBuilder(@Nonnull ProcessingEnvironment processingEnv, @Nonnull ViewDescriptor descriptor, @Nonnull BuilderDescriptor builderDescriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Builder");
        GeneratorUtil.copyTypeParameters(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PRIVATE, Modifier.STATIC);
        List<Step> steps = builderDescriptor.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            builder.addSuperinterface(BuilderGenerator.getParameterizedTypeName(descriptor, ClassName.bestGuess("Step" + (i + 1))));
        }
        List<InputDescriptor> inputsWithDefaults = descriptor.getInputs().stream().filter(p -> p.hasDefaultField() || p.hasDefaultMethod()).toList();
        if (!inputsWithDefaults.isEmpty()) {
            MethodSpec.Builder method = MethodSpec.constructorBuilder();
            method.addStatement("_element = $T.createViewElement( $T.Factory.TYPE )", REACT_ELEMENT_CLASSNAME, descriptor.getEnhancedClassName());
            method.addStatement("final $T inputs = _element.inputs()", JS_PROPERTY_MAP_T_OBJECT_CLASSNAME);
            for (InputDescriptor input : inputsWithDefaults) {
                method.addStatement("inputs.set( $T.Inputs.$N, $T.$N" + (input.hasDefaultField() ? "" : "()") + " )", descriptor.getEnhancedClassName(), input.getConstantName(), descriptor.getClassName(), input.hasDefaultField() ? input.getDefaultField().getSimpleName() : input.getDefaultMethod().getSimpleName());
            }
            builder.addMethod(method.build());
        }
        HashSet<CallSite> stepMethodsAdded = new HashSet<CallSite>();
        for (Step step : steps) {
            for (StepMethod stepMethod : step.getMethods()) {
                if (!stepMethodsAdded.add((CallSite)((Object)(stepMethod.getName() + stepMethod.getType()))) || stepMethod.isBuildIntrinsic()) continue;
                builder.addMethod(BuilderGenerator.buildBuilderStepImpl(processingEnv, descriptor, step, stepMethod));
            }
        }
        FieldSpec.Builder field = FieldSpec.builder(REACT_ELEMENT_CLASSNAME, "_element", Modifier.PRIVATE, Modifier.FINAL).addAnnotation(GeneratorUtil.NONNULL_CLASSNAME);
        if (inputsWithDefaults.isEmpty()) {
            field.initializer("$T.createViewElement( $T.Factory.TYPE )", REACT_ELEMENT_CLASSNAME, descriptor.getEnhancedClassName());
        }
        builder.addField(field.build());
        List<InputDescriptor> contextInputs = descriptor.getInputs().stream().filter(InputDescriptor::isContextSource).toList();
        if (!contextInputs.isEmpty()) {
            builder.addMethod(BuilderGenerator.buildInternalBuildStepImpl(descriptor));
            builder.addMethod(BuilderGenerator.buildContextBuildStepImpl(contextInputs.get(0)));
            int size = contextInputs.size();
            for (int i = 0; i < size; ++i) {
                InputDescriptor current = contextInputs.get(i);
                InputDescriptor next = i == size - 1 ? null : contextInputs.get(i + 1);
                builder.addField(BuilderGenerator.buildContextBuildField(current));
                builder.addMethod(BuilderGenerator.buildContextBuildStepImpl(descriptor, current, next));
            }
        } else {
            builder.addMethod(BuilderGenerator.buildBuildStepImpl(descriptor));
        }
        return builder.build();
    }

    @Nonnull
    private static TypeName getParameterizedTypeName(@Nonnull ViewDescriptor descriptor, @Nonnull ClassName baseName) {
        List<? extends TypeMirror> arguments = descriptor.getDeclaredType().getTypeArguments();
        if (arguments.isEmpty()) {
            return baseName;
        }
        return ParameterizedTypeName.get(baseName, (TypeName[])arguments.stream().map(TypeName::get).toArray(TypeName[]::new));
    }

    static String asTypeArgumentsInfix(DeclaredType declaredType) {
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        return typeArguments.isEmpty() ? "" : "<" + typeArguments.stream().map(TypeMirror::toString).collect(Collectors.joining(", ")) + ">";
    }

    @Nonnull
    private static BuilderDescriptor buildBuilderDescriptor(@Nonnull ViewDescriptor descriptor) {
        BuilderDescriptor builder = new BuilderDescriptor();
        Step optionalInputStep = null;
        List<InputDescriptor> inputs = descriptor.getInputs().stream().filter(p -> !p.isContextSource()).toList();
        int inputsSize = inputs.size();
        boolean hasSingleOptional = inputs.stream().filter(InputDescriptor::isOptional).count() == 1L;
        boolean hasNonOptionalChild = inputs.stream().filter(i -> i.isSpecialChildrenInput() && !i.isOptional()).count() == 1L;
        boolean hasRequiredAfterOptional = false;
        for (int i2 = 0; i2 < inputsSize; ++i2) {
            boolean isLast;
            InputDescriptor input = inputs.get(i2);
            boolean bl = isLast = i2 == inputsSize - 1;
            if (input.isOptional()) {
                if (null == optionalInputStep) {
                    optionalInputStep = builder.addStep();
                }
                if (input.getName().equals("children")) {
                    BuilderGenerator.addChildrenStreamInputStepMethod(optionalInputStep);
                }
                if (hasNonOptionalChild) {
                    optionalInputStep.addMethod(input, hasSingleOptional ? StepMethodType.ADVANCE : StepMethodType.STAY);
                    continue;
                }
                optionalInputStep.addMethod(input, hasSingleOptional ? StepMethodType.TERMINATE : StepMethodType.STAY);
                continue;
            }
            if (null != optionalInputStep) {
                optionalInputStep.addMethod(input, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
                if (input.getName().equals("children")) {
                    BuilderGenerator.addChildrenStreamInputStepMethod(optionalInputStep);
                }
                hasRequiredAfterOptional = true;
            }
            Step step = builder.addStep();
            step.addMethod(input, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
            if (!input.getName().equals("children")) continue;
            BuilderGenerator.addChildrenStreamInputStepMethod(step);
            BuilderGenerator.addBuildStep(step);
        }
        if (null != optionalInputStep && !hasRequiredAfterOptional) {
            BuilderGenerator.addBuildStep(optionalInputStep);
        }
        if (inputs.isEmpty()) {
            BuilderGenerator.addBuildStep(builder.addStep());
        }
        return builder;
    }

    private static void addBuildStep(@Nonnull Step step) {
        step.addTerminalMethod("build", "build", REACT_NODE_CLASSNAME);
    }

    private static void addChildrenStreamInputStepMethod(@Nonnull Step step) {
        ParameterizedTypeName typeName = ParameterizedTypeName.get(ClassName.get(Stream.class), WildcardTypeName.subtypeOf(REACT_NODE_CLASSNAME));
        step.addTerminalMethod("children", "*children_stream*", typeName);
    }
}

