/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import react4j.processor.InputComparator;
import react4j.processor.InputDescriptor;
import react4j.processor.OnInputChangeDescriptor;
import react4j.processor.PublishDescriptor;
import react4j.processor.RenderHookDescriptor;
import react4j.processor.ScheduleRenderDescriptor;
import react4j.processor.ViewType;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.proton.GeneratorUtil;
import react4j.processor.vendor.proton.MemberChecks;
import react4j.processor.vendor.proton.ProcessorException;

final class ViewDescriptor {
    @Nonnull
    private final String _name;
    @Nonnull
    private final TypeElement _element;
    @Nonnull
    private final ViewType _type;
    private final boolean _sting;
    private final boolean _hasConstructor;
    private final boolean _hasPostConstruct;
    private final boolean _shouldSetDefaultPriority;
    @Nonnull
    private final ExecutableElement _constructor;
    @Nullable
    private ExecutableElement _render;
    @Nullable
    private ExecutableElement _preUpdate;
    @Nullable
    private ExecutableElement _postRender;
    @Nullable
    private ExecutableElement _postUpdate;
    @Nullable
    private ExecutableElement _postMount;
    @Nullable
    private ExecutableElement _onError;
    @Nullable
    private List<InputDescriptor> _inputs;
    @Nullable
    private List<OnInputChangeDescriptor> _onInputChangeDescriptors;
    @Nullable
    private List<ScheduleRenderDescriptor> _scheduleRenderDescriptors;
    @Nullable
    private List<PublishDescriptor> _publishDescriptors;
    @Nullable
    private List<RenderHookDescriptor> _preRenderHooks;
    @Nullable
    private List<RenderHookDescriptor> _postRenderHooks;
    @Nullable
    private Boolean _validateInputs;
    @Nullable
    private Boolean _viewAccessesDeprecatedElements;
    @Nullable
    private Boolean _builderAccessesDeprecatedElements;
    @Nullable
    private Boolean _hasDependencyInput;

    ViewDescriptor(@Nonnull String name, @Nonnull TypeElement element, @Nonnull ExecutableElement constructor, @Nonnull ViewType type, boolean sting, boolean hasConstructor, boolean hasPostConstruct, boolean shouldSetDefaultPriority) {
        this._name = Objects.requireNonNull(name);
        this._element = Objects.requireNonNull(element);
        this._constructor = Objects.requireNonNull(constructor);
        this._type = Objects.requireNonNull(type);
        this._sting = sting;
        this._hasConstructor = hasConstructor;
        this._hasPostConstruct = hasPostConstruct;
        this._shouldSetDefaultPriority = shouldSetDefaultPriority;
    }

    @Nonnull
    String keySuffix() {
        return "_" + this._element.getSimpleName() + "_" + this.shortSha(this._element.getQualifiedName().toString());
    }

    @Nonnull
    ExecutableElement getConstructor() {
        return this._constructor;
    }

    private boolean hasConstructorParams() {
        return !this._constructor.getParameters().isEmpty();
    }

    boolean enableSting() {
        return this._sting;
    }

    boolean hasConstructor() {
        return this._hasConstructor;
    }

    boolean hasPostConstruct() {
        return this._hasPostConstruct;
    }

    boolean shouldSetDefaultPriority() {
        return this._shouldSetDefaultPriority;
    }

    boolean requireRender() {
        return ViewType.NO_RENDER != this._type;
    }

    @Nonnull
    String getPackageName() {
        return GeneratorUtil.getQualifiedPackageName(this._element);
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    ClassName getClassName() {
        return ClassName.get(this.getElement());
    }

    @Nonnull
    TypeElement getElement() {
        return this._element;
    }

    @Nonnull
    DeclaredType getDeclaredType() {
        return (DeclaredType)this._element.asType();
    }

    @Nonnull
    ClassName getEnhancedClassName() {
        return GeneratorUtil.getGeneratedClassName(this._element, "React4j_", "");
    }

    @Nonnull
    ClassName getBuilderClassName() {
        return GeneratorUtil.getGeneratedClassName(this._element, "", "Builder");
    }

    @Nonnull
    ClassName getFactoryClassName() {
        return GeneratorUtil.getGeneratedClassName(this._element, "", "Factory");
    }

    @Nonnull
    ClassName getArezClassName() {
        String simpleName = "Arez_" + GeneratorUtil.getGeneratedSimpleClassName(this._element, "React4j_", "");
        return ClassName.get(this.getPackageName(), simpleName, new String[0]);
    }

    @Nonnull
    TypeName getViewType() {
        List<TypeName> typeNames = this.getDeclaredType().getTypeArguments().stream().map(TypeName::get).collect(Collectors.toList());
        if (!typeNames.isEmpty()) {
            return ParameterizedTypeName.get(ClassName.get(this.getElement()), typeNames.toArray(new TypeName[0]));
        }
        return ClassName.get(this.getElement());
    }

    boolean needsInjection() {
        return this.hasConstructorParams();
    }

    boolean trackRender() {
        return (ViewType.MAYBE_TRACKING == this._type || ViewType.TRACKING == this._type) && this.hasRender();
    }

    @Nonnull
    ViewType getType() {
        return this._type;
    }

    int syntheticKeyParts() {
        return (int)this.getInputs().stream().filter(InputDescriptor::isImmutable).count();
    }

    boolean hasDependencyInput() {
        if (null == this._hasDependencyInput) {
            assert (null != this._inputs);
            this._hasDependencyInput = this._inputs.stream().anyMatch(InputDescriptor::isDependency);
        }
        return this._hasDependencyInput;
    }

    @Nonnull
    List<InputDescriptor> getImmutableInputs() {
        assert (null != this._inputs);
        return this._inputs.stream().filter(InputDescriptor::isImmutable).collect(Collectors.toList());
    }

    @Nonnull
    List<InputDescriptor> getInputs() {
        assert (null != this._inputs);
        return this._inputs;
    }

    void setInputs(@Nonnull List<InputDescriptor> events) {
        this._inputs = Objects.requireNonNull(events);
    }

    @Nullable
    InputDescriptor findInputNamed(@Nonnull String name) {
        return this.getInputs().stream().filter(p -> p.getName().equals(name)).findAny().orElse(null);
    }

    void sortInputs() {
        assert (null != this._inputs);
        this._inputs.sort(InputComparator.COMPARATOR);
    }

    @Nonnull
    List<OnInputChangeDescriptor> getPreUpdateOnInputChangeDescriptors() {
        return this.getOnInputChangeDescriptors().stream().filter(OnInputChangeDescriptor::isPreUpdate).collect(Collectors.toList());
    }

    @Nonnull
    List<OnInputChangeDescriptor> getPostUpdateOnInputChangeDescriptors() {
        return this.getOnInputChangeDescriptors().stream().filter(o -> !o.isPreUpdate()).collect(Collectors.toList());
    }

    @Nonnull
    private List<OnInputChangeDescriptor> getOnInputChangeDescriptors() {
        assert (null != this._onInputChangeDescriptors);
        return this._onInputChangeDescriptors;
    }

    void setOnInputChangeDescriptors(@Nonnull List<OnInputChangeDescriptor> onInputChangeDescriptors) {
        this._onInputChangeDescriptors = Objects.requireNonNull(onInputChangeDescriptors);
    }

    @Nonnull
    List<ScheduleRenderDescriptor> getScheduleRenderDescriptors() {
        assert (null != this._scheduleRenderDescriptors);
        return this._scheduleRenderDescriptors;
    }

    void setScheduleRenderDescriptors(@Nonnull List<ScheduleRenderDescriptor> scheduleRenderDescriptors) {
        this._scheduleRenderDescriptors = Objects.requireNonNull(scheduleRenderDescriptors);
    }

    @Nonnull
    List<PublishDescriptor> getPublishDescriptors() {
        assert (null != this._publishDescriptors);
        return this._publishDescriptors;
    }

    void setPublishDescriptors(@Nonnull List<PublishDescriptor> publishDescriptors) {
        this._publishDescriptors = Objects.requireNonNull(publishDescriptors);
    }

    @Nonnull
    List<RenderHookDescriptor> getPreRenderDescriptors() {
        assert (null != this._preRenderHooks);
        return this._preRenderHooks;
    }

    void setPreRenderDescriptors(@Nonnull List<RenderHookDescriptor> preRenderDescriptors) {
        this._preRenderHooks = Objects.requireNonNull(preRenderDescriptors);
    }

    @Nonnull
    List<RenderHookDescriptor> getPostRenderDescriptors() {
        assert (null != this._postRenderHooks);
        return this._postRenderHooks;
    }

    void setPostRenderDescriptors(@Nonnull List<RenderHookDescriptor> postRenderDescriptors) {
        this._postRenderHooks = Objects.requireNonNull(postRenderDescriptors);
    }

    boolean hasObservableInputs() {
        return this.getInputs().stream().anyMatch(InputDescriptor::isObservable);
    }

    @Nullable
    ExecutableElement getPreUpdate() {
        return this._preUpdate;
    }

    void setPreUpdate(@Nonnull ExecutableElement preUpdate) throws ProcessorException {
        if (null != this._preUpdate) {
            throw new ProcessorException("@PreUpdate target duplicates existing method named " + this._preUpdate.getSimpleName(), preUpdate);
        }
        this._preUpdate = preUpdate;
    }

    boolean shouldGenerateRender() {
        assert (null != this._preRenderHooks);
        assert (null != this._postRenderHooks);
        return this.hasRender() || !this._preRenderHooks.isEmpty() || !this._postRenderHooks.isEmpty();
    }

    boolean hasRender() {
        return null != this._render;
    }

    @Nonnull
    ExecutableElement getRender() {
        assert (null != this._render);
        return this._render;
    }

    void setRender(@Nonnull ExecutableElement render) {
        if (null != this._render) {
            throw new ProcessorException(MemberChecks.mustNot("react4j.annotations.Render", "be present when another method named " + this._render.getSimpleName() + " exists with the same annotation"), render);
        }
        this._render = Objects.requireNonNull(render);
    }

    @Nullable
    ExecutableElement getPostRender() {
        return this._postRender;
    }

    void setPostRender(@Nonnull ExecutableElement postRender) throws ProcessorException {
        if (null != this._postRender) {
            throw new ProcessorException("@PostMountOrUpdate target duplicates existing method named " + this._postRender.getSimpleName(), postRender);
        }
        this._postRender = postRender;
    }

    @Nullable
    ExecutableElement getPostUpdate() {
        return this._postUpdate;
    }

    void setPostUpdate(@Nonnull ExecutableElement postUpdate) throws ProcessorException {
        if (null != this._postUpdate) {
            throw new ProcessorException("@PostUpdate target duplicates existing method named " + this._postUpdate.getSimpleName(), postUpdate);
        }
        this._postUpdate = postUpdate;
    }

    @Nullable
    ExecutableElement getPostMount() {
        return this._postMount;
    }

    void setPostMount(@Nonnull ExecutableElement postMount) throws ProcessorException {
        if (null != this._postMount) {
            throw new ProcessorException("@PostMount target duplicates existing method named " + this._postMount.getSimpleName(), postMount);
        }
        this._postMount = postMount;
    }

    @Nullable
    ExecutableElement getOnError() {
        return this._onError;
    }

    void setOnError(@Nonnull ExecutableElement onError) throws ProcessorException {
        if (null != this._onError) {
            throw new ProcessorException("@OnError target duplicates existing method named " + this._onError.getSimpleName(), onError);
        }
        this._onError = onError;
    }

    private boolean shouldGenerateLifecycle() {
        return this.generateComponentDidMount() || this.generateShouldComponentUpdate() || this.generateComponentPreUpdate() || this.generateComponentDidUpdate() || this.generateComponentWillUnmount() || this.generateComponentDidCatch();
    }

    boolean shouldGenerateLiteLifecycle() {
        return (this.generateComponentDidUpdateInLiteLifecycle() != this.generateComponentDidUpdate() || this.generateComponentWillUnmountInLiteLifecycle() != this.generateComponentWillUnmount() || this.generateShouldComponentUpdateInLiteLifecycle() != this.generateShouldComponentUpdate() || this.generateComponentDidMountInLiteLifecycle() != this.generateComponentDidMount()) && this.shouldGenerateLifecycle();
    }

    boolean generateShouldComponentUpdate() {
        return this.generateShouldComponentUpdateInLiteLifecycle() || this.shouldValidateInputs();
    }

    boolean generateShouldComponentUpdateInLiteLifecycle() {
        return true;
    }

    boolean generateComponentDidCatch() {
        return null != this._onError;
    }

    boolean generateComponentWillUnmountInLiteLifecycle() {
        return true;
    }

    boolean generateComponentWillUnmount() {
        return true;
    }

    boolean generateComponentPreUpdate() {
        return this.hasPreUpdateOnInputChange() || null != this._preUpdate;
    }

    boolean generateComponentDidMount() {
        return this.generateComponentDidMountInLiteLifecycle() || this.trackRender();
    }

    boolean generateComponentDidMountInLiteLifecycle() {
        return null != this._postMount || null != this._postRender;
    }

    boolean hasPreUpdateOnInputChange() {
        return !this.getPreUpdateOnInputChangeDescriptors().isEmpty();
    }

    boolean hasPostUpdateOnInputChange() {
        return !this.getPostUpdateOnInputChangeDescriptors().isEmpty();
    }

    boolean generateComponentDidUpdate() {
        return this.generateComponentDidUpdateInLiteLifecycle() || this.trackRender();
    }

    boolean generateComponentDidUpdateInLiteLifecycle() {
        return this.hasPostUpdateOnInputChange() || null != this._postUpdate || null != this._postRender;
    }

    boolean shouldValidateInputs() {
        if (null == this._validateInputs) {
            this._validateInputs = this.getInputs().stream().anyMatch(input -> input.hasValidateMethod() || input.isNonNull() && (input.isRequired() || input.isContextSource()));
        }
        return this._validateInputs;
    }

    boolean viewAccessesDeprecatedElements() {
        if (null == this._viewAccessesDeprecatedElements) {
            this._viewAccessesDeprecatedElements = this.isDeprecated(this._element) || this.isDeprecated(this._constructor) || this.isDeprecated(this._preUpdate) || this.isDeprecated(this._postRender) || this.isDeprecated(this._postMount) || this.isDeprecated(this._postUpdate) || this.isDeprecated(this._onError) || this.getInputs().stream().anyMatch(p -> this.isDeprecated(p.getMethod()) || p.hasValidateMethod() && this.isDeprecated(p.getValidateMethod())) || this.getPostUpdateOnInputChangeDescriptors().stream().anyMatch(d -> this.isDeprecated(d.getMethod()));
        }
        return this._viewAccessesDeprecatedElements;
    }

    boolean builderAccessesDeprecatedElements() {
        if (null == this._builderAccessesDeprecatedElements) {
            this._builderAccessesDeprecatedElements = this.isDeprecated(this._element) || this.getInputs().stream().anyMatch(p -> p.hasDefaultMethod() && this.isDeprecated(p.getDefaultMethod()) || p.hasDefaultField() && this.isDeprecated(p.getDefaultField()));
        }
        return this._builderAccessesDeprecatedElements;
    }

    private boolean isDeprecated(@Nullable Element element) {
        return null != element && null != element.getAnnotation(Deprecated.class);
    }

    @Nonnull
    private String shortSha(@Nonnull String text) {
        try {
            MessageDigest algo = MessageDigest.getInstance("SHA-1");
            byte[] digest = algo.digest(text.getBytes());
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < 4; ++i) {
                byte value = digest[i];
                sb.append(Integer.toString((value & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

