/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import react4j.processor.ComponentDescriptor;
import react4j.processor.EventHandlerDescriptor;
import react4j.processor.MethodDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.ReactProcessor;
import react4j.processor.vendor.javapoet.AnnotationSpec;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.CodeBlock;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;

final class Generator {
    private static final ClassName INJECT_CLASSNAME = ClassName.get("javax.inject", "Inject", new String[0]);
    private static final ClassName NONNULL_CLASSNAME = ClassName.get("javax.annotation", "Nonnull", new String[0]);
    private static final ClassName NULLABLE_CLASSNAME = ClassName.get("javax.annotation", "Nullable", new String[0]);
    private static final ClassName ACTION_CLASSNAME = ClassName.get("org.realityforge.arez.annotations", "Action", new String[0]);
    private static final ClassName AREZ_COMPONENT_CLASSNAME = ClassName.get("org.realityforge.arez.annotations", "ArezComponent", new String[0]);
    private static final ClassName JS_OBJECT_CLASSNAME = ClassName.get("elemental2.core", "JsObject", new String[0]);
    private static final ClassName JS_TYPE_CLASSNAME = ClassName.get("jsinterop.annotations", "JsType", new String[0]);
    private static final ClassName JS_CLASSNAME = ClassName.get("jsinterop.base", "Js", new String[0]);
    private static final ClassName JS_PROPERTY_MAP_CLASSNAME = ClassName.get("jsinterop.base", "JsPropertyMap", new String[0]);
    private static final ClassName JS_PROPERTY_MAP_OF_ANY_CLASSNAME = ClassName.get("jsinterop.base", "JsPropertyMapOfAny", new String[0]);
    private static final ClassName COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME = ClassName.get("react4j.core", "ComponentConstructorFunction", new String[0]);
    private static final ClassName REACT_NODE_CLASSNAME = ClassName.get("react4j.core", "ReactNode", new String[0]);
    private static final ClassName REACT_NATIVE_ADAPTER_COMPONENT_CLASSNAME = ClassName.get("react4j.core", "NativeAdapterComponent", new String[0]);
    private static final ClassName REACT_PROP_TYPE_CLASSNAME = ClassName.get("react4j.core", "PropType", new String[0]);
    private static final ClassName REACT_CLASSNAME = ClassName.get("react4j.core", "React", new String[0]);
    private static final ClassName REACT_CONFIG_CLASSNAME = ClassName.get("react4j.core", "ReactConfig", new String[0]);

    private Generator() {
    }

    @Nonnull
    static TypeSpec buildEnhancedComponent(@Nonnull ComponentDescriptor descriptor) {
        MethodDescriptor renderMethod;
        TypeElement element = descriptor.getElement();
        String name = descriptor.getNestedClassPrefix() + descriptor.getEnhancedName();
        TypeSpec.Builder builder = TypeSpec.classBuilder(name);
        builder.superclass(descriptor.getClassName());
        if (descriptor.isArezComponent()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(AREZ_COMPONENT_CLASSNAME).addMember("type", "$S", descriptor.getName());
            if (descriptor.needsInjection()) {
                annotation.addMember("inject", "true", new Object[0]);
            }
            builder.addAnnotation(annotation.build());
        }
        ProcessorUtil.copyAccessModifiers(element, builder);
        builder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", ReactProcessor.class.getName()).build());
        FieldSpec.Builder field = FieldSpec.builder(Generator.getJsConstructorFnType(descriptor), "TYPE", Modifier.STATIC, Modifier.FINAL, Modifier.PRIVATE).initializer("getConstructorFunction()", new Object[0]);
        builder.addField(field.build());
        for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
            builder.addField(Generator.buildEventHandlerField(eventHandler).build());
        }
        builder.addMethod(Generator.buildFactoryMethod().build());
        builder.addMethod(Generator.buildFactory2Method(descriptor).build());
        builder.addMethod(Generator.buildFactory3Method(descriptor).build());
        builder.addMethod(Generator.buildConstructorFnMethod(descriptor).build());
        for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
            builder.addMethod(Generator.buildStaticEventHandlerMethod(descriptor, eventHandler).build());
        }
        if (descriptor.needsInjection() && !descriptor.isArezComponent()) {
            builder.addMethod(MethodSpec.constructorBuilder().addAnnotation(INJECT_CLASSNAME).build());
        }
        if (descriptor.shouldRunArezScheduler() && descriptor.isArezComponent()) {
            builder.addMethod(MethodSpec.methodBuilder("triggerScheduler").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED, Modifier.FINAL).addStatement("getContext().triggerScheduler()", new Object[0]).build());
        }
        if (!(renderMethod = descriptor.getRenderMethod()).getMethod().getSimpleName().toString().equals("render")) {
            builder.addMethod(Generator.buildRenderAdapterMethod(renderMethod).build());
        }
        for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
            builder.addMethod(Generator.buildEventHandlerBuilderMethod(descriptor, eventHandler).build());
        }
        if (descriptor.isArezComponent()) {
            for (EventHandlerDescriptor eventHandler : descriptor.getEventHandlers()) {
                AnnotationMirror nonActionAnnotation = eventHandler.getMethod().getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().toString().equals("react4j.arez.NoAutoAction")).findAny().orElse(null);
                if (null != nonActionAnnotation) continue;
                builder.addMethod(Generator.buildEventHandlerActionMethod(eventHandler).build());
            }
        }
        if (!descriptor.getLifecycleMethods().isEmpty()) {
            builder.addType(Generator.buildNativeLifecycleInterface(descriptor));
        }
        builder.addType(Generator.buildNativeComponent(descriptor));
        return builder.build();
    }

    @Nonnull
    private static ParameterizedTypeName getJsConstructorFnType(@Nonnull ComponentDescriptor descriptor) {
        return ParameterizedTypeName.get(COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, TypeName.get(descriptor.getPropsType().asType()), TypeName.get(descriptor.getContextType().asType()));
    }

    @Nonnull
    private static FieldSpec.Builder buildEventHandlerField(@Nonnull EventHandlerDescriptor eventHandler) {
        TypeName handlerType = TypeName.get(eventHandler.getEventHandlerType().asType());
        String handlerName = "_" + eventHandler.getMethod().getSimpleName().toString();
        return FieldSpec.builder(handlerType, handlerName, Modifier.FINAL, Modifier.PRIVATE).addAnnotation(NONNULL_CLASSNAME).initializer("create$N()", handlerName);
    }

    @Nonnull
    private static MethodSpec.Builder buildStaticEventHandlerMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull EventHandlerDescriptor eventHandler) {
        TypeName handlerType = TypeName.get(eventHandler.getEventHandlerType().asType());
        String handlerName = "_" + eventHandler.getMethod().getSimpleName();
        MethodSpec.Builder method = MethodSpec.methodBuilder(handlerName).addAnnotation(NONNULL_CLASSNAME).returns(handlerType);
        method.addModifiers(Modifier.STATIC);
        ParameterSpec.Builder parameter = ParameterSpec.builder(TypeName.get(descriptor.getElement().asType()), "component", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        method.addParameter(parameter.build());
        method.addStatement("return (($T) component).$N", descriptor.getEnhancedClassName(), handlerName);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildRenderAdapterMethod(@Nonnull MethodDescriptor renderMethod) {
        return MethodSpec.methodBuilder("render").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).addAnnotation(NULLABLE_CLASSNAME).returns(REACT_NODE_CLASSNAME).addStatement("return $T.of( $N() )", REACT_NODE_CLASSNAME, renderMethod.getMethod().getSimpleName().toString());
    }

    @Nonnull
    private static MethodSpec.Builder buildEventHandlerBuilderMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull EventHandlerDescriptor eventHandler) {
        int paramCount;
        String args;
        TypeName handlerType = TypeName.get(eventHandler.getEventHandlerType().asType());
        MethodSpec.Builder method = MethodSpec.methodBuilder("create_" + eventHandler.getMethod().getSimpleName()).addModifiers(Modifier.PRIVATE).addAnnotation(NONNULL_CLASSNAME).returns(handlerType);
        ExecutableElement target = eventHandler.getEventHandlerMethod();
        int targetParameterCount = target.getParameters().size();
        String string = args = 0 == targetParameterCount ? "()" : IntStream.range(0, targetParameterCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        if (1 < targetParameterCount) {
            args = "(" + args + ")";
        }
        String params = 0 == (paramCount = eventHandler.getMethod().getParameters().size()) ? "" : IntStream.range(0, paramCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        method.addStatement("final $T handler = " + args + " -> this.$N(" + params + ")", handlerType, eventHandler.getMethod().getSimpleName());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if( $T.enableComponentNames() )", REACT_CONFIG_CLASSNAME);
        String code = "$T.defineProperty( $T.cast( handler ), \"name\", $T.cast( $T.of( \"value\", $S ) ) )";
        block.addStatement("$T.defineProperty( $T.cast( handler ), \"name\", $T.cast( $T.of( \"value\", $S ) ) )", JS_OBJECT_CLASSNAME, JS_CLASSNAME, JS_CLASSNAME, JS_PROPERTY_MAP_CLASSNAME, descriptor.getName() + "." + eventHandler.getName());
        block.endControlFlow();
        method.addCode(block.build());
        method.addStatement("return handler", new Object[0]);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildEventHandlerActionMethod(@Nonnull EventHandlerDescriptor eventHandler) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(eventHandler.getMethod().getSimpleName().toString()).returns(TypeName.get(eventHandler.getMethodType().getReturnType()));
        ProcessorUtil.copyTypeParameters(eventHandler.getMethodType(), method);
        ProcessorUtil.copyAccessModifiers(eventHandler.getMethod(), method);
        ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)eventHandler.getMethod(), method);
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(ACTION_CLASSNAME).addMember("reportParameters", "false", new Object[0]);
        method.addAnnotation(annotation.build());
        int paramCount = eventHandler.getMethod().getParameters().size();
        for (int i2 = 0; i2 < paramCount; ++i2) {
            TypeMirror paramType = eventHandler.getMethodType().getParameterTypes().get(i2);
            ParameterSpec.Builder parameter = ParameterSpec.builder(TypeName.get(paramType), "arg" + i2, Modifier.FINAL);
            ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)eventHandler.getMethod().getParameters().get(i2), parameter);
            method.addParameter(parameter.build());
        }
        String params = 0 == paramCount ? "" : IntStream.range(0, paramCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        boolean isVoid = eventHandler.getMethodType().getReturnType().getKind() == TypeKind.VOID;
        method.addStatement((isVoid ? "" : "return ") + "super.$N(" + params + ")", eventHandler.getMethod().getSimpleName());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildFactoryMethod() {
        return MethodSpec.methodBuilder("_create").addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.STATIC).returns(REACT_NODE_CLASSNAME).addStatement("return $T.createElement( TYPE )", REACT_CLASSNAME);
    }

    @Nonnull
    private static MethodSpec.Builder buildFactory2Method(@Nonnull ComponentDescriptor descriptor) {
        return MethodSpec.methodBuilder("_create").addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.STATIC).returns(REACT_NODE_CLASSNAME).addParameter(ParameterSpec.builder(ClassName.get(descriptor.getPropsType()), "props", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME).build()).addStatement("return $T.createElement( TYPE, props )", REACT_CLASSNAME);
    }

    @Nonnull
    private static MethodSpec.Builder buildFactory3Method(@Nonnull ComponentDescriptor descriptor) {
        return MethodSpec.methodBuilder("_create").addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.STATIC).returns(REACT_NODE_CLASSNAME).addParameter(ParameterSpec.builder(ClassName.get(descriptor.getPropsType()), "props", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME).build()).addParameter(ParameterSpec.builder(REACT_NODE_CLASSNAME, "child", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME).build()).addStatement("return $T.createElement( TYPE, props, child )", REACT_CLASSNAME);
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructorFnMethod(@Nonnull ComponentDescriptor descriptor) {
        ParameterizedTypeName constructorType = Generator.getJsConstructorFnType(descriptor);
        MethodSpec.Builder method = MethodSpec.methodBuilder("getConstructorFunction").addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.STATIC, Modifier.PRIVATE).returns(constructorType);
        method.addStatement("final $T componentConstructor = $T::new", constructorType, ClassName.bestGuess("NativeReactComponent"));
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( $T.enableComponentNames() )", REACT_CONFIG_CLASSNAME);
        codeBlock.addStatement("$T.of( componentConstructor ).set( \"displayName\", $S )", JS_PROPERTY_MAP_CLASSNAME, descriptor.getName());
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        Map<Object, Object> childContextTypeFields = descriptor.hasChildContextFields() ? descriptor.getChildContextTypeFields() : Collections.emptyMap();
        Map<String, TypeMirror> contextTypeFields = descriptor.getContextTypeFields();
        if (!childContextTypeFields.isEmpty() || !contextTypeFields.isEmpty()) {
            method.addStatement("final $T valid = () -> null", REACT_PROP_TYPE_CLASSNAME);
        }
        if (!contextTypeFields.isEmpty()) {
            method.addStatement("final $T contextTypes = $T.of()", JS_PROPERTY_MAP_OF_ANY_CLASSNAME, JS_PROPERTY_MAP_CLASSNAME);
            for (String string : contextTypeFields.keySet()) {
                method.addStatement("contextTypes.set( $S, valid )", string);
            }
            method.addStatement("$T.of( componentConstructor ).set( \"contextTypes\", contextTypes )", JS_PROPERTY_MAP_CLASSNAME);
        }
        if (!childContextTypeFields.isEmpty()) {
            method.addStatement("final $T childContextTypes = $T.of()", JS_PROPERTY_MAP_OF_ANY_CLASSNAME, JS_PROPERTY_MAP_CLASSNAME);
            for (String string : childContextTypeFields.keySet()) {
                method.addStatement("childContextTypes.set( $S, valid )", string);
            }
            method.addStatement("$T.of( componentConstructor ).set( \"childContextTypes\", childContextTypes )", JS_PROPERTY_MAP_CLASSNAME);
        }
        if (descriptor.hasDefaultPropsMethod()) {
            method.addStatement("$T.of( componentConstructor ).set( \"defaultProps\", $T.$N() )", JS_PROPERTY_MAP_CLASSNAME, descriptor.getClassName(), descriptor.getDefaultPropsMethod().getSimpleName().toString());
        }
        method.addStatement("return componentConstructor", new Object[0]);
        return method;
    }

    @Nonnull
    private static TypeSpec buildNativeComponent(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("NativeReactComponent");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        ParameterizedTypeName superType = ParameterizedTypeName.get(REACT_NATIVE_ADAPTER_COMPONENT_CLASSNAME, ClassName.get(descriptor.getPropsType().asType()), ClassName.get(descriptor.getStateType().asType()), ClassName.get(descriptor.getContextType().asType()), ClassName.get(descriptor.getElement()));
        builder.superclass(superType);
        if (!descriptor.getLifecycleMethods().isEmpty()) {
            builder.addSuperinterface(ClassName.bestGuess("Lifecycle"));
        }
        ParameterSpec.Builder props = ParameterSpec.builder(ClassName.get(descriptor.getPropsType()), "props", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        ParameterSpec.Builder context = ParameterSpec.builder(ClassName.get(descriptor.getContextType()), "context", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addParameter(props.build()).addParameter(context.build());
        method.addStatement("super( props, context )", new Object[0]);
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder("createComponent").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(ClassName.get(descriptor.getElement()));
        method2.addStatement("return new $T()", descriptor.getClassNameToConstruct());
        builder.addMethod(method2.build());
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
            MethodSpec.Builder method3 = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(ClassName.get(lifecycleMethod.getMethodType().getReturnType()));
            ProcessorUtil.copyTypeParameters(lifecycleMethod.getMethodType(), method3);
            StringJoiner params = new StringJoiner(",");
            List<? extends VariableElement> sourceParameters = lifecycleMethod.getMethod().getParameters();
            List<? extends TypeMirror> sourceParameterTypes = lifecycleMethod.getMethodType().getParameterTypes();
            int parameterCount = sourceParameters.size();
            for (int i = 0; i < parameterCount; ++i) {
                VariableElement parameter = sourceParameters.get(i);
                TypeMirror parameterType = sourceParameterTypes.get(i);
                String parameterName = parameter.getSimpleName().toString();
                ParameterSpec.Builder parameterSpec = ParameterSpec.builder(TypeName.get(parameterType), parameterName, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
                method3.addParameter(parameterSpec.build());
                params.add(parameterName);
            }
            StringBuilder sb = new StringBuilder();
            if (TypeKind.VOID != lifecycleMethod.getMethodType().getReturnType().getKind()) {
                sb.append("return ");
            }
            sb.append("perform");
            sb.append(Character.toUpperCase(methodName.charAt(0)));
            sb.append(methodName.substring(1));
            sb.append("(");
            sb.append(params.toString());
            sb.append(")");
            method3.addStatement(sb.toString(), new Object[0]);
            builder.addMethod(method3.build());
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildNativeLifecycleInterface(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("Lifecycle");
        builder.addAnnotation(AnnotationSpec.builder(JS_TYPE_CLASSNAME).addMember("isNative", "true", new Object[0]).build());
        builder.addModifiers(Modifier.STATIC);
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
            MethodSpec.Builder method = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).returns(ClassName.get(lifecycleMethod.getMethodType().getReturnType()));
            ProcessorUtil.copyTypeParameters(lifecycleMethod.getMethodType(), method);
            List<? extends VariableElement> sourceParameters = lifecycleMethod.getMethod().getParameters();
            List<? extends TypeMirror> sourceParameterTypes = lifecycleMethod.getMethodType().getParameterTypes();
            int parameterCount = sourceParameters.size();
            for (int i = 0; i < parameterCount; ++i) {
                VariableElement parameter = sourceParameters.get(i);
                TypeMirror parameterType = sourceParameterTypes.get(i);
                String parameterName = parameter.getSimpleName().toString();
                ParameterSpec.Builder parameterSpec = ParameterSpec.builder(TypeName.get(parameterType), parameterName, new Modifier[0]).addAnnotation(NONNULL_CLASSNAME);
                method.addParameter(parameterSpec.build());
            }
            builder.addMethod(method.build());
        }
        return builder.build();
    }
}

