/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.proton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Generated;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import react4j.processor.vendor.javapoet.AnnotationSpec;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.JavaFile;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.javapoet.TypeVariableName;
import react4j.processor.vendor.proton.AnnotationsUtil;
import react4j.processor.vendor.proton.ElementsUtil;
import react4j.processor.vendor.proton.SuppressWarningsUtil;

public final class GeneratorUtil {
    public static final ClassName NONNULL_CLASSNAME = ClassName.get("javax.annotation", "Nonnull", new String[0]);
    public static final ClassName NULLABLE_CLASSNAME = ClassName.get("javax.annotation", "Nullable", new String[0]);
    @Nonnull
    public static final List<String> ANNOTATION_WHITELIST = Collections.unmodifiableList(Arrays.asList("javax.annotation.Nonnull", "javax.annotation.Nullable", Deprecated.class.getName()));

    private GeneratorUtil() {
    }

    @Nonnull
    public static ClassName getGeneratedClassName(@Nonnull ClassName className, @Nonnull String prefix, @Nonnull String postfix) {
        return ClassName.get(className.packageName(), GeneratorUtil.getGeneratedSimpleClassName(className, prefix, postfix), new String[0]);
    }

    @Nonnull
    public static String getGeneratedSimpleClassName(@Nonnull ClassName className, @Nonnull String prefix, @Nonnull String postfix) {
        return GeneratorUtil.getNestedClassPrefix(className) + prefix + className.simpleName() + postfix;
    }

    @Nonnull
    private static String getNestedClassPrefix(@Nonnull ClassName className) {
        StringBuilder name = new StringBuilder();
        List<String> simpleNames = className.simpleNames();
        if (simpleNames.size() > 1) {
            for (String simpleName : simpleNames.subList(0, simpleNames.size() - 1)) {
                name.append(simpleName);
                name.append("_");
            }
        }
        return name.toString();
    }

    @Nonnull
    public static ClassName getGeneratedClassName(@Nonnull TypeElement element, @Nonnull String prefix, @Nonnull String postfix) {
        return ClassName.get(GeneratorUtil.getQualifiedPackageName(element), GeneratorUtil.getGeneratedSimpleClassName(element, prefix, postfix), new String[0]);
    }

    @Nonnull
    public static String getQualifiedPackageName(@Nonnull TypeElement element) {
        return ElementsUtil.getPackageElement(element).getQualifiedName().toString();
    }

    @Nonnull
    public static String getGeneratedSimpleClassName(@Nonnull TypeElement element, @Nonnull String prefix, @Nonnull String postfix) {
        return GeneratorUtil.getNestedClassPrefix(element) + prefix + element.getSimpleName() + postfix;
    }

    @Nonnull
    private static String getNestedClassPrefix(@Nonnull TypeElement element) {
        StringBuilder name = new StringBuilder();
        TypeElement t = element;
        while (NestingKind.TOP_LEVEL != t.getNestingKind()) {
            t = (TypeElement)t.getEnclosingElement();
            name.insert(0, t.getSimpleName() + "_");
        }
        return name.toString();
    }

    public static void emitJavaType(@Nonnull String packageName, @Nonnull TypeSpec typeSpec, @Nonnull Filer filer) throws IOException {
        JavaFile.builder(packageName, typeSpec).skipJavaLangImports(true).build().writeTo(filer);
    }

    @Nonnull
    public static List<TypeVariableName> getTypeArgumentsAsNames(@Nonnull DeclaredType declaredType) {
        ArrayList<TypeVariableName> variables = new ArrayList<TypeVariableName>();
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            variables.add(TypeVariableName.get((TypeVariable)typeMirror));
        }
        return variables;
    }

    public static void copyAccessModifiers(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(Modifier.PUBLIC);
        }
    }

    public static void copyAccessModifiers(@Nonnull TypeElement element, @Nonnull MethodSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(Modifier.PUBLIC);
        }
    }

    public static void copyAccessModifiers(@Nonnull ExecutableElement element, @Nonnull MethodSpec.Builder builder) {
        if (element.getModifiers().contains((Object)Modifier.PUBLIC)) {
            builder.addModifiers(Modifier.PUBLIC);
        } else if (element.getModifiers().contains((Object)Modifier.PROTECTED)) {
            builder.addModifiers(Modifier.PROTECTED);
        }
    }

    public static void copyExceptions(@Nonnull ExecutableType method, @Nonnull MethodSpec.Builder builder) {
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            builder.addException(TypeName.get(typeMirror));
        }
    }

    public static void copyTypeParameters(@Nonnull ExecutableType action, @Nonnull MethodSpec.Builder builder) {
        for (TypeVariable typeVariable : action.getTypeVariables()) {
            builder.addTypeVariable(TypeVariableName.get(typeVariable));
        }
    }

    public static void copyTypeParameters(@Nonnull TypeElement element, @Nonnull MethodSpec.Builder builder) {
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get(typeParameterElement));
        }
    }

    public static void copyTypeParameters(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        for (TypeParameterElement typeParameterElement : element.getTypeParameters()) {
            builder.addTypeVariable(TypeVariableName.get(typeParameterElement));
        }
    }

    public static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull TypeSpec.Builder builder) {
        GeneratorUtil.copyWhitelistedAnnotations(element, builder, ANNOTATION_WHITELIST);
    }

    public static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull TypeSpec.Builder builder, @Nonnull List<String> whitelist) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!whitelist.contains(annotationMirror.getAnnotationType().toString())) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    public static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull MethodSpec.Builder builder) {
        GeneratorUtil.copyWhitelistedAnnotations(element, builder, ANNOTATION_WHITELIST);
    }

    public static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull MethodSpec.Builder builder, @Nonnull List<String> whitelist) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!whitelist.contains(annotationMirror.getAnnotationType().toString())) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    public static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull ParameterSpec.Builder builder) {
        GeneratorUtil.copyWhitelistedAnnotations(element, builder, ANNOTATION_WHITELIST);
    }

    public static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull ParameterSpec.Builder builder, @Nonnull List<String> whitelist) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!whitelist.contains(annotationMirror.getAnnotationType().toString())) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    public static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull FieldSpec.Builder builder) {
        GeneratorUtil.copyWhitelistedAnnotations(element, builder, ANNOTATION_WHITELIST);
    }

    public static void copyWhitelistedAnnotations(@Nonnull AnnotatedConstruct element, @Nonnull FieldSpec.Builder builder, @Nonnull List<String> whitelist) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!whitelist.contains(annotationMirror.getAnnotationType().toString())) continue;
            builder.addAnnotation(AnnotationSpec.get(annotationMirror));
        }
    }

    public static void addOriginatingTypes(@Nonnull TypeElement element, @Nonnull TypeSpec.Builder builder) {
        builder.addOriginatingElement(element);
        ElementsUtil.getSuperTypes(element).forEach(builder::addOriginatingElement);
    }

    public static void addGeneratedAnnotation(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeSpec.Builder builder, @Nonnull String classname) {
        builder.addAnnotation(AnnotationSpec.builder(ClassName.get(Generated.class)).addMember("value", "$S", classname).build());
    }

    @Nonnull
    public static MethodSpec.Builder overrideMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement executableElement) {
        return GeneratorUtil.overrideMethod(processingEnv, typeElement, executableElement, Collections.emptyList(), true);
    }

    @Nonnull
    public static MethodSpec.Builder overrideMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement executableElement, @Nonnull Collection<String> additionalSuppressions, boolean copyNullabilityAnnotations) {
        DeclaredType declaredType = (DeclaredType)typeElement.asType();
        ExecutableType executableType = (ExecutableType)processingEnv.getTypeUtils().asMemberOf(declaredType, executableElement);
        MethodSpec.Builder method = MethodSpec.methodBuilder(executableElement.getSimpleName().toString());
        method.addAnnotation(Override.class);
        SuppressWarningsUtil.addSuppressWarningsIfRequired(processingEnv, method, additionalSuppressions, Collections.singletonList(executableType));
        GeneratorUtil.copyAccessModifiers(executableElement, method);
        GeneratorUtil.copyTypeParameters(executableType, method);
        if (copyNullabilityAnnotations) {
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)executableElement, method);
        } else if (AnnotationsUtil.hasAnnotationOfType(executableElement, Deprecated.class.getName())) {
            method.addAnnotation(Deprecated.class);
        }
        method.varargs(executableElement.isVarArgs());
        GeneratorUtil.copyParameters(executableElement, executableType, method);
        GeneratorUtil.copyExceptions(executableType, method);
        method.returns(TypeName.get(executableType.getReturnType()));
        return method;
    }

    public static void copyParameters(@Nonnull ExecutableElement executableElement, @Nonnull ExecutableType executableType, @Nonnull MethodSpec.Builder method) {
        int paramIndex = 0;
        for (TypeMirror typeMirror : executableType.getParameterTypes()) {
            TypeName typeName = TypeName.get(typeMirror);
            VariableElement variableElement = executableElement.getParameters().get(paramIndex);
            String name = variableElement.getSimpleName().toString();
            ParameterSpec.Builder parameter = ParameterSpec.builder(typeName, name, Modifier.FINAL);
            GeneratorUtil.copyWhitelistedAnnotations((AnnotatedConstruct)variableElement, parameter);
            method.addParameter(parameter.build());
            ++paramIndex;
        }
    }

    @Nonnull
    public static MethodSpec.Builder refMethod(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeElement typeElement, @Nonnull ExecutableElement executableElement) {
        MethodSpec.Builder method = GeneratorUtil.overrideMethod(processingEnv, typeElement, executableElement, Collections.emptyList(), false);
        if (!executableElement.getReturnType().getKind().isPrimitive()) {
            method.addAnnotation(NONNULL_CLASSNAME);
        }
        return method;
    }
}

