/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor.vendor.proton;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.RecordComponentElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractElementVisitor14;
import javax.lang.model.util.SimpleAnnotationValueVisitor14;
import javax.lang.model.util.SimpleTypeVisitor14;

public final class SuperficialValidation {
    private SuperficialValidation() {
    }

    public static boolean validateElements(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Iterable<? extends Element> elements) {
        return new ValidatorVisitors(processingEnv).validateElements(elements);
    }

    public static boolean validateElement(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Element element) {
        return new ValidatorVisitors(processingEnv).validateElement(element);
    }

    public static boolean validateTypes(@Nonnull ProcessingEnvironment processingEnv, @Nonnull Iterable<? extends TypeMirror> types) {
        return new ValidatorVisitors(processingEnv).validateTypes(types);
    }

    public static boolean validateType(@Nonnull ProcessingEnvironment processingEnv, @Nonnull TypeMirror type) {
        return new ValidatorVisitors(processingEnv).validateType(type);
    }

    private static boolean isTypeOf(@Nonnull Class<?> clazz, @Nonnull TypeMirror type) {
        return type.accept(new IsTypeOf(clazz), null);
    }

    private static final class ValidatorVisitors {
        @Nonnull
        final TypeValidatingVisitor _typeValidatingVisitor = new TypeValidatingVisitor(this);
        @Nonnull
        final ElementValidatingVisitor _elementValidatingVisitor = new ElementValidatingVisitor(this);
        @Nonnull
        final ValueValidatingVisitor _valueValidatingVisitor;

        ValidatorVisitors(@Nonnull ProcessingEnvironment processingEnv) {
            this._valueValidatingVisitor = new ValueValidatingVisitor(this, processingEnv);
        }

        private boolean validateElement(@Nonnull Element element) {
            return element.accept(this._elementValidatingVisitor, null);
        }

        private boolean validateType(@Nonnull TypeMirror type) {
            return type.accept(this._typeValidatingVisitor, null);
        }

        private boolean validateElements(@Nonnull Iterable<? extends Element> elements) {
            for (Element element : elements) {
                if (this.validateElement(element)) continue;
                return false;
            }
            return true;
        }

        private boolean validateTypes(@Nonnull Iterable<? extends TypeMirror> types) {
            for (TypeMirror typeMirror : types) {
                if (this.validateType(typeMirror)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class IsTypeOf
    extends SimpleTypeVisitor14<Boolean, Void> {
        @Nonnull
        private final Class<?> _clazz;

        IsTypeOf(@Nonnull Class<?> clazz) {
            this._clazz = clazz;
        }

        @Override
        protected Boolean defaultAction(TypeMirror type, Void ignored) {
            throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
        }

        @Override
        public Boolean visitNoType(NoType noType, Void p) {
            return TypeKind.VOID == noType.getKind() && Void.TYPE.equals(this._clazz);
        }

        @Override
        public Boolean visitPrimitive(PrimitiveType type, Void p) {
            TypeKind kind = type.getKind();
            switch (kind) {
                case BOOLEAN: {
                    return Boolean.TYPE.equals(this._clazz);
                }
                case BYTE: {
                    return Byte.TYPE.equals(this._clazz);
                }
                case CHAR: {
                    return Character.TYPE.equals(this._clazz);
                }
                case DOUBLE: {
                    return Double.TYPE.equals(this._clazz);
                }
                case FLOAT: {
                    return Float.TYPE.equals(this._clazz);
                }
                case INT: {
                    return Integer.TYPE.equals(this._clazz);
                }
                case LONG: {
                    return Long.TYPE.equals(this._clazz);
                }
            }
            assert (TypeKind.SHORT == kind);
            return Short.TYPE.equals(this._clazz);
        }

        @Override
        public Boolean visitArray(ArrayType array, Void p) {
            return this._clazz.isArray() && SuperficialValidation.isTypeOf(this._clazz.getComponentType(), array.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType type, Void ignored) {
            return ((TypeElement)type.asElement()).getQualifiedName().contentEquals(this._clazz.getCanonicalName());
        }
    }

    private static class ElementValidatingVisitor
    extends AbstractElementVisitor14<Boolean, Void> {
        @Nonnull
        private final ValidatorVisitors _visitors;

        ElementValidatingVisitor(@Nonnull ValidatorVisitors visitors) {
            this._visitors = visitors;
        }

        @Override
        public Boolean visitRecordComponent(RecordComponentElement t, Void unused) {
            return null;
        }

        @Override
        public Boolean visitModule(ModuleElement t, Void unused) {
            return true;
        }

        @Override
        public Boolean visitPackage(PackageElement e, Void p) {
            return this._visitors._valueValidatingVisitor.validateAnnotations(e.getAnnotationMirrors());
        }

        @Override
        public Boolean visitType(TypeElement e, Void p) {
            return this.isValidBaseElement(e) && this._visitors.validateElements(e.getTypeParameters()) && this._visitors.validateTypes(e.getInterfaces()) && this._visitors.validateType(e.getSuperclass());
        }

        @Override
        public Boolean visitVariable(VariableElement e, Void p) {
            return this.isValidBaseElement(e);
        }

        @Override
        public Boolean visitExecutable(ExecutableElement e, Void p) {
            AnnotationValue defaultValue = e.getDefaultValue();
            return this.isValidBaseElement(e) && (null == defaultValue || defaultValue.accept(this._visitors._valueValidatingVisitor, e.getReturnType()) != false) && this._visitors.validateType(e.getReturnType()) && this._visitors.validateTypes(e.getThrownTypes()) && this._visitors.validateElements(e.getTypeParameters()) && this._visitors.validateElements(e.getParameters());
        }

        @Override
        public Boolean visitTypeParameter(TypeParameterElement e, Void p) {
            return this.isValidBaseElement(e) && this._visitors.validateTypes(e.getBounds());
        }

        @Override
        public Boolean visitUnknown(Element e, Void p) {
            return true;
        }

        private boolean isValidBaseElement(@Nonnull Element e) {
            return this._visitors.validateType(e.asType()) && this._visitors._valueValidatingVisitor.validateAnnotations(e.getAnnotationMirrors()) && this._visitors.validateElements(e.getEnclosedElements());
        }
    }

    private static class TypeValidatingVisitor
    extends SimpleTypeVisitor14<Boolean, Void> {
        @Nonnull
        private final ValidatorVisitors _visitors;

        TypeValidatingVisitor(@Nonnull ValidatorVisitors visitors) {
            this._visitors = visitors;
        }

        @Override
        protected Boolean defaultAction(TypeMirror t, Void p) {
            return true;
        }

        @Override
        public Boolean visitArray(ArrayType t, Void p) {
            return this._visitors.validateType(t.getComponentType());
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void p) {
            return this._visitors.validateTypes(t.getTypeArguments());
        }

        @Override
        public Boolean visitError(ErrorType t, Void p) {
            return false;
        }

        @Override
        public Boolean visitUnknown(TypeMirror t, Void p) {
            return this.defaultAction(t, p);
        }

        @Override
        public Boolean visitWildcard(WildcardType t, Void p) {
            TypeMirror extendsBound = t.getExtendsBound();
            TypeMirror superBound = t.getSuperBound();
            return !(null != extendsBound && !this._visitors.validateType(extendsBound) || null != superBound && !this._visitors.validateType(superBound));
        }

        @Override
        public Boolean visitExecutable(ExecutableType t, Void p) {
            return this._visitors.validateTypes(t.getParameterTypes()) && this._visitors.validateType(t.getReturnType()) && this._visitors.validateTypes(t.getThrownTypes()) && this._visitors.validateTypes(t.getTypeVariables());
        }
    }

    private static class ValueValidatingVisitor
    extends SimpleAnnotationValueVisitor14<Boolean, TypeMirror> {
        @Nonnull
        private final ValidatorVisitors _visitors;
        @Nonnull
        private final ProcessingEnvironment processingEnv;

        ValueValidatingVisitor(@Nonnull ValidatorVisitors visitors, @Nonnull ProcessingEnvironment processingEnv) {
            this._visitors = visitors;
            this.processingEnv = processingEnv;
        }

        @Override
        protected Boolean defaultAction(Object o, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(o.getClass(), expectedType);
        }

        @Override
        public Boolean visitUnknown(AnnotationValue av, TypeMirror expectedType) {
            return this.defaultAction((Object)av, expectedType);
        }

        @Override
        public Boolean visitAnnotation(AnnotationMirror a, TypeMirror expectedType) {
            return this.processingEnv.getTypeUtils().isSameType(a.getAnnotationType(), expectedType) && this.validateAnnotation(a);
        }

        private boolean validateAnnotations(@Nonnull Iterable<? extends AnnotationMirror> annotationMirrors) {
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (this.validateAnnotation(annotationMirror)) continue;
                return false;
            }
            return true;
        }

        private boolean validateAnnotation(@Nonnull AnnotationMirror annotationMirror) {
            return this._visitors.validateType(annotationMirror.getAnnotationType()) && this.validateAnnotationValues(annotationMirror.getElementValues());
        }

        private boolean validateAnnotationValues(@Nonnull Map<? extends ExecutableElement, ? extends AnnotationValue> valueMap) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> valueEntry : valueMap.entrySet()) {
                TypeMirror expectedType = valueEntry.getKey().getReturnType();
                if (this.validateAnnotationValue(valueEntry.getValue(), expectedType)) continue;
                return false;
            }
            return true;
        }

        private boolean validateAnnotationValue(@Nonnull AnnotationValue annotationValue, @Nonnull TypeMirror expectedType) {
            return annotationValue.accept(this._visitors._valueValidatingVisitor, expectedType);
        }

        @Override
        public Boolean visitArray(List<? extends AnnotationValue> values, TypeMirror expectedType) {
            if (TypeKind.ARRAY != expectedType.getKind()) {
                return false;
            }
            for (AnnotationValue annotationValue : values) {
                if (annotationValue.accept(this, ((ArrayType)expectedType).getComponentType()).booleanValue()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Boolean visitEnumConstant(VariableElement enumConstant, TypeMirror expectedType) {
            return this.processingEnv.getTypeUtils().isSameType(enumConstant.asType(), expectedType) && this._visitors.validateElement(enumConstant);
        }

        @Override
        public Boolean visitType(TypeMirror type, TypeMirror ignored) {
            return this._visitors.validateType(type);
        }

        @Override
        public Boolean visitBoolean(boolean b, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(Boolean.TYPE, expectedType);
        }

        @Override
        public Boolean visitByte(byte b, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(Byte.TYPE, expectedType);
        }

        @Override
        public Boolean visitChar(char c, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(Character.TYPE, expectedType);
        }

        @Override
        public Boolean visitDouble(double d, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(Double.TYPE, expectedType);
        }

        @Override
        public Boolean visitFloat(float f, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(Float.TYPE, expectedType);
        }

        @Override
        public Boolean visitInt(int i, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(Integer.TYPE, expectedType);
        }

        @Override
        public Boolean visitLong(long l, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(Long.TYPE, expectedType);
        }

        @Override
        public Boolean visitShort(short s, TypeMirror expectedType) {
            return SuperficialValidation.isTypeOf(Short.TYPE, expectedType);
        }
    }
}

