/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import react4j.processor.ComponentDescriptor;
import react4j.processor.EventHandlerDescriptor;
import react4j.processor.Generator;
import react4j.processor.MethodDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.ReactProcessorException;
import react4j.processor.vendor.javapoet.JavaFile;
import react4j.processor.vendor.javapoet.TypeSpec;

@SupportedAnnotationTypes(value={"react4j.annotations.*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public final class ReactProcessor
extends AbstractProcessor {
    private static final List<String> LIFECYCLE_METHODS = Arrays.asList("componentDidMount", "componentDidUpdate", "componentWillReceiveProps", "componentWillUnmount", "componentWillUpdate", "componentDidCatch", "getChildContext", "shouldComponentUpdate");
    private final HashMap<String, ExecutableElement> _componentLifecycleMethods = new HashMap();
    private ExecutableElement _componentRenderMethod;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this._componentLifecycleMethods.clear();
        this._componentRenderMethod = null;
        TypeElement annotation = this.processingEnv.getElementUtils().getTypeElement("react4j.annotations.ReactComponent");
        Set<? extends Element> elements = env.getElementsAnnotatedWith(annotation);
        this.processElements(elements);
        return false;
    }

    private void processElements(@Nonnull Set<? extends Element> elements) {
        for (Element element : elements) {
            try {
                this.process((TypeElement)element);
            }
            catch (IOException ioe) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, ioe.getMessage(), element);
            }
            catch (ReactProcessorException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage(), e.getElement());
            }
            catch (Throwable e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                sw.flush();
                String message = "Unexpected error will running the " + this.getClass().getName() + " processor. This has resulted in a failure to process the code and has left the compiler in an invalid state. Please report the failure to the developers so that it can be fixed.\n Report the error at: https://github.com/react4j/react4j/issues\n\n\n" + sw.toString();
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message, element);
            }
        }
    }

    private void process(@Nonnull TypeElement element) throws IOException, ReactProcessorException {
        ComponentDescriptor descriptor = this.parse(element);
        this.emitTypeSpec(descriptor.getPackageName(), Generator.buildEnhancedComponent(descriptor));
        if (descriptor.needsDaggerIntegration()) {
            this.emitTypeSpec(descriptor.getPackageName(), Generator.buildDaggerFactory(descriptor));
        }
    }

    private void emitTypeSpec(@Nonnull String packageName, @Nonnull TypeSpec typeSpec) throws IOException {
        JavaFile.builder(packageName, typeSpec).skipJavaLangImports(true).build().writeTo(this.processingEnv.getFiler());
    }

    @Nonnull
    private ComponentDescriptor parse(@Nonnull TypeElement typeElement) {
        String name = this.deriveComponentName(typeElement);
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(typeElement);
        ComponentDescriptor descriptor = new ComponentDescriptor(name, packageElement, typeElement);
        this.determineComponentType(descriptor, typeElement);
        this.determinePropsAndStateTypes(descriptor);
        this.determineLifecycleMethods(typeElement, descriptor);
        this.determineChildContextTypes(descriptor);
        this.determineRenderMethod(typeElement, descriptor);
        this.determineEventHandlers(descriptor);
        this.determineDefaultPropsMethod(descriptor);
        this.verifyNoUnexpectedAbstractMethod(descriptor);
        return descriptor;
    }

    private void verifyNoUnexpectedAbstractMethod(@Nonnull ComponentDescriptor descriptor) {
        ExecutableElement abstractMethod;
        if (!descriptor.isArezComponent() && null != (abstractMethod = (ExecutableElement)ProcessorUtil.getMethods(descriptor.getElement(), this.processingEnv.getTypeUtils()).stream().filter(m -> m.getModifiers().contains((Object)Modifier.ABSTRACT)).findAny().orElse(null))) {
            throw new ReactProcessorException("@ReactComponent target has an unexpected abstract method", abstractMethod);
        }
    }

    private void determineDefaultPropsMethod(@Nonnull ComponentDescriptor descriptor) {
        List defaultPropsMethods = ProcessorUtil.getMethods(descriptor.getElement(), this.processingEnv.getTypeUtils()).stream().filter(m -> m.getSimpleName().toString().equals("getInitialProps")).collect(Collectors.toList());
        if (!defaultPropsMethods.isEmpty()) {
            for (ExecutableElement method : defaultPropsMethods) {
                ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
                if (!methodType.getThrownTypes().isEmpty() || !methodType.getParameterTypes().isEmpty() || !method.getModifiers().contains((Object)Modifier.STATIC) || method.getModifiers().contains((Object)Modifier.PRIVATE) || !this.processingEnv.getTypeUtils().isAssignable(methodType.getReturnType(), descriptor.getPropsType().asType())) continue;
                descriptor.setDefaultPropsMethod(method);
                return;
            }
            throw new ReactProcessorException("The getInitialProps method does not satisfy constraints. The method must be static, non-private, have no parameters, throw no exceptions and must return a value that is compatible with the prop type for the component.", descriptor.getElement());
        }
    }

    private void determineEventHandlers(@Nonnull ComponentDescriptor descriptor) {
        List<EventHandlerDescriptor> eventHandlers = ProcessorUtil.getMethods(descriptor.getElement(), this.processingEnv.getTypeUtils()).stream().filter(m -> null != ProcessorUtil.findAnnotationByType(m, "react4j.annotations.EventHandler")).map(m -> this.createEventHandlerDescriptor(descriptor, (ExecutableElement)m)).collect(Collectors.toList());
        for (EventHandlerDescriptor eventHandler : eventHandlers) {
            ExecutableElement method = eventHandler.getMethod();
            TypeElement handlerType = this.getEventHandlerType(method);
            if (ElementKind.INTERFACE != handlerType.getKind()) {
                throw new ReactProcessorException("The @EventHandler specified an invalid type that is not an interface.", eventHandler.getMethod());
            }
            if (null == ProcessorUtil.findAnnotationByType(handlerType, "jsinterop.annotations.JsFunction")) {
                throw new ReactProcessorException("The @EventHandler specified an invalid type that is not annotated with the annotation jsinterop.annotations.JsFunction.", eventHandler.getMethod());
            }
            EventHandlerDescriptor matched = eventHandlers.stream().filter(h -> h != eventHandler && h.getName().equals(eventHandler.getName())).findAny().orElse(null);
            if (null != matched) {
                throw new ReactProcessorException("The @EventHandler has the same name as the event handler defined by " + matched.getMethod() + ".", eventHandler.getMethod());
            }
            EventHandlerDescriptor matched2 = eventHandlers.stream().filter(h -> h != eventHandler && h.getMethod().getSimpleName().equals(eventHandler.getMethod().getSimpleName())).findAny().orElse(null);
            if (null != matched2) {
                throw new ReactProcessorException("The @EventHandler has the same method name as the event handler defined by " + matched2.getMethod() + ".", eventHandler.getMethod());
            }
            ExecutableType methodType = eventHandler.getMethodType();
            List<? extends TypeMirror> parameters = methodType.getParameterTypes();
            if (parameters.isEmpty()) continue;
            ExecutableElement target = eventHandler.getEventHandlerMethod();
            List<? extends VariableElement> targetParameters = target.getParameters();
            if (targetParameters.size() != parameters.size()) {
                throw new ReactProcessorException("The @EventHandler target has " + parameters.size() + " parameters but the type parameter specified a handler with method type " + eventHandler.getEventHandlerType().getQualifiedName() + " that has handler method with " + targetParameters.size() + " parameters. The @EventHandler target should have zero parameters or match the number of parameter in the target method " + target.getSimpleName() + ".", eventHandler.getMethod());
            }
            for (int i = 0; i < parameters.size(); ++i) {
                TypeMirror parameterType = parameters.get(i);
                VariableElement element = targetParameters.get(i);
                TypeMirror targetParameterType = element.asType();
                TypeMirror targetErased = this.processingEnv.getTypeUtils().erasure(targetParameterType);
                TypeMirror parameterErased = this.processingEnv.getTypeUtils().erasure(parameterType);
                if (this.processingEnv.getTypeUtils().isAssignable(targetErased, parameterErased)) continue;
                throw new ReactProcessorException("The @EventHandler target parameter named " + eventHandler.getMethod().getParameters().get(i).getSimpleName() + " of type " + parameterType + " is not assignable from target type " + targetParameterType + " of parameter " + element.getSimpleName() + " in method " + eventHandler.getEventHandlerType().getQualifiedName() + "." + target.getSimpleName() + ".", eventHandler.getMethod());
            }
        }
        descriptor.setEventHandlers(eventHandlers);
    }

    @Nonnull
    private EventHandlerDescriptor createEventHandlerDescriptor(@Nonnull ComponentDescriptor descriptor, @Nonnull ExecutableElement method) {
        AnnotationMirror actionAnnotation;
        AnnotationMirror nonActionAnnotation;
        String name = this.deriveEventHandlerName(method);
        TypeElement eventHandlerType = this.getEventHandlerType(method);
        ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), method);
        List eventHandlerMethods = ProcessorUtil.getMethods(eventHandlerType, this.processingEnv.getTypeUtils()).stream().filter(m11 -> m11.getModifiers().contains((Object)Modifier.ABSTRACT)).collect(Collectors.toList());
        if (eventHandlerMethods.isEmpty()) {
            throw new ReactProcessorException("Method annotated with @EventHandler specified type " + eventHandlerType.getQualifiedName() + " that has no abstract method and thus is not a functional interface", method);
        }
        if (eventHandlerMethods.size() > 1) {
            throw new ReactProcessorException("Method annotated with @EventHandler specified type " + eventHandlerType.getQualifiedName() + " that has more than 1 abstract method and thus is not a functional interface", method);
        }
        if (descriptor.isArezComponent() && null == (nonActionAnnotation = (AnnotationMirror)method.getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().toString().equals("react4j.arez.NoAutoAction")).findAny().orElse(null)) && null != (actionAnnotation = (AnnotationMirror)method.getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().toString().equals("arez.annotations.Action")).findAny().orElse(null))) {
            throw new ReactProcessorException("Method annotated with @EventHandler is also annotated with @arez.annotations.Action but is not annotated with @react4j.arez.NoAutoAction which would stop react4j from also annotating the method with @Action. Please remove @Action or add @NoAutoAction annotation.", method);
        }
        return new EventHandlerDescriptor(name, method, methodType, eventHandlerType, (ExecutableElement)eventHandlerMethods.get(0));
    }

    @Nonnull
    private TypeElement getEventHandlerType(@Nonnull ExecutableElement method) {
        DeclaredType typeMirror = ProcessorUtil.getTypeMirrorAnnotationParameter(this.processingEnv.getElementUtils(), method, "react4j.annotations.EventHandler", "value");
        assert (null != typeMirror);
        return (TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror);
    }

    @Nonnull
    private String deriveEventHandlerName(@Nonnull ExecutableElement method) throws ReactProcessorException {
        String name = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), method, "react4j.annotations.EventHandler", "name").getValue();
        if (ProcessorUtil.isSentinelName(name)) {
            return method.getSimpleName().toString();
        }
        if (name.isEmpty() || !ProcessorUtil.isJavaIdentifier(name)) {
            throw new ReactProcessorException("Method annotated with @EventHandler specified invalid name " + name, method);
        }
        return name;
    }

    private void determineLifecycleMethods(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        Collection<ExecutableElement> lifecycleMethods = this.getComponentLifecycleMethods().values();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement componentType = elementUtils.getTypeElement("react4j.core.Component");
        List<MethodDescriptor> overriddenLifecycleMethods = ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils()).stream().filter(m -> lifecycleMethods.stream().anyMatch(l -> elementUtils.overrides((ExecutableElement)m, (ExecutableElement)l, typeElement))).filter(m -> m.getEnclosingElement() != componentType).map(m -> new MethodDescriptor((ExecutableElement)m, (ExecutableType)typeUtils.asMemberOf(descriptor.getDeclaredType(), (Element)m))).collect(Collectors.toList());
        descriptor.setLifecycleMethods(overriddenLifecycleMethods);
    }

    private void determineRenderMethod(@Nonnull TypeElement typeElement, @Nonnull ComponentDescriptor descriptor) {
        ExecutableElement renderMethod = this.getComponentRenderMethod();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeElement componentType = elementUtils.getTypeElement("react4j.core.Component");
        MethodDescriptor overriddenRenderMethod = ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils()).stream().filter(m -> elementUtils.overrides((ExecutableElement)m, renderMethod, typeElement)).filter(m -> m.getEnclosingElement() != componentType).map(m -> new MethodDescriptor((ExecutableElement)m, (ExecutableType)typeUtils.asMemberOf(descriptor.getDeclaredType(), (Element)m))).findAny().orElse(null);
        if (null == overriddenRenderMethod) {
            throw new ReactProcessorException("The react component does not override any render methods.", typeElement);
        }
        descriptor.setRenderMethod(overriddenRenderMethod);
    }

    @Nonnull
    private String deriveComponentName(@Nonnull TypeElement typeElement) {
        String name = (String)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "name").getValue();
        if (ProcessorUtil.isSentinelName(name)) {
            return typeElement.getSimpleName().toString();
        }
        if (name.isEmpty() || !ProcessorUtil.isJavaIdentifier(name)) {
            throw new ReactProcessorException("The @ReactComponent specified an invalid name. Name should be follow the rules of a java identifier.", typeElement);
        }
        return name;
    }

    @Nonnull
    private HashMap<String, ExecutableElement> getComponentLifecycleMethods() {
        if (this._componentLifecycleMethods.isEmpty()) {
            TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.core.Component");
            for (ExecutableElement method : ProcessorUtil.getMethods(componentType, this.processingEnv.getTypeUtils())) {
                String methodName = method.getSimpleName().toString();
                if (!LIFECYCLE_METHODS.contains(methodName)) continue;
                this._componentLifecycleMethods.put(methodName, method);
            }
        }
        return this._componentLifecycleMethods;
    }

    @Nonnull
    private ExecutableElement getComponentRenderMethod() {
        if (null == this._componentRenderMethod) {
            TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.core.Component");
            for (ExecutableElement method : ProcessorUtil.getMethods(componentType, this.processingEnv.getTypeUtils())) {
                String methodName = method.getSimpleName().toString();
                if (!"render".equals(methodName)) continue;
                this._componentRenderMethod = method;
                break;
            }
        }
        return this._componentRenderMethod;
    }

    private void determineComponentType(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeElement typeElement) {
        AnnotationMirror arezAnnotation;
        boolean isArezComponent;
        TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.core.Component");
        TypeMirror rawComponentType = this.processingEnv.getTypeUtils().erasure(componentType.asType());
        TypeElement arezComponentType = this.processingEnv.getElementUtils().getTypeElement("react4j.arez.ReactArezComponent");
        TypeMirror rawArezComponentType = null == arezComponentType ? null : this.processingEnv.getTypeUtils().erasure(arezComponentType.asType());
        DeclaredType type = descriptor.getDeclaredType();
        boolean isComponent = this.processingEnv.getTypeUtils().isSubtype(type, rawComponentType);
        boolean bl = isArezComponent = null != rawArezComponentType && this.processingEnv.getTypeUtils().isSubtype(type, rawArezComponentType);
        if (!isComponent) {
            throw new ReactProcessorException("@ReactComponent target must be a subclass of react4j.core.Component", typeElement);
        }
        if (isArezComponent && null != (arezAnnotation = (AnnotationMirror)typeElement.getAnnotationMirrors().stream().filter(m -> m.getAnnotationType().toString().equals("arez.annotations.ArezComponent")).findAny().orElse(null))) {
            throw new ReactProcessorException("@ReactComponent target extends react4j.arez.ReactArezComponent and should not be annotated with arez.annotations.ArezComponent as React4j will add annotation", typeElement);
        }
        boolean runArezScheduler = ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils()).stream().anyMatch(this::hasAutorunAnnotation);
        boolean needsInjection = this.isInjectionRequired(typeElement);
        boolean isDaggerPresent = needsInjection && this.isDaggerRequired(typeElement);
        descriptor.setNeedsInjection(needsInjection);
        descriptor.setNeedsDaggerIntegration(isDaggerPresent);
        descriptor.setArezComponent(isArezComponent);
        descriptor.setRunArezScheduler(runArezScheduler);
    }

    private boolean isInjectionRequired(@Nonnull TypeElement typeElement) {
        VariableElement injectParameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "inject").getValue();
        switch (injectParameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return ProcessorUtil.getFieldElements(typeElement).stream().anyMatch(this::hasInjectAnnotation) || ProcessorUtil.getMethods(typeElement, this.processingEnv.getTypeUtils()).stream().anyMatch(this::hasInjectAnnotation);
    }

    private boolean isDaggerRequired(@Nonnull TypeElement typeElement) {
        VariableElement injectParameter = (VariableElement)ProcessorUtil.getAnnotationValue(this.processingEnv.getElementUtils(), typeElement, "react4j.annotations.ReactComponent", "dagger").getValue();
        switch (injectParameter.getSimpleName().toString()) {
            case "ENABLE": {
                return true;
            }
            case "DISABLE": {
                return false;
            }
        }
        return null != this.processingEnv.getElementUtils().getTypeElement("dagger.Module");
    }

    private boolean hasAutorunAnnotation(Element method) {
        return null != ProcessorUtil.findAnnotationByType(method, "arez.annotations.Autorun");
    }

    private boolean hasInjectAnnotation(Element method) {
        return null != ProcessorUtil.findAnnotationByType(method, "javax.inject.Inject");
    }

    private void determinePropsAndStateTypes(@Nonnull ComponentDescriptor descriptor) {
        TypeElement componentType = this.processingEnv.getElementUtils().getTypeElement("react4j.core.Component");
        List<? extends TypeParameterElement> typeParameters = componentType.getTypeParameters();
        assert (3 == typeParameters.size());
        TypeParameterElement propsTypeParameter = typeParameters.get(0);
        assert (propsTypeParameter.getSimpleName().toString().equals("P"));
        TypeElement propsType = this.resolveToElement(descriptor, propsTypeParameter);
        descriptor.setPropsType(propsType);
        TypeParameterElement stateTypeParameter = typeParameters.get(1);
        assert (stateTypeParameter.getSimpleName().toString().equals("S"));
        TypeElement stateType = this.resolveToElement(descriptor, stateTypeParameter);
        descriptor.setStateType(stateType);
        TypeParameterElement contextTypeParameter = typeParameters.get(2);
        assert (contextTypeParameter.getSimpleName().toString().equals("C"));
        TypeElement contextType = this.resolveToElement(descriptor, contextTypeParameter);
        Map<String, TypeMirror> contextTypeFields = ProcessorUtil.getFields(contextType, this.processingEnv.getTypeUtils());
        descriptor.setContextType(contextType, contextTypeFields);
    }

    private void determineChildContextTypes(@Nonnull ComponentDescriptor descriptor) {
        MethodDescriptor getChildContext = descriptor.getLifecycleMethods().stream().filter(m -> m.getMethod().getSimpleName().toString().equals("getChildContext")).findFirst().orElse(null);
        if (null != getChildContext) {
            DeclaredType returnType = (DeclaredType)getChildContext.getMethodType().getReturnType();
            Map<String, TypeMirror> childContextTypeFields = ProcessorUtil.getFields((TypeElement)returnType.asElement(), this.processingEnv.getTypeUtils());
            descriptor.setChildContextTypeFields(childContextTypeFields);
        }
    }

    @Nonnull
    private TypeElement resolveToElement(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeParameterElement typeParameter) {
        TypeMirror propsType = this.processingEnv.getTypeUtils().asMemberOf(descriptor.getDeclaredType(), typeParameter);
        return (TypeElement)this.processingEnv.getTypeUtils().asElement(propsType);
    }
}

