/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import react4j.processor.MethodChecks;
import react4j.processor.ReactProcessorException;

final class PropDescriptor {
    @Nonnull
    private final String _name;
    @Nonnull
    private final ExecutableElement _method;
    @Nonnull
    private final ExecutableType _methodType;
    @Nullable
    private final Element _propType;
    @Nullable
    private VariableElement _defaultField;
    @Nullable
    private ExecutableElement _defaultMethod;
    private boolean _optional;

    PropDescriptor(@Nonnull String name, @Nonnull ExecutableElement method, @Nonnull ExecutableType methodType, @Nullable Element propType) {
        this._name = Objects.requireNonNull(name);
        this._method = Objects.requireNonNull(method);
        this._methodType = Objects.requireNonNull(methodType);
        this._propType = propType;
    }

    @Nonnull
    String getName() {
        return this._name;
    }

    @Nonnull
    ExecutableElement getMethod() {
        return this._method;
    }

    @Nonnull
    ExecutableType getMethodType() {
        return this._methodType;
    }

    @Nullable
    Element getPropType() {
        return this._propType;
    }

    void setDefaultMethod(@Nonnull ExecutableElement method) {
        MethodChecks.mustBeStatic("react4j.annotations.PropDefault", method);
        MethodChecks.mustNotBePrivate("react4j.annotations.PropDefault", method);
        MethodChecks.mustNotHaveAnyParameters("react4j.annotations.PropDefault", method);
        MethodChecks.mustNotThrowAnyExceptions("react4j.annotations.PropDefault", method);
        MethodChecks.mustReturnAValue("react4j.annotations.PropDefault", method);
        if (null != this._defaultMethod) {
            throw new ReactProcessorException("@PropDefault target duplicates existing method named " + this._defaultMethod.getSimpleName(), method);
        }
        assert (null == this._defaultField);
        this._defaultMethod = Objects.requireNonNull(method);
    }

    void setDefaultField(@Nonnull VariableElement field) {
        MethodChecks.mustBeStatic("react4j.annotations.PropDefault", field);
        MethodChecks.mustBeFinal("react4j.annotations.PropDefault", field);
        MethodChecks.mustNotBePrivate("react4j.annotations.PropDefault", field);
        if (null != this._defaultMethod) {
            throw new ReactProcessorException("@PropDefault target duplicates existing method named " + this._defaultMethod.getSimpleName(), field);
        }
        if (null != this._defaultField) {
            throw new ReactProcessorException("@PropDefault target duplicates existing field named " + this._defaultField.getSimpleName(), field);
        }
        this._defaultField = Objects.requireNonNull(field);
    }

    boolean hasDefaultField() {
        return null != this._defaultField;
    }

    @Nonnull
    VariableElement getDefaultField() {
        assert (null != this._defaultField);
        return this._defaultField;
    }

    boolean hasDefaultMethod() {
        return null != this._defaultMethod;
    }

    @Nonnull
    ExecutableElement getDefaultMethod() {
        assert (null != this._defaultMethod);
        return this._defaultMethod;
    }

    boolean isOptional() {
        return this._optional;
    }

    void markAsOptional() {
        this._optional = true;
    }

    boolean isSpecialChildrenProp() {
        return this.getName().equals("children") || this.getName().equals("child");
    }
}

