/*
 * Decompiled with CFR 0.152.
 */
package react4j.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import react4j.processor.BuilderDescriptor;
import react4j.processor.CallbackDescriptor;
import react4j.processor.ComponentDescriptor;
import react4j.processor.MethodDescriptor;
import react4j.processor.ProcessorUtil;
import react4j.processor.PropDescriptor;
import react4j.processor.ReactProcessor;
import react4j.processor.ReactProcessorException;
import react4j.processor.StateValueDescriptor;
import react4j.processor.Step;
import react4j.processor.StepMethod;
import react4j.processor.StepMethodType;
import react4j.processor.vendor.javapoet.AnnotationSpec;
import react4j.processor.vendor.javapoet.ClassName;
import react4j.processor.vendor.javapoet.CodeBlock;
import react4j.processor.vendor.javapoet.FieldSpec;
import react4j.processor.vendor.javapoet.MethodSpec;
import react4j.processor.vendor.javapoet.ParameterSpec;
import react4j.processor.vendor.javapoet.ParameterizedTypeName;
import react4j.processor.vendor.javapoet.TypeName;
import react4j.processor.vendor.javapoet.TypeSpec;
import react4j.processor.vendor.javapoet.TypeVariableName;
import react4j.processor.vendor.javapoet.WildcardTypeName;

final class Generator {
    private static final ClassName INJECT_CLASSNAME = ClassName.get("javax.inject", "Inject", new String[0]);
    private static final ClassName PROVIDER_CLASSNAME = ClassName.get("javax.inject", "Provider", new String[0]);
    private static final ClassName NONNULL_CLASSNAME = ClassName.get("javax.annotation", "Nonnull", new String[0]);
    private static final ClassName NULLABLE_CLASSNAME = ClassName.get("javax.annotation", "Nullable", new String[0]);
    private static final ClassName GUARDS_CLASSNAME = ClassName.get("org.realityforge.braincheck", "Guards", new String[0]);
    private static final ClassName OBSERVABLE_CLASSNAME = ClassName.get("arez", "Observable", new String[0]);
    private static final ClassName AREZ_FEATURE_CLASSNAME = ClassName.get("arez.annotations", "Feature", new String[0]);
    private static final ClassName ACTION_CLASSNAME = ClassName.get("arez.annotations", "Action", new String[0]);
    private static final ClassName OBSERVABLE_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "Observable", new String[0]);
    private static final ClassName OBSERVABLE_REF_ANNOTATION_CLASSNAME = ClassName.get("arez.annotations", "ObservableRef", new String[0]);
    private static final ClassName AREZ_COMPONENT_CLASSNAME = ClassName.get("arez.annotations", "ArezComponent", new String[0]);
    private static final ClassName AREZ_DEPENDENCY_CLASSNAME = ClassName.get("arez.annotations", "Dependency", new String[0]);
    private static final ClassName JS_OBJECT_CLASSNAME = ClassName.get("elemental2.core", "JsObject", new String[0]);
    private static final ClassName JS_ARRAY_CLASSNAME = ClassName.get("elemental2.core", "JsArray", new String[0]);
    private static final ClassName JS_TYPE_CLASSNAME = ClassName.get("jsinterop.annotations", "JsType", new String[0]);
    private static final ClassName JS_CLASSNAME = ClassName.get("jsinterop.base", "Js", new String[0]);
    private static final ClassName JS_PROPERTY_MAP_CLASSNAME = ClassName.get("jsinterop.base", "JsPropertyMap", new String[0]);
    private static final ParameterizedTypeName JS_PROPERTY_MAP_T_OBJECT_CLASSNAME = ParameterizedTypeName.get(JS_PROPERTY_MAP_CLASSNAME, TypeName.OBJECT);
    private static final ClassName COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME = ClassName.get("react4j.core", "ComponentConstructorFunction", new String[0]);
    private static final ClassName REACT_NODE_CLASSNAME = ClassName.get("react4j.core", "ReactNode", new String[0]);
    private static final ClassName REACT_NATIVE_ADAPTER_COMPONENT_CLASSNAME = ClassName.get("react4j.core", "NativeAdapterComponent", new String[0]);
    private static final ClassName REACT_CLASSNAME = ClassName.get("react4j.core", "React", new String[0]);
    private static final ClassName REACT_CONFIG_CLASSNAME = ClassName.get("react4j.core", "ReactConfig", new String[0]);
    private static final ClassName COMPONENT_CLASSNAME = ClassName.get("react4j.core", "Component", new String[0]);

    private Generator() {
    }

    @Nonnull
    static TypeSpec buildComponentBuilder(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getBuilderClassName());
        Generator.markTypeAsGenerated(builder);
        ProcessorUtil.copyAccessModifiers(descriptor.getElement(), builder);
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        BuilderDescriptor builderDescriptor = Generator.buildBuilderDescriptor(descriptor);
        ArrayList<Step> steps = builderDescriptor.getSteps();
        for (Step step : steps) {
            builder.addType(Generator.buildBuilderStepInterface(descriptor, step));
        }
        Generator.buildStaticStepMethodMethods(descriptor, builder, steps.get(0));
        Generator.buildStaticStepMethodMethods(descriptor, builder, steps.get(1));
        builder.addType(Generator.buildBuilder(descriptor, builderDescriptor));
        return builder.build();
    }

    private static void buildStaticStepMethodMethods(@Nonnull ComponentDescriptor descriptor, @Nonnull TypeSpec.Builder builder, @Nonnull Step step) {
        ArrayList<StepMethod> methods = step.getMethods();
        for (StepMethod method : methods) {
            builder.addMethod(Generator.buildStaticStepMethodMethod(descriptor, step, method));
        }
    }

    @Nonnull
    private static MethodSpec buildStaticStepMethodMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        ExecutableType propMethodType;
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName()).addAnnotation(NONNULL_CLASSNAME);
        method.addModifiers(Modifier.STATIC);
        if (descriptor.getDeclaredType().asElement().getModifiers().contains((Object)Modifier.PUBLIC)) {
            method.addModifiers(Modifier.PUBLIC);
        }
        if (null != (propMethodType = stepMethod.getPropMethodType())) {
            ProcessorUtil.copyTypeParameters(propMethodType, method);
        }
        ProcessorUtil.copyTypeParameters(descriptor.getElement(), method);
        if (!stepMethod.isBuildIntrinsic()) {
            ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), Modifier.FINAL);
            ExecutableElement propMethod = stepMethod.getPropMethod();
            if (null != propMethod) {
                ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)propMethod, parameter);
            } else if (stepMethod.isKeyIntrinsic() || stepMethod.isChildrenStreamIntrinsic()) {
                parameter.addAnnotation(NONNULL_CLASSNAME);
            } else if (stepMethod.isChildOfChildrenIntrinsic()) {
                parameter.addAnnotation(NULLABLE_CLASSNAME);
            }
            method.addParameter(parameter.build());
        }
        String infix = Generator.asTypeArgumentsInfix(descriptor.getDeclaredType());
        if (stepMethod.isBuildIntrinsic()) {
            method.addStatement("return new $T" + infix + "().build()", ClassName.bestGuess("Builder"));
        } else {
            method.addStatement("return new $T" + infix + "().$N( $N )", ClassName.bestGuess("Builder"), stepMethod.getName(), stepMethod.getName());
        }
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec.Builder buildStepInterfaceMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull String name, @Nonnull Step step, @Nonnull StepMethodType stepMethodType, @Nonnull Consumer<MethodSpec.Builder> action) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(name);
        method.addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT);
        method.addAnnotation(NONNULL_CLASSNAME);
        action.accept(method);
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethodType);
        return method;
    }

    private static void configureStepMethodReturns(@Nonnull ComponentDescriptor descriptor, @Nonnull MethodSpec.Builder method, @Nonnull Step step, @Nonnull StepMethodType stepMethodType) {
        if (StepMethodType.TERMINATE == stepMethodType) {
            method.returns(REACT_NODE_CLASSNAME);
        } else {
            int returnIndex = step.getIndex() + (StepMethodType.STAY == stepMethodType ? 0 : 1);
            ClassName className = ClassName.bestGuess("Builder" + returnIndex);
            List<TypeVariableName> variableNames = ProcessorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType());
            if (variableNames.isEmpty()) {
                method.returns(className);
            } else {
                method.returns(ParameterizedTypeName.get(className, variableNames.toArray(new TypeName[0])));
            }
        }
    }

    @Nonnull
    private static TypeSpec buildBuilderStepInterface(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step) {
        int stepIndex = step.getIndex();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("Builder" + stepIndex);
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builder.addTypeVariables(ProcessorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        if (!descriptor.getDeclaredType().getTypeArguments().isEmpty()) {
            builder.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "unused").build());
        }
        for (StepMethod stepMethod : step.getMethods()) {
            StepMethodType stepMethodType = stepMethod.getStepMethodType();
            if (stepMethod.isBuildIntrinsic()) {
                builder.addMethod(Generator.buildStepInterfaceMethod(descriptor, "build", step, stepMethodType, m -> {}).build());
                continue;
            }
            builder.addMethod(Generator.buildStepInterfaceMethod(descriptor, stepMethod.getName(), step, stepMethodType, m -> {
                ExecutableType propMethodType = stepMethod.getPropMethodType();
                if (null != propMethodType) {
                    ProcessorUtil.copyTypeParameters(propMethodType, m);
                }
                if (stepMethod.isChildrenIntrinsic()) {
                    m.varargs();
                }
                ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), new Modifier[0]);
                ExecutableElement propMethod = stepMethod.getPropMethod();
                if (null != propMethod) {
                    ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)propMethod, parameter);
                } else if (stepMethod.isKeyIntrinsic() || stepMethod.isChildrenStreamIntrinsic()) {
                    parameter.addAnnotation(NONNULL_CLASSNAME);
                } else if (stepMethod.isChildOfChildrenIntrinsic()) {
                    parameter.addAnnotation(NULLABLE_CLASSNAME);
                }
                m.addParameter(parameter.build());
            }).build());
        }
        return builder.build();
    }

    @Nonnull
    private static MethodSpec buildBuilderStepImpl(@Nonnull ComponentDescriptor descriptor, @Nonnull Step step, @Nonnull StepMethod stepMethod) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(stepMethod.getName());
        method.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        method.addAnnotation(Override.class);
        method.addAnnotation(NONNULL_CLASSNAME);
        ExecutableType propMethodType = stepMethod.getPropMethodType();
        if (null != propMethodType) {
            ProcessorUtil.copyTypeParameters(propMethodType, method);
        }
        ParameterSpec.Builder parameter = ParameterSpec.builder(stepMethod.getType(), stepMethod.getName(), Modifier.FINAL);
        ExecutableElement propMethod = stepMethod.getPropMethod();
        if (null != propMethod) {
            ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)propMethod, parameter);
        } else if (stepMethod.isKeyIntrinsic() || stepMethod.isChildrenStreamIntrinsic()) {
            parameter.addAnnotation(NONNULL_CLASSNAME);
        } else if (stepMethod.isChildOfChildrenIntrinsic()) {
            parameter.addAnnotation(NULLABLE_CLASSNAME);
        }
        method.addParameter(parameter.build());
        if (stepMethod.isChildrenIntrinsic()) {
            method.varargs();
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("for ( final $T child : $N )", REACT_NODE_CLASSNAME, stepMethod.getName());
            block.addStatement("child( child )", new Object[0]);
            block.endControlFlow();
            method.addCode(block.build());
        } else if (stepMethod.isChildOfChildrenIntrinsic()) {
            CodeBlock.Builder block = CodeBlock.builder();
            block.beginControlFlow("if ( null != $N )", stepMethod.getName());
            block.addStatement("_children.push( $N )", stepMethod.getName());
            block.endControlFlow();
            method.addCode(block.build());
        } else if (stepMethod.isChildrenStreamIntrinsic()) {
            method.addStatement("children( $N.toArray( $T[]::new ) )", stepMethod.getName(), REACT_NODE_CLASSNAME);
        } else if (stepMethod.isChildIntrinsic()) {
            assert (null != propMethod);
            if (null != ProcessorUtil.findAnnotationByType(propMethod, "javax.annotation.Nonnull")) {
                method.addStatement("_child = $T.requireNonNull( $N )", Objects.class, stepMethod.getName());
            } else {
                method.addStatement("_child = $N", stepMethod.getName());
            }
        } else if (stepMethod.isKeyIntrinsic() || null != propMethod && null != ProcessorUtil.findAnnotationByType(propMethod, "javax.annotation.Nonnull")) {
            method.addStatement("_props.set( $S, $T.requireNonNull( $N ) )", stepMethod.getName(), Objects.class, stepMethod.getName());
        } else {
            method.addStatement("_props.set( $S, $N )", stepMethod.getName(), stepMethod.getName());
        }
        if (StepMethodType.TERMINATE == stepMethod.getStepMethodType()) {
            method.addStatement("return build()", new Object[0]);
        } else {
            method.addStatement("return this", new Object[0]);
        }
        Generator.configureStepMethodReturns(descriptor, method, step, stepMethod.getStepMethodType());
        return method.build();
    }

    @Nonnull
    private static MethodSpec buildBuildStepImpl(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("build");
        method.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        method.addAnnotation(NONNULL_CLASSNAME);
        if (null != descriptor.findPropNamed("children")) {
            method.addStatement("return $T.createElement( $T.TYPE, $T.uncheckedCast( _props ), _children )", REACT_CLASSNAME, descriptor.getEnhancedClassName(), JS_CLASSNAME);
        } else if (null != descriptor.findPropNamed("child")) {
            method.addStatement("return $T.createElement( $T.TYPE, $T.uncheckedCast( _props ), _child )", REACT_CLASSNAME, descriptor.getEnhancedClassName(), JS_CLASSNAME);
        } else {
            method.addStatement("return $T.createElement( $T.TYPE, $T.uncheckedCast( _props ) )", REACT_CLASSNAME, descriptor.getEnhancedClassName(), JS_CLASSNAME);
        }
        method.returns(REACT_NODE_CLASSNAME);
        return method.build();
    }

    @Nonnull
    private static TypeSpec buildBuilder(@Nonnull ComponentDescriptor descriptor, @Nonnull BuilderDescriptor builderDescriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("Builder");
        ProcessorUtil.copyTypeParameters(descriptor.getElement(), builder);
        builder.addModifiers(Modifier.PRIVATE, Modifier.STATIC);
        ArrayList<Step> steps = builderDescriptor.getSteps();
        for (int i = 0; i < steps.size(); ++i) {
            builder.addSuperinterface(Generator.getParameterizedTypeName(descriptor, ClassName.bestGuess("Builder" + (i + 1))));
        }
        ParameterizedTypeName type = ParameterizedTypeName.get(JS_PROPERTY_MAP_CLASSNAME, TypeName.get(Object.class));
        FieldSpec.Builder field = FieldSpec.builder(type, "_props", Modifier.PRIVATE, Modifier.FINAL);
        field.initializer("$T.of()", JS_PROPERTY_MAP_CLASSNAME);
        builder.addField(field.build());
        HashSet<String> stepMethodsAdded = new HashSet<String>();
        for (Step step : steps) {
            for (StepMethod stepMethod : step.getMethods()) {
                if (!stepMethodsAdded.add(stepMethod.getName() + stepMethod.getType().toString()) || stepMethod.isBuildIntrinsic()) continue;
                builder.addMethod(Generator.buildBuilderStepImpl(descriptor, step, stepMethod));
                if (stepMethod.isChildrenIntrinsic()) {
                    ParameterizedTypeName type2 = ParameterizedTypeName.get(JS_ARRAY_CLASSNAME, REACT_NODE_CLASSNAME);
                    FieldSpec.Builder field2 = FieldSpec.builder(type2, "_children", Modifier.PRIVATE, Modifier.FINAL);
                    field2.initializer("new $T<>()", JS_ARRAY_CLASSNAME);
                    builder.addField(field2.build());
                    continue;
                }
                if (!stepMethod.isChildIntrinsic()) continue;
                FieldSpec.Builder field3 = FieldSpec.builder(REACT_NODE_CLASSNAME, "_child", Modifier.PRIVATE);
                builder.addField(field3.build());
            }
        }
        builder.addMethod(Generator.buildBuildStepImpl(descriptor));
        return builder.build();
    }

    @Nonnull
    private static TypeName getParameterizedTypeName(@Nonnull ComponentDescriptor descriptor, @Nonnull ClassName baseName) {
        List<? extends TypeMirror> arguments = descriptor.getDeclaredType().getTypeArguments();
        if (arguments.isEmpty()) {
            return baseName;
        }
        return ParameterizedTypeName.get(baseName, (TypeName[])arguments.stream().map(TypeName::get).toArray(TypeName[]::new));
    }

    @Nonnull
    static TypeSpec buildComponentHelper(@Nonnull ComponentDescriptor descriptor) {
        assert (descriptor.needsHelper());
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getHelperClassName());
        Generator.markTypeAsGenerated(builder);
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(Modifier.PRIVATE).build());
        for (CallbackDescriptor callback : descriptor.getCallbacks()) {
            builder.addMethod(Generator.buildStaticCallbackMethod(descriptor, callback).build());
        }
        return builder.build();
    }

    @Nonnull
    static TypeSpec buildEnhancedComponent(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(descriptor.getEnhancedClassName());
        builder.addTypeVariables(ProcessorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        builder.superclass(descriptor.getComponentType());
        if (descriptor.isArezComponent()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(AREZ_COMPONENT_CLASSNAME).addMember("name", "$S", descriptor.getName()).addMember("deferSchedule", "true", new Object[0]);
            if (descriptor.needsInjection()) {
                annotation.addMember("inject", "$T.ENABLE", AREZ_FEATURE_CLASSNAME);
            }
            builder.addAnnotation(annotation.build());
            builder.addModifiers(Modifier.ABSTRACT);
        }
        Generator.markTypeAsGenerated(builder);
        FieldSpec.Builder field = FieldSpec.builder(COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, "TYPE", Modifier.STATIC, Modifier.FINAL).initializer("getConstructorFunction()", new Object[0]);
        builder.addField(field.build());
        if (descriptor.needsInjection()) {
            builder.addField(Generator.buildProviderField(descriptor).build());
        }
        for (CallbackDescriptor callback : descriptor.getCallbacks()) {
            builder.addField(Generator.buildCallbackField(callback).build());
        }
        if (descriptor.needsInjection()) {
            builder.addMethod(Generator.buildSetProviderMethod(descriptor).build());
            builder.addMethod(Generator.buildGetProviderMethod(descriptor).build());
        }
        builder.addMethod(Generator.buildConstructorFnMethod(descriptor).build());
        for (PropDescriptor prop : descriptor.getProps()) {
            builder.addMethod(Generator.buildPropMethod(descriptor, prop).build());
            if (!descriptor.isArezComponent()) continue;
            builder.addMethod(Generator.buildPropObservableRefMethod(prop).build());
        }
        for (StateValueDescriptor stateValue : descriptor.getStateValues()) {
            builder.addMethod(Generator.buildStateGetterMethod(descriptor, stateValue).build());
            builder.addMethod(Generator.buildStateSetterMethod(descriptor, stateValue).build());
        }
        if (descriptor.isArezComponent()) {
            builder.addMethod(Generator.buildReportPropsChangedMethod(descriptor).build());
        }
        if (descriptor.needsInjection() && !descriptor.isArezComponent()) {
            builder.addMethod(MethodSpec.constructorBuilder().addAnnotation(INJECT_CLASSNAME).build());
        }
        if (descriptor.shouldRunArezScheduler() && descriptor.isArezComponent()) {
            builder.addMethod(MethodSpec.methodBuilder("triggerScheduler").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED, Modifier.FINAL).addStatement("getContext().triggerScheduler()", new Object[0]).build());
        }
        for (CallbackDescriptor callback : descriptor.getCallbacks()) {
            builder.addMethod(Generator.buildCallbackBuilderMethod(descriptor, callback).build());
        }
        if (descriptor.isArezComponent()) {
            for (CallbackDescriptor callback : descriptor.getCallbacks()) {
                if (!callback.shouldInitCallbackContext()) continue;
                builder.addMethod(Generator.buildCallbackActionMethod(callback).build());
            }
        }
        if (!descriptor.getLifecycleMethods().isEmpty()) {
            builder.addType(Generator.buildNativeLifecycleInterface(descriptor));
        }
        builder.addType(Generator.buildNativeComponent(descriptor));
        return builder.build();
    }

    private static void markTypeAsGenerated(TypeSpec.Builder builder) {
        builder.addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", ReactProcessor.class.getName()).build());
    }

    private static MethodSpec.Builder buildPropMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull PropDescriptor prop) {
        Element propType;
        ExecutableElement methodElement = prop.getMethod();
        ExecutableType methodType = prop.getMethodType();
        TypeMirror returnType = methodType.getReturnType();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodElement.getSimpleName().toString()).returns(TypeName.get(returnType));
        ProcessorUtil.copyTypeParameters(methodType, method);
        ProcessorUtil.copyAccessModifiers(methodElement, method);
        ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)methodElement, method);
        method.addAnnotation(Override.class);
        String name = prop.getName();
        if (descriptor.isArezComponent()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(OBSERVABLE_ANNOTATION_CLASSNAME).addMember("name", "$S", name).addMember("expectSetter", "false", new Object[0]);
            method.addAnnotation(annotation.build());
        }
        if (null != (propType = prop.getPropType()) && descriptor.isArezComponent() && ElementKind.CLASS == propType.getKind() && null != ProcessorUtil.findAnnotationByType(propType, "arez.annotations.ArezComponent")) {
            method.addAnnotation(AnnotationSpec.builder(AREZ_DEPENDENCY_CLASSNAME).build());
        }
        String convertMethodName = Generator.getConverter(returnType, methodElement, "Prop");
        String key = "child".equals(name) ? "children" : name;
        TypeKind resultKind = methodElement.getReturnType().getKind();
        if (!resultKind.isPrimitive() && null == ProcessorUtil.findAnnotationByType(methodElement, "javax.annotation.Nonnull")) {
            method.addStatement("return props().has( $S ) ? props().getAny( $S ).$N() : null", key, key, convertMethodName);
        } else {
            method.addStatement("return props().getAny( $S ).$N()", key, convertMethodName);
        }
        return method;
    }

    @Nonnull
    private static String getConverter(@Nonnull TypeMirror type, @Nonnull Element element, @Nonnull String key) {
        switch (type.getKind()) {
            case BOOLEAN: {
                return "asBoolean";
            }
            case BYTE: {
                return "asByte";
            }
            case CHAR: {
                return "asChar";
            }
            case DOUBLE: {
                return "asDouble";
            }
            case FLOAT: {
                return "asFloat";
            }
            case INT: {
                return "asInt";
            }
            case LONG: {
                return "asLong";
            }
            case SHORT: {
                return "asShort";
            }
            case TYPEVAR: {
                return "cast";
            }
            case DECLARED: {
                if (type.toString().equals("java.lang.String")) {
                    return "asString";
                }
                return "cast";
            }
            case ARRAY: {
                return "cast";
            }
        }
        throw new ReactProcessorException("Return type of @" + key + " method is not yet handled. Type: " + (Object)((Object)type.getKind()), element);
    }

    private static MethodSpec.Builder buildStateSetterMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull StateValueDescriptor stateValue) {
        ExecutableElement methodElement = stateValue.getSetter();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodElement.getSimpleName().toString());
        ProcessorUtil.copyTypeParameters(stateValue.getSetterType(), method);
        ProcessorUtil.copyAccessModifiers(methodElement, method);
        ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)methodElement, method);
        method.addAnnotation(Override.class);
        String name = stateValue.getName();
        if (descriptor.isArezComponent()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(OBSERVABLE_ANNOTATION_CLASSNAME).addMember("name", "$S", name);
            method.addAnnotation(annotation.build());
        }
        TypeMirror parameterType = stateValue.getSetterType().getParameterTypes().get(0);
        VariableElement element = stateValue.getSetter().getParameters().get(0);
        String paramName = element.getSimpleName().toString();
        TypeName type = TypeName.get(parameterType);
        ParameterSpec.Builder param = ParameterSpec.builder(type, paramName, Modifier.FINAL);
        ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)element, param);
        method.addParameter(param.build());
        method.addStatement("scheduleStateUpdate( ( ( previousState, currentProps ) -> $T.of( $S, $N ) ) )", JS_PROPERTY_MAP_CLASSNAME, name, paramName);
        return method;
    }

    private static MethodSpec.Builder buildStateGetterMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull StateValueDescriptor stateValue) {
        TypeMirror returnType = stateValue.getGetterType().getReturnType();
        ExecutableElement methodElement = stateValue.getGetter();
        MethodSpec.Builder method = MethodSpec.methodBuilder(methodElement.getSimpleName().toString()).returns(TypeName.get(returnType));
        ProcessorUtil.copyTypeParameters(stateValue.getGetterType(), method);
        ProcessorUtil.copyAccessModifiers(methodElement, method);
        ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)methodElement, method);
        method.addAnnotation(Override.class);
        String name = stateValue.getName();
        if (descriptor.isArezComponent()) {
            AnnotationSpec.Builder annotation = AnnotationSpec.builder(OBSERVABLE_ANNOTATION_CLASSNAME).addMember("name", "$S", name);
            method.addAnnotation(annotation.build());
        }
        String convertMethodName = Generator.getConverter(returnType, methodElement, "State");
        method.addStatement("return state().getAny( $S ).$N()", name, convertMethodName);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildPropObservableRefMethod(@Nonnull PropDescriptor prop) {
        return MethodSpec.methodBuilder(Generator.toObservableRefMethodName(prop)).addModifiers(Modifier.PROTECTED, Modifier.ABSTRACT).addAnnotation(NONNULL_CLASSNAME).addAnnotation(OBSERVABLE_REF_ANNOTATION_CLASSNAME).returns(OBSERVABLE_CLASSNAME);
    }

    @Nonnull
    private static String toObservableRefMethodName(@Nonnull PropDescriptor prop) {
        String name = prop.getName();
        return "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1) + "Observable";
    }

    @Nonnull
    private static MethodSpec.Builder buildReportPropsChangedMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("reportPropsChanged").addModifiers(Modifier.PROTECTED).addAnnotation(Override.class).addAnnotation(ACTION_CLASSNAME).addParameter(ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "nextProps", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME).build());
        for (PropDescriptor prop : descriptor.getProps()) {
            CodeBlock.Builder block = CodeBlock.builder();
            String code = "if ( !$T.isTripleEqual( props().get( $S ), null == nextProps ? null : nextProps.get( $S ) ) )";
            block.beginControlFlow("if ( !$T.isTripleEqual( props().get( $S ), null == nextProps ? null : nextProps.get( $S ) ) )", JS_CLASSNAME, prop.getName(), prop.getName());
            block.addStatement("$N().reportChanged()", Generator.toObservableRefMethodName(prop));
            block.endControlFlow();
            method.addCode(block.build());
        }
        return method;
    }

    private static FieldSpec.Builder buildProviderField(@Nonnull ComponentDescriptor descriptor) {
        return FieldSpec.builder(ParameterizedTypeName.get(PROVIDER_CLASSNAME, TypeName.get(descriptor.getDeclaredType())), "c_provider", Modifier.STATIC, Modifier.PRIVATE);
    }

    @Nonnull
    private static FieldSpec.Builder buildCallbackField(@Nonnull CallbackDescriptor callback) {
        TypeName handlerType = TypeName.get(callback.getCallbackType().asType());
        String handlerName = "_" + callback.getMethod().getSimpleName().toString();
        return FieldSpec.builder(handlerType, handlerName, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME).initializer("create$N()", handlerName);
    }

    @Nonnull
    private static MethodSpec.Builder buildStaticCallbackMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull CallbackDescriptor callback) {
        TypeName handlerType = TypeName.get(callback.getCallbackType().asType());
        String handlerName = "_" + callback.getMethod().getSimpleName();
        MethodSpec.Builder method = MethodSpec.methodBuilder(handlerName).addAnnotation(NONNULL_CLASSNAME).returns(handlerType);
        method.addModifiers(Modifier.STATIC);
        ParameterSpec.Builder parameter = ParameterSpec.builder(TypeName.get(descriptor.getElement().asType()), "component", Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
        method.addParameter(parameter.build());
        if (!descriptor.getElement().getTypeParameters().isEmpty()) {
            method.addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "unused").build());
            ProcessorUtil.copyTypeParameters(descriptor.getElement(), method);
        }
        method.addStatement("return (($T) component).$N", descriptor.getEnhancedClassName(), handlerName);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildCallbackBuilderMethod(@Nonnull ComponentDescriptor descriptor, @Nonnull CallbackDescriptor callback) {
        int paramCount;
        String args;
        TypeName handlerType = TypeName.get(callback.getCallbackType().asType());
        MethodSpec.Builder method = MethodSpec.methodBuilder("create_" + callback.getMethod().getSimpleName()).addModifiers(Modifier.PRIVATE).addAnnotation(NONNULL_CLASSNAME).returns(handlerType);
        ExecutableElement target = callback.getCallbackMethod();
        int targetParameterCount = target.getParameters().size();
        String string = args = 0 == targetParameterCount ? "()" : IntStream.range(0, targetParameterCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        if (1 < targetParameterCount) {
            args = "(" + args + ")";
        }
        String params = 0 == (paramCount = callback.getMethod().getParameters().size()) ? "" : IntStream.range(0, paramCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        method.addStatement("final $T handler = " + args + " -> this.$N(" + params + ")", handlerType, callback.getMethod().getSimpleName());
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if( $T.enableComponentNames() )", REACT_CONFIG_CLASSNAME);
        String code = "$T.defineProperty( $T.cast( handler ), \"name\", $T.cast( $T.of( \"value\", $S ) ) )";
        block.addStatement("$T.defineProperty( $T.cast( handler ), \"name\", $T.cast( $T.of( \"value\", $S ) ) )", JS_OBJECT_CLASSNAME, JS_CLASSNAME, JS_CLASSNAME, JS_PROPERTY_MAP_CLASSNAME, descriptor.getName() + "." + callback.getName());
        block.endControlFlow();
        method.addCode(block.build());
        method.addStatement("return handler", new Object[0]);
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildCallbackActionMethod(@Nonnull CallbackDescriptor callback) {
        MethodSpec.Builder method = MethodSpec.methodBuilder(callback.getMethod().getSimpleName().toString()).returns(TypeName.get(callback.getMethodType().getReturnType()));
        ProcessorUtil.copyTypeParameters(callback.getMethodType(), method);
        ProcessorUtil.copyAccessModifiers(callback.getMethod(), method);
        ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)callback.getMethod(), method);
        AnnotationSpec.Builder annotation = AnnotationSpec.builder(ACTION_CLASSNAME).addMember("reportParameters", "false", new Object[0]);
        method.addAnnotation(annotation.build());
        int paramCount = callback.getMethod().getParameters().size();
        for (int i2 = 0; i2 < paramCount; ++i2) {
            TypeMirror paramType = callback.getMethodType().getParameterTypes().get(i2);
            ParameterSpec.Builder parameter = ParameterSpec.builder(TypeName.get(paramType), "arg" + i2, Modifier.FINAL);
            ProcessorUtil.copyDocumentedAnnotations((AnnotatedConstruct)callback.getMethod().getParameters().get(i2), parameter);
            method.addParameter(parameter.build());
        }
        String params = 0 == paramCount ? "" : IntStream.range(0, paramCount).mapToObj(i -> "arg" + i).collect(Collectors.joining(","));
        boolean isVoid = callback.getMethodType().getReturnType().getKind() == TypeKind.VOID;
        method.addStatement((isVoid ? "" : "return ") + "super.$N(" + params + ")", callback.getMethod().getSimpleName());
        return method;
    }

    @Nonnull
    private static MethodSpec.Builder buildSetProviderMethod(@Nonnull ComponentDescriptor descriptor) {
        return MethodSpec.methodBuilder("setProvider").addModifiers(Modifier.STATIC).addParameter(ParameterizedTypeName.get(PROVIDER_CLASSNAME, TypeName.get(descriptor.getDeclaredType())), "provider", Modifier.FINAL).addStatement("c_provider = provider", new Object[0]);
    }

    @Nonnull
    private static MethodSpec.Builder buildGetProviderMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("getProvider").addModifiers(Modifier.PRIVATE, Modifier.STATIC).returns(ParameterizedTypeName.get(PROVIDER_CLASSNAME, TypeName.get(descriptor.getDeclaredType())));
        CodeBlock.Builder block = CodeBlock.builder();
        block.beginControlFlow("if ( $T.shouldCheckInvariants() )", REACT_CONFIG_CLASSNAME);
        block.addStatement("$T.invariant( () -> null != c_provider, () -> \"Attempted to create an instance of the React4j component named '$N' before the dependency injection provider has been initialized. Please see the documentation at https://react4j.github.io/dependency_injection for directions how to configure dependency injection.\" )", GUARDS_CLASSNAME, descriptor.getName());
        block.endControlFlow();
        method.addCode(block.build());
        return method.addStatement("return c_provider", new Object[0]);
    }

    @Nonnull
    private static MethodSpec.Builder buildConstructorFnMethod(@Nonnull ComponentDescriptor descriptor) {
        MethodSpec.Builder method = MethodSpec.methodBuilder("getConstructorFunction").addAnnotation(NONNULL_CLASSNAME).addModifiers(Modifier.STATIC, Modifier.PRIVATE).returns(COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME);
        method.addStatement("final $T componentConstructor = $T::new", COMPONENT_CONSTRUCTOR_FUNCTION_CLASSNAME, ClassName.bestGuess("NativeReactComponent"));
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        codeBlock.beginControlFlow("if ( $T.enableComponentNames() )", REACT_CONFIG_CLASSNAME);
        codeBlock.addStatement("$T.asPropertyMap( componentConstructor ).set( \"displayName\", $S )", JS_CLASSNAME, descriptor.getName());
        codeBlock.endControlFlow();
        method.addCode(codeBlock.build());
        List propsWithDefaults = descriptor.getProps().stream().filter(p -> p.hasDefaultField() || p.hasDefaultMethod()).collect(Collectors.toList());
        if (!propsWithDefaults.isEmpty()) {
            method.addStatement("final $T<$T> defaultProps = $T.of()", JS_PROPERTY_MAP_CLASSNAME, Object.class, JS_PROPERTY_MAP_CLASSNAME);
            for (PropDescriptor prop : propsWithDefaults) {
                method.addStatement("defaultProps.set( $S, $T.$N" + (prop.hasDefaultField() ? "" : "()") + " )", prop.getName(), descriptor.getClassName(), prop.hasDefaultField() ? prop.getDefaultField().getSimpleName() : prop.getDefaultMethod().getSimpleName());
            }
            method.addStatement("$T.asPropertyMap( componentConstructor ).set( \"defaultProps\", defaultProps )", JS_CLASSNAME);
        }
        method.addStatement("return componentConstructor", new Object[0]);
        return method;
    }

    @Nonnull
    private static TypeSpec buildNativeComponent(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("NativeReactComponent");
        builder.addModifiers(Modifier.FINAL);
        builder.addModifiers(Modifier.STATIC);
        builder.addModifiers(Modifier.PRIVATE);
        ParameterizedTypeName superType = ParameterizedTypeName.get(REACT_NATIVE_ADAPTER_COMPONENT_CLASSNAME, descriptor.getComponentType());
        builder.superclass(superType);
        builder.addTypeVariables(ProcessorUtil.getTypeArgumentsAsNames(descriptor.getDeclaredType()));
        if (!descriptor.getLifecycleMethods().isEmpty()) {
            builder.addSuperinterface(ClassName.bestGuess("Lifecycle"));
        }
        ParameterSpec.Builder props = ParameterSpec.builder(JS_PROPERTY_MAP_T_OBJECT_CLASSNAME, "props", Modifier.FINAL).addAnnotation(NULLABLE_CLASSNAME);
        MethodSpec.Builder method = MethodSpec.constructorBuilder().addParameter(props.build());
        method.addStatement("super( props )", new Object[0]);
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder("createComponent").addAnnotation(Override.class).addModifiers(Modifier.PROTECTED).returns(descriptor.getComponentType());
        if (descriptor.needsInjection()) {
            method2.addStatement("return getProvider().get()", new Object[0]);
        } else {
            String infix = Generator.asTypeArgumentsInfix(descriptor.getDeclaredType());
            method2.addStatement("return new $T" + infix + "()", descriptor.getClassNameToConstruct());
        }
        builder.addMethod(method2.build());
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
            MethodSpec.Builder method3 = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.PUBLIC).addAnnotation(Override.class).returns(ClassName.get(lifecycleMethod.getMethodType().getReturnType()));
            ProcessorUtil.copyTypeParameters(lifecycleMethod.getMethodType(), method3);
            StringJoiner params = new StringJoiner(",");
            List<? extends VariableElement> sourceParameters = lifecycleMethod.getMethod().getParameters();
            List<? extends TypeMirror> sourceParameterTypes = lifecycleMethod.getMethodType().getParameterTypes();
            int parameterCount = sourceParameters.size();
            for (int i = 0; i < parameterCount; ++i) {
                VariableElement parameter = sourceParameters.get(i);
                TypeMirror parameterType = sourceParameterTypes.get(i);
                String parameterName = parameter.getSimpleName().toString();
                ParameterSpec.Builder parameterSpec = ParameterSpec.builder(TypeName.get(parameterType), parameterName, Modifier.FINAL).addAnnotation(NONNULL_CLASSNAME);
                method3.addParameter(parameterSpec.build());
                params.add(parameterName);
            }
            StringBuilder sb = new StringBuilder();
            if (TypeKind.VOID != lifecycleMethod.getMethodType().getReturnType().getKind()) {
                sb.append("return ");
            }
            sb.append("perform");
            sb.append(Character.toUpperCase(methodName.charAt(0)));
            sb.append(methodName.substring(1));
            sb.append("(");
            sb.append(params.toString());
            sb.append(")");
            method3.addStatement(sb.toString(), new Object[0]);
            builder.addMethod(method3.build());
        }
        return builder.build();
    }

    private static String asTypeArgumentsInfix(DeclaredType declaredType) {
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        return typeArguments.isEmpty() ? "" : "<" + typeArguments.stream().map(TypeMirror::toString).collect(Collectors.joining(", ")) + ">";
    }

    @Nonnull
    private static TypeSpec buildNativeLifecycleInterface(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("Lifecycle");
        builder.addAnnotation(AnnotationSpec.builder(JS_TYPE_CLASSNAME).addMember("isNative", "true", new Object[0]).build());
        builder.addModifiers(Modifier.STATIC);
        for (MethodDescriptor lifecycleMethod : descriptor.getLifecycleMethods()) {
            String methodName = lifecycleMethod.getMethod().getSimpleName().toString();
            MethodSpec.Builder method = MethodSpec.methodBuilder(methodName).addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).returns(ClassName.get(lifecycleMethod.getMethodType().getReturnType()));
            ProcessorUtil.copyTypeParameters(lifecycleMethod.getMethodType(), method);
            List<? extends VariableElement> sourceParameters = lifecycleMethod.getMethod().getParameters();
            List<? extends TypeMirror> sourceParameterTypes = lifecycleMethod.getMethodType().getParameterTypes();
            int parameterCount = sourceParameters.size();
            for (int i = 0; i < parameterCount; ++i) {
                VariableElement parameter = sourceParameters.get(i);
                TypeMirror parameterType = sourceParameterTypes.get(i);
                String parameterName = parameter.getSimpleName().toString();
                ParameterSpec.Builder parameterSpec = ParameterSpec.builder(TypeName.get(parameterType), parameterName, new Modifier[0]).addAnnotation(NONNULL_CLASSNAME);
                method.addParameter(parameterSpec.build());
            }
            builder.addMethod(method.build());
        }
        return builder.build();
    }

    @Nonnull
    static TypeSpec buildDaggerFactory(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder(descriptor.getDaggerFactoryClassName());
        Generator.markTypeAsGenerated(builder);
        builder.addModifiers(Modifier.PUBLIC);
        MethodSpec.Builder method = MethodSpec.methodBuilder("get" + descriptor.getName() + "DaggerSubcomponent").addModifiers(Modifier.PUBLIC, Modifier.ABSTRACT).returns(ClassName.bestGuess("DaggerSubcomponent"));
        builder.addMethod(method.build());
        method = MethodSpec.methodBuilder("bind" + descriptor.getName()).addModifiers(Modifier.PUBLIC, Modifier.DEFAULT).addStatement("$T.setProvider( () -> $N().get() )", descriptor.getEnhancedClassName(), "get" + descriptor.getName() + "DaggerSubcomponent");
        builder.addMethod(method.build());
        if (descriptor.needsDaggerIntegration()) {
            builder.addType(Generator.buildDaggerModule(descriptor));
            builder.addType(Generator.buildDaggerComponent(descriptor));
        }
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildDaggerComponent(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder("DaggerSubcomponent");
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        AnnotationSpec.Builder subcomponent = AnnotationSpec.builder(ClassName.bestGuess("dagger.Subcomponent"));
        subcomponent.addMember("modules", "DaggerModule.class", new Object[0]);
        builder.addAnnotation(subcomponent.build());
        ParameterizedTypeName typeName = ParameterizedTypeName.get(PROVIDER_CLASSNAME, COMPONENT_CLASSNAME);
        MethodSpec.Builder method = MethodSpec.methodBuilder("createProvider").addModifiers(Modifier.ABSTRACT, Modifier.PUBLIC).returns(typeName);
        builder.addMethod(method.build());
        MethodSpec.Builder method2 = MethodSpec.methodBuilder("get").addModifiers(Modifier.DEFAULT, Modifier.PUBLIC).returns(descriptor.getClassName()).addStatement("return ($T) createProvider().get()", descriptor.getClassName());
        builder.addMethod(method2.build());
        return builder.build();
    }

    @Nonnull
    private static TypeSpec buildDaggerModule(@Nonnull ComponentDescriptor descriptor) {
        TypeSpec.Builder builder = TypeSpec.classBuilder("DaggerModule");
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        builder.addAnnotation(ClassName.bestGuess("dagger.Module"));
        MethodSpec.Builder method = MethodSpec.methodBuilder("provideComponent").addAnnotation(ClassName.bestGuess("dagger.Provides")).addModifiers(Modifier.STATIC).addParameter(descriptor.getClassNameToConstruct(), "component", Modifier.FINAL).returns(COMPONENT_CLASSNAME).addStatement("return component", new Object[0]);
        builder.addMethod(method.build());
        return builder.build();
    }

    @Nonnull
    private static BuilderDescriptor buildBuilderDescriptor(@Nonnull ComponentDescriptor descriptor) {
        BuilderDescriptor builder = new BuilderDescriptor();
        Step optionalPropStep = null;
        List<PropDescriptor> props = descriptor.getProps();
        int propsSize = props.size();
        builder.addStep().addStep("key", "key", TypeName.get(String.class), null, null, 0 == propsSize ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
        boolean hasSingleOptional = props.stream().filter(PropDescriptor::isOptional).count() == 1L;
        boolean hasRequiredAfterOptional = false;
        for (int i = 0; i < propsSize; ++i) {
            boolean isLast;
            PropDescriptor prop = props.get(i);
            boolean bl = isLast = i == propsSize - 1;
            if (prop.isOptional()) {
                if (null == optionalPropStep) {
                    optionalPropStep = builder.addStep();
                }
                if (prop.getName().equals("children")) {
                    Generator.addChildPropStepMethod(optionalPropStep, StepMethodType.STAY);
                    Generator.addChildrenStreamPropStepMethod(optionalPropStep);
                }
                Generator.addPropStepMethod(optionalPropStep, prop, hasSingleOptional ? StepMethodType.TERMINATE : StepMethodType.STAY);
                continue;
            }
            if (null != optionalPropStep) {
                Generator.addPropStepMethod(optionalPropStep, prop, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
                if (prop.getName().equals("children")) {
                    Generator.addChildPropStepMethod(optionalPropStep, StepMethodType.ADVANCE);
                    Generator.addChildrenStreamPropStepMethod(optionalPropStep);
                }
                hasRequiredAfterOptional = true;
            }
            Step step = builder.addStep();
            Generator.addPropStepMethod(step, prop, isLast ? StepMethodType.TERMINATE : StepMethodType.ADVANCE);
            if (!prop.getName().equals("children")) continue;
            Generator.addChildPropStepMethod(step, StepMethodType.STAY);
            Generator.addChildrenStreamPropStepMethod(step);
            Generator.addBuildStep(step);
        }
        if (null != optionalPropStep && !hasRequiredAfterOptional) {
            Generator.addBuildStep(optionalPropStep);
        }
        if (props.isEmpty()) {
            Generator.addBuildStep(builder.addStep());
        }
        return builder;
    }

    private static void addBuildStep(@Nonnull Step step) {
        step.addStep("build", "build", REACT_NODE_CLASSNAME, null, null, StepMethodType.TERMINATE);
    }

    private static void addChildPropStepMethod(@Nonnull Step step, @Nonnull StepMethodType stepMethodType) {
        step.addStep("child", "*children_child*", REACT_NODE_CLASSNAME, null, null, stepMethodType);
    }

    private static void addChildrenStreamPropStepMethod(@Nonnull Step step) {
        ParameterizedTypeName typeName = ParameterizedTypeName.get(ClassName.get(Stream.class), WildcardTypeName.subtypeOf(REACT_NODE_CLASSNAME));
        step.addStep("children", "*children_stream*", typeName, null, null, StepMethodType.TERMINATE);
    }

    private static void addPropStepMethod(@Nonnull Step step, @Nonnull PropDescriptor prop, @Nonnull StepMethodType stepMethodType) {
        step.addStep(prop.getName(), prop.getName(), TypeName.get(prop.getMethodType().getReturnType()), prop.getMethod(), prop.getMethodType(), stepMethodType);
    }
}

