/*
 * Decompiled with CFR 0.152.
 */
package org.realityforge.revapi.diff;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.json.Json;
import javax.json.stream.JsonGenerator;
import org.realityforge.getopt4j.CLArgsParser;
import org.realityforge.getopt4j.CLOption;
import org.realityforge.getopt4j.CLOptionDescriptor;
import org.realityforge.getopt4j.CLUtil;
import org.realityforge.revapi.diff.CollectorReporter;
import org.realityforge.revapi.diff.LabeledFileArchive;
import org.realityforge.revapi.diff.RawFormatter;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.AnalysisResult;
import org.revapi.Archive;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.Element;
import org.revapi.Report;
import org.revapi.Revapi;
import org.revapi.simple.FileArchive;

public class Main {
    private static final int HELP_OPT = 104;
    private static final int QUIET_OPT = 113;
    private static final int VERBOSE_OPT = 118;
    private static final int CONFIG_OPT = 2;
    private static final int OLD_API_OPT = 3;
    private static final int OLD_API_SUPPORT_OPT = 4;
    private static final int NEW_API_OPT = 5;
    private static final int NEW_API_SUPPORT_OPT = 6;
    private static final int EXPECT_NO_DIFFERENCES_OPT = 7;
    private static final int OUTPUT_OPT = 111;
    private static final CLOptionDescriptor[] OPTIONS = new CLOptionDescriptor[]{new CLOptionDescriptor("help", 8, 104, "print this message and exit"), new CLOptionDescriptor("quiet", 8, 113, "Do not output unless an error occurs, just return 0 on no difference.", new int[]{118}), new CLOptionDescriptor("verbose", 8, 118, "Verbose output of differences.", new int[]{113}), new CLOptionDescriptor("config-file", 2, 2, "The json config file passed to Revapi."), new CLOptionDescriptor("old-api", 34, 3, "Specify the path to a jar to compare against. May be specified multiple times. May also be prefixed with <label>:: so that report is generated with using <label> for archive."), new CLOptionDescriptor("old-api-support", 34, 4, "Specify the path to a jar to referenced by the old-api but not part of the analysis. May be specified multiple times."), new CLOptionDescriptor("new-api", 34, 5, "Specify the path to a jar compared by the tool. May be specified multiple times. May also be prefixed with <label>:: so that report is generated with using <label> for archive."), new CLOptionDescriptor("new-api-support", 34, 6, "Specify the path to a jar to referenced by the new-api but not part of the analysis. May be specified multiple times."), new CLOptionDescriptor("output-file", 2, 111, "The output file reporting the API differences."), new CLOptionDescriptor("expect-no-differences", 8, 7, "Return exit code of 1 if API differences are detected.")};
    private static final int SUCCESS_EXIT_CODE = 0;
    private static final int DIFFERENCE_EXIT_CODE = 1;
    private static final int ERROR_PARSING_ARGS_EXIT_CODE = 2;
    private static final int ERROR_OTHER_EXIT_CODE = 3;
    private static final Set<String> ATTACHMENT_EXCLUDES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("exampleUseChainInNewApi", "exampleUseChainInOldApi", "newArchive", "oldArchive")));
    private static final String DEFAULT_CONFIG = "[\n  {\n    \"extension\": \"revapi.java\",\n    \"configuration\": {\n      \"missing-classes\": {\n        \"behavior\": \"ignore\",\n        \"ignoreMissingAnnotations\": true\n      },\n      \"reportUsesFor\": \"all-differences\"\n    }\n  }\n]";
    private static final Logger c_logger = Logger.getGlobal();
    private static Revapi c_revapi;
    private static AnalysisContext.Builder c_builder;
    private static API.Builder c_oldAPI;
    private static API.Builder c_newAPI;
    private static File c_configFile;
    private static File c_outputFile;
    private static boolean c_errorOnDifferences;

    public static void main(String[] args) {
        int differenceCount;
        Main.setupLogger();
        Main.setupRevapi();
        if (!Main.processOptions(args)) {
            System.exit(2);
            return;
        }
        try {
            AnalysisContext analysisContext = Main.buildAnalysisContext();
            AnalysisResult analyze = c_revapi.analyze(analysisContext);
            analyze.throwIfFailed();
            Map reporters = analyze.getExtensions().getReporters();
            CollectorReporter reporter = (CollectorReporter)((Object)reporters.keySet().iterator().next());
            differenceCount = Main.emitReport(reporter);
        }
        catch (Throwable t) {
            c_logger.log(Level.SEVERE, "Error performing analysis: " + t);
            t.printStackTrace();
            System.exit(3);
            return;
        }
        if (0 != differenceCount) {
            if (c_logger.isLoggable(Level.INFO)) {
                c_logger.log(Level.SEVERE, differenceCount + " differences found between APIs");
            }
            if (c_errorOnDifferences) {
                System.exit(1);
            } else {
                System.exit(0);
            }
        } else {
            if (c_logger.isLoggable(Level.INFO)) {
                c_logger.log(Level.INFO, "No difference found between APIs");
            }
            System.exit(0);
        }
    }

    private static int emitReport(@Nonnull CollectorReporter reporter) throws IOException {
        JsonGenerator g;
        int differenceCount = 0;
        List<Report> reports = reporter.getReports();
        try (FileOutputStream output = new FileOutputStream(c_outputFile);){
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            g = Json.createGeneratorFactory(config).createGenerator((OutputStream)output);
            g.flush();
            g.close();
        }
        Main.formatJson(c_outputFile);
        return differenceCount += Main.emitReports(g, reports);
    }

    private static void formatJson(@Nonnull File file) throws IOException {
        byte[] data = Files.readAllBytes(file.toPath());
        Charset charset = Charset.forName("UTF-8");
        String jsonData = new String(data, charset);
        String output = jsonData.replaceAll("(?m)^ {4}\\{", "  {").replaceAll("(?m)^ {4}}", "  }").replaceAll("(?m)^ {8}\"", "    \"").replaceAll("(?m)^ {8}}", "    }").replaceAll("(?m)^ {12}\"", "      \"").replaceAll("(?m)^\n\\[\n", "[\n") + "\n";
        Files.write(file.toPath(), output.getBytes(charset), new OpenOption[0]);
    }

    private static int emitReports(@Nonnull JsonGenerator g, @Nonnull List<Report> reports) {
        int differenceCount = 0;
        g.writeStartArray();
        for (Report report : reports) {
            List<Difference> differences = Main.sort(report);
            for (Difference difference : differences) {
                Main.emitDifference(g, report, difference);
                ++differenceCount;
            }
        }
        g.writeEnd();
        return differenceCount;
    }

    @Nonnull
    private static List<Difference> sort(@Nonnull Report report) {
        return report.getDifferences().stream().sorted(Main::compareDiff).collect(Collectors.toList());
    }

    private static int compareDiff(@Nonnull Difference d1, @Nonnull Difference d2) {
        return Main.toDescriptor(d1).compareTo(Main.toDescriptor(d2));
    }

    @Nonnull
    private static String toDescriptor(@Nonnull Difference d) {
        return d.code + "-" + Main.sortKeys(d.classification).stream().map(k -> k + "=" + d.classification.get(k)).collect(Collectors.joining(",")) + "-" + Main.sortKeys(d.attachments).stream().map(k -> k + "=" + (String)d.attachments.get(k)).collect(Collectors.joining(","));
    }

    @Nonnull
    private static <K, V> List<K> sortKeys(@Nonnull Map<K, V> map) {
        return map.keySet().stream().sorted().collect(Collectors.toList());
    }

    private static void emitDifference(@Nonnull JsonGenerator g, @Nonnull Report report, @Nonnull Difference difference) {
        g.writeStartObject();
        g.write("code", difference.code);
        g.write("description", difference.description);
        Element newElement = report.getNewElement();
        Element oldElement = report.getOldElement();
        if (null != oldElement && null != newElement && newElement.getFullHumanReadableString().equals(oldElement.getFullHumanReadableString())) {
            g.write("element", newElement.getFullHumanReadableString());
        } else {
            if (null != newElement) {
                g.write("newElement", newElement.getFullHumanReadableString());
            }
            if (null != oldElement) {
                g.write("oldElement", oldElement.getFullHumanReadableString());
            }
        }
        g.writeStartObject("classification");
        for (Object key : Main.sortKeys(difference.classification)) {
            g.write(key.name(), ((DifferenceSeverity)difference.classification.get(key)).name());
        }
        g.writeEnd();
        g.writeStartObject("attachments");
        for (Object key : Main.sortKeys(difference.attachments)) {
            if (ATTACHMENT_EXCLUDES.contains(key)) continue;
            g.write((String)key, (String)difference.attachments.get(key));
        }
        g.writeEnd();
        g.writeEnd();
    }

    @Nonnull
    private static AnalysisContext buildAnalysisContext() throws IOException {
        c_builder.withOldAPI(c_oldAPI.build());
        c_builder.withNewAPI(c_newAPI.build());
        if (null != c_configFile) {
            c_builder.withConfigurationFromJSONStream((InputStream)new FileInputStream(c_configFile));
        } else {
            c_builder.withConfigurationFromJSON(DEFAULT_CONFIG);
        }
        return c_builder.build();
    }

    private static void setupRevapi() {
        c_revapi = Revapi.builder().withReporters(new Class[]{CollectorReporter.class}).withAllExtensionsFromThreadContextClassLoader().build();
        c_builder = AnalysisContext.builder();
        c_oldAPI = API.builder();
        c_newAPI = API.builder();
    }

    private static void setupLogger() {
        c_logger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new RawFormatter());
        c_logger.addHandler(handler);
    }

    private static boolean processOptions(String[] args) {
        CLArgsParser parser = new CLArgsParser(args, OPTIONS);
        if (null != parser.getErrorString()) {
            c_logger.log(Level.SEVERE, "Error: " + parser.getErrorString());
            return false;
        }
        boolean newApiAdded = false;
        boolean oldApiAdded = false;
        List options = parser.getArguments();
        for (CLOption option : options) {
            switch (option.getId()) {
                case 0: {
                    c_logger.log(Level.SEVERE, "Error: Unexpected argument: " + option.getArgument());
                    return false;
                }
                case 2: {
                    String argument = option.getArgument();
                    File file = new File(argument);
                    if (!file.exists()) {
                        c_logger.log(Level.SEVERE, "Error: Specified config file does not exist: " + argument);
                        return false;
                    }
                    c_configFile = file;
                    break;
                }
                case 3: {
                    oldApiAdded = true;
                    String argument = option.getArgument();
                    LabeledFileArchive archive = Main.parseArchive(argument);
                    if (!archive.getFile().exists()) {
                        c_logger.log(Level.SEVERE, "Error: Specified old api does not exist: " + argument);
                        return false;
                    }
                    c_oldAPI.addArchive((Archive)archive);
                    break;
                }
                case 4: {
                    String argument = option.getArgument();
                    File file = new File(argument);
                    if (!file.exists()) {
                        c_logger.log(Level.SEVERE, "Error: Specified old api support archive does not exist: " + argument);
                        return false;
                    }
                    c_oldAPI.addSupportArchive((Archive)new FileArchive(file));
                    break;
                }
                case 5: {
                    newApiAdded = true;
                    String argument = option.getArgument();
                    LabeledFileArchive archive = Main.parseArchive(argument);
                    if (!archive.getFile().exists()) {
                        c_logger.log(Level.SEVERE, "Error: Specified new api does not exist: " + argument);
                        return false;
                    }
                    c_newAPI.addArchive((Archive)archive);
                    break;
                }
                case 6: {
                    String argument = option.getArgument();
                    File file = new File(argument);
                    if (!file.exists()) {
                        c_logger.log(Level.SEVERE, "Error: Specified new api support archive does not exist: " + argument);
                        return false;
                    }
                    c_newAPI.addSupportArchive((Archive)new FileArchive(file));
                    break;
                }
                case 111: {
                    String argument = option.getArgument();
                    File file = new File(argument);
                    if (!file.getAbsoluteFile().getParentFile().exists()) {
                        c_logger.log(Level.SEVERE, "Error: Directory containing output file does not exist: " + file.getParentFile());
                        return false;
                    }
                    c_outputFile = file;
                    break;
                }
                case 7: {
                    c_errorOnDifferences = true;
                    break;
                }
                case 118: {
                    c_logger.setLevel(Level.ALL);
                    break;
                }
                case 113: {
                    c_logger.setLevel(Level.WARNING);
                    break;
                }
                case 104: {
                    Main.printUsage();
                    return false;
                }
            }
        }
        if (!newApiAdded) {
            c_logger.log(Level.SEVERE, "Error: --new-api not specified");
            return false;
        }
        if (!oldApiAdded) {
            c_logger.log(Level.SEVERE, "Error: --old-api not specified");
            return false;
        }
        if (null == c_outputFile) {
            c_logger.log(Level.SEVERE, "Error: --output-file not specified");
            return false;
        }
        return true;
    }

    private static LabeledFileArchive parseArchive(String argument) {
        File file;
        String name;
        int separatorIndex = argument.indexOf("::");
        if (-1 != separatorIndex) {
            name = argument.substring(0, separatorIndex);
            file = new File(argument.substring(separatorIndex + 2));
        } else {
            file = new File(argument);
            name = file.getName();
        }
        return new LabeledFileArchive(name, file);
    }

    private static void printUsage() {
        String lineSeparator = System.getProperty("line.separator");
        c_logger.log(Level.INFO, "java " + Main.class.getName() + " [options]" + lineSeparator + "Options: " + lineSeparator + CLUtil.describeOptions((CLOptionDescriptor[])OPTIONS));
    }
}

