/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.data;

import org.refcodes.data.QuotationMark;
import org.refcodes.mixin.CharSetAccessor;

public enum CharSet implements CharSetAccessor
{
    ALPHABETIC(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'}),
    ALPHANUMERIC(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}),
    ARABIC_BASE64(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '+', '/'}),
    ASCII(new char[]{' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~'}),
    ASCII_SPECIAL(new char[]{' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '`', '{', '|', '}', '~'}),
    BASE64(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'}),
    BASE64URL(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'}),
    BINARY(new char[]{'0', '1'}),
    CLOSING_BRACES(new char[]{')', ']', '}'}),
    DECIMAL(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}),
    ENCODED_AS_NUMBER(new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9'}),
    END_OF_LINE(new char[]{'\n', '\f'}),
    END_OF_SENTENCE(new char[]{'.', '?', '!'}),
    ESCAPE_SEQUENCES(new char[]{'\t', '\b', '\n', '\r', '\f', '\'', '\"', '\\'}),
    HEXADECIMAL(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'}),
    LINE_BREAK_MARKERS(new char[]{'=', '#', '.', ',', '?', '!', ';', ':', '\t', '\f'}),
    LOWER_CASE(new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'}),
    NUMERIC(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'}),
    OCTAL(new char[]{'0', '1', '2', '3', '4', '5', '6', '7'}),
    OPENING_BRACES(new char[]{'(', '[', '{'}),
    QUOTES(new char[]{QuotationMark.SINGLE_QUOTE.getChar(), '`', '\"'}),
    REGEX_SPECIAL_CHARS(new char[]{'.', '^', '$', '*', '+', '?', '(', ')', '[', '{', '\\', '|'}),
    SPACE_MARKERS(new char[]{' ', '\t', '\n', '\f'}),
    UPPER_CASE(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'}),
    WHITE_SPACES(new char[]{' ', '\t', '\b', '\n', '\f', '\r'});

    private char[] _charSet;

    private CharSet(char[] aCharSet) {
        this._charSet = aCharSet;
    }

    public char[] getCharSet() {
        return this._charSet;
    }

    public boolean hasChar(char aChar) {
        for (char eChar : this._charSet) {
            if (eChar != aChar) continue;
            return true;
        }
        return false;
    }

    public static CharSet toCharset(String aCharsetName) {
        if (aCharsetName == null || aCharsetName.length() == 0) {
            return null;
        }
        for (CharSet eCharset : CharSet.values()) {
            if (!eCharset.name().toLowerCase().replace("_", "").equals(aCharsetName.toLowerCase().replace("_", ""))) continue;
            return eCharset;
        }
        return null;
    }
}

