/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.Delimiter;
import org.refcodes.data.Literal;
import org.refcodes.generator.Generator;
import org.refcodes.generator.UniqueIdGenerator;
import org.refcodes.mixin.IdAccessor;

public enum Correlation implements IdAccessor.IdProperty<String>
{
    REQUEST(8),
    SESSION(8);

    private ThreadLocal<String> _correlationId = new ThreadLocal();
    private Generator<String> _generator;

    private Correlation(int n2) {
        this._generator = new UniqueIdGenerator(n2);
    }

    public void setId(String string) {
        this._correlationId.set(string);
    }

    public String getId() {
        return this._correlationId.get();
    }

    public String pullId() {
        String string = this._correlationId.get();
        if (string == null) {
            string = (String)this._generator.next();
            this._correlationId.set(string);
        }
        return string;
    }

    public String nextId() {
        String string = (String)this._generator.next();
        this._correlationId.set(string);
        return string;
    }

    public static String toFullCorrelationId() {
        Object object = "";
        Correlation[] correlationArray = Correlation.values();
        for (int i = correlationArray.length - 1; i >= 0; --i) {
            String string;
            if (((String)object).length() != 0) {
                object = (String)object + Delimiter.CORRELATION_ID.getChar();
            }
            if ((string = correlationArray[i].getId()) == null) {
                string = Literal.UNKNOWN.getValue();
            }
            object = (String)object + string;
        }
        return object;
    }

    public static boolean hasAnyCorrelationId() {
        for (Correlation correlation : Correlation.values()) {
            if (correlation.getId() == null) continue;
            return true;
        }
        return false;
    }
}

