/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.util.Arrays;
import org.refcodes.data.Delimiter;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.ExceptionUtility;

public final class EnvironmentUtility {
    private EnvironmentUtility() {
    }

    public static String toAbsoluteUserHomePath(String string) throws IllegalStateException {
        File file = new File(string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        try {
            String string2 = EnvironmentVariable.USER_HOME.getValue();
            if (string2 == null || string2.length() == 0) {
                string2 = SystemProperty.USER_HOME.getValue();
            }
            return EnvironmentUtility.toAbsolutePathFromEnvironment(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalStateException(ExceptionUtility.toMessage((Throwable)illegalArgumentException), illegalArgumentException);
        }
    }

    public static String toAbsolutePathFromEnvironment(String string, String ... stringArray) throws IllegalArgumentException {
        if (string == null || string.length() == 0 || string.charAt(0) == Delimiter.PATH.getChar() || string.length() > 1 && string.charAt(1) == ':') {
            return string;
        }
        File file = new File(string);
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = System.getenv(stringArray[i]);
            if (string2 == null || string2.length() <= 0) continue;
            String string3 = string2 + Delimiter.PATH.getChar() + string;
            return string3;
        }
        throw new IllegalArgumentException("A relative path \"" + string + "\" was provided though the system environment variable(s) " + Arrays.asList(stringArray).toString() + " is not set, unable to create an absolute path. Either set the system environment variable or specify an absolute path.");
    }

    public static String toPlatformSpecificPath(String string) {
        String string2 = SystemProperty.FILE_SEPARATOR.getValue();
        if (string2 == null || string2.length() == 1) {
            // empty if block
        }
        return string;
    }
}

