/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Locale;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.struct.PrimitiveArrayType;
import org.refcodes.time.DateFormat;
import org.refcodes.time.DateFormats;

public enum SimpleType {
    DEFAULT(false, true, false),
    KEEP_TYPES(true, true, false),
    WRAPPER_TYPES(false, true, false),
    PRIMITIVE_TYPES(true, false, false),
    KEEP_TYPES_WITH_ARRAY_TYPES(true, true, true),
    WRAPPER_TYPES_WITH_ARRAY_TYPES(false, true, true),
    PRIMITIVE_TYPES_WITH_ARRAY_TYPES(true, false, true);

    private boolean _hasPrimitiveTypeSupport;
    private boolean _hasWrapperTypeSupport;
    private boolean _hasArrayTypeSupport;

    private SimpleType(boolean bl, boolean bl2, boolean bl3) {
        this._hasPrimitiveTypeSupport = bl;
        this._hasWrapperTypeSupport = bl2;
        this._hasArrayTypeSupport = bl3;
    }

    public boolean hasPrimitiveTypeSupport() {
        return this._hasPrimitiveTypeSupport;
    }

    public boolean hasWrapperTypeSupport() {
        return this._hasWrapperTypeSupport;
    }

    public boolean hasArrayTypeSupport() {
        return this._hasArrayTypeSupport;
    }

    public Class<?> toType(Class<?> clazz) {
        boolean bl = SimpleType.isPrimitiveType(clazz, this._hasArrayTypeSupport);
        boolean bl2 = SimpleType.isWrapperType(clazz, this._hasArrayTypeSupport);
        if (this._hasPrimitiveTypeSupport && this._hasWrapperTypeSupport && (bl || bl2)) {
            return bl ? SimpleType.toPrimitiveType(clazz, this._hasArrayTypeSupport) : SimpleType.toWrapperType(clazz, this._hasArrayTypeSupport);
        }
        if (bl2 && this._hasPrimitiveTypeSupport && !this._hasWrapperTypeSupport) {
            return SimpleType.toPrimitiveType(clazz, this._hasArrayTypeSupport);
        }
        if (bl && !this._hasPrimitiveTypeSupport && this._hasWrapperTypeSupport) {
            return SimpleType.toWrapperType(clazz, this._hasArrayTypeSupport);
        }
        if (bl && this._hasPrimitiveTypeSupport) {
            return SimpleType.toPrimitiveType(clazz, this._hasArrayTypeSupport);
        }
        if (bl2 && this._hasWrapperTypeSupport) {
            return SimpleType.toWrapperType(clazz, this._hasArrayTypeSupport);
        }
        return null;
    }

    public static Class<?> toPrimitiveType(Class<?> clazz) {
        return SimpleType.toPrimitiveType(clazz, false);
    }

    public static Class<?> toPrimitiveType(Class<?> clazz, boolean bl) {
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return Boolean.TYPE;
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            return Byte.TYPE;
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            return Character.TYPE;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return Double.TYPE;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return Float.TYPE;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return Integer.TYPE;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return Long.TYPE;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            return Short.TYPE;
        }
        if (bl && clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (Boolean.TYPE.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Boolean.class.isAssignableFrom(clazz2)) {
                return Array.newInstance(Boolean.TYPE, 0).getClass();
            }
            if (Byte.TYPE.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Byte.class.isAssignableFrom(clazz2)) {
                return Array.newInstance(Byte.TYPE, 0).getClass();
            }
            if (Character.TYPE.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Character.class.isAssignableFrom(clazz2)) {
                return Array.newInstance(Character.TYPE, 0).getClass();
            }
            if (Double.TYPE.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Double.class.isAssignableFrom(clazz2)) {
                return Array.newInstance(Double.TYPE, 0).getClass();
            }
            if (Float.TYPE.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Float.class.isAssignableFrom(clazz2)) {
                return Array.newInstance(Float.TYPE, 0).getClass();
            }
            if (Integer.TYPE.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Integer.class.isAssignableFrom(clazz2)) {
                return Array.newInstance(Integer.TYPE, 0).getClass();
            }
            if (Long.TYPE.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Long.class.isAssignableFrom(clazz2)) {
                return Array.newInstance(Long.TYPE, 0).getClass();
            }
            if (Short.TYPE.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Short.class.isAssignableFrom(clazz2)) {
                return Array.newInstance(Short.TYPE, 0).getClass();
            }
        }
        return null;
    }

    public static Class<?> toWrapperType(Class<?> clazz) {
        return SimpleType.toWrapperType(clazz, false);
    }

    public static Class<?> toWrapperType(Class<?> clazz, boolean bl) {
        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
            return Boolean.class;
        }
        if (Byte.class.isAssignableFrom(clazz) || Byte.TYPE.isAssignableFrom(clazz)) {
            return Byte.class;
        }
        if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
            return Character.class;
        }
        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
            return Double.class;
        }
        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
            return Float.class;
        }
        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
            return Integer.class;
        }
        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
            return Long.class;
        }
        if (Short.class.isAssignableFrom(clazz) || Short.TYPE.isAssignableFrom(clazz)) {
            return Short.class;
        }
        if (bl && clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (Boolean.class.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Boolean.TYPE.isAssignableFrom(clazz2)) {
                return Array.newInstance(Boolean.class, 0).getClass();
            }
            if (Byte.class.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Byte.TYPE.isAssignableFrom(clazz2)) {
                return Array.newInstance(Byte.class, 0).getClass();
            }
            if (Character.class.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Character.TYPE.isAssignableFrom(clazz2)) {
                return Array.newInstance(Character.class, 0).getClass();
            }
            if (Double.class.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Double.TYPE.isAssignableFrom(clazz2)) {
                return Array.newInstance(Double.class, 0).getClass();
            }
            if (Float.class.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Float.TYPE.isAssignableFrom(clazz2)) {
                return Array.newInstance(Float.class, 0).getClass();
            }
            if (Integer.class.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Integer.TYPE.isAssignableFrom(clazz2)) {
                return Array.newInstance(Integer.class, 0).getClass();
            }
            if (Long.class.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Long.TYPE.isAssignableFrom(clazz2)) {
                return Array.newInstance(Long.class, 0).getClass();
            }
            if (Short.class.isAssignableFrom(clazz2)) {
                return clazz;
            }
            if (Short.TYPE.isAssignableFrom(clazz2)) {
                return Array.newInstance(Short.class, 0).getClass();
            }
        }
        return null;
    }

    public static boolean isPrimitiveType(Class<?> clazz, boolean bl) {
        return SimpleType.isPrimitiveType(clazz) || bl && SimpleType.isPrimitiveArrayType(clazz);
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        if (Boolean.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        if (Character.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        if (Double.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        if (Float.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        if (Integer.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        if (Long.TYPE.isAssignableFrom(clazz)) {
            return true;
        }
        return Short.TYPE.isAssignableFrom(clazz);
    }

    public static boolean isPrimitiveArrayType(Class<?> clazz) {
        return PrimitiveArrayType.isPrimitiveArrayType(clazz);
    }

    public static boolean isWrapperType(Class<?> clazz, boolean bl) {
        return SimpleType.isWrapperType(clazz) || bl && SimpleType.isWrapperArrayType(clazz);
    }

    public static boolean isWrapperType(Class<?> clazz) {
        if (Boolean.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Byte.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Character.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Float.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Long.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Short.class.isAssignableFrom(clazz);
    }

    public static boolean isWrapperArrayType(Class<?> clazz) {
        if (Boolean[].class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Byte[].class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Character[].class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Double[].class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Float[].class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Integer[].class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Long[].class.isAssignableFrom(clazz)) {
            return true;
        }
        return Short[].class.isAssignableFrom(clazz);
    }

    public static boolean isSimpleType(Class<?> clazz, boolean bl) {
        return SimpleType.isSimpleType(clazz) || bl && SimpleType.isSimpleArrayType(clazz);
    }

    public static boolean isSimpleType(Class<?> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Class.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return true;
        }
        return SimpleType.isPrimitiveType(clazz) || SimpleType.isWrapperType(clazz);
    }

    public static boolean isSimpleArrayType(Class<?> clazz) {
        if (String[].class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Enum[].class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Class[].class.isAssignableFrom(clazz)) {
            return true;
        }
        return SimpleType.isPrimitiveArrayType(clazz) || SimpleType.isWrapperArrayType(clazz);
    }

    public static boolean isCompositeType(Class<?> clazz, boolean bl) {
        return SimpleType.isCompositeType(clazz) || bl && SimpleType.isCompositeArrayType(clazz);
    }

    public static boolean isCompositeType(Class<?> clazz) {
        return !SimpleType.isSimpleArrayType(clazz);
    }

    public static boolean isCompositeArrayType(Class<?> clazz) {
        return !SimpleType.isSimpleArrayType(clazz);
    }

    public static <T> String fromSimpleType(T t) {
        if (String.class.isAssignableFrom(t.getClass())) {
            return (String)t;
        }
        if (Number.class.isAssignableFrom(t.getClass()) || Boolean.class.isAssignableFrom(t.getClass())) {
            return SimpleType.fromNumber(t);
        }
        if (Character.class.isAssignableFrom(t.getClass())) {
            return SimpleType.fromCharacter((Character)t);
        }
        if (Date.class.isAssignableFrom(t.getClass())) {
            return SimpleType.fromDate((Date)t);
        }
        if (LocalDateTime.class.isAssignableFrom(t.getClass())) {
            return SimpleType.fromLocalDateTime((LocalDateTime)t);
        }
        if (LocalDate.class.isAssignableFrom(t.getClass())) {
            return SimpleType.fromLocalDate((LocalDate)t);
        }
        if (Enum.class.isAssignableFrom(t.getClass())) {
            return SimpleType.fromEnum((Enum)t);
        }
        if (Locale.class.isAssignableFrom(t.getClass())) {
            return SimpleType.fromLocale((Locale)t);
        }
        if (Class.class.isAssignableFrom(t.getClass())) {
            return ((Class)t).getName();
        }
        return null;
    }

    public static <TYPE> TYPE toSimpleType(String string, Class<TYPE> clazz) {
        if (clazz.isAssignableFrom(String.class)) {
            return (TYPE)string;
        }
        if (clazz.isAssignableFrom(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (TYPE)Integer.valueOf(string);
        }
        if (clazz.isAssignableFrom(Short.class) || clazz.equals(Short.TYPE)) {
            return (TYPE)Short.valueOf(string);
        }
        if (clazz.isAssignableFrom(Byte.class) || clazz.equals(Byte.TYPE)) {
            return (TYPE)Byte.valueOf(string);
        }
        if (clazz.isAssignableFrom(Float.class) || clazz.equals(Float.TYPE)) {
            return (TYPE)Float.valueOf(string);
        }
        if (clazz.isAssignableFrom(Double.class) || clazz.equals(Double.TYPE)) {
            return (TYPE)Double.valueOf(string);
        }
        if (clazz.isAssignableFrom(Long.class) || clazz.equals(Long.TYPE)) {
            return (TYPE)Long.valueOf(string);
        }
        if (clazz.isAssignableFrom(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return (TYPE)Boolean.valueOf(string);
        }
        if (clazz.isAssignableFrom(Character.class) || clazz.equals(Character.TYPE)) {
            return (TYPE)SimpleType.toCharacter(string);
        }
        if (clazz.isAssignableFrom(Date.class)) {
            return (TYPE)SimpleType.toDate(string);
        }
        if (clazz.isAssignableFrom(LocalDateTime.class)) {
            return (TYPE)SimpleType.toLocalDateTime(string);
        }
        if (clazz.isAssignableFrom(LocalDate.class)) {
            return (TYPE)SimpleType.toLocalDate(string);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return (TYPE)SimpleType.toEnum(string, clazz);
        }
        if (Locale.class.isAssignableFrom(clazz)) {
            return (TYPE)SimpleType.toLocale(string);
        }
        if (clazz.isAssignableFrom(Class.class)) {
            try {
                return (TYPE)Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> boolean invokeSimpleType(T t, Method method, String string, Class<?> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        if (clazz.equals(String.class)) {
            method.invoke(t, string);
        } else if (Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            Constructor<String> constructor = SimpleType.toNumber(clazz);
            method.invoke(t, constructor.newInstance(string));
        } else if (clazz.equals(Character.class)) {
            method.invoke(t, SimpleType.toCharacter(string));
        } else if (clazz.equals(Date.class)) {
            method.invoke(t, SimpleType.toDate(string));
        } else if (Enum.class.isAssignableFrom(clazz)) {
            method.invoke(t, SimpleType.toEnum(string, clazz));
        } else if (Locale.class.isAssignableFrom(clazz)) {
            method.invoke(t, SimpleType.toLocale(string));
        } else if (clazz.equals(Class.class)) {
            method.invoke(t, Class.forName(string));
        } else if (clazz.equals(Boolean.TYPE)) {
            if (!BooleanLiterals.isTrue((String)string) && !BooleanLiterals.isFalse((String)string)) {
                return false;
            }
            method.invoke(t, BooleanLiterals.isTrue((String)string));
        } else if (clazz.equals(Byte.TYPE)) {
            method.invoke(t, Byte.parseByte(string));
        } else if (clazz.equals(Character.TYPE)) {
            method.invoke(t, SimpleType.toCharacter(string));
        } else if (clazz.equals(Short.TYPE)) {
            method.invoke(t, Short.parseShort(string));
        } else if (clazz.equals(Integer.TYPE)) {
            method.invoke(t, Integer.parseInt(string));
        } else if (clazz.equals(Long.TYPE)) {
            method.invoke(t, Long.parseLong(string));
        } else if (clazz.equals(Float.TYPE)) {
            method.invoke(t, Float.valueOf(Float.parseFloat(string)));
        } else if (clazz.equals(Double.TYPE)) {
            method.invoke(t, Double.parseDouble(string));
        } else {
            return false;
        }
        return true;
    }

    public static <T> boolean invokeSimpleType(T t, Field field, String string, Class<?> clazz) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException {
        if (clazz.equals(String.class)) {
            field.set(t, string);
        } else if (Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            Constructor<String> constructor = SimpleType.toNumber(clazz);
            field.set(t, constructor.newInstance(string));
        } else if (clazz.equals(Character.class)) {
            field.set(t, SimpleType.toCharacter(string));
        } else if (clazz.equals(Date.class)) {
            field.set(t, SimpleType.toDate(string));
        } else if (Enum.class.isAssignableFrom(clazz)) {
            field.set(t, SimpleType.toEnum(string, clazz));
        } else if (Locale.class.isAssignableFrom(clazz)) {
            field.set(t, SimpleType.toLocale(string));
        } else if (clazz.equals(Class.class)) {
            field.set(t, Class.forName(string));
        } else if (clazz.equals(Boolean.TYPE)) {
            if (!BooleanLiterals.isTrue((String)string) && !BooleanLiterals.isFalse((String)string)) {
                return false;
            }
            field.setBoolean(t, BooleanLiterals.isTrue((String)string));
        } else if (clazz.equals(Byte.TYPE)) {
            field.setByte(t, Byte.parseByte(string));
        } else if (clazz.equals(Character.TYPE)) {
            field.setChar(t, SimpleType.toCharacter(string).charValue());
        } else if (clazz.equals(Short.TYPE)) {
            field.setShort(t, Short.parseShort(string));
        } else if (clazz.equals(Integer.TYPE)) {
            field.setInt(t, Integer.parseInt(string));
        } else if (clazz.equals(Long.TYPE)) {
            field.setLong(t, Long.parseLong(string));
        } else if (clazz.equals(Float.TYPE)) {
            field.setFloat(t, Float.parseFloat(string));
        } else if (clazz.equals(Double.TYPE)) {
            field.setDouble(t, Double.parseDouble(string));
        } else {
            return false;
        }
        return true;
    }

    public static <T> boolean invokeSimpleType(T t, int n, String string, Class<?> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (clazz.equals(String.class)) {
            Array.set(t, n, string);
        } else if (Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
            Constructor<String> constructor = SimpleType.toNumber(clazz);
            Array.set(t, n, constructor.newInstance(string));
        } else if (clazz.equals(Character.class)) {
            Array.set(t, n, SimpleType.toCharacter(string));
        } else if (clazz.equals(Date.class)) {
            Array.set(t, n, SimpleType.toDate(string));
        } else if (Enum.class.isAssignableFrom(clazz)) {
            Array.set(t, n, SimpleType.toEnum(string, clazz));
        } else if (Locale.class.isAssignableFrom(clazz)) {
            Array.set(t, n, SimpleType.toLocale(string));
        } else if (clazz.equals(Class.class)) {
            Array.set(t, n, Class.forName(string));
        } else if (clazz.equals(Boolean.TYPE)) {
            if (!BooleanLiterals.isTrue((String)string) && !BooleanLiterals.isFalse((String)string)) {
                return false;
            }
            Array.set(t, n, BooleanLiterals.isTrue((String)string));
        } else if (clazz.equals(Byte.TYPE)) {
            Array.set(t, n, Byte.parseByte(string));
        } else if (clazz.equals(Character.TYPE)) {
            Array.set(t, n, SimpleType.toCharacter(string));
        } else if (clazz.equals(Short.TYPE)) {
            Array.set(t, n, Short.parseShort(string));
        } else if (clazz.equals(Integer.TYPE)) {
            Array.set(t, n, Integer.parseInt(string));
        } else if (clazz.equals(Long.TYPE)) {
            Array.set(t, n, Long.parseLong(string));
        } else if (clazz.equals(Float.TYPE)) {
            Array.set(t, n, Float.valueOf(Float.parseFloat(string)));
        } else if (clazz.equals(Double.TYPE)) {
            Array.set(t, n, Double.parseDouble(string));
        } else {
            return false;
        }
        return true;
    }

    private static <T> String fromDate(Date date) {
        return DateFormat.ISO_OFFSET_DATE_TIME.getFormatter().format(Instant.ofEpochMilli(date.getTime()));
    }

    private static Date toDate(String string) {
        return DateFormats.asDate((String)string);
    }

    private static <T> String fromLocalDate(LocalDate localDate) {
        return DateFormat.ISO_LOCAL_DATE.getFormatter().format(localDate);
    }

    private static LocalDate toLocalDate(String string) {
        return DateFormats.asLocalDate((String)string);
    }

    private static <T> String fromLocalDateTime(LocalDateTime localDateTime) {
        return DateFormat.ISO_LOCAL_DATE_TIME.getFormatter().format(localDateTime);
    }

    private static LocalDateTime toLocalDateTime(String string) {
        return DateFormats.asLocalDateTime((String)string);
    }

    private static <T> String fromEnum(Enum<?> enum_) {
        return enum_.name();
    }

    private static Enum<?> toEnum(String string, Class<?> clazz) {
        return Enum.valueOf(clazz, string);
    }

    private static <T> String fromLocale(Locale locale) {
        return locale.getLanguage() + "-" + locale.getCountry();
    }

    private static Locale toLocale(String string) {
        return Locale.forLanguageTag(string);
    }

    private static <T> String fromCharacter(Character c) {
        return c.toString();
    }

    private static Character toCharacter(String string) {
        if (string.length() != 0) {
            return Character.valueOf(string.charAt(0));
        }
        return null;
    }

    private static <T> String fromNumber(T t) {
        String string = t.toString();
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private static Constructor<String> toNumber(Class<?> clazz) throws NoSuchMethodException {
        Constructor<String> constructor = clazz.getConstructor(String.class);
        try {
            constructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return constructor;
    }
}

