/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.DifferenceTransform;
import org.revapi.Element;

public class SemverIgnoreTransform
implements DifferenceTransform<Element> {
    private boolean enabled;
    private DifferenceSeverity allowedSeverity;
    private List<String> passThroughDifferences;

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        Pattern[] patternArray;
        if (this.enabled) {
            Pattern[] patternArray2 = new Pattern[1];
            patternArray = patternArray2;
            patternArray2[0] = Pattern.compile(".*");
        } else {
            patternArray = new Pattern[]{};
        }
        return patternArray;
    }

    @Nullable
    public Difference transform(@Nullable Element oldElement, @Nullable Element newElement, @Nonnull Difference difference) {
        if (!this.enabled) {
            return difference;
        }
        if (this.passThroughDifferences.contains(difference.code)) {
            return difference;
        }
        if (this.allowedSeverity == null) {
            return this.asBreaking(difference);
        }
        if (this.allowedSeverity == DifferenceSeverity.BREAKING) {
            return null;
        }
        DifferenceSeverity diffSeverity = this.getMaxSeverity(difference);
        if (this.allowedSeverity.ordinal() - diffSeverity.ordinal() >= 0) {
            return null;
        }
        return this.asBreaking(difference);
    }

    private Difference asBreaking(Difference d) {
        Difference.Builder bld = (Difference.Builder)((Difference.Builder)Difference.copy((Difference)d).addClassification(CompatibilityType.OTHER, DifferenceSeverity.BREAKING)).addAttachment("breaksSemanticVersioning", "true");
        if (d.description == null || !d.description.endsWith("(breaks semantic versioning)")) {
            bld.withDescription(d.description == null ? "(breaks semantic versioning)" : d.description + " (breaks semantic versioning)");
        }
        if (!d.name.startsWith("Incompatible with the current version: ")) {
            bld.withName("Incompatible with the current version: " + d.name);
        }
        return bld.build();
    }

    private DifferenceSeverity getMaxSeverity(Difference diff) {
        return (DifferenceSeverity)diff.classification.values().stream().max((d1, d2) -> d1.ordinal() - d2.ordinal()).get();
    }

    public void close() throws Exception {
    }

    @Nullable
    public String getExtensionId() {
        return "revapi.semver.ignore";
    }

    @Nullable
    public Reader getJSONSchema() {
        return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/semver-ignore-schema.json"), Charset.forName("UTF-8"));
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode node = analysisContext.getConfiguration();
        boolean bl = this.enabled = node.get("enabled").isDefined() && node.get("enabled").asBoolean();
        if (this.enabled) {
            if (this.hasMultipleElements(analysisContext.getOldApi().getArchives()) || this.hasMultipleElements(analysisContext.getNewApi().getArchives())) {
                throw new IllegalArgumentException("The semver extension doesn't handle changes in multiple archives at once.");
            }
            Iterator oldArchives = analysisContext.getOldApi().getArchives().iterator();
            Iterator newArchives = analysisContext.getNewApi().getArchives().iterator();
            if (!oldArchives.hasNext() || !newArchives.hasNext()) {
                this.enabled = false;
                return;
            }
            Archive oldArchive = (Archive)oldArchives.next();
            Archive newArchive = (Archive)newArchives.next();
            if (!(oldArchive instanceof Archive.Versioned)) {
                throw new IllegalArgumentException("Old archive doesn't support extracting the version.");
            }
            if (!(newArchive instanceof Archive.Versioned)) {
                throw new IllegalArgumentException("New archive doesn't support extracting the version.");
            }
            String oldVersionString = ((Archive.Versioned)oldArchive).getVersion();
            String newVersionString = ((Archive.Versioned)newArchive).getVersion();
            Version oldVersion = Version.parse(oldVersionString);
            Version newVersion = Version.parse(newVersionString);
            if (newVersion.major == 0 && oldVersion.major == 0 && !node.get("versionIncreaseAllows").isDefined()) {
                DifferenceSeverity minorChangeAllowed = SemverIgnoreTransform.asSeverity(node.get(new String[]{"versionIncreaseAllows", "minor"}), DifferenceSeverity.BREAKING);
                DifferenceSeverity patchVersionAllowed = SemverIgnoreTransform.asSeverity(node.get(new String[]{"versionIncreaseAllows", "patch"}), DifferenceSeverity.NON_BREAKING);
                this.allowedSeverity = newVersion.minor > oldVersion.minor ? minorChangeAllowed : (newVersion.minor == oldVersion.minor && newVersion.patch > oldVersion.patch ? patchVersionAllowed : null);
            } else {
                DifferenceSeverity majorChangeAllowed = SemverIgnoreTransform.asSeverity(node.get(new String[]{"versionIncreaseAllows", "major"}), DifferenceSeverity.BREAKING);
                DifferenceSeverity minorChangeAllowed = SemverIgnoreTransform.asSeverity(node.get(new String[]{"versionIncreaseAllows", "minor"}), DifferenceSeverity.NON_BREAKING);
                DifferenceSeverity patchVersionAllowed = SemverIgnoreTransform.asSeverity(node.get(new String[]{"versionIncreaseAllows", "patch"}), DifferenceSeverity.EQUIVALENT);
                this.allowedSeverity = newVersion.major > oldVersion.major ? majorChangeAllowed : (newVersion.major == oldVersion.major && newVersion.minor > oldVersion.minor ? minorChangeAllowed : patchVersionAllowed);
            }
            this.passThroughDifferences = Collections.emptyList();
            if (node.get("passThroughDifferences").isDefined()) {
                this.passThroughDifferences = node.get("passThroughDifferences").asList().stream().map(ModelNode::asString).collect(Collectors.toList());
            }
        }
    }

    private boolean hasMultipleElements(Iterable<?> it) {
        Iterator<?> i = it.iterator();
        if (!i.hasNext()) {
            return false;
        }
        i.next();
        return i.hasNext();
    }

    private static DifferenceSeverity asSeverity(ModelNode configNode, DifferenceSeverity defaultValue) {
        if (configNode == null || !configNode.isDefined()) {
            return defaultValue;
        }
        switch (configNode.asString()) {
            case "none": {
                return null;
            }
            case "equivalent": {
                return DifferenceSeverity.EQUIVALENT;
            }
            case "nonBreaking": {
                return DifferenceSeverity.NON_BREAKING;
            }
            case "potentiallyBreaking": {
                return DifferenceSeverity.POTENTIALLY_BREAKING;
            }
            case "breaking": {
                return DifferenceSeverity.BREAKING;
            }
        }
        return defaultValue;
    }

    private static final class Version {
        private static final Pattern SEMVER_PATTERN = Pattern.compile("(\\d+)(\\.(\\d+)(?:\\.)?(\\d*))?(\\.|-|\\+)?([0-9A-Za-z-.]*)?");
        final int major;
        final int minor;
        final int patch;
        final String sep;
        final String suffix;

        static Version parse(String version) {
            Matcher m = SEMVER_PATTERN.matcher(version);
            if (!m.matches()) {
                throw new IllegalArgumentException("Could not parse the version string '" + version + "'. It does not follow the semver schema.");
            }
            int major = Integer.valueOf(m.group(1));
            String minorMatch = m.group(3);
            int minor = minorMatch == null || minorMatch.isEmpty() ? 0 : Integer.valueOf(minorMatch);
            int patch = 0;
            String patchMatch = m.group(4);
            if (patchMatch != null && !patchMatch.isEmpty()) {
                patch = Integer.valueOf(patchMatch);
            }
            String sep = m.group(5);
            String suffix = m.group(6);
            if (sep != null && sep.isEmpty()) {
                sep = null;
            }
            if (suffix != null && suffix.isEmpty()) {
                suffix = null;
            }
            return new Version(major, minor, patch, sep, suffix);
        }

        Version(int major, int minor, int patch, String sep, String suffix) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.sep = sep;
            this.suffix = suffix;
        }
    }
}

