/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.util.regex.Pattern;
import org.jboss.dmr.ModelNode;
import org.revapi.Difference;
import org.revapi.Element;

public abstract class DifferenceMatchRecipe {
    final ModelNode config;
    final boolean regex;
    final String code;
    final Pattern codeRegex;
    final String oldElement;
    final Pattern oldElementRegex;
    final String newElement;
    final Pattern newElementRegex;

    protected DifferenceMatchRecipe(ModelNode config) {
        if (!config.has("code")) {
            throw new IllegalArgumentException("Difference code has to be specified.");
        }
        this.regex = config.has("regex") && config.get("regex").asBoolean();
        this.code = config.get("code").asString();
        this.codeRegex = this.regex ? Pattern.compile(this.code) : null;
        this.oldElement = config.has("old") ? config.get("old").asString() : null;
        this.oldElementRegex = this.regex && this.oldElement != null ? Pattern.compile(this.oldElement) : null;
        this.newElement = config.has("new") ? config.get("old").asString() : null;
        this.newElementRegex = this.regex && this.newElement != null ? Pattern.compile(this.newElement) : null;
        this.config = config;
    }

    public boolean matches(Difference difference, Element oldElement, Element newElement) {
        if (this.regex) {
            return !(!this.codeRegex.matcher(difference.code).matches() || this.oldElementRegex != null && !this.oldElementRegex.matcher(oldElement.getFullHumanReadableString()).matches() || this.newElementRegex != null && !this.newElementRegex.matcher(newElement.getFullHumanReadableString()).matches());
        }
        return !(!this.code.equals(difference.code) || this.oldElement != null && !this.oldElement.equals(oldElement.getFullHumanReadableString()) || this.newElement != null && !this.newElement.equals(newElement.getFullHumanReadableString()));
    }

    public abstract Difference transformMatching(Difference var1, Element var2, Element var3);
}

