/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Element;
import org.revapi.ElementFilter;

public class ConfigurableElementFilter
implements ElementFilter {
    private final List<Pattern> elementIncludes = new ArrayList<Pattern>();
    private final List<Pattern> elementExcludes = new ArrayList<Pattern>();
    private final List<Pattern> archiveIncludes = new ArrayList<Pattern>();
    private final List<Pattern> archiveExcludes = new ArrayList<Pattern>();
    private boolean doNothing;

    @Nullable
    public String[] getConfigurationRootPaths() {
        return new String[]{"revapi.filter"};
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        if ("revapi.filter".equals(configurationRootPath)) {
            return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/filter-schema.json"), Charset.forName("UTF-8"));
        }
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode archives;
        ModelNode root = analysisContext.getConfiguration().get(new String[]{"revapi", "filter"});
        if (!root.isDefined()) {
            this.doNothing = true;
            return;
        }
        ModelNode elements = root.get("elements");
        if (elements.isDefined()) {
            ConfigurableElementFilter.readFilter(elements, this.elementIncludes, this.elementExcludes);
        }
        if ((archives = root.get("archives")).isDefined()) {
            ConfigurableElementFilter.readFilter(archives, this.archiveIncludes, this.archiveExcludes);
        }
        this.doNothing = this.elementIncludes.isEmpty() && this.elementExcludes.isEmpty() && this.archiveIncludes.isEmpty() && this.archiveExcludes.isEmpty();
    }

    public boolean applies(@Nullable Element element) {
        if (this.doNothing) {
            return true;
        }
        String archive = element == null ? null : (element.getArchive() == null ? null : element.getArchive().getName());
        boolean include = true;
        if (archive != null) {
            include = ConfigurableElementFilter.isIncluded(archive, this.archiveIncludes, this.archiveExcludes);
        }
        if (include) {
            String representation;
            String string = representation = element == null ? null : element.getFullHumanReadableString();
            if (representation != null) {
                include = ConfigurableElementFilter.isIncluded(representation, this.elementIncludes, this.elementExcludes);
            }
        }
        return include;
    }

    public boolean shouldDescendInto(@Nullable Object element) {
        return true;
    }

    public void close() {
    }

    private static void readFilter(ModelNode root, List<Pattern> include, List<Pattern> exclude) {
        ModelNode excludeNode;
        ModelNode includeNode = root.get("include");
        if (includeNode.isDefined()) {
            for (ModelNode inc : includeNode.asList()) {
                include.add(Pattern.compile(inc.asString()));
            }
        }
        if ((excludeNode = root.get("exclude")).isDefined()) {
            for (ModelNode exc : excludeNode.asList()) {
                exclude.add(Pattern.compile(exc.asString()));
            }
        }
    }

    private static boolean isIncluded(String representation, List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        boolean include = true;
        if (!includePatterns.isEmpty()) {
            include = false;
            for (Pattern p : includePatterns) {
                if (!p.matcher(representation).matches()) continue;
                include = true;
                break;
            }
        }
        if (include) {
            for (Pattern p : excludePatterns) {
                if (!p.matcher(representation).matches()) continue;
                include = false;
                break;
            }
        }
        return include;
    }
}

