/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Archive;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.DifferenceTransform;
import org.revapi.Element;

public class SemverIgnoreTransform
implements DifferenceTransform<Element> {
    private boolean enabled;
    private DifferenceSeverity allowedSeverity;

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        Pattern[] patternArray;
        if (this.enabled) {
            Pattern[] patternArray2 = new Pattern[1];
            patternArray = patternArray2;
            patternArray2[0] = Pattern.compile(".*");
        } else {
            patternArray = new Pattern[]{};
        }
        return patternArray;
    }

    @Nullable
    public Difference transform(@Nullable Element oldElement, @Nullable Element newElement, @Nonnull Difference difference) {
        if (!this.enabled || this.allowedSeverity == null) {
            return difference;
        }
        if (this.allowedSeverity == DifferenceSeverity.BREAKING) {
            return null;
        }
        DifferenceSeverity diffSeverity = this.getMaxSeverity(difference);
        if (this.allowedSeverity.ordinal() - diffSeverity.ordinal() >= 0) {
            return null;
        }
        return difference;
    }

    private DifferenceSeverity getMaxSeverity(Difference diff) {
        return (DifferenceSeverity)diff.classification.values().stream().max((d1, d2) -> d1.ordinal() - d2.ordinal()).get();
    }

    public void close() throws Exception {
    }

    @Nullable
    public String[] getConfigurationRootPaths() {
        return new String[]{"revapi.semver.ignore"};
    }

    @Nullable
    public Reader getJSONSchema(@Nonnull String configurationRootPath) {
        if ("revapi.semver.ignore".equals(configurationRootPath)) {
            return new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/semver-ignore-schema.json"), Charset.forName("UTF-8"));
        }
        return null;
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        ModelNode node = analysisContext.getConfiguration().get(new String[]{"revapi", "semver", "ignore", "enabled"});
        if (this.hasMultipleElements(analysisContext.getOldApi().getArchives()) || this.hasMultipleElements(analysisContext.getNewApi().getArchives())) {
            throw new IllegalArgumentException("The semver extension doesn't handle changes in multiple archives at once.");
        }
        boolean bl = this.enabled = node.isDefined() && node.asBoolean();
        if (this.enabled) {
            Archive oldArchive = (Archive)analysisContext.getOldApi().getArchives().iterator().next();
            Archive newArchive = (Archive)analysisContext.getNewApi().getArchives().iterator().next();
            if (!(oldArchive instanceof Archive.Versioned)) {
                throw new IllegalArgumentException("Old archive doesn't support extracting the version.");
            }
            if (!(newArchive instanceof Archive.Versioned)) {
                throw new IllegalArgumentException("New archive doesn't support extracting the version.");
            }
            String oldVersionString = ((Archive.Versioned)oldArchive).getVersion();
            String newVersionString = ((Archive.Versioned)newArchive).getVersion();
            Version oldVersion = Version.parse(oldVersionString);
            Version newVersion = Version.parse(newVersionString);
            this.allowedSeverity = newVersion.major == 0 && oldVersion.major == 0 ? (newVersion.minor > oldVersion.minor ? DifferenceSeverity.BREAKING : (newVersion.minor == oldVersion.minor && newVersion.patch > oldVersion.patch ? DifferenceSeverity.POTENTIALLY_BREAKING : null)) : (newVersion.major > oldVersion.major ? DifferenceSeverity.BREAKING : (newVersion.major == oldVersion.major && newVersion.minor > oldVersion.minor ? DifferenceSeverity.POTENTIALLY_BREAKING : null));
        }
    }

    private boolean hasMultipleElements(Iterable<?> it) {
        Iterator<?> i = it.iterator();
        if (!i.hasNext()) {
            return false;
        }
        i.next();
        return i.hasNext();
    }

    private static final class Version {
        private static final Pattern SEMVER_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)(?:\\.)?(\\d*)(\\.|-|\\+)?([0-9A-Za-z-.]*)?");
        final int major;
        final int minor;
        final int patch;
        final String sep;
        final String suffix;

        static Version parse(String version) {
            Matcher m = SEMVER_PATTERN.matcher(version);
            if (!m.matches()) {
                throw new IllegalArgumentException("Could not parse the version string '" + version + ". It does not follow semver schema.");
            }
            int major = Integer.valueOf(m.group(1));
            int minor = Integer.valueOf(m.group(2));
            int patch = 0;
            String patchMatch = m.group(3);
            if (patchMatch != null && !patchMatch.isEmpty()) {
                patch = Integer.valueOf(patchMatch);
            }
            String sep = m.group(4);
            String suffix = m.group(5);
            return new Version(major, minor, patch, sep, suffix);
        }

        Version(int major, int minor, int patch, String sep, String suffix) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.sep = sep;
            this.suffix = suffix;
        }
    }
}

