/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;
import org.revapi.Archive;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.compilation.ArchiveProbeObject;
import org.revapi.java.compilation.ClassTreeInitializer;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.MarkerAnnotationObject;
import org.revapi.java.compilation.ProbingAnnotationProcessor;
import org.revapi.java.compilation.ProbingEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Compiler {
    private static final Logger LOG = LoggerFactory.getLogger(Compiler.class);
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final Writer output;
    private final Iterable<? extends Archive> classPath;
    private final Iterable<? extends Archive> additionalClassPath;
    private final ExecutorService executor;

    public Compiler(ExecutorService executor, Writer reportingOutput, Iterable<? extends Archive> classPath, Iterable<? extends Archive> additionalClassPath) {
        if (this.compiler == null) {
            throw new AssertionError((Object)"Could not obtain the system compiler. Is tools.jar on the classpath?");
        }
        this.executor = executor;
        this.output = reportingOutput;
        this.classPath = classPath;
        this.additionalClassPath = additionalClassPath;
    }

    public CompilationValve compile(final ProbingEnvironment environment, final AnalysisConfiguration.MissingClassReporting missingClassReporting, final boolean ignoreMissingAnnotations, final Set<File> bootstrapClasspath, final boolean ignoreAdditionalClasspathContributions) throws Exception {
        File targetPath = Files.createTempDirectory("revapi-java", new FileAttribute[0]).toAbsolutePath().toFile();
        File sourceDir = new File(targetPath, "sources");
        sourceDir.mkdir();
        File lib = new File(targetPath, "lib");
        lib.mkdir();
        int classPathSize = this.size(this.classPath);
        int nofArchives = classPathSize + this.size(this.additionalClassPath);
        int prefixLength = (int)Math.log10(nofArchives) + 1;
        this.copyArchives(this.classPath, lib, 0, prefixLength);
        this.copyArchives(this.additionalClassPath, lib, classPathSize, prefixLength);
        List<String> options = Arrays.asList("-d", sourceDir.toString(), "-cp", this.composeClassPath(lib));
        List<JavaFileObject> sources = Arrays.asList(new MarkerAnnotationObject(), new ArchiveProbeObject());
        final JavaCompiler.CompilationTask task = this.compiler.getTask(this.output, null, null, options, Arrays.asList("Probe"), sources);
        ProbingAnnotationProcessor processor = new ProbingAnnotationProcessor(environment);
        task.setProcessors(Arrays.asList(processor));
        Future<Boolean> future = processor.submitWithCompilationAwareness(this.executor, new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                new ClassTreeInitializer(environment, missingClassReporting, ignoreMissingAnnotations, bootstrapClasspath, ignoreAdditionalClasspathContributions).initTree();
                return task.call();
            }
        });
        return new CompilationValve(future, targetPath, environment);
    }

    private String composeClassPath(File classPathDir) {
        StringBuilder bld = new StringBuilder();
        File[] jars = classPathDir.listFiles();
        if (jars == null || jars.length == 0) {
            return "";
        }
        ArrayList<File> sortedJars = new ArrayList<File>(Arrays.asList(jars));
        Collections.sort(sortedJars, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Iterator it = sortedJars.iterator();
        bld.append(((File)it.next()).getAbsolutePath());
        while (it.hasNext()) {
            bld.append(File.pathSeparator).append(((File)it.next()).getAbsolutePath());
        }
        return bld.toString();
    }

    private void copyArchives(Iterable<? extends Archive> archives, File parentDir, int startIdx, int prefixLength) {
        if (archives == null) {
            return;
        }
        for (Archive archive : archives) {
            String name;
            File f;
            if ((f = new File(parentDir, name = this.formatName(startIdx++, prefixLength, archive.getName()))).exists()) {
                LOG.warn("File " + f.getAbsolutePath() + " already exists. Assume it already contains the bits we need.");
                continue;
            }
            Path target = new File(parentDir, name).toPath();
            try {
                InputStream data = archive.openStream();
                Throwable throwable = null;
                try {
                    Files.copy(data, target, new CopyOption[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (data == null) continue;
                    if (throwable != null) {
                        try {
                            data.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    data.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to copy class path element: " + archive.getName() + " to " + f.getAbsolutePath(), e);
            }
        }
    }

    private int size(Iterable<?> collection) {
        if (collection == null) {
            return 0;
        }
        int ret = 0;
        Iterator<?> it = collection.iterator();
        while (it.hasNext()) {
            ++ret;
            it.next();
        }
        return ret;
    }

    private String formatName(int idx, int prefixLength, String rootName) {
        return String.format("%0" + prefixLength + "d-" + rootName, idx);
    }
}

