/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.Util;

public final class Removed
extends CheckBase {
    private TypeElement activeNewType;

    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS, Check.Type.FIELD);
    }

    protected void doVisitClass(@Nullable TypeElement oldType, @Nullable TypeElement newType) {
        this.activeNewType = newType;
    }

    protected void doVisitField(VariableElement oldField, VariableElement newField) {
        if (oldField != null && newField == null && this.isAccessible(oldField, this.getOldTypeEnvironment())) {
            this.pushActive(oldField, null, new Object[0]);
        }
    }

    protected List<Difference> doEnd() {
        boolean isConstant;
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        boolean bl = isConstant = ((VariableElement)fields.oldElement).getConstantValue() != null;
        if (this.activeNewType != null) {
            String oldFieldType = Util.toUniqueString((TypeMirror)((VariableElement)fields.oldElement).asType());
            for (TypeMirror superType : Util.getAllSuperClasses((Types)this.getNewTypeEnvironment().getTypeUtils(), (TypeMirror)this.activeNewType.asType())) {
                if (!(superType instanceof DeclaredType)) continue;
                DeclaredType st = (DeclaredType)superType;
                List<VariableElement> superFields = ElementFilter.fieldsIn(st.asElement().getEnclosedElements());
                for (VariableElement superField : superFields) {
                    String newFieldType;
                    if (!superField.getSimpleName().contentEquals(((VariableElement)fields.oldElement).getSimpleName()) || !this.isAccessible(superField, this.getNewTypeEnvironment()) || !oldFieldType.equals(newFieldType = Util.toUniqueString((TypeMirror)superField.asType()))) continue;
                    return Collections.singletonList(this.createDifference(Code.FIELD_MOVED_TO_SUPER_CLASS, new Object[]{Util.toHumanReadableString((AnnotatedConstruct)((VariableElement)fields.oldElement).getEnclosingElement()), Util.toHumanReadableString((AnnotatedConstruct)st.asElement())}));
                }
            }
        }
        return Collections.singletonList(this.createDifference(isConstant ? Code.FIELD_CONSTANT_REMOVED : Code.FIELD_REMOVED, new Object[0]));
    }
}

