/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.fields;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaFieldElement;

public final class Added
extends CheckBase {
    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.FIELD);
    }

    @Override
    protected void doVisitField(JavaFieldElement oldField, JavaFieldElement newField) {
        if (oldField == null && newField != null && this.isAccessible(newField)) {
            this.pushActive(null, newField, new Object[0]);
        }
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements fields = this.popIfActive();
        if (fields == null) {
            return null;
        }
        boolean isStatic = ((JavaFieldElement)fields.newElement).getDeclaringElement().getModifiers().contains((Object)Modifier.STATIC);
        if (isStatic) {
            return Collections.singletonList(this.createDifference(Code.FIELD_ADDED_STATIC_FIELD, Code.attachmentsFor(fields.oldElement, fields.newElement, new String[0])));
        }
        return Collections.singletonList(this.createDifference(Code.FIELD_ADDED, Code.attachmentsFor(fields.oldElement, fields.newElement, new String[0])));
    }
}

