/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.checks.classes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import org.revapi.CoIterator;
import org.revapi.Difference;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.CheckBase;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.Util;

public final class InheritanceChainChanged
extends CheckBase {
    private static final TypeVisitor<Boolean, Void> IS_MISSING_VISITOR = new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

        @Override
        public Boolean visitError(ErrorType t, Void __) {
            return true;
        }

        @Override
        public Boolean visitDeclared(DeclaredType t, Void aVoid) {
            return t.asElement().asType().getKind() == TypeKind.ERROR;
        }
    };

    @Override
    public EnumSet<Check.Type> getInterest() {
        return EnumSet.of(Check.Type.CLASS);
    }

    @Override
    protected List<Difference> doEnd() {
        CheckBase.ActiveElements types = this.popIfActive();
        if (types != null) {
            String str;
            ArrayList<Difference> ret = new ArrayList<Difference>();
            List oldSuperClasses = (List)types.context[0];
            List newSuperClasses = (List)types.context[1];
            this.reportMissingSuperTypes(ret, oldSuperClasses, Code.MISSING_OLD_SUPERTYPE, types);
            this.reportMissingSuperTypes(ret, newSuperClasses, Code.MISSING_NEW_SUPERTYPE, types);
            if (!ret.isEmpty()) {
                return ret;
            }
            Comparator<TypeMirror> typeNameComparator = Comparator.comparing(Util::toUniqueString);
            List<TypeMirror> removedSuperClasses = new ArrayList<TypeMirror>();
            List<TypeMirror> addedSuperClasses = new ArrayList<TypeMirror>();
            oldSuperClasses.sort(typeNameComparator);
            newSuperClasses.sort(typeNameComparator);
            CoIterator iterator = new CoIterator(oldSuperClasses.iterator(), newSuperClasses.iterator(), typeNameComparator);
            while (iterator.hasNext()) {
                iterator.next();
                TypeMirror oldType = (TypeMirror)iterator.getLeft();
                TypeMirror newType = (TypeMirror)iterator.getRight();
                if (oldType == null) {
                    addedSuperClasses.add(newType);
                    continue;
                }
                if (newType != null) continue;
                removedSuperClasses.add(oldType);
            }
            removedSuperClasses = this.retainInCopy(oldSuperClasses, removedSuperClasses);
            addedSuperClasses = this.retainInCopy(newSuperClasses, addedSuperClasses);
            Iterator<TypeMirror> removedIt = removedSuperClasses.iterator();
            Iterator<TypeMirror> addedIt = addedSuperClasses.iterator();
            if (removedIt.hasNext()) {
                removedIt.next();
            }
            if (addedIt.hasNext()) {
                addedIt.next();
            }
            this.removeClassesWithEquivalentSuperClassChain(removedIt, this.getOldTypeEnvironment(), this.getNewTypeEnvironment());
            this.removeClassesWithEquivalentSuperClassChain(addedIt, this.getNewTypeEnvironment(), this.getOldTypeEnvironment());
            for (TypeMirror t : removedSuperClasses) {
                str = Util.toHumanReadableString(t);
                ret.add(this.createDifference(Code.CLASS_NO_LONGER_INHERITS_FROM_CLASS, Code.attachmentsFor(types.oldElement, types.newElement, new String[]{"superClass", str})));
            }
            for (TypeMirror t : addedSuperClasses) {
                str = Util.toHumanReadableString(t);
                Code code = ((JavaTypeElement)types.oldElement).getDeclaringElement().getModifiers().contains((Object)Modifier.FINAL) ? Code.CLASS_FINAL_CLASS_INHERITS_FROM_NEW_CLASS : Code.CLASS_NON_FINAL_CLASS_INHERITS_FROM_NEW_CLASS;
                ret.add(this.createDifference(code, Code.attachmentsFor(types.oldElement, types.newElement, new String[]{"superClass", str})));
                if (!this.changedToCheckedException(this.getNewTypeEnvironment().getTypeUtils(), t, oldSuperClasses)) continue;
                ret.add(this.createDifference(Code.CLASS_NOW_CHECKED_EXCEPTION, Code.attachmentsFor(types.oldElement, types.newElement, new String[0])));
            }
            return ret;
        }
        return null;
    }

    @Override
    protected void doVisitClass(JavaTypeElement oldEl, JavaTypeElement newEl) {
        if (!this.isBothAccessible(oldEl, newEl)) {
            return;
        }
        TypeElement oldType = oldEl.getDeclaringElement();
        TypeElement newType = newEl.getDeclaringElement();
        List<TypeMirror> oldSuperTypes = Util.getAllSuperClasses(this.getOldTypeEnvironment().getTypeUtils(), oldType.asType());
        List<TypeMirror> newSuperTypes = Util.getAllSuperClasses(this.getNewTypeEnvironment().getTypeUtils(), newType.asType());
        if (oldSuperTypes.size() != newSuperTypes.size()) {
            this.pushActive(oldEl, newEl, oldSuperTypes, newSuperTypes);
        } else {
            Types oldTypes = this.getOldTypeEnvironment().getTypeUtils();
            Types newTypes = this.getNewTypeEnvironment().getTypeUtils();
            for (int i = 0; i < oldSuperTypes.size(); ++i) {
                TypeMirror newSuperClass;
                TypeMirror oldSuperClass = oldTypes.erasure(oldSuperTypes.get(i));
                if (Util.isSameType(oldSuperClass, newSuperClass = newTypes.erasure(newSuperTypes.get(i)))) continue;
                this.pushActive(oldEl, newEl, oldSuperTypes, newSuperTypes);
                break;
            }
        }
    }

    private boolean changedToCheckedException(@Nonnull Types newTypeEnv, @Nonnull TypeMirror newType, @Nonnull List<TypeMirror> oldTypes) {
        if ("java.lang.Exception".equals(Util.toHumanReadableString(newType))) {
            return this.isTypeThrowable(oldTypes);
        }
        for (TypeMirror sc : Util.getAllSuperClasses(newTypeEnv, newType)) {
            if (!"java.lang.Exception".equals(Util.toHumanReadableString(sc))) continue;
            return this.isTypeThrowable(oldTypes);
        }
        return false;
    }

    private boolean isTypeThrowable(@Nonnull List<TypeMirror> superClassesOfType) {
        for (TypeMirror sc : superClassesOfType) {
            if (!Util.toHumanReadableString(sc).equals("java.lang.Throwable")) continue;
            return true;
        }
        return false;
    }

    private List<String> superClassChainAsUniqueStrings(@Nonnull TypeMirror cls, @Nonnull Types env) {
        List<TypeMirror> supers = Util.getAllSuperClasses(env, cls);
        ArrayList<String> ret = new ArrayList<String>(supers.size());
        for (TypeMirror s : supers) {
            ret.add(Util.toUniqueString(env.erasure(s)));
        }
        return ret;
    }

    private void removeClassesWithEquivalentSuperClassChain(Iterator<TypeMirror> candidates, TypeEnvironment candidateEnvironment, TypeEnvironment oppositeEnvironment) {
        while (candidates.hasNext()) {
            boolean report = true;
            TypeMirror candidate = candidates.next();
            String typeName = Util.toHumanReadableString(candidate);
            TypeElement el = oppositeEnvironment.getElementUtils().getTypeElement(typeName);
            if (el != null) {
                List<String> oppositeSuperChain;
                TypeMirror opposite = el.asType();
                List<String> candidateSuperChain = this.superClassChainAsUniqueStrings(candidate, candidateEnvironment.getTypeUtils());
                boolean bl = report = !candidateSuperChain.equals(oppositeSuperChain = this.superClassChainAsUniqueStrings(opposite, oppositeEnvironment.getTypeUtils()));
            }
            if (report) continue;
            candidates.remove();
        }
    }

    private List<TypeMirror> retainInCopy(List<TypeMirror> all, List<TypeMirror> retained) {
        ArrayList<TypeMirror> tmp = new ArrayList<TypeMirror>(all);
        tmp.retainAll(retained);
        return tmp;
    }

    private void reportMissingSuperTypes(List<Difference> diffs, List<TypeMirror> superTypes, Code code, CheckBase.ActiveElements<?> activeElements) {
        for (TypeMirror t : superTypes) {
            if (!InheritanceChainChanged.isMissing(t)) continue;
            String type = Util.toHumanReadableString(t);
            diffs.add(this.createDifferenceWithExplicitParams(code, Code.attachmentsFor(activeElements.oldElement, activeElements.newElement, new String[]{"superClass", type}), type));
        }
    }

    private static boolean isMissing(TypeMirror type) {
        return type.accept(IS_MISSING_VISITOR, null);
    }
}

