/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.transforms.annotations;

import java.io.Reader;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaTypeElement;

public class NoLongerPresent
implements DifferenceTransform<JavaTypeElement> {
    private Locale locale;

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return new Pattern[]{Pattern.compile("java\\.class\\.removed")};
    }

    @Nullable
    public Difference transform(@Nullable JavaTypeElement oldElement, @Nullable JavaTypeElement newElement, @Nonnull Difference difference) {
        if (oldElement == null || newElement != null) {
            return difference;
        }
        if (oldElement.getDeclaringElement().getKind() == ElementKind.ANNOTATION_TYPE) {
            return Code.ANNOTATION_NO_LONGER_PRESENT.createDifference(this.locale, Code.attachmentsFor(oldElement, newElement, new String[0]));
        }
        return difference;
    }

    public void close() throws Exception {
    }

    public String getExtensionId() {
        return null;
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void initialize(AnalysisContext analysisContext) {
        this.locale = analysisContext.getLocale();
    }
}

