/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.compilation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.lang.model.util.SimpleTypeVisitor7;
import javax.lang.model.util.Types;
import org.objectweb.asm.Type;
import org.revapi.API;
import org.revapi.java.compilation.MissingTypeAwareDelegatingElements;
import org.revapi.java.compilation.MissingTypeAwareDelegatingTypes;
import org.revapi.java.compilation.RawUseSite;
import org.revapi.java.model.FieldElement;
import org.revapi.java.model.JavaElementForest;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.MethodParameterElement;
import org.revapi.java.model.MissingClassElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.TypeEnvironment;
import org.revapi.java.spi.UseSite;
import org.revapi.java.spi.Util;
import org.revapi.query.Filter;

public final class ProbingEnvironment
implements TypeEnvironment {
    private final API api;
    private volatile ProcessingEnvironment processingEnvironment;
    private final CountDownLatch compilationProgressLatch = new CountDownLatch(1);
    private final CountDownLatch compilationEnvironmentTeardownLatch = new CountDownLatch(1);
    private final JavaElementForest tree;
    private final Map<String, Set<RawUseSite>> useSiteMap = new HashMap<String, Set<RawUseSite>>();
    private final HashMap<RawUseSite, UseSite> useSiteCache = new HashMap();

    public ProbingEnvironment(API api) {
        this.api = api;
        this.tree = new JavaElementForest(api);
    }

    public API getApi() {
        return this.api;
    }

    public CountDownLatch getCompilationTeardownLatch() {
        return this.compilationEnvironmentTeardownLatch;
    }

    public CountDownLatch getCompilationProgressLatch() {
        return this.compilationProgressLatch;
    }

    public JavaElementForest getTree() {
        return this.tree;
    }

    public void setProcessingEnvironment(ProcessingEnvironment env) {
        this.processingEnvironment = env;
    }

    @Nonnull
    public Elements getElementUtils() {
        return this.processingEnvironment == null ? null : new MissingTypeAwareDelegatingElements(this.processingEnvironment.getElementUtils());
    }

    @Nonnull
    public Types getTypeUtils() {
        return this.processingEnvironment == null ? null : new MissingTypeAwareDelegatingTypes(this.processingEnvironment.getTypeUtils());
    }

    @Nonnull
    public Map<String, Set<RawUseSite>> getUseSiteMap() {
        return this.useSiteMap;
    }

    @Nullable
    public <R, P> R visitUseSites(@Nonnull javax.lang.model.element.TypeElement type, final @Nonnull UseSite.Visitor<R, P> visitor, @Nullable P parameter) {
        final Elements elements = this.getElementUtils();
        String binaryName = elements.getBinaryName(type).toString();
        Set<RawUseSite> sites = this.useSiteMap.get(binaryName);
        if (sites == null) {
            return (R)visitor.end(type, parameter);
        }
        Object ret = this.visitRawUseSites(binaryName, sites, new RawUseSiteVisitor<R, P>(){

            @Override
            public R visit(String binaryName, RawUseSite site, P parameter) {
                javax.lang.model.element.TypeElement type = Util.findTypeByBinaryName((Elements)elements, (String)binaryName);
                if (type == null) {
                    return null;
                }
                UseSite use = ProbingEnvironment.this.toUseSite(type, site, elements);
                return visitor.visit(type, use, parameter);
            }
        }, parameter);
        if (ret == null) {
            ret = visitor.end(type, parameter);
        }
        return ret;
    }

    private <R, P> R visitRawUseSites(String binaryName, Set<RawUseSite> sites, RawUseSiteVisitor<R, P> visitor, P parameter) {
        for (RawUseSite site : sites) {
            R ret = visitor.visit(binaryName, site, parameter);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private UseSite toUseSite(javax.lang.model.element.TypeElement type, final RawUseSite ru, final Elements elements) {
        UseSite cachedUseSite = this.useSiteCache.get(ru);
        if (cachedUseSite != null) {
            return cachedUseSite;
        }
        List<JavaTypeElement> userTypes = this.tree.search(JavaTypeElement.class, true, new Filter<JavaTypeElement>(){

            public boolean applies(@Nullable JavaTypeElement element) {
                if (element instanceof TypeElement) {
                    return ((TypeElement)element).getBinaryName().equals(ru.getSiteClass());
                }
                return element != null && elements.getBinaryName(element.getModelElement()).contentEquals(ru.getSiteClass());
            }

            public boolean shouldDescendInto(@Nullable Object element) {
                return element instanceof JavaTypeElement;
            }
        }, null);
        JavaTypeElement t = userTypes.isEmpty() ? new MissingClassElement(this, ru.getSiteClass(), ru.getSiteClass()) : userTypes.get(0);
        JavaTypeElement userType = t;
        Object user = null;
        block0 : switch (ru.getUseType()) {
            case ANNOTATES: {
                Object params;
                block10 : switch (ru.getSiteType()) {
                    case CLASS: {
                        user = userType;
                        break;
                    }
                    case FIELD: {
                        for (FieldElement f : userType.searchChildren(FieldElement.class, false, null)) {
                            if (!((VariableElement)f.getModelElement()).getSimpleName().contentEquals(ru.getSiteName())) continue;
                            user = f;
                            break block10;
                        }
                        break block0;
                    }
                    case METHOD: {
                        user = this.findMatchingMethod(ru, userType);
                        break;
                    }
                    case METHOD_PARAMETER: {
                        MethodElement method = this.findMatchingMethod(ru, userType);
                        if (method != null && (params = method.searchChildren(MethodParameterElement.class, false, null)).size() > ru.getSitePosition()) {
                            user = (JavaElement)params.get(ru.getSitePosition());
                        } else {
                            break;
                        }
                    }
                }
                break;
            }
            case HAS_TYPE: {
                for (FieldElement f : userType.searchChildren(FieldElement.class, false, null)) {
                    if (!((VariableElement)f.getModelElement()).getSimpleName().contentEquals(ru.getSiteName())) continue;
                    user = f;
                    break block0;
                }
                break;
            }
            case IS_IMPLEMENTED: {
                if (!ProbingEnvironment.hasMatchingType(elements, type, userType.getModelElement().getInterfaces())) break;
                user = userType;
                break;
            }
            case IS_INHERITED: {
                if (!ProbingEnvironment.hasMatchingType(elements, type, Collections.singleton(userType.getModelElement().getSuperclass()))) break;
                user = userType;
                break;
            }
            case IS_THROWN: {
                MethodElement method = this.findMatchingMethod(ru, userType);
                if (method == null || !ProbingEnvironment.hasMatchingType(elements, type, ((ExecutableElement)method.getModelElement()).getThrownTypes())) break;
                user = method;
                break;
            }
            case PARAMETER_TYPE: {
                MethodParameterElement parameter;
                Object params;
                MethodElement method = this.findMatchingMethod(ru, userType);
                if (method == null || (params = method.searchChildren(MethodParameterElement.class, false, null)).size() <= ru.getSitePosition() || !ProbingEnvironment.hasMatchingType(elements, type, Collections.singleton(((VariableElement)(parameter = (MethodParameterElement)((Object)params.get(ru.getSitePosition()))).getModelElement()).asType()))) break;
                user = method;
                break;
            }
            case RETURN_TYPE: {
                MethodElement method = this.findMatchingMethod(ru, userType);
                if (method == null || !ProbingEnvironment.hasMatchingType(elements, type, Collections.singleton(((ExecutableElement)method.getModelElement()).getReturnType()))) break;
                user = method;
                break;
            }
            case CONTAINS: {
                user = userType;
            }
        }
        if (user == null) {
            throw new IllegalStateException("Could not find the corresponding model element for use: " + ru + " of type " + type.getQualifiedName());
        }
        UseSite useSite = new UseSite(ru.getUseType(), (JavaElement)user);
        this.useSiteCache.put(ru, useSite);
        return useSite;
    }

    private MethodElement findMatchingMethod(RawUseSite methodUseSite, JavaTypeElement containingType) {
        return this.findMatchingMethod(methodUseSite, containingType.searchChildren(MethodElement.class, false, null));
    }

    private MethodElement findMatchingMethod(RawUseSite methodUseSite, List<MethodElement> candidates) {
        Type[] parameterTypes = Type.getArgumentTypes((String)methodUseSite.getSiteDescriptor());
        Type returnType = Type.getReturnType((String)methodUseSite.getSiteDescriptor());
        for (MethodElement m : candidates) {
            List<? extends VariableElement> params;
            ExecutableElement method = (ExecutableElement)m.getModelElement();
            if (!method.getSimpleName().contentEquals(methodUseSite.getSiteName()) || !this.equals(returnType, method.getReturnType()) || (params = method.getParameters()).size() != parameterTypes.length) continue;
            int i = 0;
            for (VariableElement variableElement : method.getParameters()) {
                if (!this.equals(parameterTypes[i], variableElement.asType())) break;
                ++i;
            }
            if (i != parameterTypes.length) continue;
            return m;
        }
        return null;
    }

    private static boolean hasMatchingType(final Elements elements, javax.lang.model.element.TypeElement type, Iterable<? extends TypeMirror> types) {
        final boolean isErrorType = type.asType().getKind() == TypeKind.ERROR;
        final Name comparableName = isErrorType ? elements.getBinaryName(type) : type.getQualifiedName();
        for (TypeMirror typeMirror : types) {
            boolean found = typeMirror.accept(new SimpleTypeVisitor7<Boolean, Void>(Boolean.valueOf(false)){
                SimpleElementVisitor7<Boolean, Void> typeNameChecker;
                {
                    super(x0);
                    this.typeNameChecker = new SimpleElementVisitor7<Boolean, Void>(Boolean.valueOf(false)){

                        @Override
                        public Boolean visitType(javax.lang.model.element.TypeElement e, Void ignored) {
                            if (isErrorType) {
                                return elements.getBinaryName(e).contentEquals(comparableName);
                            }
                            return comparableName.contentEquals(e.getQualifiedName());
                        }
                    };
                }

                @Override
                public Boolean visitError(ErrorType t, Void ignored) {
                    return t.asElement().accept(this.typeNameChecker, null);
                }

                @Override
                public Boolean visitArray(ArrayType t, Void ignored) {
                    return (Boolean)this.visit(t.getComponentType(), ignored);
                }

                @Override
                public Boolean visitDeclared(DeclaredType t, Void ignored) {
                    return t.asElement().accept(this.typeNameChecker, null);
                }

                @Override
                public Boolean visitTypeVariable(TypeVariable t, Void ignored) {
                    return (Boolean)this.visit(t.getUpperBound(), ignored);
                }
            }, null);
            if (!found) continue;
            return true;
        }
        return false;
    }

    private boolean equals(final Type type, TypeMirror mirror) {
        if (type == null || mirror == null) {
            return false;
        }
        switch (type.getSort()) {
            case 9: {
                TypeMirror elementType = mirror.accept(new SimpleTypeVisitor7<TypeMirror, Void>(null){

                    @Override
                    public TypeMirror visitArray(ArrayType t, Void ignored) {
                        return t.getComponentType();
                    }

                    @Override
                    public TypeMirror visitTypeVariable(TypeVariable t, Void ignored) {
                        return (TypeMirror)this.visit(ProbingEnvironment.this.getTypeUtils().erasure(t), null);
                    }
                }, null);
                return this.equals(type.getElementType(), elementType);
            }
            case 10: {
                return mirror.accept(new SimpleTypeVisitor7<Boolean, Void>(Boolean.valueOf(false)){
                    SimpleElementVisitor7<Boolean, Void> binaryNameChecker;
                    {
                        super(x0);
                        this.binaryNameChecker = new SimpleElementVisitor7<Boolean, Void>(Boolean.valueOf(false)){

                            @Override
                            public Boolean visitType(javax.lang.model.element.TypeElement e, Void ignored) {
                                return ProbingEnvironment.this.getElementUtils().getBinaryName(e).contentEquals(type.getClassName());
                            }
                        };
                    }

                    @Override
                    public Boolean visitDeclared(DeclaredType t, Void ignored) {
                        return t.asElement().accept(this.binaryNameChecker, null);
                    }

                    @Override
                    public Boolean visitError(ErrorType t, Void aVoid) {
                        return t.asElement().accept(this.binaryNameChecker, null);
                    }

                    @Override
                    public Boolean visitTypeVariable(TypeVariable t, Void ignored) {
                        return (Boolean)this.visit(ProbingEnvironment.this.getTypeUtils().erasure(t), null);
                    }

                    @Override
                    public Boolean visitWildcard(WildcardType t, Void ignored) {
                        return (Boolean)this.visit(ProbingEnvironment.this.getTypeUtils().capture(t), null);
                    }
                }, null);
            }
            case 11: {
                return false;
            }
            case 0: {
                return mirror.getKind() == TypeKind.VOID;
            }
            case 1: {
                return mirror.getKind() == TypeKind.BOOLEAN;
            }
            case 3: {
                return mirror.getKind() == TypeKind.BYTE;
            }
            case 2: {
                return mirror.getKind() == TypeKind.CHAR;
            }
            case 8: {
                return mirror.getKind() == TypeKind.DOUBLE;
            }
            case 6: {
                return mirror.getKind() == TypeKind.FLOAT;
            }
            case 5: {
                return mirror.getKind() == TypeKind.INT;
            }
            case 7: {
                return mirror.getKind() == TypeKind.LONG;
            }
            case 4: {
                return mirror.getKind() == TypeKind.SHORT;
            }
        }
        return false;
    }

    private static interface RawUseSiteVisitor<R, P> {
        public R visit(String var1, RawUseSite var2, P var3);
    }
}

