/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.ToolProvider;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.ApiAnalyzer;
import org.revapi.Archive;
import org.revapi.ArchiveAnalyzer;
import org.revapi.CoIterator;
import org.revapi.CorrespondenceComparatorDeducer;
import org.revapi.DifferenceAnalyzer;
import org.revapi.configuration.Configurable;
import org.revapi.configuration.JSONUtil;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.JavaArchiveAnalyzer;
import org.revapi.java.JavaElementDifferenceAnalyzer;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementFactory;
import org.revapi.java.model.MethodElement;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.Check;
import org.revapi.java.spi.JarExtractor;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaApiAnalyzer
implements ApiAnalyzer<JavaElement> {
    private static final Logger LOG = LoggerFactory.getLogger(JavaApiAnalyzer.class);
    private static final Method CLEAR_COMPILER_CACHE;
    private static final Object SHARED_ZIP_FILE_INDEX_CACHE;
    private final List<ExecutorService> compilationExecutors = new ArrayList<ExecutorService>(2);
    private AnalysisContext analysisContext;
    private AnalysisConfiguration configuration;
    private final Iterable<Check> checks;
    private final Iterable<JarExtractor> jarExtractors;
    private final List<CompilationValve> activeCompilations = new ArrayList<CompilationValve>(2);

    public JavaApiAnalyzer() {
        this(JavaApiAnalyzer.serviceLoad(Check.class), JavaApiAnalyzer.serviceLoad(JarExtractor.class));
    }

    private static <T> Iterable<T> serviceLoad(Class<T> type) {
        return ServiceLoader.load(type, JavaApiAnalyzer.class.getClassLoader());
    }

    public JavaApiAnalyzer(Iterable<Check> checks, Iterable<JarExtractor> archiveTransformers) {
        this.checks = checks;
        this.jarExtractors = archiveTransformers;
    }

    public CorrespondenceComparatorDeducer<JavaElement> getCorrespondenceDeducer() {
        if (!this.configuration.isMatchOverloads()) {
            return CorrespondenceComparatorDeducer.naturalOrder();
        }
        return (l1, l2) -> {
            if (l1.isEmpty() || l2.isEmpty()) {
                return Comparator.naturalOrder();
            }
            JavaElement parent = (JavaElement)((JavaElement)l1.get(0)).getParent();
            if (!(parent instanceof TypeElement)) {
                return Comparator.naturalOrder();
            }
            IdentityHashMap<MethodElement, Integer> c1MethodOrder = new IdentityHashMap<MethodElement, Integer>(l1.size());
            IdentityHashMap<MethodElement, Integer> c2MethodOrder = new IdentityHashMap<MethodElement, Integer>(l2.size());
            JavaApiAnalyzer.determineOrder(l1, l2, c1MethodOrder, c2MethodOrder);
            return (e1, e2) -> {
                int ret = JavaElementFactory.compareByType(e1, e2);
                if (ret != 0) {
                    return ret;
                }
                if (e1 instanceof MethodElement && e2 instanceof MethodElement) {
                    MethodElement m1 = (MethodElement)((Object)((Object)e1));
                    MethodElement m2 = (MethodElement)((Object)((Object)e2));
                    return (Integer)c1MethodOrder.get((Object)m1) - (Integer)c2MethodOrder.get((Object)m2);
                }
                return e1.compareTo(e2);
            };
        };
    }

    private static void determineOrder(List<JavaElement> l1, List<JavaElement> l2, IdentityHashMap<MethodElement, Integer> l1MethodOrder, IdentityHashMap<MethodElement, Integer> l2MethodOrder) {
        TreeMap<String, List<MethodElement>> l1MethodsByName = new TreeMap<String, List<MethodElement>>();
        TreeMap<String, List<MethodElement>> l2MethodsByName = new TreeMap<String, List<MethodElement>>();
        int l1MethodsSize = JavaApiAnalyzer.addAllMethods(l1, l1MethodsByName);
        int l2MethodsSize = JavaApiAnalyzer.addAllMethods(l2, l2MethodsByName);
        int index = 0;
        Iterator<Map.Entry<String, List<MethodElement>>> l1MethodsIterator = l1MethodsByName.entrySet().iterator();
        Iterator<Map.Entry<String, List<MethodElement>>> l2MethodsIterator = l2MethodsByName.entrySet().iterator();
        CoIterator coit = new CoIterator(l1MethodsIterator, l2MethodsIterator, Map.Entry.comparingByKey());
        ArrayList<JavaElement> l2MethodsInOrder = new ArrayList<JavaElement>(l1MethodsSize);
        ArrayList<JavaElement> l1MethodsInOrder = new ArrayList<JavaElement>(l2MethodsSize);
        while (coit.hasNext()) {
            coit.next();
            Map.Entry l1e = (Map.Entry)coit.getLeft();
            Map.Entry l2e = (Map.Entry)coit.getRight();
            if (l1e == null) {
                for (MethodElement m : (List)l2e.getValue()) {
                    l2MethodOrder.put(m, index++);
                    l2MethodsInOrder.add(m);
                }
                continue;
            }
            if (l2e == null) {
                for (MethodElement m : (List)l1e.getValue()) {
                    l1MethodOrder.put(m, index++);
                    l1MethodsInOrder.add(m);
                }
                continue;
            }
            List l1Overloads = (List)l1e.getValue();
            List l2Overloads = (List)l2e.getValue();
            if (l1Overloads.size() == 1 && l2Overloads.size() == 1) {
                MethodElement m1 = (MethodElement)((Object)l1Overloads.get(0));
                MethodElement m2 = (MethodElement)((Object)l2Overloads.get(0));
                l1MethodsInOrder.add(m1);
                l2MethodsInOrder.add(m2);
                l2MethodOrder.put(m2, index);
                l1MethodOrder.put(m1, index++);
                continue;
            }
            List as = l1Overloads;
            List bs = l2Overloads;
            ArrayList<JavaElement> aio = l1MethodsInOrder;
            ArrayList<JavaElement> bio = l2MethodsInOrder;
            IdentityHashMap<MethodElement, Integer> ao = l1MethodOrder;
            IdentityHashMap<MethodElement, Integer> bo = l2MethodOrder;
            if (l1Overloads.size() > l2Overloads.size()) {
                as = l2Overloads;
                bs = l1Overloads;
                aio = l2MethodsInOrder;
                bio = l1MethodsInOrder;
                ao = l2MethodOrder;
                bo = l1MethodOrder;
            }
            TreeMap<Integer, Map> methodsByDistance = new TreeMap<Integer, Map>();
            int maxOverrides = bs.size();
            for (MethodElement ma : as) {
                String aRet = Util.toUniqueString((TypeMirror)((ExecutableType)ma.getModelRepresentation()).getReturnType());
                String aErasedRet = Util.toUniqueString((TypeMirror)ma.getTypeEnvironment().getTypeUtils().erasure(((ExecutableType)ma.getModelRepresentation()).getReturnType()));
                List<String> aParams = JavaApiAnalyzer.methodParamsSignature(ma, false);
                List<String> aErasedParams = JavaApiAnalyzer.methodParamsSignature(ma, true);
                for (MethodElement mb : bs) {
                    int distance = JavaApiAnalyzer.levenshteinDistance(aRet, aErasedRet, aParams, aErasedParams, mb);
                    methodsByDistance.computeIfAbsent(distance, __ -> new LinkedHashMap()).computeIfAbsent(ma, __ -> new ArrayList(maxOverrides)).add(mb);
                }
            }
            IdentityHashMap unmatchedAs = new IdentityHashMap();
            as.forEach(a -> unmatchedAs.put(a, null));
            IdentityHashMap unmatchedBs = new IdentityHashMap();
            bs.forEach(b -> unmatchedBs.put(b, null));
            for (Map matchingMethods : methodsByDistance.values()) {
                block6: for (Map.Entry e : matchingMethods.entrySet()) {
                    MethodElement ma = (MethodElement)((Object)e.getKey());
                    List mbs = (List)e.getValue();
                    if (!unmatchedAs.containsKey((Object)ma)) continue;
                    for (MethodElement mb : mbs) {
                        if (!unmatchedBs.containsKey((Object)mb)) continue;
                        unmatchedAs.remove((Object)ma);
                        unmatchedBs.remove((Object)mb);
                        ao.put(ma, index);
                        aio.add(ma);
                        bo.put(mb, index++);
                        bio.add(mb);
                        continue block6;
                    }
                }
            }
            for (MethodElement m : unmatchedBs.keySet()) {
                bo.put(m, index++);
                bio.add(m);
            }
        }
        JavaApiAnalyzer.reAddSortedMethods(l1, l1MethodsInOrder);
        JavaApiAnalyzer.reAddSortedMethods(l2, l2MethodsInOrder);
    }

    private static void reAddSortedMethods(List<JavaElement> elements, List<JavaElement> sortedMethods) {
        JavaElement e;
        int index;
        int methodRank = JavaElementFactory.getModelTypeRank(MethodElement.class);
        for (index = 0; index < elements.size() && JavaElementFactory.getModelTypeRank((e = elements.get(index)).getClass()) < methodRank; ++index) {
        }
        while (index < elements.size() && (e = elements.get(index)) instanceof MethodElement) {
            elements.remove(index);
        }
        elements.addAll(index, sortedMethods);
    }

    private static List<String> methodParamsSignature(MethodElement method, boolean erased) {
        if (erased) {
            Types types = method.getTypeEnvironment().getTypeUtils();
            return ((ExecutableElement)method.getDeclaringElement()).getParameters().stream().map(p -> Util.toUniqueString((TypeMirror)types.erasure(p.asType()))).collect(Collectors.toList());
        }
        return ((ExecutableType)method.getModelRepresentation()).getParameterTypes().stream().map(Util::toUniqueString).collect(Collectors.toList());
    }

    private static int levenshteinDistance(String aRet, String aErasedRet, List<String> aParams, List<String> aErasedParams, MethodElement mb) {
        int retCost;
        int i;
        String bRet = Util.toUniqueString((TypeMirror)((ExecutableType)mb.getModelRepresentation()).getReturnType());
        String bErasedRet = Util.toUniqueString((TypeMirror)mb.getTypeEnvironment().getTypeUtils().erasure(((ExecutableType)mb.getModelRepresentation()).getReturnType()));
        List<String> bParams = JavaApiAnalyzer.methodParamsSignature(mb, false);
        List<String> bErasedParams = JavaApiAnalyzer.methodParamsSignature(mb, true);
        int[][] d = new int[aParams.size() + 1][bParams.size() + 1];
        for (i = 0; i < d.length; ++i) {
            d[i][0] = i;
        }
        for (i = 0; i < d[0].length; ++i) {
            d[0][i] = i;
        }
        for (i = 1; i < d.length; ++i) {
            for (int j = 1; j < d[0].length; ++j) {
                String b;
                int cost;
                String a = aErasedParams.get(i - 1);
                int n = cost = a.equals(b = bErasedParams.get(j - 1)) ? 0 : 1;
                if (cost == 0) {
                    a = i == 1 ? aRet : aParams.get(i - 2);
                    b = j == 1 ? bRet : bParams.get(j - 2);
                    cost = a.equals(b) ? 0 : 1;
                }
                int min1 = d[i - 1][j] + 1;
                int min2 = d[i][j - 1] + 1;
                int min3 = d[i - 1][j - 1] + cost;
                d[i][j] = Math.min(Math.min(min1, min2), min3);
            }
        }
        int paramsDistance = d[d.length - 1][d[0].length - 1];
        if (paramsDistance > 0) {
            paramsDistance += bParams.size() * aParams.size();
        }
        int n = retCost = aErasedRet.equals(bErasedRet) ? 0 : 1;
        if (retCost == 0) {
            retCost = aRet.equals(bRet) ? 0 : 1;
        }
        return retCost + paramsDistance;
    }

    private static int addAllMethods(Collection<? extends JavaElement> els, TreeMap<String, List<MethodElement>> methods) {
        int ret = 0;
        for (JavaElement javaElement : els) {
            if (!(javaElement instanceof MethodElement)) continue;
            JavaApiAnalyzer.add((MethodElement)javaElement, methods);
            ++ret;
        }
        return ret;
    }

    private static void add(MethodElement method, TreeMap<String, List<MethodElement>> methods) {
        String name = ((ExecutableElement)method.getDeclaringElement()).getSimpleName().toString();
        List overloads = methods.computeIfAbsent(name, __ -> new ArrayList());
        overloads.add(method);
    }

    public String getExtensionId() {
        return "revapi.java";
    }

    public Reader getJSONSchema() {
        HashMap<String, Reader> checkSchemas = new HashMap<String, Reader>(4);
        for (Check c : this.checks) {
            String eid = c.getExtensionId();
            Reader schema = c.getJSONSchema();
            if (eid == null || schema == null) continue;
            checkSchemas.put(eid, schema);
        }
        InputStreamReader rdr = new InputStreamReader(this.getClass().getResourceAsStream("/META-INF/config-schema.json"), StandardCharsets.UTF_8);
        if (checkSchemas.isEmpty()) {
            return rdr;
        }
        try {
            JsonNode baseSchema = JSONUtil.parse((String)JavaApiAnalyzer.consume(rdr));
            ObjectNode checksNode = (ObjectNode)baseSchema.with("properties").with("checks");
            checksNode.put("type", "object");
            for (Map.Entry entry : checkSchemas.entrySet()) {
                String checkId = (String)entry.getKey();
                Reader checkSchemaReader = (Reader)entry.getValue();
                JsonNode checkSchema = JSONUtil.parse((String)JavaApiAnalyzer.consume(checkSchemaReader));
                checksNode.with("properties").set(checkId, checkSchema);
            }
            return new StringReader(baseSchema.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read the schema for the revapi extension...", e);
        }
    }

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
        this.configuration = AnalysisConfiguration.fromModel(analysisContext.getConfigurationNode());
        this.configureExtensions("checks", this.checks);
        this.configureExtensions("extract", this.jarExtractors);
    }

    private void configureExtensions(String rootNode, Iterable<? extends Configurable> exts) {
        for (Configurable configurable : exts) {
            if (configurable.getExtensionId() != null) {
                JsonNode checkConfig = this.analysisContext.getConfigurationNode().path(rootNode).path(configurable.getExtensionId());
                AnalysisContext checkCtx = this.analysisContext.copyWithConfiguration(checkConfig);
                configurable.initialize(checkCtx);
                continue;
            }
            configurable.initialize(this.analysisContext.copyWithConfiguration((JsonNode)JsonNodeFactory.instance.nullNode()));
        }
    }

    @Nonnull
    public JavaArchiveAnalyzer getArchiveAnalyzer(@Nonnull API api) {
        boolean ignoreMissingAnnotations = this.configuration.isIgnoreMissingAnnotations();
        return new JavaArchiveAnalyzer(this, api, this.jarExtractors, this.getExecutor(api), this.configuration.getMissingClassReporting(), ignoreMissingAnnotations, this.configuration.getPackageClassFilter());
    }

    @Nonnull
    public DifferenceAnalyzer<JavaElement> getDifferenceAnalyzer(@Nonnull ArchiveAnalyzer<JavaElement> oldArchive, @Nonnull ArchiveAnalyzer<JavaElement> newArchive) {
        JavaArchiveAnalyzer oldA = (JavaArchiveAnalyzer)oldArchive;
        JavaArchiveAnalyzer newA = (JavaArchiveAnalyzer)newArchive;
        ProbingEnvironment oldEnvironment = oldA.getProbingEnvironment();
        ProbingEnvironment newEnvironment = newA.getProbingEnvironment();
        CompilationValve oldValve = oldA.getCompilationValve();
        CompilationValve newValve = newA.getCompilationValve();
        this.activeCompilations.add(oldValve);
        this.activeCompilations.add(newValve);
        return new JavaElementDifferenceAnalyzer(this.analysisContext, oldEnvironment, newEnvironment, this.checks, this.configuration);
    }

    public void close() {
        this.compilationExecutors.forEach(ExecutorService::shutdown);
        this.activeCompilations.forEach(CompilationValve::removeCompiledResults);
        JavaApiAnalyzer.forceClearCompilerCache();
    }

    private static String consume(Reader rdr) throws IOException {
        Throwable suppressed = null;
        try {
            int cnt;
            char[] buffer = new char[512];
            StringBuilder bld = new StringBuilder();
            while ((cnt = rdr.read(buffer)) >= 0) {
                bld.append(buffer, 0, cnt);
            }
            String string = bld.toString();
            return string;
        }
        catch (Throwable t) {
            suppressed = t;
            throw t;
        }
        finally {
            try {
                rdr.close();
            }
            catch (IOException e) {
                if (suppressed != null) {
                    e.addSuppressed(suppressed);
                }
                throw e;
            }
        }
    }

    private static void forceClearCompilerCache() {
        if (CLEAR_COMPILER_CACHE != null && SHARED_ZIP_FILE_INDEX_CACHE != null) {
            try {
                CLEAR_COMPILER_CACHE.invoke(SHARED_ZIP_FILE_INDEX_CACHE, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.warn("Failed to force-clear compiler caches, even though it should have been possible.This will probably leak memory", (Throwable)e);
            }
        }
    }

    private ExecutorService getExecutor(API api) {
        ExecutorService ret = Executors.newSingleThreadExecutor(r -> {
            String as = StreamSupport.stream(api.getArchives().spliterator(), false).map(Archive::getName).collect(Collectors.joining(", "));
            Thread t = new Thread(r, "Java API Compilation Thread for API of " + as);
            t.setDaemon(true);
            return t;
        });
        this.compilationExecutors.add(ret);
        return ret;
    }

    static {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.")) {
            Method clearCompilerCache = null;
            Object sharedInstance = null;
            try {
                Class<?> zipFileIndexCacheClass = ToolProvider.getSystemToolClassLoader().loadClass("com.sun.tools.javac.file.ZipFileIndexCache");
                clearCompilerCache = zipFileIndexCacheClass.getDeclaredMethod("clearCache", new Class[0]);
                Method getSharedInstance = zipFileIndexCacheClass.getDeclaredMethod("getSharedInstance", new Class[0]);
                sharedInstance = getSharedInstance.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                LOG.warn("Failed to initialize the force-clearing of javac file caches. We will probably leak resources.", (Throwable)e);
            }
            if (clearCompilerCache != null && sharedInstance != null) {
                CLEAR_COMPILER_CACHE = clearCompilerCache;
                SHARED_ZIP_FILE_INDEX_CACHE = sharedInstance;
            } else {
                CLEAR_COMPILER_CACHE = null;
                SHARED_ZIP_FILE_INDEX_CACHE = null;
            }
        } else {
            CLEAR_COMPILER_CACHE = null;
            SHARED_ZIP_FILE_INDEX_CACHE = null;
        }
    }
}

