/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java;

import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.API;
import org.revapi.ApiAnalyzer;
import org.revapi.ArchiveAnalyzer;
import org.revapi.ElementForest;
import org.revapi.TreeFilter;
import org.revapi.java.AnalysisConfiguration;
import org.revapi.java.JavaApiAnalyzer;
import org.revapi.java.Timing;
import org.revapi.java.compilation.CompilationFuture;
import org.revapi.java.compilation.CompilationValve;
import org.revapi.java.compilation.Compiler;
import org.revapi.java.compilation.ProbingEnvironment;
import org.revapi.java.model.JavaElementForest;
import org.revapi.java.model.TypeElement;
import org.revapi.java.spi.JarExtractor;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.UseSite;

public final class JavaArchiveAnalyzer
implements ArchiveAnalyzer<JavaElement> {
    private final JavaApiAnalyzer apiAnalyzer;
    private final API api;
    private final ExecutorService executor;
    private final ProbingEnvironment probingEnvironment;
    private final AnalysisConfiguration.MissingClassReporting missingClassReporting;
    private final boolean ignoreMissingAnnotations;
    private final Iterable<JarExtractor> jarExtractors;
    private CompilationValve compilationValve;
    @Deprecated
    @Nullable
    private final TreeFilter<JavaElement> implicitFilter;

    public JavaArchiveAnalyzer(JavaApiAnalyzer apiAnalyzer, API api, Iterable<JarExtractor> jarExtractors, ExecutorService compilationExecutor, AnalysisConfiguration.MissingClassReporting missingClassReporting, boolean ignoreMissingAnnotations, @Nullable TreeFilter<JavaElement> implicitFilter) {
        this.apiAnalyzer = apiAnalyzer;
        this.api = api;
        this.jarExtractors = jarExtractors;
        this.executor = compilationExecutor;
        this.missingClassReporting = missingClassReporting;
        this.ignoreMissingAnnotations = ignoreMissingAnnotations;
        this.probingEnvironment = new ProbingEnvironment(api);
        this.implicitFilter = implicitFilter;
    }

    public ApiAnalyzer<JavaElement> getApiAnalyzer() {
        return this.apiAnalyzer;
    }

    public API getApi() {
        return this.api;
    }

    @Nonnull
    public JavaElementForest analyze(TreeFilter<JavaElement> filter) {
        if (Timing.LOG.isDebugEnabled()) {
            Timing.LOG.debug("Starting analysis of " + this.api);
        }
        TreeFilter finalFilter = this.implicitFilter == null ? filter : TreeFilter.union((TreeFilter[])new TreeFilter[]{filter, this.implicitFilter});
        StringWriter output = new StringWriter();
        Compiler compiler = new Compiler(this.executor, output, this.jarExtractors, this.api.getArchives(), this.api.getSupplementaryArchives(), (TreeFilter<JavaElement>)finalFilter);
        try {
            this.compilationValve = compiler.compile(this.probingEnvironment, this.missingClassReporting, this.ignoreMissingAnnotations);
            this.probingEnvironment.getTree().setCompilationFuture(new CompilationFuture(this.compilationValve, output));
            if (Timing.LOG.isDebugEnabled()) {
                Timing.LOG.debug("Preliminary API tree produced for " + this.api);
            }
            return this.probingEnvironment.getTree();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to analyze archives in api " + this.api, e);
        }
    }

    public void prune(ElementForest<JavaElement> forest) {
        boolean changed;
        if (!(forest instanceof JavaElementForest)) {
            return;
        }
        HashSet<TypeElement> toRemove = new HashSet<TypeElement>();
        do {
            Iterator it = forest.stream(TypeElement.class, true, null).iterator();
            toRemove.clear();
            while (it.hasNext()) {
                TypeElement type = (TypeElement)((Object)it.next());
                boolean remove = true;
                Iterator<UseSite> usit = type.getUseSites().iterator();
                while (usit.hasNext()) {
                    UseSite useSite = usit.next();
                    if (JavaArchiveAnalyzer.isInForest(forest, useSite.getSite())) {
                        if (!useSite.getUseType().isMovingToApi()) continue;
                        remove = false;
                        continue;
                    }
                    usit.remove();
                }
                if (JavaArchiveAnalyzer.isInApi(type) || !remove) continue;
                toRemove.add(type);
            }
            changed = !toRemove.isEmpty();
            for (TypeElement t : toRemove) {
                if (t.getParent() == null) {
                    forest.getRoots().remove((Object)t);
                } else {
                    t.getParent().getChildren().remove((Object)t);
                }
                t.getUsedTypes().entrySet().removeIf(e -> {
                    UseSite.Type useType = (UseSite.Type)e.getKey();
                    ((Map)e.getValue()).entrySet().removeIf(e2 -> {
                        JavaTypeElement usedType = (JavaTypeElement)e2.getKey();
                        usedType.getUseSites().removeIf(us -> us.getUseType() == useType && ((Set)e2.getValue()).contains(us.getSite()));
                        return usedType.getUseSites().isEmpty();
                    });
                    return ((Map)e.getValue()).isEmpty();
                });
            }
        } while (changed);
    }

    public ProbingEnvironment getProbingEnvironment() {
        return this.probingEnvironment;
    }

    public CompilationValve getCompilationValve() {
        return this.compilationValve;
    }

    private static boolean isInForest(ElementForest<JavaElement> forest, JavaElement element) {
        for (JavaElement parent = (JavaElement)element.getParent(); parent != null; parent = (JavaElement)parent.getParent()) {
            element = parent;
        }
        return forest.getRoots().contains(element);
    }

    private static boolean isInApi(TypeElement element) {
        while (element != null) {
            if (element.isInAPI() && !element.isInApiThroughUse()) {
                return true;
            }
            if (element.getParent() instanceof TypeElement) {
                element = (TypeElement)element.getParent();
                continue;
            }
            element = null;
        }
        return false;
    }
}

