/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.revapi.classif.StructuralMatcher;
import org.revapi.classif.match.NameMatch;
import org.revapi.classif.match.Operator;
import org.revapi.classif.match.declaration.AnnotationAttributeMatch;
import org.revapi.classif.match.declaration.AnnotationMatch;
import org.revapi.classif.match.declaration.AnnotationValueMatch;
import org.revapi.classif.match.declaration.AnnotationsMatch;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.declaration.DefaultValueMatch;
import org.revapi.classif.match.declaration.ExtendsMatch;
import org.revapi.classif.match.declaration.ImplementsMatch;
import org.revapi.classif.match.declaration.MethodConstraintsMatch;
import org.revapi.classif.match.declaration.MethodParameterMatch;
import org.revapi.classif.match.declaration.Modifier;
import org.revapi.classif.match.declaration.ModifierClusterMatch;
import org.revapi.classif.match.declaration.ModifierMatch;
import org.revapi.classif.match.declaration.ModifiersMatch;
import org.revapi.classif.match.declaration.OverridesMatch;
import org.revapi.classif.match.declaration.ThrowsMatch;
import org.revapi.classif.match.declaration.TypeConstraintsMatch;
import org.revapi.classif.match.declaration.TypeKind;
import org.revapi.classif.match.declaration.TypeKindMatch;
import org.revapi.classif.match.declaration.UsedByMatch;
import org.revapi.classif.match.declaration.UsesMatch;
import org.revapi.classif.match.instance.FqnMatch;
import org.revapi.classif.match.instance.SingleTypeReferenceMatch;
import org.revapi.classif.match.instance.TypeParameterMatch;
import org.revapi.classif.match.instance.TypeParameterWildcardMatch;
import org.revapi.classif.match.instance.TypeParametersMatch;
import org.revapi.classif.match.instance.TypeReferenceMatch;
import org.revapi.classif.statement.AbstractStatement;
import org.revapi.classif.statement.FieldStatement;
import org.revapi.classif.statement.GenericStatement;
import org.revapi.classif.statement.MethodStatement;
import org.revapi.classif.statement.TypeDefinitionStatement;

public final class Classif {
    private Classif() {
        throw new AssertionError((Object)"No!");
    }

    public static Builder match() {
        return new Builder(Collections.emptyList());
    }

    public static Builder match(String var, String ... vars) {
        ArrayList<String> rets = new ArrayList<String>(vars.length + 1);
        rets.add(var);
        rets.addAll(Arrays.asList(vars));
        return new Builder(rets);
    }

    public static Builder match(Collection<String> vars) {
        return new Builder(vars);
    }

    public static GenericStatementBuilder declaration() {
        return new GenericStatementBuilder();
    }

    public static FieldStatementBuilder field(NameMatch name) {
        return new FieldStatementBuilder(name);
    }

    public static MethodStatementBuilder method(NameMatch name) {
        return new MethodStatementBuilder(name);
    }

    public static TypeDefinitionStatementBuilder type(TypeKind kind, NameMatch fqnFirstPart, NameMatch ... fqnRest) {
        return Classif.type(new TypeKindBuilder(kind), Classif.fqn(fqnFirstPart, fqnRest));
    }

    public static TypeDefinitionStatementBuilder type(TypeKind kind, FqnMatchBuilder fqn) {
        return new TypeDefinitionStatementBuilder(new TypeKindBuilder(kind), fqn);
    }

    public static TypeDefinitionStatementBuilder type(TypeKindBuilder kind, NameMatch fqnFirstPart, NameMatch ... fqnRest) {
        return new TypeDefinitionStatementBuilder(kind, Classif.fqn(fqnFirstPart, fqnRest));
    }

    public static TypeDefinitionStatementBuilder type(TypeKindBuilder kind, FqnMatchBuilder fqn) {
        return new TypeDefinitionStatementBuilder(kind, fqn);
    }

    public static FqnMatchBuilder fqn(NameMatch name, NameMatch ... names) {
        ArrayList<NameMatch> parts = new ArrayList<NameMatch>(names.length + 1);
        parts.add(name);
        parts.addAll(Arrays.asList(names));
        return new FqnMatchBuilder(parts);
    }

    public static TypeParameterMatchBuilder wildcard() {
        return new TypeParameterWildcardBuilder(true);
    }

    public static TypeParameterWildcardBuilder wildcardExtends(TypeReferenceMatchBuilder type) {
        return new TypeParameterWildcardBuilder(true).and(type);
    }

    public static TypeParameterWildcardBuilder wildcardSuper(TypeReferenceMatchBuilder type) {
        return new TypeParameterWildcardBuilder(false).and(type);
    }

    public static TypeParameterBoundBuilder bound(TypeReferenceMatchBuilder type) {
        return new TypeParameterBoundBuilder().and(type);
    }

    public static TypeReferenceMatchBuilder type() {
        return new TypeReferenceMatchBuilder();
    }

    public static TypeReferenceMatchBuilder anyType() {
        return (TypeReferenceMatchBuilder)Classif.type().fqn(NameMatch.any(), new NameMatch[0]);
    }

    public static TypeReferenceMatchBuilder anyTypes() {
        return (TypeReferenceMatchBuilder)Classif.type().fqn(NameMatch.all(), new NameMatch[0]);
    }

    public static UsesMatchBuilder uses(TypeReferenceMatchBuilder type) {
        return new UsesMatchBuilder(type);
    }

    public static UsedByMatchBuilder usedBy(String var, String ... vars) {
        ArrayList<String> vs = new ArrayList<String>(vars.length + 1);
        vs.add(var);
        vs.addAll(Arrays.asList(vars));
        return new UsedByMatchBuilder(vs);
    }

    public static TypeKindBuilder kind(TypeKind kind) {
        return new TypeKindBuilder(kind);
    }

    public static OverridesMatchBuilder overrides() {
        return new OverridesMatchBuilder();
    }

    public static ModifiersMatchBuilder modifiers() {
        return new ModifiersMatchBuilder();
    }

    public static ModifiersMatchBuilder modifiers(Modifier first, Modifier ... rest) {
        ModifiersMatchBuilder ret = new ModifiersMatchBuilder().$(first);
        for (Modifier m : rest) {
            ret = ret.$(m);
        }
        return ret;
    }

    public static ModifierClusterMatchBuilder atLeastOne() {
        return new ModifierClusterMatchBuilder();
    }

    public static DefaultMethodValueMatchBuilder defaultValue() {
        return new DefaultMethodValueMatchBuilder();
    }

    public static AnnotationValueBuilder value(Operator operator) {
        return new AnnotationValueBuilder(operator);
    }

    public static AnnotationValueMatchAllBuilder allValues() {
        return new AnnotationValueMatchAllBuilder();
    }

    public static AnnotationMatchBuilder annotation(TypeReferenceMatchBuilder type) {
        return new AnnotationMatchBuilder(type);
    }

    public static AnnotationAttributeValueBuilder attribute(NameMatch name) {
        return new AnnotationAttributeValueBuilder(name);
    }

    public static AnnotationAttributeAnyBuilder anyAttribute() {
        return new AnnotationAttributeAnyBuilder();
    }

    public static AnnotationAttributeAllBuilder anyAttributes() {
        return new AnnotationAttributeAllBuilder();
    }

    public static AnnotationArrayValueBuilder array() {
        return new AnnotationArrayValueBuilder();
    }

    public static AnnotationArrayItemValueBuilder item() {
        return new AnnotationArrayItemValueBuilder();
    }

    public static MethodParameterMatchBuilder parameter(TypeReferenceMatchBuilder type) {
        return new MethodParameterMatchBuilder(type);
    }

    public static MethodParameterMatchBuilder anyParameter() {
        return new MethodParameterMatchBuilder(Classif.anyType());
    }

    public static MethodParameterMatchBuilder anyParameters() {
        return new MethodParameterMatchBuilder(Classif.anyTypes());
    }

    public static ImplementsMatchBuilder implements_() {
        return new ImplementsMatchBuilder();
    }

    public static ExtendsMatchBuilder extends_(TypeReferenceMatchBuilder type) {
        return new ExtendsMatchBuilder(type);
    }

    public static abstract class AbstractMatchBuilder<M> {
        final List<String> referencedVariables = new ArrayList<String>();

        public abstract M build();

        private void copyVariables(AbstractMatchBuilder<?> other) {
            if (other != null) {
                this.referencedVariables.addAll(other.referencedVariables);
            }
        }

        <X> X finish(AbstractMatchBuilder<X> builder) {
            if (builder == null) {
                return null;
            }
            X ret = builder.build();
            this.copyVariables(builder);
            return ret;
        }

        <X> List<X> finish(List<? extends AbstractMatchBuilder<? extends X>> builders) {
            return builders.stream().filter(Objects::nonNull).map(this::finish).collect(Collectors.toList());
        }

        <T> T castThis() {
            return (T)this;
        }
    }

    public static final class DefaultMethodValueMatchBuilder
    extends AbstractMatchBuilder<DefaultValueMatch> {
        private boolean negation;
        private AnnotationValueBuilder value;

        private DefaultMethodValueMatchBuilder() {
        }

        public DefaultMethodValueMatchBuilder not() {
            this.negation = true;
            return this;
        }

        public DefaultMethodValueMatchBuilder $(AnnotationValueBuilder value) {
            this.value = value;
            return this;
        }

        @Override
        public DefaultValueMatch build() {
            return new DefaultValueMatch(this.negation, this.finish(this.value));
        }
    }

    public static final class AnnotationAttributeValueBuilder
    extends AnnotationAttributeMatchBuilder {
        private final NameMatch name;
        private AnnotationValueMatchBuilder valueMatch;

        private AnnotationAttributeValueBuilder(NameMatch name) {
            this.name = name;
        }

        public AnnotationAttributeValueBuilder $(AnnotationValueMatchBuilder value) {
            this.valueMatch = value;
            return this;
        }

        @Override
        public AnnotationAttributeMatch build() {
            return new AnnotationAttributeMatch(false, false, this.name, this.finish(this.valueMatch));
        }
    }

    public static final class AnnotationAttributeAllBuilder
    extends AnnotationAttributeMatchBuilder {
        private AnnotationAttributeAllBuilder() {
        }

        @Override
        public AnnotationAttributeMatch build() {
            return new AnnotationAttributeMatch(false, true, null, null);
        }
    }

    public static final class AnnotationAttributeAnyBuilder
    extends AnnotationAttributeMatchBuilder {
        private AnnotationAttributeAnyBuilder() {
        }

        @Override
        public AnnotationAttributeMatch build() {
            return new AnnotationAttributeMatch(true, false, null, null);
        }
    }

    public static abstract class AnnotationAttributeMatchBuilder
    extends AbstractMatchBuilder<AnnotationAttributeMatch> {
        private AnnotationAttributeMatchBuilder() {
        }

        @Override
        public abstract AnnotationAttributeMatch build();
    }

    public static final class AnnotationMatchBuilder
    extends AbstractMatchBuilder<AnnotationMatch> {
        private boolean negation;
        private final TypeReferenceMatchBuilder type;
        private final List<AnnotationAttributeMatchBuilder> attributes = new ArrayList<AnnotationAttributeMatchBuilder>();

        private AnnotationMatchBuilder(TypeReferenceMatchBuilder type) {
            this.type = type;
        }

        public AnnotationMatchBuilder negated() {
            this.negation = true;
            return this;
        }

        public AnnotationMatchBuilder $(AnnotationAttributeMatchBuilder attribute) {
            this.attributes.add(attribute);
            return this;
        }

        @Override
        public AnnotationMatch build() {
            return new AnnotationMatch(this.negation, this.finish(this.type), this.finish(this.attributes));
        }
    }

    public static final class AnnotationArrayItemValueBuilder
    extends AnnotationValueBuilder {
        private AnnotationArrayItemValueBuilder() {
            super(Operator.EQ);
        }

        public AnnotationArrayItemValueBuilder anyValues() {
            this.bld.value = null;
            return this;
        }

        @Override
        public AnnotationValueMatch build() {
            if (this.bld.value == null) {
                return AnnotationValueMatch.all();
            }
            return super.build();
        }
    }

    public static final class AnnotationArrayValueBuilder
    extends AbstractMatchBuilder<List<AnnotationValueMatch>> {
        private final List<AnnotationArrayItemValueBuilder> matches = new ArrayList<AnnotationArrayItemValueBuilder>();

        private AnnotationArrayValueBuilder() {
        }

        public AnnotationArrayValueBuilder $(AnnotationArrayItemValueBuilder value) {
            this.matches.add(value);
            return this;
        }

        @Override
        public List<AnnotationValueMatch> build() {
            return this.finish(this.matches);
        }
    }

    public static class AnnotationValueBuilder
    extends AbstractAnnotationValueBuilder<AnnotationValueBuilder> {
        private static final Object DEFAULT_VALUE = new Object();

        private AnnotationValueBuilder(Operator operator) {
            super(operator);
        }

        public AnnotationValueBuilder defaultValue() {
            this.bld.value = DEFAULT_VALUE;
            return this;
        }

        @Override
        public AnnotationValueMatch build() {
            if (this.bld.value == DEFAULT_VALUE) {
                return AnnotationValueMatch.defaultValue(this.bld.operator);
            }
            return super.build();
        }
    }

    static abstract class AbstractAnnotationValueBuilder<This extends AbstractAnnotationValueBuilder<This>>
    extends AnnotationValueMatchBuilder {
        protected final BaseAnnotationValueBuilder<This, AnnotationValueMatch> bld;

        AbstractAnnotationValueBuilder(Operator operator) {
            this.bld = new BaseAnnotationValueBuilder<This, AnnotationValueMatch>(operator){

                @Override
                public AnnotationValueMatch build() {
                    return this.buildValueMatch();
                }
            };
        }

        public This string(String value) {
            this.bld.string(value);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        public This regex(Pattern regex) {
            this.bld.regex(regex);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        public This number(Number number) {
            this.bld.number(number);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        public This bool(boolean bool) {
            this.bld.bool(bool);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        public This any() {
            this.bld.any(this.bld.operator);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        public This enumConstant(FqnMatchBuilder fqn, NameMatch name) {
            this.bld.enumConstant(fqn, name);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        public This $(TypeReferenceMatchBuilder type) {
            this.bld.type(type);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        public This $(AnnotationMatchBuilder annotation) {
            this.bld.annotation(annotation);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        public This $(AnnotationArrayValueBuilder values) {
            this.bld.of(values);
            return (This)((AbstractAnnotationValueBuilder)this.castThis());
        }

        @Override
        public AnnotationValueMatch build() {
            return (AnnotationValueMatch)this.bld.build();
        }
    }

    static abstract class BaseAnnotationValueBuilder<This extends AbstractMatchBuilder<M>, M>
    extends AbstractMatchBuilder<M> {
        private static final Object ANY = new Object();
        protected final Operator operator;
        protected Object value;

        BaseAnnotationValueBuilder(Operator operator) {
            this.operator = operator;
        }

        public This string(String value) {
            this.value = value;
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        public This regex(Pattern regex) {
            this.value = regex;
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        public This number(Number number) {
            this.value = number;
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        public This bool(boolean bool) {
            this.value = bool;
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        public This any(Operator op) {
            this.value = ANY;
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        public This enumConstant(FqnMatchBuilder fqn, NameMatch name) {
            this.value = new AbstractMap.SimpleImmutableEntry<FqnMatchBuilder, NameMatch>(fqn, name);
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        public This type(TypeReferenceMatchBuilder type) {
            this.value = type;
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        public This annotation(AnnotationMatchBuilder annotation) {
            this.value = annotation;
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        public This of(AnnotationArrayValueBuilder values) {
            this.value = values;
            return (This)((AbstractMatchBuilder)this.castThis());
        }

        AnnotationValueMatch buildValueMatch() {
            if (this.value instanceof String) {
                return AnnotationValueMatch.string(this.operator, (String)this.value);
            }
            if (this.value instanceof Pattern) {
                return AnnotationValueMatch.regex(this.operator, (Pattern)this.value);
            }
            if (this.value instanceof Number) {
                return AnnotationValueMatch.number(this.operator, (Number)this.value);
            }
            if (this.value instanceof Boolean) {
                return AnnotationValueMatch.bool(this.operator, (Boolean)this.value);
            }
            if (this.value == ANY) {
                return AnnotationValueMatch.any(this.operator);
            }
            if (this.value instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)this.value;
                return AnnotationValueMatch.enumConstant(this.operator, (FqnMatch)this.finish((AbstractMatchBuilder)e.getKey()), (NameMatch)e.getValue());
            }
            if (this.value instanceof TypeReferenceMatchBuilder) {
                return AnnotationValueMatch.type(this.operator, this.finish((TypeReferenceMatchBuilder)this.value));
            }
            if (this.value instanceof AnnotationMatchBuilder) {
                return AnnotationValueMatch.annotation(this.operator, this.finish((AnnotationMatchBuilder)this.value));
            }
            if (this.value instanceof AnnotationArrayValueBuilder) {
                return AnnotationValueMatch.array(this.operator, this.finish((AnnotationArrayValueBuilder)this.value));
            }
            throw new IllegalStateException("Unhandled annotation value type: " + this.value);
        }
    }

    public static final class AnnotationValueMatchAllBuilder
    extends AnnotationValueMatchBuilder {
        @Override
        public AnnotationValueMatch build() {
            return AnnotationValueMatch.all();
        }
    }

    public static abstract class AnnotationValueMatchBuilder
    extends AbstractMatchBuilder<AnnotationValueMatch> {
    }

    public static final class ModifierClusterMatchBuilder
    extends AbstractMatchBuilder<ModifierClusterMatch> {
        private final List<ModifierMatch> mods = new ArrayList<ModifierMatch>();

        private ModifierClusterMatchBuilder() {
        }

        public ModifierClusterMatchBuilder $(Modifier modifier) {
            this.mods.add(new ModifierMatch(false, modifier));
            return this;
        }

        public ModifierClusterMatchBuilder not(Modifier modifier) {
            this.mods.add(new ModifierMatch(true, modifier));
            return this;
        }

        @Override
        public ModifierClusterMatch build() {
            return new ModifierClusterMatch(this.mods);
        }
    }

    public static final class ModifiersMatchBuilder
    extends AbstractMatchBuilder<ModifiersMatch> {
        private final List<ModifierClusterMatchBuilder> clusters = new ArrayList<ModifierClusterMatchBuilder>();

        public ModifiersMatchBuilder $(Modifier modifier) {
            this.clusters.add(new ModifierClusterMatchBuilder().$(modifier));
            return this;
        }

        public ModifiersMatchBuilder not(Modifier modifier) {
            this.clusters.add(new ModifierClusterMatchBuilder().not(modifier));
            return this;
        }

        public ModifiersMatchBuilder oneOf(ModifierClusterMatchBuilder mods) {
            this.clusters.add(mods);
            return this;
        }

        @Override
        public ModifiersMatch build() {
            return new ModifiersMatch(this.finish(this.clusters));
        }
    }

    public static final class OverridesMatchBuilder
    extends AbstractMatchBuilder<OverridesMatch> {
        private TypeReferenceMatchBuilder type;

        private OverridesMatchBuilder() {
        }

        public OverridesMatchBuilder from(TypeReferenceMatchBuilder type) {
            this.type = type;
            return this;
        }

        @Override
        public OverridesMatch build() {
            return new OverridesMatch(this.finish(this.type));
        }
    }

    public static final class ThrowsMatchBuilder
    extends AbstractMatchBuilder<ThrowsMatch> {
        private final List<TypeReferenceMatchBuilder> types = new ArrayList<TypeReferenceMatchBuilder>();

        public ThrowsMatchBuilder $(TypeReferenceMatchBuilder type) {
            this.types.add(type);
            return this;
        }

        @Override
        public ThrowsMatch build() {
            return new ThrowsMatch(this.finish(this.types));
        }
    }

    public static final class TypeKindBuilder
    extends AbstractMatchBuilder<TypeKindMatch> {
        private boolean negated;
        private final TypeKind kind;

        private TypeKindBuilder(TypeKind kind) {
            this.kind = kind;
        }

        public TypeKindBuilder negated() {
            this.negated = true;
            return this;
        }

        @Override
        public TypeKindMatch build() {
            return new TypeKindMatch(this.negated, this.kind);
        }
    }

    public static final class UsedByMatchBuilder
    extends AbstractMatchBuilder<UsedByMatch> {
        private boolean onlyDirect;

        private UsedByMatchBuilder(List<String> variables) {
            this.referencedVariables.addAll(variables);
        }

        public UsedByMatchBuilder directly() {
            this.onlyDirect = true;
            return this;
        }

        @Override
        public UsedByMatch build() {
            return new UsedByMatch(this.onlyDirect, this.referencedVariables);
        }
    }

    public static final class UsesMatchBuilder
    extends AbstractMatchBuilder<UsesMatch> {
        private boolean onlyDirect;
        private final TypeReferenceMatchBuilder type;

        private UsesMatchBuilder(TypeReferenceMatchBuilder type) {
            this.type = type;
        }

        public UsesMatchBuilder directly() {
            this.onlyDirect = true;
            return this;
        }

        @Override
        public UsesMatch build() {
            return new UsesMatch(this.onlyDirect, this.finish(this.type));
        }
    }

    public static final class TypeReferenceMatchBuilder
    extends SingleTypeReferenceMatchBuilder<TypeReferenceMatchBuilder, TypeReferenceMatch> {
        private final List<SingleTypeReferenceMatch> types = new ArrayList<SingleTypeReferenceMatch>();

        private TypeReferenceMatchBuilder() {
        }

        public TypeReferenceMatchBuilder or() {
            if (this.variable != null) {
                this.referencedVariables.add(this.variable);
            }
            TypeParametersMatch typeParams = this.typeParameters.isEmpty() ? null : new TypeParametersMatch(this.finish(this.typeParameters));
            this.types.add(new SingleTypeReferenceMatch(this.finish(this.fqn), typeParams, this.variable, this.negation, this.arrayDimension));
            this.clear();
            return this;
        }

        @Override
        public TypeReferenceMatch build() {
            this.or();
            return new TypeReferenceMatch(this.types);
        }
    }

    private static abstract class SingleTypeReferenceMatchBuilder<This extends SingleTypeReferenceMatchBuilder<This, M>, M>
    extends AbstractMatchBuilder<M> {
        protected FqnMatchBuilder fqn;
        protected final List<TypeParameterMatchBuilder> typeParameters = new ArrayList<TypeParameterMatchBuilder>();
        protected String variable;
        protected boolean negation;
        protected int arrayDimension;

        SingleTypeReferenceMatchBuilder() {
        }

        public This negated() {
            this.negation = true;
            return (This)((SingleTypeReferenceMatchBuilder)this.castThis());
        }

        public This array(int arrayDimension) {
            this.arrayDimension = arrayDimension;
            return (This)((SingleTypeReferenceMatchBuilder)this.castThis());
        }

        public This ref(String variableName) {
            this.variable = variableName;
            return (This)((SingleTypeReferenceMatchBuilder)this.castThis());
        }

        public This fqn(NameMatch first, NameMatch ... rest) {
            this.fqn = Classif.fqn(first, rest);
            return (This)((SingleTypeReferenceMatchBuilder)this.castThis());
        }

        public This $(TypeParameterMatchBuilder typeParameter) {
            this.typeParameters.add(typeParameter);
            return (This)((SingleTypeReferenceMatchBuilder)this.castThis());
        }

        void clear() {
            this.fqn = null;
            this.typeParameters.clear();
            this.variable = null;
            this.negation = false;
            this.arrayDimension = 0;
        }
    }

    public static final class TypeParameterBoundBuilder
    extends TypeParameterMatchBuilder {
        private final List<TypeReferenceMatchBuilder> bounds = new ArrayList<TypeReferenceMatchBuilder>();

        private TypeParameterBoundBuilder() {
        }

        public TypeParameterBoundBuilder and(TypeReferenceMatchBuilder type) {
            this.bounds.add(type);
            return this;
        }

        @Override
        public TypeParameterMatch build() {
            return new TypeParameterMatch(null, this.finish(this.bounds));
        }
    }

    public static final class TypeParameterWildcardBuilder
    extends TypeParameterMatchBuilder {
        private final boolean isExtends;
        private final List<TypeReferenceMatchBuilder> bounds = new ArrayList<TypeReferenceMatchBuilder>();

        private TypeParameterWildcardBuilder(boolean isExtends) {
            this.isExtends = isExtends;
        }

        public TypeParameterWildcardBuilder and(TypeReferenceMatchBuilder type) {
            this.bounds.add(type);
            return this;
        }

        @Override
        public TypeParameterMatch build() {
            return new TypeParameterMatch(new TypeParameterWildcardMatch(this.isExtends, this.finish(this.bounds)), null);
        }
    }

    public static abstract class TypeParameterMatchBuilder
    extends AbstractMatchBuilder<TypeParameterMatch> {
        private TypeParameterMatchBuilder() {
        }

        @Override
        public abstract TypeParameterMatch build();
    }

    public static final class FqnMatchBuilder
    extends AbstractMatchBuilder<FqnMatch> {
        private final List<NameMatch> parts;

        private FqnMatchBuilder(List<NameMatch> parts) {
            this.parts = parts;
        }

        public FqnMatchBuilder dot(NameMatch name) {
            this.parts.add(name);
            return this;
        }

        public FqnMatchBuilder parts(NameMatch ... names) {
            this.parts.addAll(Arrays.asList(names));
            return this;
        }

        @Override
        public FqnMatch build() {
            return new FqnMatch(this.parts);
        }
    }

    public static final class Builder
    extends AbstractMatchBuilder<StructuralMatcher> {
        private final List<AbstractStatementBuilder<?, ? extends AbstractStatement>> statements = new ArrayList();
        private final List<String> returns;
        private boolean strictHierarchy;

        private Builder(Collection<String> returns) {
            this.returns = new ArrayList<String>(returns);
        }

        public Builder strictHierarchy() {
            this.strictHierarchy = true;
            return this;
        }

        public Builder $(GenericStatementBuilder decl) {
            this.statements.add(decl);
            return this;
        }

        public Builder $(TypeDefinitionStatementBuilder type) {
            this.statements.add(type);
            return this;
        }

        @Override
        public StructuralMatcher build() {
            return new StructuralMatcher(new StructuralMatcher.Configuration(this.strictHierarchy), this.returns, this.finish(this.statements));
        }
    }

    public static final class MethodParameterMatchBuilder
    extends AbstractMatchBuilder<MethodParameterMatch> {
        private final List<AnnotationMatchBuilder> annotations = new ArrayList<AnnotationMatchBuilder>();
        private final TypeReferenceMatchBuilder type;

        private MethodParameterMatchBuilder(TypeReferenceMatchBuilder type) {
            this.type = type;
        }

        public MethodParameterMatchBuilder $(AnnotationMatchBuilder annotation) {
            this.annotations.add(annotation);
            return this;
        }

        @Override
        public MethodParameterMatch build() {
            return new MethodParameterMatch(new AnnotationsMatch(this.finish(this.annotations)), this.finish(this.type));
        }
    }

    public static final class ExtendsMatchBuilder
    extends AbstractMatchBuilder<ExtendsMatch> {
        private boolean directly;
        private final TypeReferenceMatchBuilder type;

        private ExtendsMatchBuilder(TypeReferenceMatchBuilder type) {
            this.type = type;
        }

        public ExtendsMatchBuilder directly() {
            this.directly = true;
            return this;
        }

        @Override
        public ExtendsMatch build() {
            return new ExtendsMatch(this.directly, this.finish(this.type));
        }
    }

    public static final class ImplementsMatchBuilder
    extends AbstractMatchBuilder<ImplementsMatch> {
        private boolean directly;
        private boolean exactly;
        private final List<TypeReferenceMatchBuilder> types = new ArrayList<TypeReferenceMatchBuilder>();

        private ImplementsMatchBuilder() {
        }

        public ImplementsMatchBuilder directly() {
            this.directly = true;
            return this;
        }

        public ImplementsMatchBuilder exactly() {
            this.exactly = true;
            return this;
        }

        public ImplementsMatchBuilder $(TypeReferenceMatchBuilder type) {
            this.types.add(type);
            return this;
        }

        @Override
        public ImplementsMatch build() {
            return new ImplementsMatch(this.directly, this.exactly, this.finish(this.types));
        }
    }

    public static final class TypeDefinitionStatementBuilder
    extends AbstractStatementBuilder<TypeDefinitionStatementBuilder, TypeDefinitionStatement> {
        private final TypeKindBuilder typeKind;
        private final FqnMatchBuilder fqn;
        private final List<TypeParameterMatchBuilder> typeParameters = new ArrayList<TypeParameterMatchBuilder>();
        private final List<ImplementsMatchBuilder> implemented = new ArrayList<ImplementsMatchBuilder>();
        private ExtendsMatchBuilder extended;
        private final List<UsesMatchBuilder> uses = new ArrayList<UsesMatchBuilder>();
        private final List<UsedByMatchBuilder> usedBys = new ArrayList<UsedByMatchBuilder>();
        private final List<AbstractStatementBuilder<?, ? extends AbstractStatement>> innerStatements = new ArrayList();

        private TypeDefinitionStatementBuilder(TypeKindBuilder kind, FqnMatchBuilder fqn) {
            this.typeKind = kind;
            this.fqn = fqn;
        }

        public TypeDefinitionStatementBuilder $(TypeParameterMatchBuilder param) {
            this.typeParameters.add(param);
            return this;
        }

        public TypeDefinitionStatementBuilder $(ImplementsMatchBuilder implements_) {
            this.implemented.add(implements_);
            return this;
        }

        public TypeDefinitionStatementBuilder $(ExtendsMatchBuilder extends_) {
            this.extended = extends_;
            return this;
        }

        public TypeDefinitionStatementBuilder $(UsesMatchBuilder uses) {
            this.uses.add(uses);
            return this;
        }

        public TypeDefinitionStatementBuilder $(UsedByMatchBuilder usedBy) {
            this.usedBys.add(usedBy);
            return this;
        }

        public TypeDefinitionStatementBuilder $(FieldStatementBuilder field) {
            this.innerStatements.add(field);
            return this;
        }

        public TypeDefinitionStatementBuilder $(MethodStatementBuilder method) {
            this.innerStatements.add(method);
            return this;
        }

        public TypeDefinitionStatementBuilder $(TypeDefinitionStatementBuilder type) {
            this.innerStatements.add(type);
            return this;
        }

        @Override
        public TypeDefinitionStatement build() {
            TypeDefinitionStatement type = new TypeDefinitionStatement(this.definedVariable, this.referencedVariables, new AnnotationsMatch(this.finish(this.annotations)), this.finish(this.modifiers), this.finish(this.typeKind), this.finish(this.fqn), this.typeParameters.isEmpty() ? null : new TypeParametersMatch(this.finish(this.typeParameters)), new TypeConstraintsMatch(this.finish(this.implemented), this.finish(this.extended), this.finish(this.uses), this.finish(this.usedBys)), this.negation, this.isMatch);
            type.getChildren().addAll(this.finish(this.innerStatements));
            return type;
        }
    }

    public static final class MethodStatementBuilder
    extends AbstractStatementBuilder<MethodStatementBuilder, MethodStatement> {
        private final NameMatch name;
        private TypeReferenceMatchBuilder returnType;
        private TypeReferenceMatchBuilder declaringType;
        private final List<TypeParameterMatchBuilder> typeParameters = new ArrayList<TypeParameterMatchBuilder>();
        private OverridesMatchBuilder overrides;
        private UsesMatchBuilder uses;
        private final List<TypeReferenceMatchBuilder> throws_ = new ArrayList<TypeReferenceMatchBuilder>();
        private DefaultMethodValueMatchBuilder defaultValue;
        private final List<MethodParameterMatchBuilder> parameters = new ArrayList<MethodParameterMatchBuilder>();

        private MethodStatementBuilder(NameMatch name) {
            this.name = name;
        }

        public MethodStatementBuilder returns(TypeReferenceMatchBuilder type) {
            this.returnType = type;
            return this;
        }

        public MethodStatementBuilder declaredIn(TypeReferenceMatchBuilder type) {
            this.declaringType = type;
            return this;
        }

        public MethodStatementBuilder $(TypeParameterMatchBuilder typeParameter) {
            this.typeParameters.add(typeParameter);
            return this;
        }

        public MethodStatementBuilder $(OverridesMatchBuilder overrides) {
            this.overrides = overrides;
            return this;
        }

        public MethodStatementBuilder $(UsesMatchBuilder uses) {
            this.uses = uses;
            return this;
        }

        public MethodStatementBuilder throws_(TypeReferenceMatchBuilder type) {
            this.throws_.add(type);
            return this;
        }

        public MethodStatementBuilder $(MethodParameterMatchBuilder parameter) {
            this.parameters.add(parameter);
            return this;
        }

        public MethodStatementBuilder $(DefaultMethodValueMatchBuilder defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @Override
        public MethodStatement build() {
            ThrowsMatch throwsMatch = this.throws_.isEmpty() ? null : new ThrowsMatch(this.finish(this.throws_));
            List<DeclarationMatch> constraints = this.finish(Arrays.asList(this.overrides, this.uses, this.defaultValue));
            if (throwsMatch != null) {
                constraints.add(throwsMatch);
            }
            TypeParametersMatch typeParamsMatch = this.typeParameters.isEmpty() ? null : new TypeParametersMatch(this.finish(this.typeParameters));
            return new MethodStatement(this.definedVariable, this.referencedVariables, new AnnotationsMatch(this.finish(this.annotations)), this.finish(this.modifiers), this.isMatch, this.name, this.finish(this.returnType), this.finish(this.declaringType), typeParamsMatch, this.finish(this.parameters), new MethodConstraintsMatch(constraints), this.negation);
        }
    }

    public static final class FieldStatementBuilder
    extends AbstractStatementBuilder<FieldStatementBuilder, FieldStatement> {
        private final NameMatch name;
        private TypeReferenceMatchBuilder type;
        private TypeReferenceMatchBuilder declaringType;
        private UsesMatchBuilder uses;

        private FieldStatementBuilder(NameMatch name) {
            this.name = name;
        }

        public FieldStatementBuilder $(TypeReferenceMatchBuilder type) {
            this.type = type;
            return this;
        }

        public FieldStatementBuilder declaredIn(TypeReferenceMatchBuilder type) {
            this.declaringType = type;
            return this;
        }

        public FieldStatementBuilder $(UsesMatchBuilder uses) {
            this.uses = uses;
            return this;
        }

        @Override
        public FieldStatement build() {
            return new FieldStatement(this.definedVariable, this.referencedVariables, new AnnotationsMatch(this.finish(this.annotations)), this.finish(this.modifiers), this.isMatch, this.negation, this.name, this.finish(this.type), this.finish(this.declaringType), this.finish(this.uses));
        }
    }

    public static final class GenericStatementBuilder
    extends AbstractStatementBuilder<GenericStatementBuilder, GenericStatement> {
        private UsesMatchBuilder uses;

        private GenericStatementBuilder() {
        }

        public GenericStatementBuilder $(UsesMatchBuilder uses) {
            this.uses = uses;
            return this;
        }

        @Override
        public GenericStatement build() {
            return new GenericStatement(this.definedVariable, this.referencedVariables, new AnnotationsMatch(this.finish(this.annotations)), this.finish(this.modifiers), this.isMatch, this.negation, this.finish(this.uses));
        }
    }

    private static abstract class AbstractStatementBuilder<This extends AbstractStatementBuilder<This, S>, S extends AbstractStatement>
    extends AbstractMatchBuilder<S> {
        protected final List<AnnotationMatchBuilder> annotations = new ArrayList<AnnotationMatchBuilder>();
        protected ModifiersMatchBuilder modifiers = new ModifiersMatchBuilder();
        protected boolean negation;
        String definedVariable;
        boolean isMatch;

        private AbstractStatementBuilder() {
        }

        public This as(String name) {
            this.definedVariable = name;
            return (This)((AbstractStatementBuilder)this.castThis());
        }

        public This matched() {
            this.isMatch = true;
            return (This)((AbstractStatementBuilder)this.castThis());
        }

        public This $(ModifiersMatchBuilder modifiers) {
            this.modifiers = modifiers;
            return (This)((AbstractStatementBuilder)this.castThis());
        }

        public This $(AnnotationMatchBuilder annotation) {
            this.annotations.add(annotation);
            return (This)((AbstractStatementBuilder)this.castThis());
        }

        public This negated() {
            this.negation = true;
            return (This)((AbstractStatementBuilder)this.castThis());
        }
    }
}

