/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.classif.match;

import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.revapi.classif.TestResult;
import org.revapi.classif.match.declaration.DeclarationMatch;
import org.revapi.classif.match.instance.TypeInstanceMatch;
import org.revapi.classif.progress.context.MatchContext;

public abstract class Match {
    protected Match() {
    }

    public final <M> TestResult test(M model, MatchContext<M> ctx) {
        return this.test(ctx.getModelInspector().toElement(model), ctx.getModelInspector().toMirror(model), ctx);
    }

    public final <M> TestResult test(Element declaration, TypeMirror instance, MatchContext<M> ctx) {
        if (this instanceof DeclarationMatch) {
            return this.testDeclaration(declaration, instance, ctx);
        }
        if (this instanceof TypeInstanceMatch) {
            return this.testInstance(instance, ctx);
        }
        throw new IllegalStateException("Only DeclarationMatch and TypeInstanceMatch are valid subclasses of the Match class.");
    }

    public abstract <M> TestResult testDeclaration(Element var1, TypeMirror var2, MatchContext<M> var3);

    public abstract <M> TestResult testInstance(TypeMirror var1, MatchContext<M> var2);
}

